/*
 * Decompiled with CFR 0.152.
 */
package com.igormaznitsa.zxpoly.components.tapereader.tzx;

import com.igormaznitsa.jbbp.io.JBBPBitInputStream;
import com.igormaznitsa.jbbp.io.JBBPBitOutputStream;
import com.igormaznitsa.zxpoly.components.tapereader.tzx.AbstractTzxInformationBlock;
import com.igormaznitsa.zxpoly.components.tapereader.tzx.TzxBlockId;
import java.io.IOException;

public class TzxBlockEmulationinfo
extends AbstractTzxInformationBlock {
    private final int generalEmulationFlags;
    private final int screenRefreshDelay;
    private final int interruptFreqHz;
    private final int reserved;

    public TzxBlockEmulationinfo(JBBPBitInputStream inputStream) throws IOException {
        super(TzxBlockId.EMULATION_INFO.getId());
        this.generalEmulationFlags = TzxBlockEmulationinfo.readWord(inputStream);
        this.screenRefreshDelay = inputStream.readByte();
        this.interruptFreqHz = TzxBlockEmulationinfo.readWord(inputStream);
        this.reserved = TzxBlockEmulationinfo.readThreeByteValue(inputStream);
    }

    public int getGeneralEmulationFlags() {
        return this.generalEmulationFlags;
    }

    public int getScreenRefreshDelay() {
        return this.screenRefreshDelay;
    }

    public int getInterruptFreqHz() {
        return this.interruptFreqHz;
    }

    public int getReserved() {
        return this.reserved;
    }

    @Override
    public void write(JBBPBitOutputStream outputStream) throws IOException {
        super.write(outputStream);
        TzxBlockEmulationinfo.writeDWord(outputStream, this.generalEmulationFlags);
        outputStream.write(this.screenRefreshDelay);
        TzxBlockEmulationinfo.writeWord(outputStream, this.interruptFreqHz);
        TzxBlockEmulationinfo.writeThreeByteValue(outputStream, this.reserved);
    }
}

