/*
 * Decompiled with CFR 0.152.
 */
package com.igormaznitsa.zxpoly.components.tapereader.tzx;

import com.igormaznitsa.jbbp.io.JBBPBitInputStream;
import com.igormaznitsa.jbbp.io.JBBPBitOutputStream;
import com.igormaznitsa.zxpoly.components.tapereader.tzx.AbstractTzxInformationBlock;
import com.igormaznitsa.zxpoly.components.tapereader.tzx.TzxBlockId;
import java.io.IOException;
import java.nio.charset.StandardCharsets;

public class TzxBlockGroupStart
extends AbstractTzxInformationBlock {
    private final String groupName;

    public TzxBlockGroupStart(JBBPBitInputStream inputStream) throws IOException {
        super(TzxBlockId.GROUP_START.getId());
        int length = inputStream.readByte();
        this.groupName = new String(inputStream.readByteArray(length), StandardCharsets.ISO_8859_1);
    }

    public String getGroupName() {
        return this.groupName;
    }

    @Override
    public void write(JBBPBitOutputStream outputStream) throws IOException {
        super.write(outputStream);
        byte[] chars = this.groupName.getBytes(StandardCharsets.ISO_8859_1);
        outputStream.write(chars.length);
        outputStream.write(chars);
    }
}

