/*
 * Decompiled with CFR 0.152.
 */
package com.igormaznitsa.zxpoly.components.tapereader.tzx;

import com.igormaznitsa.jbbp.io.JBBPBitInputStream;
import com.igormaznitsa.zxpoly.components.tapereader.tzx.AbstractTzxBlock;
import com.igormaznitsa.zxpoly.components.tapereader.tzx.TzxBlockArchiveInfo;
import com.igormaznitsa.zxpoly.components.tapereader.tzx.TzxBlockC64Rom;
import com.igormaznitsa.zxpoly.components.tapereader.tzx.TzxBlockC64Turbo;
import com.igormaznitsa.zxpoly.components.tapereader.tzx.TzxBlockCSWRecording;
import com.igormaznitsa.zxpoly.components.tapereader.tzx.TzxBlockCallSequence;
import com.igormaznitsa.zxpoly.components.tapereader.tzx.TzxBlockCustomInfo;
import com.igormaznitsa.zxpoly.components.tapereader.tzx.TzxBlockDirectRecording;
import com.igormaznitsa.zxpoly.components.tapereader.tzx.TzxBlockEmulationinfo;
import com.igormaznitsa.zxpoly.components.tapereader.tzx.TzxBlockGeneralizedData;
import com.igormaznitsa.zxpoly.components.tapereader.tzx.TzxBlockGlue;
import com.igormaznitsa.zxpoly.components.tapereader.tzx.TzxBlockGroupEnd;
import com.igormaznitsa.zxpoly.components.tapereader.tzx.TzxBlockGroupStart;
import com.igormaznitsa.zxpoly.components.tapereader.tzx.TzxBlockHardwareType;
import com.igormaznitsa.zxpoly.components.tapereader.tzx.TzxBlockJumpTo;
import com.igormaznitsa.zxpoly.components.tapereader.tzx.TzxBlockKansasCityStandard;
import com.igormaznitsa.zxpoly.components.tapereader.tzx.TzxBlockLoopEnd;
import com.igormaznitsa.zxpoly.components.tapereader.tzx.TzxBlockLoopStart;
import com.igormaznitsa.zxpoly.components.tapereader.tzx.TzxBlockMessage;
import com.igormaznitsa.zxpoly.components.tapereader.tzx.TzxBlockPauseOrStop;
import com.igormaznitsa.zxpoly.components.tapereader.tzx.TzxBlockPureData;
import com.igormaznitsa.zxpoly.components.tapereader.tzx.TzxBlockPureTone;
import com.igormaznitsa.zxpoly.components.tapereader.tzx.TzxBlockSelect;
import com.igormaznitsa.zxpoly.components.tapereader.tzx.TzxBlockSequenceReturn;
import com.igormaznitsa.zxpoly.components.tapereader.tzx.TzxBlockSetSignalLevel;
import com.igormaznitsa.zxpoly.components.tapereader.tzx.TzxBlockSnapshot;
import com.igormaznitsa.zxpoly.components.tapereader.tzx.TzxBlockStandardSpeedData;
import com.igormaznitsa.zxpoly.components.tapereader.tzx.TzxBlockStopTapeIf48k;
import com.igormaznitsa.zxpoly.components.tapereader.tzx.TzxBlockTextDescription;
import com.igormaznitsa.zxpoly.components.tapereader.tzx.TzxBlockTurboSpeedData;
import com.igormaznitsa.zxpoly.components.tapereader.tzx.TzxBlockVarSequencePulses;
import java.io.IOException;
import java.util.Locale;

public enum TzxBlockId {
    STANDARD_SPEED_DATA_BLOCK(16, TzxBlockStandardSpeedData::new),
    TURBO_SPEED_DATA_BLOCK(17, TzxBlockTurboSpeedData::new),
    PURE_TONE(18, TzxBlockPureTone::new),
    VAR_SEQUENCE_PULSES(19, TzxBlockVarSequencePulses::new),
    PURE_DATA_BLOCK(20, TzxBlockPureData::new),
    DIRECT_RECORDING_BLOCK(21, TzxBlockDirectRecording::new),
    CSW_RECORDING_BLOCK(24, TzxBlockCSWRecording::new),
    GENERALIZED_DATA_BLOCK(25, TzxBlockGeneralizedData::new),
    PAUSE_OR_STOP(32, TzxBlockPauseOrStop::new),
    GROUP_START(33, TzxBlockGroupStart::new),
    GROUP_END(34, TzxBlockGroupEnd::new),
    JUMP_TO_BLOCK(35, TzxBlockJumpTo::new),
    LOOP_START(36, TzxBlockLoopStart::new),
    LOOP_END(37, TzxBlockLoopEnd::new),
    CALL_SEQUENCE(38, TzxBlockCallSequence::new),
    RETURN_FROM_SEQUENCE(39, TzxBlockSequenceReturn::new),
    SELECT_BLOCK(40, TzxBlockSelect::new),
    STOP_TAPE_IF_48K(42, TzxBlockStopTapeIf48k::new),
    SET_SIGNAL_LEVEL(43, TzxBlockSetSignalLevel::new),
    TEXT_DESCRIPTION(48, TzxBlockTextDescription::new),
    MESSAGE_BLOCK(49, TzxBlockMessage::new),
    ARCHIVE_INFO(50, TzxBlockArchiveInfo::new),
    HARDWARE_TYPE(51, TzxBlockHardwareType::new),
    EMULATION_INFO(52, TzxBlockEmulationinfo::new),
    CUSTOM_INFO(53, TzxBlockCustomInfo::new),
    SNAPSHOT(64, TzxBlockSnapshot::new),
    KANSAS_CITY_STANDARD(75, TzxBlockKansasCityStandard::new),
    C64ROM(22, TzxBlockC64Rom::new),
    C64TURBO(23, TzxBlockC64Turbo::new),
    GLUE(90, TzxBlockGlue::new),
    UNKNOWN(-1, in -> {
        throw new IOException("UNKNOWN BLOCK");
    });

    private final int id;
    private final TzxReadFunction readFunction;

    private TzxBlockId(int id, TzxReadFunction readFunction) {
        this.id = id;
        this.readFunction = readFunction;
    }

    public static AbstractTzxBlock readNextBlock(JBBPBitInputStream inputStream) throws IOException {
        int id = inputStream.readByte();
        TzxBlockId block = UNKNOWN;
        for (TzxBlockId b : TzxBlockId.values()) {
            if (b.id != id) continue;
            block = b;
            break;
        }
        if (block == UNKNOWN) {
            throw new IOException("Unsupported block id: 0x" + Integer.toHexString(id).toUpperCase(Locale.ENGLISH));
        }
        return block.getReadFunction().read(inputStream);
    }

    public int getId() {
        return this.id;
    }

    public TzxReadFunction getReadFunction() {
        return this.readFunction;
    }

    @FunctionalInterface
    public static interface TzxReadFunction {
        public AbstractTzxBlock read(JBBPBitInputStream var1) throws IOException;
    }
}

