/*
 * Decompiled with CFR 0.152.
 */
package com.igormaznitsa.zxpoly.components.tapereader.tzx;

import com.igormaznitsa.jbbp.io.JBBPBitInputStream;
import com.igormaznitsa.jbbp.io.JBBPBitOutputStream;
import com.igormaznitsa.zxpoly.components.tapereader.tzx.AbstractTzxInformationBlock;
import com.igormaznitsa.zxpoly.components.tapereader.tzx.TzxBlockId;
import java.io.IOException;
import java.nio.charset.StandardCharsets;

public class TzxBlockMessage
extends AbstractTzxInformationBlock {
    private final int timeInSeconds;
    private final String text;

    public TzxBlockMessage(JBBPBitInputStream inputStream) throws IOException {
        super(TzxBlockId.MESSAGE_BLOCK.getId());
        this.timeInSeconds = inputStream.readByte();
        int chars = inputStream.readByte();
        this.text = new String(inputStream.readByteArray(chars), StandardCharsets.ISO_8859_1);
    }

    public int getTimeInSeconds() {
        return this.timeInSeconds;
    }

    public String getText() {
        return this.text;
    }

    @Override
    public void write(JBBPBitOutputStream outputStream) throws IOException {
        super.write(outputStream);
        outputStream.write(this.timeInSeconds);
        byte[] chars = this.text.getBytes(StandardCharsets.ISO_8859_1);
        outputStream.write(chars.length);
        outputStream.write(chars);
    }
}

