/*
 * Decompiled with CFR 0.152.
 */
package com.igormaznitsa.zxpoly.components.tapereader.tzx;

import com.igormaznitsa.jbbp.io.JBBPBitInputStream;
import com.igormaznitsa.jbbp.io.JBBPBitOutputStream;
import com.igormaznitsa.zxpoly.components.tapereader.tzx.AbstractTzxSoundDataBlock;
import com.igormaznitsa.zxpoly.components.tapereader.tzx.TzxBlockId;
import com.igormaznitsa.zxpoly.components.tapereader.tzx.TzxDeprecatedBlock;
import java.io.IOException;

public class TzxBlockSnapshot
extends AbstractTzxSoundDataBlock
implements TzxDeprecatedBlock {
    private final int type;
    private final byte[] data;

    public TzxBlockSnapshot(JBBPBitInputStream inputStream) throws IOException {
        super(TzxBlockId.SNAPSHOT.getId());
        this.type = inputStream.read();
        int length = TzxBlockSnapshot.readThreeByteValue(inputStream);
        this.data = inputStream.readByteArray(length);
    }

    public int getType() {
        return this.type;
    }

    @Override
    public int getDataLength() {
        return this.data.length;
    }

    @Override
    public byte[] extractData() throws IOException {
        return this.data;
    }

    @Override
    public void write(JBBPBitOutputStream outputStream) throws IOException {
        super.write(outputStream);
        outputStream.write(this.type);
        TzxBlockSnapshot.writeThreeByteValue(outputStream, this.data.length);
        outputStream.write(this.data);
    }
}

