/*
 * Decompiled with CFR 0.152.
 */
package com.igormaznitsa.zxpoly.components.tapereader.tzx;

import com.igormaznitsa.jbbp.io.JBBPBitInputStream;
import com.igormaznitsa.jbbp.io.JBBPBitOutputStream;
import com.igormaznitsa.zxpoly.components.tapereader.tzx.AbstractTzxSoundDataBlock;
import com.igormaznitsa.zxpoly.components.tapereader.tzx.TzxBlockId;
import java.io.IOException;

public class TzxBlockStandardSpeedData
extends AbstractTzxSoundDataBlock {
    private final int pauseAfterBlockMs;
    private final byte[] data;

    public TzxBlockStandardSpeedData(JBBPBitInputStream inputStream) throws IOException {
        super(TzxBlockId.STANDARD_SPEED_DATA_BLOCK.getId());
        this.pauseAfterBlockMs = TzxBlockStandardSpeedData.readWord(inputStream);
        int dataLength = TzxBlockStandardSpeedData.readWord(inputStream);
        this.data = inputStream.readByteArray(dataLength);
    }

    @Override
    public byte[] extractData() throws IOException {
        return this.data;
    }

    public int getPauseAfterBlockMs() {
        return this.pauseAfterBlockMs;
    }

    @Override
    public int getDataLength() {
        return this.data.length;
    }

    @Override
    public void write(JBBPBitOutputStream outputStream) throws IOException {
        super.write(outputStream);
        TzxBlockStandardSpeedData.writeWord(outputStream, this.pauseAfterBlockMs);
        TzxBlockStandardSpeedData.writeWord(outputStream, this.data.length);
        outputStream.write(this.data);
    }
}

