/*
 * Decompiled with CFR 0.152.
 */
package com.igormaznitsa.zxpoly.components.tapereader.tzx;

import com.igormaznitsa.jbbp.io.JBBPBitInputStream;
import com.igormaznitsa.jbbp.io.JBBPBitOutputStream;
import com.igormaznitsa.zxpoly.components.tapereader.tzx.AbstractTzxSoundDataBlock;
import com.igormaznitsa.zxpoly.components.tapereader.tzx.TzxBlockId;
import java.io.IOException;

public class TzxBlockTurboSpeedData
extends AbstractTzxSoundDataBlock {
    private final int pauseAfterBlockMs;
    private final byte[] data;
    private final int lengthPilotPulse;
    private final int lengthSyncFirstPulse;
    private final int lengthSyncSecondPulse;
    private final int lengthZeroBitPulse;
    private final int lengthOneBitPulse;
    private final int lengthPilotTone;
    private final int usedBitsInLastByte;

    public TzxBlockTurboSpeedData(JBBPBitInputStream inputStream) throws IOException {
        super(TzxBlockId.TURBO_SPEED_DATA_BLOCK.getId());
        this.lengthPilotPulse = TzxBlockTurboSpeedData.readWord(inputStream);
        this.lengthSyncFirstPulse = TzxBlockTurboSpeedData.readWord(inputStream);
        this.lengthSyncSecondPulse = TzxBlockTurboSpeedData.readWord(inputStream);
        this.lengthZeroBitPulse = TzxBlockTurboSpeedData.readWord(inputStream);
        this.lengthOneBitPulse = TzxBlockTurboSpeedData.readWord(inputStream);
        this.lengthPilotTone = TzxBlockTurboSpeedData.readWord(inputStream);
        this.usedBitsInLastByte = inputStream.readByte();
        this.pauseAfterBlockMs = TzxBlockTurboSpeedData.readWord(inputStream);
        int dataLength = TzxBlockTurboSpeedData.readThreeByteValue(inputStream);
        this.data = inputStream.readByteArray(dataLength);
    }

    @Override
    public byte[] extractData() throws IOException {
        return this.data;
    }

    @Override
    public void write(JBBPBitOutputStream outputStream) throws IOException {
        super.write(outputStream);
        TzxBlockTurboSpeedData.writeWord(outputStream, this.lengthPilotPulse);
        TzxBlockTurboSpeedData.writeWord(outputStream, this.lengthSyncFirstPulse);
        TzxBlockTurboSpeedData.writeWord(outputStream, this.lengthSyncSecondPulse);
        TzxBlockTurboSpeedData.writeWord(outputStream, this.lengthZeroBitPulse);
        TzxBlockTurboSpeedData.writeWord(outputStream, this.lengthOneBitPulse);
        TzxBlockTurboSpeedData.writeWord(outputStream, this.lengthPilotTone);
        outputStream.write(this.usedBitsInLastByte);
        TzxBlockTurboSpeedData.writeWord(outputStream, this.pauseAfterBlockMs);
        TzxBlockTurboSpeedData.writeThreeByteValue(outputStream, this.data.length);
        outputStream.write(this.data);
    }

    public int getPauseAfterBlockMs() {
        return this.pauseAfterBlockMs;
    }

    @Override
    public int getDataLength() {
        return this.data.length;
    }

    public int getLengthPilotPulse() {
        return this.lengthPilotPulse;
    }

    public int getLengthSyncFirstPulse() {
        return this.lengthSyncFirstPulse;
    }

    public int getLengthSyncSecondPulse() {
        return this.lengthSyncSecondPulse;
    }

    public int getLengthZeroBitPulse() {
        return this.lengthZeroBitPulse;
    }

    public int getLengthOneBitPulse() {
        return this.lengthOneBitPulse;
    }

    public int getLengthPilotTone() {
        return this.lengthPilotTone;
    }

    public int getUsedBitsInLastByte() {
        return this.usedBitsInLastByte;
    }
}

