/*
 * Decompiled with CFR 0.152.
 */
package com.igormaznitsa.zxpoly.components.tapereader.tzx;

import com.igormaznitsa.jbbp.io.JBBPBitInputStream;
import com.igormaznitsa.jbbp.io.JBBPBitOutputStream;
import com.igormaznitsa.zxpoly.components.tapereader.tzx.AbstractTzxBlock;
import com.igormaznitsa.zxpoly.components.tapereader.tzx.TzxBlockId;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.stream.Stream;

public class TzxFile {
    private final int revisionMajor;
    private final int revisionMinor;
    private final List<AbstractTzxBlock> blockList;

    public TzxFile(InputStream inputStream) throws IOException {
        JBBPBitInputStream jbbpBitInputStream = new JBBPBitInputStream(inputStream);
        String signature = new String(jbbpBitInputStream.readByteArray(7), StandardCharsets.ISO_8859_1);
        if (!signature.equals("ZXTape!")) {
            throw new IOException("TZX signature error: " + signature);
        }
        if (jbbpBitInputStream.readByte() != 26) {
            throw new IOException("TZX error end of text file marker");
        }
        this.revisionMajor = jbbpBitInputStream.readByte();
        this.revisionMinor = jbbpBitInputStream.readByte();
        ArrayList<AbstractTzxBlock> blocks = new ArrayList<AbstractTzxBlock>();
        while (jbbpBitInputStream.hasAvailableData()) {
            blocks.add(TzxBlockId.readNextBlock(jbbpBitInputStream));
        }
        this.blockList = Collections.unmodifiableList(blocks);
    }

    public Stream<AbstractTzxBlock> stream() {
        return this.blockList.stream();
    }

    public List<AbstractTzxBlock> getBlockList() {
        return this.blockList;
    }

    public int getRevisionMajor() {
        return this.revisionMajor;
    }

    public int getRevisionMinor() {
        return this.revisionMinor;
    }

    public void write(OutputStream outputStream) throws IOException {
        JBBPBitOutputStream jbbpBitOutputStream = new JBBPBitOutputStream(outputStream);
        jbbpBitOutputStream.write("ZXTape!".getBytes(StandardCharsets.ISO_8859_1));
        jbbpBitOutputStream.write(26);
        jbbpBitOutputStream.write(this.revisionMajor);
        jbbpBitOutputStream.write(this.revisionMinor);
        for (AbstractTzxBlock block : this.blockList) {
            block.write(jbbpBitOutputStream);
        }
        jbbpBitOutputStream.flush();
    }
}

