/*
 * Decompiled with CFR 0.152.
 */
package com.igormaznitsa.zxpoly.components.tapereader.wave;

import com.igormaznitsa.zxpoly.components.tapereader.wave.SeekableContainer;
import java.io.EOFException;
import java.io.IOException;

public class ByteArraySeekableContainer
implements SeekableContainer {
    private final byte[] data;
    private int pointer;

    public ByteArraySeekableContainer(byte[] data) {
        this.data = data;
    }

    @Override
    public long length() throws IOException {
        return this.data.length;
    }

    @Override
    public long getFilePointer() throws IOException {
        return this.pointer;
    }

    private int read() {
        if (this.pointer < this.data.length) {
            return this.data[this.pointer++] & 0xFF;
        }
        return -1;
    }

    @Override
    public int readUnsignedShort() throws IOException {
        int ch2;
        int ch1 = this.read();
        if ((ch1 | (ch2 = this.read())) < 0) {
            throw new EOFException();
        }
        return ch1 << 8 | ch2;
    }

    @Override
    public void readFully(byte[] wavData) throws IOException {
        for (int i = 0; i < wavData.length; ++i) {
            int value = this.read();
            if (value < 0) {
                throw new EOFException();
            }
            wavData[i] = (byte)value;
        }
    }

    @Override
    public int readInt() throws IOException {
        int ch4;
        int ch3;
        int ch2;
        int ch1 = this.read();
        if ((ch1 | (ch2 = this.read()) | (ch3 = this.read()) | (ch4 = this.read())) < 0) {
            throw new EOFException();
        }
        return ch1 << 24 | ch2 << 16 | ch3 << 8 | ch4;
    }

    @Override
    public void seek(long pos) throws IOException {
        if (pos < 0L) {
            throw new IOException("Negative seek offset");
        }
        this.pointer = (int)pos;
    }

    @Override
    public int skipBytes(int bytes) throws IOException {
        int value;
        int counter = 0;
        for (int i = 0; i < bytes && (value = this.read()) >= 0; ++i) {
            ++counter;
        }
        return counter;
    }

    @Override
    public void close() throws IOException {
    }
}

