/*
 * Decompiled with CFR 0.152.
 */
package com.igormaznitsa.zxpoly.components.tapereader.wave;

import com.igormaznitsa.zxpoly.components.tapereader.wave.SeekableContainer;
import java.io.IOException;

public final class InMemoryWavFile {
    private final byte[] wavData;
    private final int audioFormat;
    private final int numChannels;
    private final int sampleRate;
    private final int byteRate;
    private final int blockAlign;
    private final int bitsPerSample;
    private final long wavDataStartOffset;
    private final double tstatesPerBlock;

    public InMemoryWavFile(SeekableContainer seekableContainer, long tstatesPerSecond) throws IOException {
        long fileSize = seekableContainer.length();
        if (!InMemoryWavFile.is("RIFF", InMemoryWavFile.readChunkId(seekableContainer))) {
            throw new IOException("It is not RIFF container");
        }
        int chunkSize = InMemoryWavFile.readInt(seekableContainer);
        if (chunkSize < 36) {
            throw new IOException("Wrong container length in WAV file");
        }
        if (!InMemoryWavFile.is("WAVE", InMemoryWavFile.readChunkId(seekableContainer))) {
            throw new IOException("It is not WAV file");
        }
        long startSubChunksPos = seekableContainer.getFilePointer();
        if (!InMemoryWavFile.posToChunk(seekableContainer, "fmt ", startSubChunksPos, fileSize)) {
            throw new IOException("Can't find 'fmt' chunk");
        }
        long formatChunkSize = InMemoryWavFile.readChunkSize(seekableContainer);
        if (formatChunkSize < 16L) {
            throw new IOException("'fmt' chunk has size less than 16");
        }
        this.audioFormat = InMemoryWavFile.readShort(seekableContainer);
        this.numChannels = InMemoryWavFile.readShort(seekableContainer);
        this.sampleRate = InMemoryWavFile.readInt(seekableContainer);
        this.byteRate = InMemoryWavFile.readInt(seekableContainer);
        this.blockAlign = InMemoryWavFile.readShort(seekableContainer);
        this.bitsPerSample = InMemoryWavFile.readShort(seekableContainer);
        if (this.audioFormat != 1 && this.audioFormat != 3) {
            throw new IOException("Only PCM format is supported: " + this.audioFormat);
        }
        if (this.bitsPerSample != 8 && this.bitsPerSample != 16 && this.bitsPerSample != 24 && this.bitsPerSample != 32) {
            throw new IOException("Unsupported bit sample size: " + this.bitsPerSample);
        }
        if (!InMemoryWavFile.posToChunk(seekableContainer, "data", startSubChunksPos, fileSize)) {
            throw new IOException("Can't find chunk 'data'");
        }
        long dataLength = InMemoryWavFile.readChunkSize(seekableContainer);
        if (dataLength >= Integer.MAX_VALUE) {
            throw new IOException("Too big WAV file to be cached: " + dataLength + " bytes");
        }
        this.wavData = new byte[(int)dataLength];
        this.wavDataStartOffset = seekableContainer.getFilePointer();
        seekableContainer.readFully(this.wavData);
        this.tstatesPerBlock = (double)this.sampleRate / (double)tstatesPerSecond;
    }

    private static int readChunkId(SeekableContainer file) throws IOException {
        return file.readInt();
    }

    private static long readChunkSize(SeekableContainer file) throws IOException {
        return (long)InMemoryWavFile.readInt(file) & 0xFFFFFFFFL;
    }

    private static int readInt(SeekableContainer file) throws IOException {
        int value = file.readInt();
        int result = 0;
        for (int i = 0; i < 4; ++i) {
            result = value & 0xFF | result << 8;
            value >>>= 8;
        }
        return result;
    }

    private static int readShort(SeekableContainer file) throws IOException {
        int value = file.readUnsignedShort();
        return (value & 0xFF) << 8 | value >>> 8;
    }

    private static boolean is(String text, int value) {
        int textAsInt = (text.charAt(0) & 0xFF) << 24 | (text.charAt(1) & 0xFF) << 16 | (text.charAt(2) & 0xFF) << 8 | text.charAt(3) & 0xFF;
        return textAsInt == value;
    }

    private static boolean posToChunk(SeekableContainer file, String chunkName, long from, long length) throws IOException {
        file.seek(from);
        while (file.getFilePointer() < length) {
            if (InMemoryWavFile.is(chunkName, InMemoryWavFile.readChunkId(file))) {
                return true;
            }
            int chunkSize = InMemoryWavFile.readInt(file);
            file.skipBytes(chunkSize);
        }
        return false;
    }

    public int getBitsPerSample() {
        return this.bitsPerSample;
    }

    private float readUnsignedByteAt(long pos) {
        return (float)(this.wavData[(int)pos] & 0xFF) / 255.0f;
    }

    private float readSignedShort(long pos) {
        int p = (int)pos;
        int a = this.wavData[p++] & 0xFF;
        byte b = this.wavData[p];
        return (float)(b << 8 | a) / 32767.0f;
    }

    private float readPcm24(long pos) {
        int p = (int)pos;
        int a = this.wavData[p++] & 0xFF;
        int b = this.wavData[p++] & 0xFF;
        byte c = this.wavData[p];
        return (float)(c << 16 | b << 8 | a) / 8388607.0f;
    }

    private float readPcm32(long pos) {
        int p = (int)pos;
        int a = this.wavData[p++] & 0xFF;
        int b = this.wavData[p++] & 0xFF;
        int c = this.wavData[p++] & 0xFF;
        byte d = this.wavData[p];
        int result = d << 24 | c << 16 | b << 8 | a;
        if (this.audioFormat == 3) {
            return Float.intBitsToFloat(result);
        }
        return (float)result / 2.1474836E9f;
    }

    public long findTstatesForWavDataPosition(long wavFileOffset) {
        return Math.round((double)(wavFileOffset - this.wavDataStartOffset) / this.tstatesPerBlock);
    }

    public long calcPositionInWavData(long tstatePosition) {
        return Math.round(this.tstatesPerBlock * (double)tstatePosition) * (long)this.blockAlign;
    }

    public long calcPositionInWavFile(long tstatePosition) {
        return this.calcPositionInWavData(tstatePosition) + this.wavDataStartOffset;
    }

    public float readAtPosition(long tstatePosition) {
        long blockPosition = Math.round(this.tstatesPerBlock * (double)tstatePosition) * (long)this.blockAlign;
        if (this.numChannels == 1) {
            switch (this.bitsPerSample) {
                case 8: {
                    return this.readUnsignedByteAt(blockPosition);
                }
                case 16: {
                    return this.readSignedShort(blockPosition);
                }
                case 24: {
                    return this.readPcm24(blockPosition);
                }
                case 32: {
                    return this.readPcm32(blockPosition);
                }
            }
            throw new Error("Unexpected bitness");
        }
        float result = 0.0f;
        for (int i = 0; i < this.numChannels; ++i) {
            result += (switch (this.bitsPerSample) {
                case 8 -> this.readUnsignedByteAt(blockPosition);
                case 16 -> this.readSignedShort(blockPosition);
                case 24 -> this.readPcm24(blockPosition);
                case 32 -> this.readPcm32(blockPosition);
                default -> throw new Error("Unexpected bitness");
            });
            blockPosition += (long)this.blockAlign;
        }
        return result /= (float)this.numChannels;
    }

    public void dispose() {
    }

    public int getBlockAlign() {
        return this.blockAlign;
    }

    public int getByteRate() {
        return this.byteRate;
    }

    public int getSampleRate() {
        return this.sampleRate;
    }

    public int getNumChannels() {
        return this.numChannels;
    }

    public int getAudioFormat() {
        return this.audioFormat;
    }

    public int size() {
        return this.wavData.length;
    }
}

