/*
 * Decompiled with CFR 0.152.
 */
package com.igormaznitsa.zxpoly.components.video;

import com.igormaznitsa.zxpoly.Bounds;
import com.igormaznitsa.zxpoly.MainForm;
import com.igormaznitsa.zxpoly.components.BoardMode;
import com.igormaznitsa.zxpoly.components.IoDevice;
import com.igormaznitsa.zxpoly.components.Motherboard;
import com.igormaznitsa.zxpoly.components.ZxPolyConstants;
import com.igormaznitsa.zxpoly.components.ZxPolyModule;
import com.igormaznitsa.zxpoly.components.video.BorderWidth;
import com.igormaznitsa.zxpoly.components.video.UlaPlusContainer;
import com.igormaznitsa.zxpoly.components.video.VirtualKeyboardDecoration;
import com.igormaznitsa.zxpoly.components.video.VirtualKeyboardRender;
import com.igormaznitsa.zxpoly.components.video.timings.TimingProfile;
import com.igormaznitsa.zxpoly.components.video.tvfilters.TvFilter;
import com.igormaznitsa.zxpoly.components.video.tvfilters.TvFilterChain;
import com.igormaznitsa.zxpoly.formats.Spec256Arch;
import com.igormaznitsa.zxpoly.ui.FastButton;
import com.igormaznitsa.zxpoly.utils.AppOptions;
import com.igormaznitsa.zxpoly.utils.Utils;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferInt;
import java.awt.image.RenderedImage;
import java.lang.reflect.InvocationTargetException;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.SwingUtilities;

public final class VideoController
extends JComponent
implements ZxPolyConstants,
MouseWheelListener,
IoDevice {
    public static final int ZXSCREEN_ROWS = 192;
    public static final int ZXSCREEN_COLS = 256;
    public static final int SCREEN_WIDTH = 512;
    public static final int SCREEN_HEIGHT = 384;
    public static final int[] PALETTE_ZXPOLY = new int[]{-16777216, -16777026, -4325376, -4325186, -16728576, -16728386, -4276736, -4276546, -16777216, -16776961, -65536, -65281, -16711936, -16711681, -256, -1};
    public static final Color[] PALETTE_ZXPOLY_COLORS = new Color[]{new Color(0, 0, 0), new Color(0, 0, 190), new Color(190, 0, 0), new Color(190, 0, 190), new Color(0, 190, 0), new Color(0, 190, 190), new Color(190, 190, 0), new Color(190, 190, 190), new Color(0, 0, 0), new Color(0, 0, 255), new Color(255, 0, 0), new Color(255, 0, 255), new Color(0, 255, 0), new Color(0, 255, 255), new Color(255, 255, 0), new Color(255, 255, 255)};
    public static final int[] PALETTE_SPEC256 = Utils.readRawPalette(VideoController.class.getResourceAsStream("/com/igormaznitsa/zxpoly/pal/spec256.raw.pal"), true);
    private static final int[] PALETTE_ALIGNED_ZXPOLY = Utils.alignPaletteColors(PALETTE_ZXPOLY, PALETTE_SPEC256);
    private static final Logger log = Logger.getLogger(VideoController.class.getName());
    private static final long serialVersionUID = -6290427036692912036L;
    private static final Image MOUSE_TRAPPED = Utils.loadIcon("escmouse.png");
    private static final float SCALE_STEP = 0.025f;
    private static final float SCALE_MIN = 1.0f;
    private static final float SCALE_MAX = 6.0f;
    private static final int[] ZX_SCREEN_ROW_OFFSETS = VideoController.generateZxScreenRowStartOffsets();
    private static final int BORDER_SHORT = 16;
    private static volatile boolean gfxBackOverFF = false;
    private static volatile boolean gfxPaper00InkFF = false;
    private static volatile boolean gfxHideSameInkPaper = true;
    private static volatile int gfxUpColorsMixed = 64;
    private static volatile int gfxDownColorsMixed = 0;
    private static volatile int[] gfxPrerenderedBack = null;
    private final VirtualKeyboardDecoration vkbdContainer;
    private final Motherboard board;
    private final BufferedImage workZxScreenImage;
    private final BufferedImage outputZxScreenImage;
    private final int[] workZxScreenImageRgbData;
    private final ZxPolyModule[] modules;
    private final boolean showVkbdApart;
    private final TimingProfile timingProfile;
    private final boolean syncRepaint;
    private final Dimension baseComponentSize;
    private final BufferedImage borderImage;
    private final int[] borderImageRgbData;
    private final BorderWidth borderWidth;
    private final boolean virtualKeyboardUndecorated;
    private volatile int currentVideoMode = 7;
    private Dimension size = new Dimension(512, 384);
    private volatile float zoom = 1.0f;
    private volatile int portFEw = 0;
    private volatile boolean mouseTrapActive = false;
    private volatile boolean mouseTrapEnabled = false;
    private volatile boolean showVkb = false;
    private volatile TvFilterChain tvFilterChain = TvFilterChain.NONE;
    private volatile boolean enableMouseTrapIndicator = false;
    private Window vkbdWindow = null;
    private boolean fullScreenMode;
    private VirtualKeyboardRender vkbdRender;
    private int stepStartTiStates = 0;
    private int preStepBorderColor;
    private Rectangle lastVirtualKeyboardWindowPosition = null;
    private final UlaPlusContainer ulaPlus;
    private final Lock lockWorkImage = new ReentrantLock();
    private final Lock lockOutputImage = new ReentrantLock();

    public VideoController(BorderWidth borderWidth, TimingProfile timingProfile, boolean syncRepaint, Bounds virtualKeyboardPosition, Motherboard board, VirtualKeyboardDecoration vkbdContainer, boolean ulaPlus) {
        this.ulaPlus = new UlaPlusContainer(ulaPlus);
        if (this.ulaPlus.isEnabled()) {
            log.info("ULA PLUS is enabled");
        }
        this.borderWidth = borderWidth;
        this.syncRepaint = syncRepaint;
        this.timingProfile = timingProfile;
        switch (this.borderWidth) {
            case FULL: {
                this.baseComponentSize = new Dimension(512 + (this.timingProfile.tstatesPerBorderLeft << 2) + (this.timingProfile.tstatesPerBorderRight << 2), 384 + this.timingProfile.linesBorderTop + this.timingProfile.linesBorderBottom);
                break;
            }
            case SHORT: {
                this.baseComponentSize = new Dimension(544, 416);
                break;
            }
            case NONE: {
                this.baseComponentSize = new Dimension(512, 384);
                break;
            }
            default: {
                throw new Error("Unsupported border width: " + String.valueOf((Object)this.borderWidth));
            }
        }
        this.setFocusTraversalKeysEnabled(false);
        this.vkbdContainer = Objects.requireNonNull(vkbdContainer);
        if (virtualKeyboardPosition == null) {
            this.showVkbdApart = AppOptions.getInstance().isVkbdApart();
            this.virtualKeyboardUndecorated = false;
        } else {
            this.showVkbdApart = true;
            this.virtualKeyboardUndecorated = true;
            this.lastVirtualKeyboardWindowPosition = virtualKeyboardPosition.asRectangle();
        }
        this.board = board;
        this.modules = board.getModules();
        this.workZxScreenImage = new BufferedImage(512, 384, 1);
        this.outputZxScreenImage = new BufferedImage(512, 384, 1);
        this.outputZxScreenImage.setAccelerationPriority(1.0f);
        this.workZxScreenImage.setAccelerationPriority(1.0f);
        this.workZxScreenImageRgbData = ((DataBufferInt)this.workZxScreenImage.getRaster().getDataBuffer()).getData();
        this.borderImage = new BufferedImage(this.timingProfile.tstatesPerLine, this.timingProfile.scanLines, 1);
        this.borderImage.setAccelerationPriority(1.0f);
        this.borderImageRgbData = ((DataBufferInt)this.borderImage.getRaster().getDataBuffer()).getData();
        this.addMouseWheelListener(this);
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                if (!e.isConsumed() && VideoController.this.vkbdWindow == null && !VideoController.this.mouseTrapActive && VideoController.this.showVkb) {
                    VideoController.this.vkbdRender.setLastMouseEvent(e);
                    e.consume();
                }
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                if (!e.isConsumed() && VideoController.this.vkbdWindow == null && !VideoController.this.mouseTrapActive && VideoController.this.showVkb) {
                    VideoController.this.vkbdRender.setLastMouseEvent(e);
                    e.consume();
                }
            }
        });
        this.setDoubleBuffered(false);
    }

    private static void fillDataBufferForZxSpectrum128Mode(LineRenderMode renderLines, ZxPolyModule[] modules, int[] pixelRgbBuffer, boolean flashActive, int lineFrom, int lineTo, UlaPlusContainer ulaPlus) {
        ZxPolyModule mainModule = modules[0];
        byte[] heap = mainModule.getMotherboard().getHeapRam();
        int videoRamHeapOffset = (mainModule.read7FFD() & 8) == 0 ? mainModule.getHeapOffset() + 81920 : mainModule.getHeapOffset() + 114688;
        boolean useUlaPlus = ulaPlus.isActive();
        int offset = 0;
        int attributeOffset = 0;
        for (int yy = lineFrom; yy < lineTo; ++yy) {
            int addressFrom = ZX_SCREEN_ROW_OFFSETS[yy];
            int addressTo = addressFrom + 32;
            for (int i = addressFrom; i < addressTo; ++i) {
                int argbPaperColor;
                int argbInkColor;
                if ((i & 0x1F) == 0) {
                    int y = VideoController.extractYFromAddress(i);
                    offset = y << 10;
                    attributeOffset = VideoController.calcAttributeAddressZxMode(i);
                }
                int currentPixels = heap[videoRamHeapOffset + i] & 0xFF;
                int attrOffset = attributeOffset++;
                if (useUlaPlus) {
                    int attribute = heap[videoRamHeapOffset + attrOffset] & 0xFF;
                    argbInkColor = ulaPlus.findInkRgbForAttribute(attribute);
                    argbPaperColor = ulaPlus.findPaperRgbForAttribute(attribute);
                } else {
                    int effectiveAttribute = heap[videoRamHeapOffset + attrOffset];
                    effectiveAttribute = flashActive && (effectiveAttribute & 0x80) != 0 ? effectiveAttribute & 0x40 | effectiveAttribute >> 3 & 7 | (effectiveAttribute & 7) << 3 : effectiveAttribute;
                    argbInkColor = VideoController.extractInkPaletteColor(effectiveAttribute);
                    argbPaperColor = VideoController.extractPaperPaletteColor(effectiveAttribute);
                }
                int x = 8;
                while (x-- > 0) {
                    int color = (currentPixels & 0x80) == 0 ? argbPaperColor : argbInkColor;
                    currentPixels <<= 1;
                    offset = renderLines.apply(pixelRgbBuffer, offset, color);
                }
            }
        }
    }

    private static int[] generateZxScreenRowStartOffsets() {
        int[] result = new int[193];
        for (int y = 0; y < 193; ++y) {
            result[y] = (y & 0xC0) << 5 | (y & 7) << 8 | (y & 0x38) << 2;
        }
        return result;
    }

    public static void setGfxBack(Spec256Arch.Spec256Bkg bkg) {
        if (bkg == null) {
            gfxPrerenderedBack = null;
        } else {
            int yoffset = (bkg.getHeight() - 192) / 2;
            int xoffset = (bkg.getWidth() - 256) / 2;
            int[] prerendered = new int[196608];
            byte[] imgData = bkg.getData();
            for (int y = 0; y < 192; ++y) {
                for (int x = 0; x < 256; ++x) {
                    int color = PALETTE_SPEC256[imgData[(y + yoffset) * bkg.getWidth() + x + xoffset] & 0xFF];
                    int zxoffset = y * 512 * 2 + x * 2;
                    prerendered[zxoffset] = color;
                    prerendered[zxoffset++ + 512] = color;
                    prerendered[zxoffset] = color;
                    prerendered[zxoffset + 512] = color;
                }
            }
            gfxPrerenderedBack = prerendered;
        }
    }

    public static int toZxPolyIndex(byte spec256PaletteIndex) {
        int spec256argb = PALETTE_SPEC256[spec256PaletteIndex & 0xFF];
        int sr = spec256argb >>> 16 & 0xFF;
        int sg = spec256argb >>> 8 & 0xFF;
        int sb = spec256argb & 0xFF;
        double minDistance = Double.MAX_VALUE;
        int zxPolyIndex = 0;
        for (int i = 0; i < PALETTE_ZXPOLY.length; ++i) {
            int zpolyArgb = PALETTE_ZXPOLY[i];
            double dr = sr - (zpolyArgb >>> 16 & 0xFF);
            double dg = sg - (zpolyArgb >>> 8 & 0xFF);
            double db = sb - (zpolyArgb & 0xFF);
            double dist = Math.sqrt(Math.pow(dr, 2.0) + Math.pow(dg, 2.0) + Math.pow(db, 2.0));
            if (Double.compare(dist, minDistance) >= 0) continue;
            zxPolyIndex = i;
            minDistance = dist;
        }
        return zxPolyIndex;
    }

    private static int mixRgb(int rgb1, int rgb2) {
        int r1 = rgb1 >>> 16 & 0xFF;
        int g1 = rgb1 >>> 8 & 0xFF;
        int b1 = rgb1 & 0xFF;
        int r2 = rgb2 >>> 16 & 0xFF;
        int g2 = rgb2 >>> 8 & 0xFF;
        int b2 = rgb2 & 0xFF;
        int avgR = r1 + r2 >> 1;
        int avgG = g1 + g2 >> 1;
        int avgB = b1 + b2 >> 1;
        return 0xFF000000 | avgR << 16 | avgG << 8 | avgB;
    }

    private static void fillDataBufferForSpec256VideoMode(LineRenderMode renderLines, ZxPolyModule[] modules, int[] pixelRgbBuffer, boolean flashActive, int lineFrom, int lineTo) {
        int[] preRenderedBack = gfxPrerenderedBack;
        boolean bkOverFF = gfxBackOverFF;
        boolean paper00inkFF = gfxPaper00InkFF;
        boolean hideSameInkPaper = gfxHideSameInkPaper;
        int downAttrMixedIndex = gfxDownColorsMixed;
        int upAttrMixedIndex = 255 - gfxUpColorsMixed;
        ZxPolyModule sourceModule = modules[0];
        int offset = 0;
        int aoffset = 0;
        for (int yy = lineFrom; yy < lineTo; ++yy) {
            int addressFrom = ZX_SCREEN_ROW_OFFSETS[yy];
            int addressTo = addressFrom + 32;
            for (int i = addressFrom; i < addressTo; ++i) {
                if ((i & 0x1F) == 0) {
                    int coordY = VideoController.extractYFromAddress(i);
                    aoffset = VideoController.calcAttributeAddressZxMode(i);
                    offset = coordY << 10;
                }
                int attrOffset = aoffset++;
                long pixelData = sourceModule.readGfxVideo(i);
                int origData = sourceModule.readVideo(i);
                int attrData = sourceModule.readVideo(attrOffset);
                int inkColor = VideoController.extractInkColorSpec256(attrData, flashActive);
                int paperColor = VideoController.extractPaperColor(attrData, flashActive);
                int x = 8;
                block7: while (x-- > 0) {
                    boolean mixWithAttributes;
                    int colorIndex = (int)(pixelData >>> 56 & 0xFFL);
                    boolean origPixelSet = (origData & 0x80) != 0;
                    int color = PALETTE_SPEC256[colorIndex];
                    boolean draw = true;
                    boolean bl = mixWithAttributes = colorIndex < downAttrMixedIndex || colorIndex > upAttrMixedIndex;
                    if (preRenderedBack == null) {
                        if (hideSameInkPaper && inkColor == paperColor) {
                            color = inkColor;
                        } else if (paper00inkFF) {
                            if (colorIndex == 0) {
                                color = paperColor;
                            } else if (colorIndex == 255) {
                                color = inkColor;
                            }
                        }
                    } else {
                        boolean backShouldBeShown;
                        boolean bl2 = backShouldBeShown = (attrData & 0x80) != 0 && flashActive || hideSameInkPaper && inkColor == paperColor;
                        if (paper00inkFF) {
                            if (colorIndex == 0) {
                                color = paperColor;
                            } else if (colorIndex == 255) {
                                color = inkColor;
                            } else {
                                draw = !backShouldBeShown;
                            }
                        } else {
                            boolean bl3 = draw = !backShouldBeShown && colorIndex != 0 && (!bkOverFF || colorIndex != 255);
                        }
                    }
                    if (draw && mixWithAttributes) {
                        color = VideoController.mixRgb(origPixelSet ? inkColor : paperColor, color);
                    }
                    pixelData <<= 8;
                    origData <<= 1;
                    int theColor = draw ? color : preRenderedBack[offset];
                    switch (renderLines.ordinal()) {
                        case 0: {
                            pixelRgbBuffer[offset++] = theColor;
                            pixelRgbBuffer[offset] = theColor;
                            offset += 512;
                            pixelRgbBuffer[offset--] = theColor;
                            pixelRgbBuffer[offset] = theColor;
                            offset -= 510;
                            continue block7;
                        }
                        case 1: {
                            pixelRgbBuffer[offset++] = theColor;
                            pixelRgbBuffer[offset++] = theColor;
                            continue block7;
                        }
                        case 2: {
                            pixelRgbBuffer[512 + offset++] = theColor;
                            pixelRgbBuffer[512 + offset++] = theColor;
                            continue block7;
                        }
                    }
                    throw new Error("Unexpected mode");
                }
            }
        }
    }

    public UlaPlusContainer getUlaPlus() {
        return this.ulaPlus;
    }

    private static void fillDataBufferForZxPolyVideoMode(LineRenderMode renderLines, int zxPolyVideoMode, ZxPolyModule[] modules, int[] pixelRgbBuffer, boolean flashActive, int lineFrom, int lineTo) {
        switch (zxPolyVideoMode) {
            case 0: 
            case 1: 
            case 2: 
            case 3: {
                ZxPolyModule sourceModule = modules[zxPolyVideoMode & 3];
                int offset = 0;
                int attributeOffset = 0;
                for (int yy = lineFrom; yy < lineTo; ++yy) {
                    int addressFrom = ZX_SCREEN_ROW_OFFSETS[yy];
                    int addressTo = addressFrom + 32;
                    for (int i = addressFrom; i < addressTo; ++i) {
                        if ((i & 0x1F) == 0) {
                            int y = VideoController.extractYFromAddress(i);
                            offset = y << 10;
                            attributeOffset = VideoController.calcAttributeAddressZxMode(i);
                        }
                        int attrOffset = attributeOffset++;
                        int effectiveAttribute = sourceModule.readVideo(attrOffset);
                        effectiveAttribute = flashActive && (effectiveAttribute & 0x80) != 0 ? effectiveAttribute & 0x40 | effectiveAttribute >> 3 & 7 | (effectiveAttribute & 7) << 3 : effectiveAttribute;
                        int videoPixels = sourceModule.readVideo(i);
                        int inkColor = VideoController.extractInkPaletteColor(effectiveAttribute);
                        int paperColor = VideoController.extractPaperPaletteColor(effectiveAttribute);
                        int x = 8;
                        block51: while (x-- > 0) {
                            int color = (videoPixels & 0x80) == 0 ? paperColor : inkColor;
                            videoPixels <<= 1;
                            switch (renderLines.ordinal()) {
                                case 0: {
                                    pixelRgbBuffer[offset++] = color;
                                    pixelRgbBuffer[offset] = color;
                                    offset += 512;
                                    pixelRgbBuffer[offset--] = color;
                                    pixelRgbBuffer[offset] = color;
                                    offset -= 510;
                                    continue block51;
                                }
                                case 1: {
                                    pixelRgbBuffer[offset++] = color;
                                    pixelRgbBuffer[offset++] = color;
                                    continue block51;
                                }
                                case 2: {
                                    pixelRgbBuffer[512 + offset++] = color;
                                    pixelRgbBuffer[512 + offset++] = color;
                                    continue block51;
                                }
                            }
                            throw new Error("Unexpected mode");
                        }
                    }
                }
                break;
            }
            case 4: 
            case 6: 
            case 7: {
                int offset = 0;
                int attributeoffset = 0;
                ZxPolyModule module0 = modules[0];
                ZxPolyModule module1 = modules[1];
                ZxPolyModule module2 = modules[2];
                ZxPolyModule module3 = modules[3];
                for (int yy = lineFrom; yy < lineTo; ++yy) {
                    int addressFrom = ZX_SCREEN_ROW_OFFSETS[yy];
                    int addressTo = addressFrom + 32;
                    block53: for (int i = addressFrom; i < addressTo; ++i) {
                        if ((i & 0x1F) == 0) {
                            int y = VideoController.extractYFromAddress(i);
                            offset = y << 10;
                            attributeoffset = VideoController.calcAttributeAddressZxMode(i);
                        }
                        int videoValue0 = module0.readVideo(i);
                        int videoValue1 = module1.readVideo(i);
                        int videoValue2 = module2.readVideo(i);
                        int videoValue3 = module3.readVideo(i);
                        switch (zxPolyVideoMode) {
                            case 6: {
                                int color;
                                int value;
                                int attrModule0 = module0.readVideo(attributeoffset++);
                                int inkColor = VideoController.extractInkColor(attrModule0, flashActive);
                                int paperColor = VideoController.extractPaperColor(attrModule0, flashActive);
                                int x = 8;
                                if (inkColor == paperColor) {
                                    block54: while (x-- > 0) {
                                        switch (renderLines.ordinal()) {
                                            case 0: {
                                                pixelRgbBuffer[offset++] = inkColor;
                                                pixelRgbBuffer[offset] = inkColor;
                                                offset += 512;
                                                pixelRgbBuffer[offset--] = inkColor;
                                                pixelRgbBuffer[offset] = inkColor;
                                                offset -= 510;
                                                continue block54;
                                            }
                                            case 1: {
                                                pixelRgbBuffer[offset++] = inkColor;
                                                pixelRgbBuffer[offset++] = inkColor;
                                                continue block54;
                                            }
                                            case 2: {
                                                pixelRgbBuffer[512 + offset++] = inkColor;
                                                pixelRgbBuffer[512 + offset++] = inkColor;
                                                continue block54;
                                            }
                                        }
                                        throw new Error("Unexpected mode");
                                    }
                                    continue block53;
                                }
                                block55: while (x-- > 0) {
                                    value = ((videoValue3 & 0x80) == 0 ? 0 : 8) | ((videoValue0 & 0x80) == 0 ? 0 : 4) | ((videoValue1 & 0x80) == 0 ? 0 : 2) | ((videoValue2 & 0x80) == 0 ? 0 : 1);
                                    videoValue0 <<= 1;
                                    videoValue1 <<= 1;
                                    videoValue2 <<= 1;
                                    videoValue3 <<= 1;
                                    color = PALETTE_ZXPOLY[value];
                                    switch (renderLines.ordinal()) {
                                        case 0: {
                                            pixelRgbBuffer[offset++] = color;
                                            pixelRgbBuffer[offset] = color;
                                            offset += 512;
                                            pixelRgbBuffer[offset--] = color;
                                            pixelRgbBuffer[offset] = color;
                                            offset -= 510;
                                            continue block55;
                                        }
                                        case 1: {
                                            pixelRgbBuffer[offset++] = color;
                                            pixelRgbBuffer[offset++] = color;
                                            continue block55;
                                        }
                                        case 2: {
                                            pixelRgbBuffer[512 + offset++] = color;
                                            pixelRgbBuffer[512 + offset++] = color;
                                            continue block55;
                                        }
                                    }
                                    throw new Error("Unexpected mode");
                                }
                                continue block53;
                            }
                            case 7: {
                                int color;
                                int value;
                                int attrModule0 = module0.readVideo(attributeoffset++);
                                int inkColorMod0 = VideoController.extractInkColor(attrModule0, false);
                                int paperColorMod0 = VideoController.extractPaperColor(attrModule0, false);
                                int x = 8;
                                if ((attrModule0 & 0x80) == 0) {
                                    while (x-- > 0) {
                                        switch (renderLines.ordinal()) {
                                            case 0: {
                                                pixelRgbBuffer[offset] = (videoValue0 & 0x80) == 0 ? paperColorMod0 : inkColorMod0;
                                                pixelRgbBuffer[offset + 512] = (videoValue2 & 0x80) == 0 ? paperColorMod0 : inkColorMod0;
                                                pixelRgbBuffer[++offset] = (videoValue1 & 0x80) == 0 ? paperColorMod0 : inkColorMod0;
                                                pixelRgbBuffer[offset++ + 512] = (videoValue3 & 0x80) == 0 ? paperColorMod0 : inkColorMod0;
                                                break;
                                            }
                                            case 1: {
                                                pixelRgbBuffer[offset++] = (videoValue0 & 0x80) == 0 ? paperColorMod0 : inkColorMod0;
                                                pixelRgbBuffer[offset++] = (videoValue1 & 0x80) == 0 ? paperColorMod0 : inkColorMod0;
                                                break;
                                            }
                                            case 2: {
                                                pixelRgbBuffer[offset++ + 512] = (videoValue2 & 0x80) == 0 ? paperColorMod0 : inkColorMod0;
                                                pixelRgbBuffer[offset++ + 512] = (videoValue3 & 0x80) == 0 ? paperColorMod0 : inkColorMod0;
                                                break;
                                            }
                                            default: {
                                                throw new Error("Unexpected mode");
                                            }
                                        }
                                        videoValue0 <<= 1;
                                        videoValue2 <<= 1;
                                        videoValue1 <<= 1;
                                        videoValue3 <<= 1;
                                    }
                                    continue block53;
                                }
                                if (inkColorMod0 == paperColorMod0) {
                                    block57: while (x-- > 0) {
                                        switch (renderLines.ordinal()) {
                                            case 0: {
                                                pixelRgbBuffer[offset++] = inkColorMod0;
                                                pixelRgbBuffer[offset] = inkColorMod0;
                                                offset += 512;
                                                pixelRgbBuffer[offset--] = inkColorMod0;
                                                pixelRgbBuffer[offset] = inkColorMod0;
                                                offset -= 510;
                                                continue block57;
                                            }
                                            case 1: {
                                                pixelRgbBuffer[offset++] = inkColorMod0;
                                                pixelRgbBuffer[offset++] = inkColorMod0;
                                                continue block57;
                                            }
                                            case 2: {
                                                pixelRgbBuffer[512 + offset++] = inkColorMod0;
                                                pixelRgbBuffer[512 + offset++] = inkColorMod0;
                                                continue block57;
                                            }
                                        }
                                        throw new Error("Unexpected mode");
                                    }
                                    continue block53;
                                }
                                block58: while (x-- > 0) {
                                    value = ((videoValue3 & 0x80) == 0 ? 0 : 8) | ((videoValue0 & 0x80) == 0 ? 0 : 4) | ((videoValue1 & 0x80) == 0 ? 0 : 2) | ((videoValue2 & 0x80) == 0 ? 0 : 1);
                                    videoValue0 <<= 1;
                                    videoValue1 <<= 1;
                                    videoValue2 <<= 1;
                                    videoValue3 <<= 1;
                                    color = PALETTE_ZXPOLY[value];
                                    switch (renderLines.ordinal()) {
                                        case 0: {
                                            pixelRgbBuffer[offset++] = color;
                                            pixelRgbBuffer[offset] = color;
                                            offset += 512;
                                            pixelRgbBuffer[offset--] = color;
                                            pixelRgbBuffer[offset] = color;
                                            offset -= 510;
                                            continue block58;
                                        }
                                        case 1: {
                                            pixelRgbBuffer[offset++] = color;
                                            pixelRgbBuffer[offset++] = color;
                                            continue block58;
                                        }
                                        case 2: {
                                            pixelRgbBuffer[512 + offset++] = color;
                                            pixelRgbBuffer[512 + offset++] = color;
                                            continue block58;
                                        }
                                    }
                                    throw new Error("Unexpected mode");
                                }
                                continue block53;
                            }
                            default: {
                                int x = 8;
                                block59: while (x-- > 0) {
                                    int value = ((videoValue3 & 0x80) == 0 ? 0 : 8) | ((videoValue0 & 0x80) == 0 ? 0 : 4) | ((videoValue1 & 0x80) == 0 ? 0 : 2) | ((videoValue2 & 0x80) == 0 ? 0 : 1);
                                    videoValue0 <<= 1;
                                    videoValue1 <<= 1;
                                    videoValue2 <<= 1;
                                    videoValue3 <<= 1;
                                    int color = PALETTE_ZXPOLY[value];
                                    switch (renderLines.ordinal()) {
                                        case 0: {
                                            pixelRgbBuffer[offset++] = color;
                                            pixelRgbBuffer[offset] = color;
                                            offset += 512;
                                            pixelRgbBuffer[offset--] = color;
                                            pixelRgbBuffer[offset] = color;
                                            offset -= 510;
                                            continue block59;
                                        }
                                        case 1: {
                                            pixelRgbBuffer[offset++] = color;
                                            pixelRgbBuffer[offset++] = color;
                                            continue block59;
                                        }
                                        case 2: {
                                            pixelRgbBuffer[512 + offset++] = color;
                                            pixelRgbBuffer[512 + offset++] = color;
                                            continue block59;
                                        }
                                    }
                                    throw new Error("Unexpected mode");
                                }
                                break block10;
                            }
                        }
                    }
                }
                break;
            }
            case 5: {
                int offset = 0;
                int attributeOffset = 0;
                ZxPolyModule module0 = modules[0];
                ZxPolyModule module1 = modules[1];
                ZxPolyModule module2 = modules[2];
                ZxPolyModule module3 = modules[3];
                for (int yy = lineFrom; yy < lineTo; ++yy) {
                    int addressFrom = ZX_SCREEN_ROW_OFFSETS[yy];
                    int addressTo = addressFrom + 32;
                    for (int i = addressFrom; i < addressTo; ++i) {
                        if ((i & 0x1F) == 0) {
                            int y = VideoController.extractYFromAddress(i);
                            offset = y << 10;
                            attributeOffset = VideoController.calcAttributeAddressZxMode(i);
                        }
                        int videoValue0 = module0.readVideo(i);
                        int attribute0 = module0.readVideo(attributeOffset);
                        int videoValue1 = module1.readVideo(i);
                        int attribute1 = module1.readVideo(attributeOffset);
                        int videoValue2 = module2.readVideo(i);
                        int attribute2 = module2.readVideo(attributeOffset);
                        int videoValue3 = module3.readVideo(i);
                        int attribute3 = module3.readVideo(attributeOffset++);
                        int x = 8;
                        while (x-- > 0) {
                            switch (renderLines.ordinal()) {
                                case 0: {
                                    pixelRgbBuffer[offset] = (videoValue0 & 0x80) == 0 ? VideoController.extractPaperColor(attribute0, flashActive) : VideoController.extractInkColor(attribute0, flashActive);
                                    pixelRgbBuffer[offset + 512] = (videoValue2 & 0x80) == 0 ? VideoController.extractPaperColor(attribute2, flashActive) : VideoController.extractInkColor(attribute2, flashActive);
                                    pixelRgbBuffer[++offset] = (videoValue1 & 0x80) == 0 ? VideoController.extractPaperColor(attribute1, flashActive) : VideoController.extractInkColor(attribute1, flashActive);
                                    pixelRgbBuffer[offset++ + 512] = (videoValue3 & 0x80) == 0 ? VideoController.extractPaperColor(attribute3, flashActive) : VideoController.extractInkColor(attribute3, flashActive);
                                    break;
                                }
                                case 1: {
                                    pixelRgbBuffer[offset++] = (videoValue0 & 0x80) == 0 ? VideoController.extractPaperColor(attribute0, flashActive) : VideoController.extractInkColor(attribute0, flashActive);
                                    pixelRgbBuffer[offset++] = (videoValue1 & 0x80) == 0 ? VideoController.extractPaperColor(attribute1, flashActive) : VideoController.extractInkColor(attribute1, flashActive);
                                    break;
                                }
                                case 2: {
                                    pixelRgbBuffer[offset++ + 512] = (videoValue2 & 0x80) == 0 ? VideoController.extractPaperColor(attribute2, flashActive) : VideoController.extractInkColor(attribute2, flashActive);
                                    pixelRgbBuffer[offset++ + 512] = (videoValue3 & 0x80) == 0 ? VideoController.extractPaperColor(attribute3, flashActive) : VideoController.extractInkColor(attribute3, flashActive);
                                    break;
                                }
                                default: {
                                    throw new Error("Unexpected mode");
                                }
                            }
                            videoValue0 <<= 1;
                            videoValue2 <<= 1;
                            videoValue1 <<= 1;
                            videoValue3 <<= 1;
                        }
                    }
                }
                break;
            }
            default: {
                throw new Error("Unexpected video mode [" + zxPolyVideoMode + "]");
            }
        }
    }

    public static int preciseRgbColorToIndex(int rgbColor) {
        return switch (rgbColor | 0xFF000000) {
            case -16777216 -> 0;
            case -16777026 -> 1;
            case -4325376 -> 2;
            case -4325186 -> 3;
            case -16728576 -> 4;
            case -16728386 -> 5;
            case -4276736 -> 6;
            case -4276546 -> 7;
            case -16776961 -> 9;
            case -65536 -> 10;
            case -65281 -> 11;
            case -16711936 -> 12;
            case -16711681 -> 13;
            case -256 -> 14;
            case -1 -> 15;
            default -> -1;
        };
    }

    public static int extractYFromAddress(int address) {
        return (address & 0x1800) >> 5 | (address & 0x700) >> 8 | (address & 0xE0) >> 2;
    }

    public static int calcAttributeAddressZxMode(int screenOffset) {
        int line = screenOffset >>> 5 & 7 | screenOffset >>> 8 & 0x18;
        int column = screenOffset & 0x1F;
        int off = line >>> 3 << 8 | ((line & 7) << 5 | column);
        return 6144 + off;
    }

    private static int extractInkColor(int attribute, boolean flashActive) {
        boolean flash;
        int bright = (attribute & 0x40) == 0 ? 0 : 8;
        int inkColor = PALETTE_ZXPOLY[attribute & 7 | bright];
        int paperColor = PALETTE_ZXPOLY[attribute >> 3 & 7 | bright];
        boolean bl = flash = (attribute & 0x80) != 0;
        int result = flash ? (flashActive ? paperColor : inkColor) : inkColor;
        return result;
    }

    private static int extractPaperPaletteColor(int attribute) {
        int bright = (attribute & 0x40) == 0 ? 0 : 8;
        return PALETTE_ZXPOLY[attribute >> 3 & 7 | bright];
    }

    private static int extractInkPaletteColor(int attribute) {
        int bright = (attribute & 0x40) == 0 ? 0 : 8;
        return PALETTE_ZXPOLY[attribute & 7 | bright];
    }

    private static int extractInkColorSpec256(int attribute, boolean flashActive) {
        boolean flash;
        int bright = (attribute & 0x40) == 0 ? 0 : 8;
        int inkColor = PALETTE_ALIGNED_ZXPOLY[attribute & 7 | bright];
        int paperColor = PALETTE_ALIGNED_ZXPOLY[attribute >> 3 & 7 | bright];
        boolean bl = flash = (attribute & 0x80) != 0;
        int result = flash ? (flashActive ? paperColor : inkColor) : inkColor;
        return result;
    }

    private static int extractPaperColor(int attribute, boolean flashActive) {
        boolean flash;
        int bright = (attribute & 0x40) == 0 ? 0 : 8;
        int inkColor = PALETTE_ZXPOLY[attribute & 7 | bright];
        int paperColor = PALETTE_ZXPOLY[attribute >> 3 & 7 | bright];
        boolean bl = flash = (attribute & 0x80) != 0;
        int result = flash ? (flashActive ? inkColor : paperColor) : paperColor;
        return result;
    }

    public static void setGfxUpColorsMixed(int value) {
        gfxUpColorsMixed = value;
    }

    public static void setGfxDownColorsMixed(int value) {
        gfxDownColorsMixed = value;
    }

    public static void setGfxBackOverFF(boolean flag) {
        gfxBackOverFF = flag;
    }

    public static void setGfxPaper00InkFF(boolean flag) {
        gfxPaper00InkFF = flag;
    }

    public static void setGfxHideSameInkPaper(boolean flag) {
        gfxHideSameInkPaper = flag;
    }

    private static String decodeVideoModeCode(int code) {
        return switch (code) {
            case 0 -> "ZX-Spectrum 0";
            case 1 -> "ZX-Spectrum 1";
            case 2 -> "ZX-Spectrum 2";
            case 3 -> "ZX-Spectrum 3";
            case 4 -> "ZX-Poly 256x192";
            case 5 -> "ZX-Poly 512x384";
            case 6 -> "ZX-Poly 256x192M0";
            case 7 -> "ZX-Poly 256x192M1";
            case 8 -> "SPEC256 256x192";
            default -> "Unknown [" + code + "]";
        };
    }

    @Override
    public void init(boolean tryLessSystemResources) {
        this.vkbdRender = new VirtualKeyboardRender(this.board, this.vkbdContainer);
    }

    public TvFilterChain getTvFilterChain() {
        return this.tvFilterChain;
    }

    public void setTvFilterChain(TvFilterChain chain) {
        this.tvFilterChain = chain == null ? TvFilterChain.NONE : chain;
    }

    public boolean isVkbShow() {
        return this.showVkb;
    }

    public void setVkbShow(boolean show) {
        if (!show || !this.showVkb) {
            this.showVkb = show;
            this.vkbdRender.doReset();
            if (this.showVkb) {
                if (this.showVkbdApart && !this.fullScreenMode) {
                    if (this.vkbdWindow != null) {
                        this.vkbdWindow.dispose();
                    }
                    final Window mainFrame = SwingUtilities.windowForComponent(this);
                    this.vkbdWindow = new JDialog(mainFrame, "ZX-Poly virtual keyboard", Dialog.ModalityType.MODELESS, this.getGraphicsConfiguration());
                    if (this.virtualKeyboardUndecorated) {
                        ((JDialog)this.vkbdWindow).setUndecorated(true);
                    }
                    this.vkbdWindow.addWindowListener(new WindowAdapter(this){
                        final /* synthetic */ VideoController this$0;
                        {
                            this.this$0 = this$0;
                        }

                        @Override
                        public void windowClosing(WindowEvent e) {
                            this.this$0.lastVirtualKeyboardWindowPosition = this.this$0.vkbdWindow.getBounds();
                            this.this$0.showVkb = false;
                            ((MainForm)mainFrame).setFastButtonState(FastButton.VIRTUAL_KEYBOARD, false);
                        }
                    });
                    JComponent keyboardPanel = new JComponent(){
                        private final Dimension size;
                        {
                            this.size = new Dimension(VideoController.this.vkbdRender.getImageWidth(), VideoController.this.vkbdRender.getImageHeight());
                        }

                        @Override
                        public Dimension getPreferredSize() {
                            return this.size;
                        }

                        @Override
                        public Dimension getMinimumSize() {
                            return this.size;
                        }

                        @Override
                        public Dimension getMaximumSize() {
                            return this.size;
                        }

                        @Override
                        public boolean isFocusable() {
                            return false;
                        }

                        @Override
                        public boolean isOpaque() {
                            return true;
                        }

                        @Override
                        public void paintComponent(Graphics g) {
                            Graphics2D g2d = (Graphics2D)g;
                            g2d.setColor(Color.GRAY);
                            g2d.fillRect(this.getX(), this.getY(), this.size.width, this.size.height);
                            VideoController.this.vkbdRender.render(this, g2d, new Rectangle(0, 0, this.getWidth(), this.getHeight()), false);
                        }
                    };
                    keyboardPanel.addMouseListener(new MouseAdapter(){

                        @Override
                        public void mousePressed(MouseEvent e) {
                            if (!e.isConsumed()) {
                                VideoController.this.vkbdRender.setLastMouseEvent(e);
                                e.consume();
                            }
                        }

                        @Override
                        public void mouseReleased(MouseEvent e) {
                            if (!e.isConsumed()) {
                                VideoController.this.vkbdRender.setLastMouseEvent(e);
                                e.consume();
                            }
                        }
                    });
                    this.vkbdWindow.add(keyboardPanel);
                    this.vkbdWindow.setFocusableWindowState(false);
                    this.vkbdWindow.setLocation(mainFrame.getLocation());
                    this.vkbdWindow.setVisible(true);
                    this.vkbdWindow.pack();
                    if (this.lastVirtualKeyboardWindowPosition != null) {
                        this.vkbdWindow.setBounds(this.lastVirtualKeyboardWindowPosition);
                    }
                }
            } else if (this.vkbdWindow != null) {
                this.lastVirtualKeyboardWindowPosition = this.vkbdWindow.getBounds();
                this.vkbdWindow.dispose();
            }
        }
    }

    public Optional<Rectangle> getVirtualKeyboardWindowPosition() {
        Window window = this.vkbdWindow;
        Rectangle result = window == null ? this.lastVirtualKeyboardWindowPosition : window.getBounds();
        return Optional.ofNullable(result);
    }

    public void setVirtualKeyboardWindowPosition(Rectangle position) {
        this.lastVirtualKeyboardWindowPosition = position;
        if (position != null) {
            Runnable call = () -> {
                Window window = this.vkbdWindow;
                if (window != null) {
                    window.setBounds(position);
                }
            };
            if (SwingUtilities.isEventDispatchThread()) {
                call.run();
            } else {
                SwingUtilities.invokeLater(call);
            }
        }
    }

    public void setEnableTrapMouse(boolean flag, boolean enableMouseTrapIndicator) {
        this.enableMouseTrapIndicator = enableMouseTrapIndicator;
        this.mouseTrapEnabled = flag;
        this.setTrapMouseActive(flag);
    }

    public void setTrapMouseActive(boolean flag) {
        this.mouseTrapActive = flag;
        this.setHideMouse(flag);
    }

    public boolean isMouseTrapEnabled() {
        return this.mouseTrapEnabled;
    }

    public boolean isMouseTrapActive() {
        return this.mouseTrapActive;
    }

    public void setHideMouse(boolean doHide) {
        Runnable runnable = () -> {
            if (doHide) {
                this.setCursor(Toolkit.getDefaultToolkit().createCustomCursor(new BufferedImage(1, 1, 3), new Point(0, 0), "InvisibleCursor"));
            } else {
                this.setCursor(Cursor.getDefaultCursor());
            }
        };
        Utils.safeSwingCall(runnable);
    }

    public void zoomIn() {
        this.updateZoom(Math.min(6.0f, this.zoom + 0.025f));
    }

    public void zoomOut() {
        this.updateZoom(Math.max(1.0f, this.zoom - 0.025f));
    }

    @Override
    public void mouseWheelMoved(MouseWheelEvent e) {
        float newZoom;
        if (e.isControlDown() && (newZoom = e.getPreciseWheelRotation() > 0.0 ? Math.max(1.0f, this.zoom - 0.025f) : Math.min(6.0f, this.zoom + 0.025f)) != this.zoom) {
            this.updateZoom(newZoom);
        }
    }

    @Override
    public Dimension getPreferredSize() {
        return new Dimension(Math.max(this.size.width, this.baseComponentSize.width), Math.max(this.size.height, this.baseComponentSize.height));
    }

    @Override
    public Dimension getMinimumSize() {
        return this.baseComponentSize;
    }

    private void updateZoom(float value) {
        this.zoom = value;
        this.size = new Dimension(Math.round(512.0f * value), Math.round(384.0f * value));
        this.repaint();
        this.getParent().revalidate();
        this.getParent().repaint();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void copyWorkScreenToOutputScreen(int x, int y, int width, int height) {
        this.lockWorkImage.lock();
        try {
            this.lockOutputImage.lock();
            try {
                Graphics2D g = this.outputZxScreenImage.createGraphics();
                try {
                    g.setClip(x << 1, y << 1, width << 1, height << 1);
                    g.drawImage((Image)this.workZxScreenImage, 0, 0, null);
                }
                finally {
                    g.dispose();
                }
            }
            finally {
                this.lockOutputImage.unlock();
            }
        }
        finally {
            this.lockWorkImage.unlock();
        }
    }

    private void refreshBufferData(LineRenderMode renderLines, int lineFrom, int lineTo, int videoMode) {
        switch (videoMode) {
            case 0: {
                VideoController.fillDataBufferForZxSpectrum128Mode(renderLines, this.modules, this.workZxScreenImageRgbData, this.board.isFlashActive(), lineFrom, lineTo, this.ulaPlus);
                break;
            }
            case 8: {
                VideoController.fillDataBufferForSpec256VideoMode(renderLines, this.modules, this.workZxScreenImageRgbData, this.board.isFlashActive(), lineFrom, lineTo);
                break;
            }
            default: {
                VideoController.fillDataBufferForZxPolyVideoMode(renderLines, this.currentVideoMode, this.modules, this.workZxScreenImageRgbData, this.board.isFlashActive(), lineFrom, lineTo);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] grabRgb(byte[] array) {
        byte[] result;
        this.lockWorkImage.lock();
        try {
            int[] buffer = this.workZxScreenImageRgbData;
            int bufferLen = buffer.length;
            result = array == null ? new byte[bufferLen * 3] : array;
            int outIndex = 0;
            for (int argb : buffer) {
                result[outIndex++] = (byte)(argb >> 16);
                result[outIndex++] = (byte)(argb >> 8);
                result[outIndex++] = (byte)argb;
            }
        }
        finally {
            this.lockWorkImage.unlock();
        }
        if (this.tvFilterChain != null) {
            int argbBorderColor = PALETTE_ZXPOLY[this.portFEw & 7];
            for (TvFilter f : this.tvFilterChain.getFilterChain()) {
                result = f.apply(false, result, argbBorderColor);
            }
        }
        return result;
    }

    private void drawBorder(Graphics2D g2, int visibleWidth, int visibleHeight) {
        int invisibleWidth = this.timingProfile.tstatesPerHBlank + this.timingProfile.tstatesPerHSync;
        int invisibleHeight = this.timingProfile.linesPerVSync;
        int visibleBorderAreaWidth = this.borderImage.getWidth() - invisibleWidth;
        int visibleBorderAreaHeight = this.borderImage.getHeight() - invisibleHeight;
        double sx = (double)visibleWidth / (double)visibleBorderAreaWidth;
        double sy = (double)visibleHeight / (double)visibleBorderAreaHeight;
        int offsetX = (int)((double)(-invisibleWidth) * sx);
        int offsetY = (int)((double)(-invisibleHeight) * sy);
        g2.drawImage(this.borderImage, offsetX, offsetY, (int)(sx * (double)this.borderImage.getWidth()), (int)(sy * (double)this.borderImage.getHeight()), null);
    }

    @Override
    public void paintComponent(Graphics g) {
        Graphics2D g2 = (Graphics2D)g;
        Rectangle bounds = this.getBounds();
        int visibleWidth = bounds.width;
        int visibleHeight = bounds.height;
        int screenOffsetX = (visibleWidth - this.size.width) / 2;
        int screenOffsetY = (visibleHeight - this.size.height) / 2;
        if (screenOffsetX > 0 || screenOffsetY > 0) {
            this.drawBorder(g2, visibleWidth, visibleHeight);
        }
        this.drawBuffer(g2, screenOffsetX, screenOffsetY, this.zoom, this.tvFilterChain);
        if (this.mouseTrapActive && this.enableMouseTrapIndicator) {
            g2.drawImage(MOUSE_TRAPPED, 2, 2, null);
        }
        if (this.showVkb) {
            Rectangle renderRectangle;
            int imgWidth = this.vkbdRender.getImageWidth();
            int imgHeight = this.vkbdRender.getImageHeight();
            if (bounds.width >= imgWidth) {
                if (bounds.width >= imgWidth * 3) {
                    double scale = (double)bounds.width / 3.0 / (double)imgWidth;
                    int newWidth = (int)Math.round(scale * (double)imgWidth);
                    int newHeight = (int)Math.round(scale * (double)imgHeight);
                    renderRectangle = new Rectangle((bounds.width - newWidth) / 2, bounds.height - newHeight, newWidth, newHeight);
                } else {
                    renderRectangle = new Rectangle((bounds.width - imgWidth) / 2, bounds.height - imgHeight, imgWidth, imgHeight);
                }
            } else {
                double scale = (double)bounds.width / (double)imgWidth;
                int newWidth = (int)Math.round(scale * (double)imgWidth);
                int newHeight = (int)Math.round(scale * (double)imgHeight);
                renderRectangle = new Rectangle(0, bounds.height - newHeight, newWidth, newHeight);
            }
            if (!this.showVkbdApart || this.fullScreenMode) {
                this.vkbdRender.render(this, g2, renderRectangle, true);
            } else if (this.vkbdWindow != null) {
                this.vkbdWindow.repaint();
            }
        }
    }

    public int[] findCurrentPalette() {
        if (this.tvFilterChain.isEmpty()) {
            switch (this.currentVideoMode) {
                case 8: 
                case 9: {
                    return PALETTE_SPEC256;
                }
            }
            if (this.ulaPlus.isActive()) {
                return this.ulaPlus.getArgbPalette();
            }
            return PALETTE_ZXPOLY;
        }
        return this.tvFilterChain.findPalette();
    }

    public int getVideoMode() {
        return this.currentVideoMode;
    }

    public void setVideoMode(int newVideoMode) {
        this.lockWorkImage.lock();
        try {
            if (this.currentVideoMode != newVideoMode) {
                this.currentVideoMode = newVideoMode;
                log.log(Level.INFO, "mode set: " + VideoController.decodeVideoModeCode(newVideoMode));
                this.refreshBufferData(LineRenderMode.ALL, 0, 192, this.currentVideoMode);
            }
        }
        finally {
            this.lockWorkImage.unlock();
        }
    }

    public void setBorderColor(int colorIndex) {
        int old = this.portFEw & 0xFFFFFFF8;
        this.portFEw = old | colorIndex & 7;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void syncUpdateBuffer(int lineFrom, int lineTo, LineRenderMode renderLines) {
        this.lockWorkImage.lock();
        try {
            this.refreshBufferData(renderLines, lineFrom, lineTo, this.currentVideoMode);
        }
        finally {
            this.lockWorkImage.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int[] makeCopyOfVideoBuffer(boolean applyFilters) {
        Color borderColor;
        int[] cloneOfBuffer;
        this.lockWorkImage.lock();
        try {
            cloneOfBuffer = (int[])this.workZxScreenImageRgbData.clone();
            borderColor = PALETTE_ZXPOLY_COLORS[this.portFEw & 7];
        }
        finally {
            this.lockWorkImage.unlock();
        }
        if (applyFilters) {
            byte[] rgb = this.argb2rgb(cloneOfBuffer);
            for (TvFilter f : this.tvFilterChain.getFilterChain()) {
                rgb = f.apply(false, rgb, borderColor.getRGB());
                borderColor = f.applyBorderColor(borderColor);
            }
            cloneOfBuffer = this.rgb2argb(rgb);
        }
        return cloneOfBuffer;
    }

    private byte[] argb2rgb(int[] argb) {
        byte[] result = new byte[argb.length * 3];
        int j = 0;
        for (int value : argb) {
            result[j++] = (byte)(value >> 16);
            result[j++] = (byte)(value >> 8);
            result[j++] = (byte)value;
        }
        return result;
    }

    private int[] rgb2argb(byte[] rgb) {
        int[] result = new int[rgb.length / 3];
        int j = 0;
        int i = 0;
        while (i < rgb.length) {
            int r = rgb[i++] & 0xFF;
            int g = rgb[i++] & 0xFF;
            int b = rgb[i++] & 0xFF;
            result[j++] = 0xFF000000 | r << 16 | g << 8 | b;
        }
        return result;
    }

    public RenderedImage makeCopyOfCurrentPicture() {
        BufferedImage result = new BufferedImage(this.workZxScreenImage.getWidth(), this.workZxScreenImage.getHeight(), 1);
        Graphics2D gfx = result.createGraphics();
        try {
            this.drawBuffer(gfx, 0, 0, 1.0f, this.tvFilterChain);
        }
        finally {
            gfx.dispose();
        }
        return result;
    }

    @Override
    public Motherboard getMotherboard() {
        return this.board;
    }

    @Override
    public int readIo(ZxPolyModule module, int port) {
        int result = -1;
        if (this.ulaPlus.isEnabled() && port == 65339) {
            result = this.ulaPlus.getData();
        }
        return result;
    }

    public int getPortFE() {
        return this.portFEw;
    }

    @Override
    public void writeIo(ZxPolyModule module, int port, int value) {
        if (!module.isTrdosActive()) {
            boolean zxPolyMode;
            boolean bl = zxPolyMode = module.getMotherboard().getBoardMode() == BoardMode.ZXPOLY;
            if (zxPolyMode) {
                if ((port & 0xFF) == 254) {
                    this.portFEw = value & 0xFF;
                }
            } else if ((port & 1) == 0) {
                this.portFEw = value & 0xFF;
            }
            if (this.ulaPlus.isEnabled()) {
                if (port == 65339) {
                    this.ulaPlus.setData(value);
                } else if (port == 48955) {
                    this.ulaPlus.setRegister(value);
                } else if ((port & 0xFF) == 255) {
                    this.ulaPlus.setPortFF(value);
                }
            }
        }
    }

    @Override
    public int getNotificationFlags() {
        return 3;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void drawBuffer(Graphics2D gfx, int x, int y, float zoom, TvFilterChain filterChain) {
        if (filterChain.isEmpty()) {
            this.lockOutputImage.lock();
            try {
                float normalZoom = Math.max(1.0f, zoom);
                if (normalZoom == 1.0f) {
                    gfx.drawImage(this.outputZxScreenImage, null, x, y);
                }
                gfx.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
                gfx.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_SPEED);
                gfx.drawImage(this.outputZxScreenImage, x, y, Math.round(512.0f * normalZoom), Math.round(384.0f * normalZoom), null);
            }
            finally {
                this.lockOutputImage.unlock();
            }
        } else {
            Rectangle area;
            BufferedImage postProcessedImage;
            int borderArgbColor = this.borderImageRgbData[this.borderImageRgbData.length / 2];
            TvFilter[] tvFilters = filterChain.getFilterChain();
            this.lockOutputImage.lock();
            try {
                postProcessedImage = tvFilters[0].apply(this.outputZxScreenImage, zoom, borderArgbColor, true);
            }
            finally {
                this.lockOutputImage.unlock();
            }
            for (int i = 1; i < tvFilters.length; ++i) {
                postProcessedImage = tvFilters[i].apply(postProcessedImage, zoom, borderArgbColor, false);
            }
            if (zoom == 1.0f) {
                area = new Rectangle(x, y, 512, 384);
                gfx.drawImage(postProcessedImage, null, x, y);
            } else {
                boolean sizeChangedDuringPostprocessing;
                boolean bl = sizeChangedDuringPostprocessing = postProcessedImage.getWidth() != this.outputZxScreenImage.getWidth();
                if (sizeChangedDuringPostprocessing) {
                    gfx.drawImage(postProcessedImage, null, x, y);
                    area = new Rectangle(x, y, 512, 384);
                } else {
                    float normalizedZoom = Math.max(1.0f, zoom);
                    gfx.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
                    gfx.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_SPEED);
                    area = new Rectangle(x, y, Math.round(512.0f * normalizedZoom), Math.round(384.0f * normalizedZoom));
                    gfx.drawImage(postProcessedImage, x, y, area.width, area.height, null);
                }
            }
            for (TvFilter filter : tvFilters) {
                filter.apply(gfx, area, zoom);
            }
        }
    }

    @Override
    public void preStep(int frameTiStates, boolean signalReset, boolean tiStatesIntReached, boolean wallClockInt) {
        this.stepStartTiStates = tiStatesIntReached ? -1 : frameTiStates;
        UlaPlusContainer ulaPlusContainer = this.ulaPlus;
        if (signalReset) {
            this.portFEw = 0;
            if (ulaPlusContainer != null) {
                ulaPlusContainer.reset();
            }
        }
        this.vkbdRender.preState(signalReset, tiStatesIntReached, wallClockInt);
        this.preStepBorderColor = ulaPlusContainer == null || !ulaPlusContainer.isActive() ? this.tvFilterChain.applyBorderColor(PALETTE_ZXPOLY_COLORS[this.portFEw & 7]).getRGB() : this.tvFilterChain.applyBorderColor(this.ulaPlus.findColorForIndex(this.portFEw & 7 | 8)).getRGB();
    }

    @Override
    public void doReset() {
        this.vkbdRender.doReset();
    }

    @Override
    public void postStep(int spentTiStates) {
        int borderColor = this.preStepBorderColor;
        int offset = this.stepStartTiStates;
        if (offset >= 0) {
            while (spentTiStates > 0 && offset < this.timingProfile.tstatesFrame) {
                this.borderImageRgbData[offset++] = borderColor;
                --spentTiStates;
            }
        }
    }

    public float getZoom() {
        return this.zoom;
    }

    @Override
    public String toString() {
        return this.getName();
    }

    public void zoomForSize(Rectangle rectangle) {
        float width = (float)rectangle.width - (float)rectangle.width * 0.025f;
        float height = rectangle.height;
        float maxZoomW = (float)((int)(width / (float)this.baseComponentSize.width / 0.025f)) * 0.025f;
        float maxZoomH = (float)((int)(height / (float)this.baseComponentSize.height / 0.025f)) * 0.025f;
        this.updateZoom(Math.max(1.0f, Math.min(6.0f, Math.min(maxZoomH, maxZoomW))));
    }

    public long getVkbState() {
        return this.vkbdRender.getKeyState();
    }

    public Window getVirtualKeboardWindow() {
        return this.vkbdWindow;
    }

    public void setFullScreenMode(boolean active) {
        this.fullScreenMode = active;
        this.setVkbShow(false);
    }

    @Override
    public boolean isOpaque() {
        return true;
    }

    private void doImmediatePaint() {
        this.paintImmediately(0, 0, this.getWidth(), this.getHeight());
    }

    public void notifyRepaint() {
        if (this.syncRepaint) {
            this.doSyncRepaint();
        } else {
            this.repaint(0L);
        }
    }

    public void doSyncRepaint() {
        if (SwingUtilities.isEventDispatchThread()) {
            this.doImmediatePaint();
        } else {
            try {
                SwingUtilities.invokeAndWait(this::doImmediatePaint);
            }
            catch (InterruptedException ex) {
                Thread.currentThread().interrupt();
            }
            catch (InvocationTargetException invocationTargetException) {
                // empty catch block
            }
        }
    }

    public static enum LineRenderMode {
        ALL((pixelRgbBuffer, offset, color) -> {
            pixelRgbBuffer[offset++] = color;
            pixelRgbBuffer[offset] = color;
            offset += 512;
            pixelRgbBuffer[offset--] = color;
            pixelRgbBuffer[offset] = color;
            return offset -= 510;
        }),
        EVEN((pixelRgbBuffer, offset, color) -> {
            pixelRgbBuffer[offset++] = color;
            pixelRgbBuffer[offset++] = color;
            return offset;
        }),
        ODD((pixelRgbBuffer, offset, color) -> {
            pixelRgbBuffer[512 + offset++] = color;
            pixelRgbBuffer[512 + offset++] = color;
            return offset;
        });

        private final LineRenderModeFunction processor;

        private LineRenderMode(LineRenderModeFunction processor) {
            this.processor = processor;
        }

        public int apply(int[] buffer, int offset, int color) {
            return this.processor.apply(buffer, offset, color);
        }
    }

    @FunctionalInterface
    public static interface LineRenderModeFunction {
        public int apply(int[] var1, int var2, int var3);
    }
}

