/*
 * Decompiled with CFR 0.152.
 */
package com.igormaznitsa.zxpoly.components.video;

import com.igormaznitsa.zxpoly.components.KeyboardKempstonAndTapeIn;
import com.igormaznitsa.zxpoly.components.Motherboard;
import com.igormaznitsa.zxpoly.components.video.VirtualKeyboardDecoration;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics2D;
import java.awt.MouseInfo;
import java.awt.Point;
import java.awt.PointerInfo;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.util.Objects;
import javax.swing.SwingUtilities;

public final class VirtualKeyboardRender {
    private static final long VKB_STICKY_KEYS = 0x200000000000001L;
    private static final long[] KEY_TABLE = new long[]{0x1000000L, 0x2000000L, 0x4000000L, 0x8000000L, 0x10000000L, 0x1000000000L, 0x800000000L, 0x400000000L, 0x200000000L, 0x100000000L, 65536L, 131072L, 262144L, 524288L, 0x100000L, 0x100000000000L, 0x80000000000L, 0x40000000000L, 0x20000000000L, 0x10000000000L, 256L, 512L, 1024L, 2048L, 4096L, 0x10000000000000L, 0x8000000000000L, 0x4000000000000L, 0x2000000000000L, 0x1000000000000L, 1L, 2L, 4L, 8L, 16L, 0x1000000000000000L, 0x800000000000000L, 0x400000000000000L, 0x200000000000000L, 0x100000000000000L};
    private static final int[] BIT2KEY = new int[64];
    private static final int TICKS_BEFORE_RELEASE_STICKY = 10;
    private final KeyboardKempstonAndTapeIn mainKeyboard;
    private final VirtualKeyboardDecoration vkbdDecoration;
    private volatile int ticksTillReleaseStickyKeys = 0;
    private volatile long vkbKeysState = 0x1F1F1F1F1F1F1F1FL;
    private volatile MouseEvent lastMouseClickEvent = null;

    public VirtualKeyboardRender(Motherboard motherboard, VirtualKeyboardDecoration vkbdDecoration) {
        this.mainKeyboard = Objects.requireNonNull(motherboard.findIoDevice(KeyboardKempstonAndTapeIn.class));
        this.vkbdDecoration = Objects.requireNonNull(vkbdDecoration);
    }

    public void setLastMouseEvent(MouseEvent clickMouseEvent) {
        this.lastMouseClickEvent = clickMouseEvent;
    }

    public void render(Component parent, Graphics2D gfx, Rectangle renderRectangle, boolean transparentIfNotFocused) {
        PointerInfo pointerInfo = MouseInfo.getPointerInfo();
        Point mousePoint = new Point(pointerInfo.getLocation());
        SwingUtilities.convertPointFromScreen(mousePoint, parent);
        if (transparentIfNotFocused) {
            gfx.setComposite(AlphaComposite.getInstance(3, renderRectangle.contains(mousePoint) ? 1.0f : 0.5f));
        }
        gfx.drawImage(this.vkbdDecoration.getImage(), renderRectangle.x, renderRectangle.y, renderRectangle.width, renderRectangle.height, null);
        MouseEvent lastClickEvent = this.lastMouseClickEvent;
        this.lastMouseClickEvent = null;
        this.processVkbMouseClick(renderRectangle, lastClickEvent);
        this.drawVkbState(gfx, renderRectangle);
    }

    private void drawVkbState(Graphics2D gfx, Rectangle keyboardArea) {
        double scaleX = (double)keyboardArea.width / (double)this.vkbdDecoration.getWidth();
        double scaleY = (double)keyboardArea.height / (double)this.vkbdDecoration.getHeight();
        gfx.setColor(Color.GREEN);
        gfx.setComposite(AlphaComposite.getInstance(3, 0.5f));
        int bitPos = 0;
        for (long totalKeyboardState = (this.mainKeyboard.getKeyState() & this.vkbKeysState ^ 0x1F1F1F1F1F1F1F1FL) & 0x1F1F1F1F1F1F1F1FL; totalKeyboardState != 0L; totalKeyboardState >>>= 1) {
            if ((totalKeyboardState & 1L) != 0L) {
                Rectangle rectangle = this.vkbdDecoration.getKeyRectangleForBitIndex(bitPos);
                gfx.fillOval(keyboardArea.x + (int)Math.round(scaleX * (double)rectangle.x), keyboardArea.y + (int)Math.round(scaleY * (double)rectangle.y), (int)Math.round(scaleX * (double)rectangle.width), (int)Math.round(scaleY * (double)rectangle.height));
            }
            ++bitPos;
        }
    }

    public void preState(boolean signalReset, boolean tstatesIntReached, boolean wallClockInt) {
        if (wallClockInt && this.ticksTillReleaseStickyKeys > 0) {
            --this.ticksTillReleaseStickyKeys;
            if (this.ticksTillReleaseStickyKeys == 0) {
                this.vkbKeysState |= 0x200000000000001L;
            }
        }
    }

    public void processVkbMouseClick(Rectangle keyboardArea, MouseEvent mouseEvent) {
        long result = this.vkbKeysState;
        double scaleX = (double)keyboardArea.width / (double)this.vkbdDecoration.getWidth();
        double scaleY = (double)keyboardArea.height / (double)this.vkbdDecoration.getHeight();
        if (mouseEvent != null && keyboardArea.contains(mouseEvent.getPoint())) {
            boolean pressingEvent;
            Point normalized = new Point((int)Math.round((double)(mouseEvent.getPoint().x - keyboardArea.x) / scaleX), (int)Math.round((double)(mouseEvent.getPoint().y - keyboardArea.y) / scaleY));
            int pressedKeyBits = this.vkbdDecoration.findPressedKeyBits(normalized);
            if (pressedKeyBits < 0) {
                return;
            }
            long keyCode = KEY_TABLE[BIT2KEY[pressedKeyBits]];
            boolean bl = pressingEvent = mouseEvent.getID() == 501;
            if ((keyCode & 0xFDFFFFFFFFFFFFFEL) != 0L) {
                long woSticky = keyCode & 0xFDFFFFFFFFFFFFFEL;
                result = pressingEvent ? (result &= woSticky ^ 0xFFFFFFFFFFFFFFFFL) : (result |= woSticky);
            }
            if ((keyCode & 0x200000000000001L) != 0L && pressingEvent && ((result ^= keyCode & 0x200000000000001L) & 0x200000000000001L) == 0L) {
                this.ticksTillReleaseStickyKeys = 10;
            }
        }
        this.vkbKeysState = result;
    }

    public void doReset() {
        this.vkbKeysState = 0x1F1F1F1F1F1F1F1FL;
        this.ticksTillReleaseStickyKeys = 0;
        this.lastMouseClickEvent = null;
    }

    public long getKeyState() {
        return this.vkbKeysState;
    }

    public int getImageHeight() {
        return this.vkbdDecoration.getHeight();
    }

    public int getImageWidth() {
        return this.vkbdDecoration.getWidth();
    }

    static {
        int keyIndex = 0;
        while (keyIndex < KEY_TABLE.length) {
            long acc = KEY_TABLE[keyIndex];
            int arrayIndex = 0;
            while (acc != 0L) {
                acc >>>= 1;
                ++arrayIndex;
            }
            VirtualKeyboardRender.BIT2KEY[arrayIndex - 1] = keyIndex++;
        }
    }
}

