/*
 * Decompiled with CFR 0.152.
 */
package com.igormaznitsa.zxpoly.components.video.tvfilters;

import com.igormaznitsa.zxpoly.components.video.VideoController;
import com.igormaznitsa.zxpoly.components.video.tvfilters.TvFilterOldTv;
import java.awt.Color;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferInt;

public abstract class AbstractMonochromeOldTvFilter
extends TvFilterOldTv {
    private final Color[] borderColors = this.precalculateEightBorderColors();

    AbstractMonochromeOldTvFilter() {
    }

    public static int rgb2y(int r, int g, int b) {
        return Math.min(Math.round((float)r * 0.4047f + (float)g * 0.5913f + (float)b * 0.2537f), 255);
    }

    @Override
    public int[] makePalette() {
        int[] result = new int[256];
        for (int y = 0; y < 256; ++y) {
            result[y] = this.y2rgb(y);
        }
        return result;
    }

    private Color[] precalculateEightBorderColors() {
        Color[] result = new Color[8];
        for (int i = 0; i < 8; ++i) {
            Color color = VideoController.PALETTE_ZXPOLY_COLORS[i];
            int y = AbstractMonochromeOldTvFilter.rgb2y(color.getRed(), color.getGreen(), color.getBlue());
            result[i] = new Color(this.y2rgb(y));
        }
        return result;
    }

    @Override
    public boolean isGifCompatible() {
        return true;
    }

    protected abstract int y2rgb(int var1);

    @Override
    public final BufferedImage apply(BufferedImage srcImageArgb512x384, float zoom, int argbBorderColor, boolean firstInChain) {
        BufferedImage result = super.apply(srcImageArgb512x384, zoom, argbBorderColor, firstInChain);
        int[] argbBuffer = ((DataBufferInt)result.getRaster().getDataBuffer()).getData();
        for (int i = 0; i < argbBuffer.length; ++i) {
            int argb = argbBuffer[i];
            int a = argb >>> 24 & 0xFF;
            int r = argb >>> 16 & 0xFF;
            int g = argb >>> 8 & 0xFF;
            int b = argb & 0xFF;
            int rgb = this.y2rgb(AbstractMonochromeOldTvFilter.rgb2y(r, g, b));
            argbBuffer[i] = a << 24 | rgb;
        }
        return result;
    }

    @Override
    public final byte[] apply(boolean forceCopy, byte[] rgbArray512x384, int argbBorderColor) {
        byte[] result = super.apply(forceCopy, rgbArray512x384, argbBorderColor);
        int i = 0;
        while (i < result.length) {
            int resultOffset = i;
            int r = result[i++] & 0xFF;
            int g = result[i++] & 0xFF;
            int b = result[i++] & 0xFF;
            int rgb = this.y2rgb(AbstractMonochromeOldTvFilter.rgb2y(r, g, b));
            result[resultOffset++] = (byte)(rgb >> 16);
            result[resultOffset++] = (byte)(rgb >> 8);
            result[resultOffset] = (byte)rgb;
        }
        return result;
    }

    @Override
    public Color applyBorderColor(Color borderColor) {
        int rgb = borderColor.getRGB();
        int index = ((rgb >> 16 & 0xFF) == 0 ? 0 : 4) | ((rgb >> 8 & 0xFF) == 0 ? 0 : 2) | ((rgb & 0xFF) == 0 ? 0 : 1);
        return this.borderColors[index];
    }
}

