/*
 * Decompiled with CFR 0.152.
 */
package com.igormaznitsa.zxpoly.components.video.tvfilters;

import com.igormaznitsa.zxpoly.components.video.tvfilters.TvFilter;
import java.awt.Color;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferInt;
import java.util.Arrays;

public final class TvFilterBlackWhite
implements TvFilter {
    private static final int[][] MATRIX = new int[][]{{0, 48, 12, 60, 3, 51, 15, 63}, {32, 16, 44, 28, 35, 19, 47, 31}, {8, 56, 4, 52, 11, 59, 7, 55}, {40, 24, 36, 20, 43, 27, 39, 23}, {2, 50, 14, 62, 1, 49, 13, 61}, {34, 18, 46, 30, 33, 17, 45, 29}, {10, 58, 6, 54, 9, 57, 5, 53}, {42, 26, 38, 22, 41, 25, 37, 21}};
    private static final TvFilterBlackWhite INSTANCE = new TvFilterBlackWhite();

    public static TvFilterBlackWhite getInstance() {
        return INSTANCE;
    }

    private static int toBitPair(int color) {
        if (color < 64) {
            return 0;
        }
        if (color < 128) {
            return 1;
        }
        if (color < 192) {
            return 2;
        }
        return 3;
    }

    private static int getLevel64(int argb) {
        int r = argb >> 16 & 0xFF;
        int g = argb >> 8 & 0xFF;
        int b = argb & 0xFF;
        int bits = TvFilterBlackWhite.toBitPair(g) << 4 | TvFilterBlackWhite.toBitPair(r) << 2 | TvFilterBlackWhite.toBitPair(b);
        return bits == 63 ? 64 : bits;
    }

    private static int getLevel64(int r, int g, int b) {
        int bits = TvFilterBlackWhite.toBitPair(g) << 4 | TvFilterBlackWhite.toBitPair(r) << 2 | TvFilterBlackWhite.toBitPair(b);
        return bits == 63 ? 64 : bits;
    }

    @Override
    public Color applyBorderColor(Color borderColor) {
        return borderColor.getRed() < 128 ? Color.BLACK : Color.WHITE;
    }

    @Override
    public BufferedImage apply(BufferedImage srcImageArgb512x384, float zoom, int argbBorderColor, boolean firstInChain) {
        int[] src = ((DataBufferInt)srcImageArgb512x384.getRaster().getDataBuffer()).getData();
        int[] dst = SHARED_BUFFER_RASTER;
        for (int y = 0; y < 384; ++y) {
            for (int x = 0; x < 512; ++x) {
                int pos = y * 512 + x;
                dst[pos] = MATRIX[x & 7][y & 7] < TvFilterBlackWhite.getLevel64(src[pos]) ? -1 : -16777216;
            }
        }
        return SHARED_BUFFER;
    }

    @Override
    public byte[] apply(boolean forceCopy, byte[] rgbArray512x384, int argbBorderColor) {
        byte[] result = forceCopy ? Arrays.copyOf(rgbArray512x384, rgbArray512x384.length) : rgbArray512x384;
        for (int y = 0; y < 384; ++y) {
            for (int x = 0; x < 512; ++x) {
                int b;
                int g;
                int r;
                int pos;
                int tpos = pos = y * 1536 + x * 3;
                int level = MATRIX[x & 7][y & 7] < TvFilterBlackWhite.getLevel64(r = result[tpos++] & 0xFF, g = result[tpos++] & 0xFF, b = result[tpos] & 0xFF) ? -1 : 0;
                tpos = pos;
                result[tpos++] = level;
                result[tpos++] = level;
                result[tpos] = level;
            }
        }
        return result;
    }

    @Override
    public int[] makePalette() {
        return new int[]{0, 0xFFFFFF};
    }

    @Override
    public boolean isGifCompatible() {
        return true;
    }
}

