/*
 * Decompiled with CFR 0.152.
 */
package com.igormaznitsa.zxpoly.components.video.tvfilters;

import com.igormaznitsa.zxpoly.components.video.tvfilters.TvFilter;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferInt;
import java.util.Arrays;
import java.util.stream.IntStream;

public class TvFilterGaussian
implements TvFilter {
    private static final TvFilterGaussian INSTANCE = new TvFilterGaussian();
    private static final int[] FILTER = new int[]{1, 2, 1, 2, 4, 2, 1, 2, 1};
    private static final int FILTER_SUM = IntStream.of(FILTER).sum();
    private static final int FILTER_WIDTH = 3;
    private static final int CENTER_OFFSET_X = 1;
    private static final int CENTER_OFFSET_Y = FILTER.length / 3 / 2;
    private static final int PIXEL_INDEX_OFFSET_ARGB_INT = 509;
    private static final int PIXEL_INDEX_OFFSET_RGB_BYTE = 1527;
    private final int[] blurBuffer = new int[196608];
    private final byte[] blurByteBuffer = new byte[589824];

    private TvFilterGaussian() {
    }

    public static TvFilterGaussian getInstance() {
        return INSTANCE;
    }

    private static void blur(int[] src, int[] out) {
        int h = 384 - FILTER.length / 3 + 1;
        int w = 510;
        for (int y = 0; y < h; ++y) {
            for (int x = 0; x < w; ++x) {
                int r = 0;
                int g = 0;
                int b = 0;
                int f = 0;
                int pixelIndex = y * 512 + x;
                while (f < FILTER.length) {
                    int fx = 0;
                    while (fx < 3) {
                        int filterFactor = FILTER[f];
                        int srcArgb = src[pixelIndex++];
                        r += (srcArgb >>> 16 & 0xFF) * filterFactor;
                        g += (srcArgb >>> 8 & 0xFF) * filterFactor;
                        b += (srcArgb & 0xFF) * filterFactor;
                        ++fx;
                        ++f;
                    }
                    pixelIndex += 509;
                }
                out[x + 1 + (y + TvFilterGaussian.CENTER_OFFSET_Y) * 512] = (r /= FILTER_SUM) << 16 | (g /= FILTER_SUM) << 8 | (b /= FILTER_SUM) | 0xFF000000;
            }
        }
    }

    private static void blur(byte[] rgbSrc, byte[] rgbOut) {
        int h = 384 - FILTER.length / 3 + 1;
        int w = 1530;
        for (int y = 0; y < h; ++y) {
            for (int x = 0; x < w; x += 3) {
                int r = 0;
                int g = 0;
                int b = 0;
                int f = 0;
                int pixelIndex = y * 1536 + x;
                while (f < FILTER.length) {
                    int fx = 0;
                    while (fx < 3) {
                        int filterFactor = FILTER[f];
                        r += (rgbSrc[pixelIndex++] & 0xFF) * filterFactor;
                        g += (rgbSrc[pixelIndex++] & 0xFF) * filterFactor;
                        b += (rgbSrc[pixelIndex++] & 0xFF) * filterFactor;
                        ++fx;
                        ++f;
                    }
                    pixelIndex += 1527;
                }
                int outIndex = x + 3 + (y + CENTER_OFFSET_Y) * 1536;
                rgbOut[outIndex++] = (byte)(r /= FILTER_SUM);
                rgbOut[outIndex++] = (byte)(g /= FILTER_SUM);
                rgbOut[outIndex] = (byte)(b /= FILTER_SUM);
            }
        }
    }

    @Override
    public byte[] apply(boolean forceCopy, byte[] rgbArray512x384, int argbBorderColor) {
        byte[] result = forceCopy ? Arrays.copyOf(rgbArray512x384, rgbArray512x384.length) : rgbArray512x384;
        System.arraycopy(result, 0, this.blurByteBuffer, 0, result.length);
        TvFilterGaussian.blur(result, this.blurByteBuffer);
        System.arraycopy(this.blurByteBuffer, 0, result, 0, this.blurByteBuffer.length);
        return result;
    }

    @Override
    public BufferedImage apply(BufferedImage srcImageArgb512x384, float zoom, int argbBorderColor, boolean firstInChain) {
        int[] resultRaster;
        BufferedImage result;
        if (firstInChain) {
            result = SHARED_BUFFER;
            resultRaster = SHARED_BUFFER_RASTER;
            int[] srcRaster = ((DataBufferInt)srcImageArgb512x384.getRaster().getDataBuffer()).getData();
            System.arraycopy(srcRaster, 0, resultRaster, 0, resultRaster.length);
        } else {
            result = srcImageArgb512x384;
            resultRaster = ((DataBufferInt)result.getRaster().getDataBuffer()).getData();
        }
        TvFilterGaussian.blur(resultRaster, this.blurBuffer);
        System.arraycopy(this.blurBuffer, 0, resultRaster, 0, this.blurBuffer.length);
        return result;
    }
}

