/*
 * Decompiled with CFR 0.152.
 */
package com.igormaznitsa.zxpoly.components.video.tvfilters;

import com.igormaznitsa.zxpoly.components.video.VideoController;
import com.igormaznitsa.zxpoly.components.video.tvfilters.TvFilter;
import java.awt.Color;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferInt;
import java.util.Arrays;
import java.util.stream.Stream;

public final class TvFilterGrayscale
implements TvFilter {
    private static final TvFilterGrayscale INSTANCE = new TvFilterGrayscale();
    private static final Color[] GRAYSCALE_BORDER_COLORS = (Color[])Stream.of(VideoController.PALETTE_ZXPOLY_COLORS).limit(8L).map(TvFilterGrayscale::color2gray).toArray(Color[]::new);

    private TvFilterGrayscale() {
    }

    private static Color color2gray(Color color) {
        int rgb = color.getRGB();
        int y = TvFilterGrayscale.rgb2y(rgb >>> 16 & 0xFF, rgb >>> 8 & 0xFF, rgb & 0xFF);
        return new Color(y, y, y);
    }

    public static TvFilterGrayscale getInstance() {
        return INSTANCE;
    }

    private static int rgb2y(int r, int g, int b) {
        return Math.min(Math.round((float)r * 0.4047f + (float)g * 0.5913f + (float)b * 0.2537f), 255);
    }

    private static void fastArgbToGrayscale(int[] src) {
        int index = src.length;
        while (--index >= 0) {
            int argb = src[index];
            int a = argb >>> 24 & 0xFF;
            int r = argb >>> 16 & 0xFF;
            int g = argb >>> 8 & 0xFF;
            int b = argb & 0xFF;
            int y = TvFilterGrayscale.rgb2y(r, g, b);
            TvFilterGrayscale.SHARED_BUFFER_RASTER[index] = a << 24 | y << 16 | y << 8 | y;
        }
    }

    @Override
    public byte[] apply(boolean forceCopy, byte[] rgbArray512x384, int argbBorderColor) {
        byte[] result = forceCopy ? Arrays.copyOf(rgbArray512x384, rgbArray512x384.length) : rgbArray512x384;
        int index = result.length;
        while (--index > 0) {
            int base = index;
            int b = result[index--] & 0xFF;
            int g = result[index--] & 0xFF;
            int r = result[index] & 0xFF;
            byte y = (byte)TvFilterGrayscale.rgb2y(r, g, b);
            result[base--] = y;
            result[base--] = y;
            result[base] = y;
        }
        return result;
    }

    @Override
    public Color applyBorderColor(Color borderColor) {
        int rgb = borderColor.getRGB();
        int index = ((rgb >>> 16 & 0xFF) == 0 ? 0 : 4) | ((rgb >>> 8 & 0xFF) == 0 ? 0 : 2) | ((rgb & 0xFF) == 0 ? 0 : 1);
        return GRAYSCALE_BORDER_COLORS[index];
    }

    @Override
    public BufferedImage apply(BufferedImage srcImageArgb512x384, float zoom, int argbBorder, boolean firstInChain) {
        int[] src = ((DataBufferInt)srcImageArgb512x384.getRaster().getDataBuffer()).getData();
        TvFilterGrayscale.fastArgbToGrayscale(src);
        return SHARED_BUFFER;
    }

    @Override
    public int[] makePalette() {
        int[] palette = new int[256];
        for (int y = 0; y < 256; ++y) {
            palette[y] = y << 16 | y << 8 | y;
        }
        return palette;
    }

    @Override
    public boolean isGifCompatible() {
        return true;
    }
}

