/*
 * Decompiled with CFR 0.152.
 */
package com.igormaznitsa.zxpoly.formats;

import com.igormaznitsa.zxpoly.components.BoardMode;
import com.igormaznitsa.zxpoly.components.Motherboard;
import com.igormaznitsa.zxpoly.components.RomData;
import com.igormaznitsa.zxpoly.components.video.VideoController;
import com.igormaznitsa.zxpoly.formats.Snapshot;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Locale;
import org.apache.commons.io.IOUtils;

public class FormatRom
extends Snapshot {
    @Override
    public void loadFromArray(File srcFile, Motherboard board, VideoController vc, byte[] array) throws IOException {
        byte[] data;
        if (srcFile.length() > 65536L) {
            throw new IOException("Too big ROM file");
        }
        try (FileInputStream inputStream = new FileInputStream(srcFile);){
            data = IOUtils.readFully((InputStream)inputStream, (int)srcFile.length());
        }
        RomData newRomData = new RomData(srcFile.getAbsolutePath(), data);
        board.getModules()[0].setRomData(newRomData);
        board.setBoardMode(BoardMode.ZX128, true);
    }

    @Override
    public boolean canMakeSnapshotForBoardMode(BoardMode mode) {
        return false;
    }

    @Override
    public String getExtension() {
        return "rom";
    }

    @Override
    public byte[] saveToArray(Motherboard board, VideoController vc) throws IOException {
        throw new IOException("Unsupported board mode: " + String.valueOf((Object)board.getBoardMode()));
    }

    @Override
    public String getName() {
        return "ROM snapshot";
    }

    @Override
    public boolean accept(File f) {
        return f != null && (f.isDirectory() || f.getName().toLowerCase(Locale.ENGLISH).endsWith(".rom"));
    }

    @Override
    public String getDescription() {
        return "ROM image (*.rom)";
    }
}

