/*
 * Decompiled with CFR 0.152.
 */
package com.igormaznitsa.zxpoly.formats;

import com.igormaznitsa.jbbp.io.JBBPBitInputStream;
import com.igormaznitsa.jbbp.io.JBBPBitOutputStream;
import com.igormaznitsa.z80.Z80;
import com.igormaznitsa.zxpoly.components.BoardMode;
import com.igormaznitsa.zxpoly.components.Motherboard;
import com.igormaznitsa.zxpoly.components.ZxPolyModule;
import com.igormaznitsa.zxpoly.components.video.VideoController;
import com.igormaznitsa.zxpoly.formats.SNAParser;
import com.igormaznitsa.zxpoly.formats.Snapshot;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.Locale;
import java.util.stream.IntStream;

public class FormatSNA
extends Snapshot {
    @Override
    public String getExtension() {
        return "sna";
    }

    @Override
    public boolean canMakeSnapshotForBoardMode(BoardMode mode) {
        return mode == BoardMode.ZX128 || mode == BoardMode.SPEC256;
    }

    @Override
    public void loadFromArray(File srcFile, Motherboard board, VideoController vc, byte[] array) throws IOException {
        int pcReg;
        boolean sna128;
        SNAParser parser = new SNAParser().read(new JBBPBitInputStream(new ByteArrayInputStream(array)));
        boolean bl = sna128 = array.length > 49179;
        if (sna128) {
            this.doMode128(board);
        } else {
            this.doMode48(board);
        }
        ZxPolyModule module = board.getModules()[0];
        Z80 cpu = module.getCpu();
        cpu.setRegisterPair(0, parser.getREGAF());
        cpu.setRegisterPair(2, parser.getREGBC());
        cpu.setRegisterPair(4, parser.getREGDE());
        cpu.setRegisterPair(6, parser.getREGHL());
        cpu.setRegisterPair(0, parser.getALTREGAF(), true);
        cpu.setRegisterPair(2, parser.getALTREGBC(), true);
        cpu.setRegisterPair(4, parser.getALTREGDE(), true);
        cpu.setRegisterPair(6, parser.getALTREGHL(), true);
        cpu.setRegister(8, parser.getREGIX());
        cpu.setRegister(9, parser.getREGIY());
        cpu.setRegister(12, parser.getREGI());
        cpu.setRegister(13, parser.getREGR());
        cpu.setIM(parser.getINTMODE() & 3);
        boolean iff2 = (parser.getIFF2() & 4) == 4;
        cpu.setIFF(iff2, iff2);
        vc.writeIo(module, 254, parser.getBORDERCOLOR() & 7);
        vc.setBorderColor(parser.getBORDERCOLOR() & 7);
        if (sna128) {
            int[] bankIndex = new int[]{0, 1, 2, 3, 4, 5, 6, 7};
            bankIndex[2] = -1;
            bankIndex[5] = -1;
            bankIndex[parser.getEXTENDEDDATA().getPORT7FFD() & 7] = -1;
            module.writeHeapPage(5, Arrays.copyOfRange(parser.ramdump, 0, 16384));
            module.writeHeapPage(2, Arrays.copyOfRange(parser.ramdump, 16384, 32768));
            module.writeHeapPage(parser.getEXTENDEDDATA().getPORT7FFD() & 7, Arrays.copyOfRange(parser.ramdump, 32768, 49152));
            pcReg = parser.getEXTENDEDDATA().getREGPC();
            cpu.setRegister(11, pcReg);
            cpu.setRegister(10, parser.getREGSP());
            module.write7FFD(parser.getEXTENDEDDATA().getPORT7FFD(), true);
            module.setTrdosActive(parser.getEXTENDEDDATA().getONTRDOS() != 0);
            int extraBankIndex = 0;
            for (int i = 0; i < 8 && extraBankIndex < parser.getEXTENDEDDATA().getEXTRABANK().length; ++i) {
                if (bankIndex[i] < 0) continue;
                module.writeHeapPage(bankIndex[i], parser.getEXTENDEDDATA().getEXTRABANK()[extraBankIndex++].getDATA());
            }
        } else {
            for (int i = 0; i < parser.getRAMDUMP().length; ++i) {
                module.writeMemory(cpu, 0, 16384 + i, parser.getRAMDUMP()[i]);
            }
            int regSp = parser.getREGSP();
            int lowPc = module.readMemory(cpu, 0, regSp, false, false) & 0xFF;
            regSp = regSp + '\u0001' & 0xFFFF;
            int highPc = module.readMemory(cpu, 0, regSp, false, false) & 0xFF;
            regSp = regSp + 1 & 0xFFFF;
            pcReg = highPc << 8 | lowPc;
            cpu.setRegister(10, regSp);
            cpu.setRegister(11, pcReg);
        }
        LOGGER.info("Start address: " + pcReg);
    }

    @Override
    public byte[] saveToArray(Motherboard board, VideoController vc) throws IOException {
        SNAParser parser = new SNAParser();
        ZxPolyModule module = board.getModules()[0];
        Z80 cpu = board.getMasterCpu();
        parser.setREGAF((char)cpu.getRegisterPair(0));
        parser.setREGBC((char)cpu.getRegisterPair(2));
        parser.setREGDE((char)cpu.getRegisterPair(4));
        parser.setREGHL((char)cpu.getRegisterPair(6));
        parser.setALTREGAF((char)cpu.getRegisterPair(0, true));
        parser.setALTREGBC((char)cpu.getRegisterPair(2, true));
        parser.setALTREGDE((char)cpu.getRegisterPair(4, true));
        parser.setALTREGHL((char)cpu.getRegisterPair(6, true));
        parser.setREGIX((char)cpu.getRegister(8));
        parser.setREGIY((char)cpu.getRegister(9));
        parser.setREGI((char)cpu.getRegister(12));
        parser.setREGR((char)cpu.getRegister(13));
        parser.setINTMODE((char)(cpu.getIM() & 3));
        parser.setIFF2((char)(cpu.isIFF1() ? 4 : 0));
        parser.setBORDERCOLOR((char)(vc.getPortFE() & 7));
        int topPageIndex = module.read7FFD() & 7;
        int offsetPage2 = 32768;
        int offsetPage5 = 81920;
        int offsetPageTop = topPageIndex * 16384;
        byte[] lowRam = new byte[49179];
        int[] bankIndex = new int[]{0, 1, 2, 3, 4, 5, 6, 7};
        bankIndex[2] = -1;
        bankIndex[5] = -1;
        bankIndex[topPageIndex] = -1;
        for (int i = 0; i < 16384; ++i) {
            lowRam[i] = (byte)module.readHeap(81920 + i);
            lowRam[i + 16384] = (byte)module.readHeap(32768 + i);
            lowRam[i + 32768] = (byte)module.readHeap(offsetPageTop + i);
        }
        if (FormatSNA.isMode48(module)) {
            int regSp = cpu.getRegister(10);
            int regPc = cpu.getRegister(11);
            regSp = regSp - 1 & 0xFFFF;
            lowRam[regSp - 16384] = (byte)(regPc >> 8);
            regSp = regSp - 1 & 0xFFFF;
            lowRam[regSp - 16384] = (byte)regPc;
            parser.setREGSP((char)regSp);
            parser.setRAMDUMP(lowRam);
        } else {
            parser.setREGSP((char)cpu.getRegister(10));
            parser.setRAMDUMP(lowRam);
            SNAParser.EXTENDEDDATA extData = parser.makeEXTENDEDDATA();
            extData.setREGPC((char)cpu.getRegister(11));
            extData.setPORT7FFD((char)module.read7FFD());
            extData.setONTRDOS((byte)(module.isTrdosActive() ? 1 : 0));
            int totalExtraBanks = (int)IntStream.of(bankIndex).filter(x -> x >= 0).count();
            SNAParser.EXTENDEDDATA.EXTRABANK[] extraBank = parser.getEXTENDEDDATA().makeEXTRABANK(totalExtraBanks);
            for (int i = 0; i < extraBank.length; ++i) {
                extraBank[i] = new SNAParser.EXTENDEDDATA.EXTRABANK(parser);
                extraBank[i].setDATA(new byte[16384]);
            }
            int extraBankIndex = 0;
            for (int i = 0; i < 8; ++i) {
                if (bankIndex[i] < 0) continue;
                byte[] data = parser.getEXTENDEDDATA().getEXTRABANK()[extraBankIndex++].getDATA();
                int heapOffset = bankIndex[i] * 16384;
                for (int a = 0; a < data.length; ++a) {
                    data[a] = (byte)module.readHeap(heapOffset + a);
                }
            }
        }
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        try (JBBPBitOutputStream bitOut = new JBBPBitOutputStream(bos);){
            parser.write(bitOut);
        }
        return bos.toByteArray();
    }

    @Override
    public boolean accept(File f) {
        return f != null && (f.isDirectory() || f.getName().toLowerCase(Locale.ENGLISH).endsWith(".sna"));
    }

    @Override
    public String getDescription() {
        return "SNA Snapshot (*.sna)";
    }

    @Override
    public String getName() {
        return "SNA snapshot";
    }
}

