/*
 * Decompiled with CFR 0.152.
 */
package com.igormaznitsa.zxpoly.formats;

import com.igormaznitsa.z80.Z80;
import com.igormaznitsa.zxpoly.components.BoardMode;
import com.igormaznitsa.zxpoly.components.Motherboard;
import com.igormaznitsa.zxpoly.components.ZxPolyModule;
import com.igormaznitsa.zxpoly.components.sound.AyBasedSoundDevice;
import com.igormaznitsa.zxpoly.components.video.UlaPlusContainer;
import com.igormaznitsa.zxpoly.components.video.VideoController;
import com.igormaznitsa.zxpoly.components.video.timings.TimingProfile;
import com.igormaznitsa.zxpoly.formats.Snapshot;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.EOFException;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.function.BiConsumer;
import java.util.logging.Level;
import java.util.stream.Collectors;
import java.util.zip.Deflater;
import java.util.zip.DeflaterOutputStream;
import org.apache.commons.compress.compressors.deflate.DeflateCompressorInputStream;
import org.apache.commons.io.IOUtils;

public class FormatSZX
extends Snapshot {
    @Override
    public String getExtension() {
        return "szx";
    }

    @Override
    public void loadFromArray(File srcFile, Motherboard board, VideoController vc, byte[] array) throws IOException {
        boolean spec128;
        SzxContainer container = new SzxContainer(new ByteArrayInputStream(array));
        LOGGER.log(Level.INFO, container.toString());
        ZxPolyModule module = board.getModules()[0];
        Z80 cpu = module.getCpu();
        switch (container.getMachineId()) {
            case 0: 
            case 1: 
            case 15: {
                spec128 = false;
                this.doMode48(board);
                break;
            }
            default: {
                spec128 = true;
                this.doMode128(board);
            }
        }
        container.getBlocks().stream().filter(x -> x.getId() == SzxContainer.SzxBlock.ID_ZXSTZ80REGS).forEach(x -> x.consume((block, in) -> {
            cpu.setRegisterPair(0, in.readWord());
            cpu.setRegisterPair(2, in.readWord());
            cpu.setRegisterPair(4, in.readWord());
            cpu.setRegisterPair(6, in.readWord());
            cpu.setRegisterPair(0, in.readWord(), true);
            cpu.setRegisterPair(2, in.readWord(), true);
            cpu.setRegisterPair(4, in.readWord(), true);
            cpu.setRegisterPair(6, in.readWord(), true);
            cpu.setRegister(8, in.readWord());
            cpu.setRegister(9, in.readWord());
            cpu.setRegister(10, in.readWord());
            cpu.setRegister(11, in.readWord());
            cpu.setRegister(12, in.readByte());
            cpu.setRegister(13, in.readByte());
            boolean iff1 = in.readByte() != 0;
            boolean iff2 = in.readByte() != 0;
            cpu.setIFF(iff1, iff2);
            cpu.setIM(in.readByte());
            int dwCyclesStart = in.readDWord();
            int chHoldIntReqCycles = in.readByte();
            int chFlags = in.readByte();
            int wMemPtr = in.readWord();
            cpu.setTstates(dwCyclesStart);
            in.assertNoMoreData();
        }));
        container.getBlocks().stream().filter(x -> x.getId() == SzxContainer.SzxBlock.ID_ZXSTAYBLOCK).forEach(x -> x.consume((block, in) -> {
            int flags = in.readByte();
            int currentRegister = in.readByte();
            byte[] registerData = in.readFully(16);
            in.assertNoMoreData();
            AyBasedSoundDevice foundAyDevice = board.findIoDevice(AyBasedSoundDevice.class);
            if (foundAyDevice != null) {
                foundAyDevice.setAyAddress(currentRegister);
                for (int i = 0; i < registerData.length; ++i) {
                    foundAyDevice.setAyRegister(i, registerData[i] & 0xFF);
                }
            }
        }));
        container.getBlocks().stream().filter(x -> x.getId() == SzxContainer.SzxBlock.ID_ZXSTSPECREGS).forEach(x -> x.consume((block, in) -> {
            int border = in.readByte();
            int port7FFD = in.readByte();
            int port1FFDorEFF7 = in.readByte();
            int portFE = in.readByte();
            int reserved = in.readDWord();
            if (spec128) {
                module.write7FFD(port7FFD, true);
            }
            board.getVideoController().setBorderColor(border & 7);
            in.assertNoMoreData();
        }));
        container.getBlocks().stream().filter(x -> x.getId() == SzxContainer.SzxBlock.ID_ZXSTRAMPAGE).forEach(x -> x.consume((block, in) -> {
            int flags = in.readWord();
            int pageNum = in.readByte();
            byte[] data = in.rest();
            if ((flags & 1) != 0) {
                data = SzxContainer.SzxBlock.decompress(data);
            }
            module.writeHeapPage(pageNum, data);
            in.assertNoMoreData();
        }));
        container.getBlocks().stream().filter(x -> x.getId() == SzxContainer.SzxBlock.ID_ZXSTPALETTE).forEach(x -> x.consume((block, in) -> {
            int flags = in.readByte();
            int register = in.readByte();
            byte[] palette = in.readFully(64);
            int portFF = 0;
            if (in.available() > 0) {
                portFF = in.readByte();
            }
            in.assertNoMoreData();
            UlaPlusContainer ulaPlusContainer = board.getVideoController().getUlaPlus();
            if (ulaPlusContainer.isEnabled()) {
                ulaPlusContainer.loadPalette(palette);
                ulaPlusContainer.setRegister(register);
                ulaPlusContainer.setPortFF(portFF);
                ulaPlusContainer.setActive((flags & 1) != 0);
            }
        }));
    }

    @Override
    public boolean canMakeSnapshotForBoardMode(BoardMode mode) {
        return mode == BoardMode.ZX128;
    }

    @Override
    public boolean isAllowUlaPlus() {
        return true;
    }

    @Override
    public byte[] saveToArray(Motherboard board, VideoController vc) throws IOException {
        int machineId = board.getTimingProfile() == TimingProfile.PENTAGON128 ? 7 : 2;
        ZxPolyModule module = board.getModules()[0];
        AyBasedSoundDevice ayDevice = board.findIoDevice(AyBasedSoundDevice.class);
        SzxContainer container = new SzxContainer(machineId, 0, List.of(new SzxContainer.SzxBlock(SzxContainer.SzxBlock.ID_ZXSTCREATOR, (block, out) -> {
            out.writeFully(Arrays.copyOf("ZX-Poly emulator                       ".getBytes(StandardCharsets.US_ASCII), 32));
            out.writeWord(2);
            out.writeWord(3);
        }), new SzxContainer.SzxBlock(SzxContainer.SzxBlock.ID_ZXSTZ80REGS, (block, out) -> {
            Z80 cpu = module.getCpu();
            out.writeWord(cpu.getRegisterPair(0));
            out.writeWord(cpu.getRegisterPair(2));
            out.writeWord(cpu.getRegisterPair(4));
            out.writeWord(cpu.getRegisterPair(6));
            out.writeWord(cpu.getRegisterPair(0, true));
            out.writeWord(cpu.getRegisterPair(2, true));
            out.writeWord(cpu.getRegisterPair(4, true));
            out.writeWord(cpu.getRegisterPair(6, true));
            out.writeWord(cpu.getRegister(8));
            out.writeWord(cpu.getRegister(9));
            out.writeWord(cpu.getRegister(10));
            out.writeWord(cpu.getRegister(11));
            out.write(cpu.getRegister(12));
            out.write(cpu.getRegister(13));
            out.write(cpu.isIFF1() ? 1 : 0);
            out.write(cpu.isIFF2() ? 1 : 0);
            out.write(cpu.getIM());
            out.writeDWord(0);
            out.write(0);
            out.write(0);
            out.writeWord(0);
        }), new SzxContainer.SzxBlock(SzxContainer.SzxBlock.ID_ZXSTSPECREGS, (block, out) -> {
            int portFE = board.getVideoController().getPortFE();
            out.write(portFE & 7);
            out.write(module.read7FFD());
            out.write(0);
            out.write(portFE);
            out.writeDWord(0);
        }), new SzxContainer.SzxBlock(SzxContainer.SzxBlock.ID_ZXSTPALETTE, (block, out) -> {
            UlaPlusContainer ulaPlus = board.getVideoController().getUlaPlus();
            out.write(ulaPlus.getMode());
            out.write(ulaPlus.getRegister());
            out.writeFully(ulaPlus.getPalette());
            out.write(ulaPlus.getPortFF());
        }), new SzxContainer.SzxBlock(SzxContainer.SzxBlock.ID_ZXSTRAMPAGE, (block, out) -> {
            boolean page = false;
            out.writeWord(1);
            out.write(0);
            out.write(SzxContainer.SzxBlock.compress(module.makeCopyOfHeapPage(0)));
        }), new SzxContainer.SzxBlock(SzxContainer.SzxBlock.ID_ZXSTRAMPAGE, (block, out) -> {
            boolean page = true;
            out.writeWord(1);
            out.write(1);
            out.write(SzxContainer.SzxBlock.compress(module.makeCopyOfHeapPage(1)));
        }), new SzxContainer.SzxBlock(SzxContainer.SzxBlock.ID_ZXSTRAMPAGE, (block, out) -> {
            int page = 2;
            out.writeWord(1);
            out.write(2);
            out.write(SzxContainer.SzxBlock.compress(module.makeCopyOfHeapPage(2)));
        }), new SzxContainer.SzxBlock(SzxContainer.SzxBlock.ID_ZXSTRAMPAGE, (block, out) -> {
            int page = 3;
            out.writeWord(1);
            out.write(3);
            out.write(SzxContainer.SzxBlock.compress(module.makeCopyOfHeapPage(3)));
        }), new SzxContainer.SzxBlock(SzxContainer.SzxBlock.ID_ZXSTRAMPAGE, (block, out) -> {
            int page = 4;
            out.writeWord(1);
            out.write(4);
            out.write(SzxContainer.SzxBlock.compress(module.makeCopyOfHeapPage(4)));
        }), new SzxContainer.SzxBlock(SzxContainer.SzxBlock.ID_ZXSTRAMPAGE, (block, out) -> {
            int page = 5;
            out.writeWord(1);
            out.write(5);
            out.write(SzxContainer.SzxBlock.compress(module.makeCopyOfHeapPage(5)));
        }), new SzxContainer.SzxBlock(SzxContainer.SzxBlock.ID_ZXSTRAMPAGE, (block, out) -> {
            int page = 6;
            out.writeWord(1);
            out.write(6);
            out.write(SzxContainer.SzxBlock.compress(module.makeCopyOfHeapPage(6)));
        }), new SzxContainer.SzxBlock(SzxContainer.SzxBlock.ID_ZXSTRAMPAGE, (block, out) -> {
            int page = 7;
            out.writeWord(1);
            out.write(7);
            out.write(SzxContainer.SzxBlock.compress(module.makeCopyOfHeapPage(7)));
        }), ayDevice == null ? SzxContainer.SzxBlock.FAKE : new SzxContainer.SzxBlock(SzxContainer.SzxBlock.ID_ZXSTAYBLOCK, (block, out) -> {
            out.write(0);
            out.write(ayDevice.getAyAddress());
            for (int i = 0; i < 16; ++i) {
                out.write(ayDevice.getAyRegister(i));
            }
        })));
        ByteArrayOutputStream buffer = new ByteArrayOutputStream();
        container.write(buffer);
        return buffer.toByteArray();
    }

    @Override
    public String getName() {
        return "Spectaculator";
    }

    @Override
    public boolean accept(File f) {
        return f != null && (f.isDirectory() || f.getName().toLowerCase(Locale.ENGLISH).endsWith(".szx"));
    }

    @Override
    public String getDescription() {
        return "Spectaculator (*.szx)";
    }

    public static class SzxContainer {
        public static final int FLAG_ZXSTMF_ALTERNATETIMINGS = 1;
        public static final int ZXSTMID_16K = 0;
        public static final int ZXSTMID_48K = 1;
        public static final int ZXSTMID_128K = 2;
        public static final int ZXSTMID_PLUS2 = 3;
        public static final int ZXSTMID_PLUS2A = 4;
        public static final int ZXSTMID_PLUS3 = 5;
        public static final int ZXSTMID_PLUS3E = 6;
        public static final int ZXSTMID_PENTAGON128 = 7;
        public static final int ZXSTMID_TC2048 = 8;
        public static final int ZXSTMID_TC2068 = 9;
        public static final int ZXSTMID_SCORPION = 10;
        public static final int ZXSTMID_SE = 11;
        public static final int ZXSTMID_TS2068 = 12;
        public static final int ZXSTMID_PENTAGON512 = 13;
        public static final int ZXSTMID_PENTAGON1024 = 14;
        public static final int ZXSTMID_NTSC48K = 15;
        public static final int ZXSTMID_128KE = 16;
        private static final int MAGIC = SzxContainer.makeDword('Z', 'X', 'S', 'T');
        private final List<SzxBlock> blocks;
        private final int magic;
        private final int majorVersion;
        private final int minorVersion;
        private final int machineId;
        private final int flags;

        SzxContainer(int machineId, int flags, List<SzxBlock> blocks) {
            this.magic = MAGIC;
            this.majorVersion = 1;
            this.minorVersion = 4;
            this.flags = flags;
            this.machineId = machineId;
            this.blocks = blocks.stream().filter(Objects::nonNull).collect(Collectors.toList());
        }

        SzxContainer(InputStream inputStream) throws IOException {
            SzxInputStream in = new SzxInputStream(inputStream);
            this.magic = in.readDWord();
            if (this.magic != MAGIC) {
                throw new IOException("Stream is not SZF, can't detect magic");
            }
            this.majorVersion = in.readByte();
            this.minorVersion = in.readByte();
            this.machineId = in.readByte();
            this.flags = in.readByte();
            ArrayList<SzxBlock> foundBlocks = new ArrayList<SzxBlock>();
            while (in.available() > 0) {
                foundBlocks.add(new SzxBlock(in));
            }
            this.blocks = Collections.unmodifiableList(foundBlocks);
        }

        public void write(OutputStream os) throws IOException {
            SzxOutputStream outputStream = new SzxOutputStream(os);
            outputStream.writeDWord(this.magic);
            outputStream.write(this.majorVersion);
            outputStream.write(this.minorVersion);
            outputStream.write(this.machineId);
            outputStream.write(this.flags);
            for (SzxBlock block : this.blocks) {
                block.write(outputStream);
            }
        }

        private static String asString(int dword) {
            char d = (char)(dword >>> 24 & 0xFF);
            char c = (char)(dword >>> 16 & 0xFF);
            char b = (char)(dword >>> 8 & 0xFF);
            char a = (char)(dword & 0xFF);
            return "" + (Character.isISOControl(a) ? (char)' ' : (char)a) + (Character.isISOControl(b) ? (char)' ' : (char)b) + (Character.isISOControl(c) ? (char)' ' : (char)c) + (Character.isISOControl(d) ? (char)' ' : (char)d);
        }

        private static int makeDword(char a, char b, char c, char d) {
            return (d & 0xFF) << 24 | (c & 0xFF) << 16 | (b & 0xFF) << 8 | a & 0xFF;
        }

        public String toString() {
            return String.format("SzxContainer(major=%d,minor=%d,machine=%d,flags=%d,blocks=%s", this.majorVersion, this.minorVersion, this.machineId, this.flags, this.blocks.stream().map(SzxBlock::toString).collect(Collectors.joining(",", "[", "]")));
        }

        public List<SzxBlock> getBlocks() {
            return this.blocks;
        }

        public int getMagic() {
            return this.magic;
        }

        public int getMajorVersion() {
            return this.majorVersion;
        }

        public int getMinorVersion() {
            return this.minorVersion;
        }

        public int getMachineId() {
            return this.machineId;
        }

        public int getFlags() {
            return this.flags;
        }

        public static class SzxInputStream
        extends InputStream {
            private final InputStream inputStream;

            public SzxInputStream(InputStream inputStream) {
                this.inputStream = Objects.requireNonNull(inputStream);
            }

            public byte[] rest() {
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                try {
                    int data;
                    while (this.inputStream.available() > 0 && (data = this.inputStream.read()) >= 0) {
                        baos.write(data);
                    }
                }
                catch (IOException ex) {
                    throw new RuntimeException(ex);
                }
                return baos.toByteArray();
            }

            @Override
            public int read() throws IOException {
                return this.inputStream.read();
            }

            public void assertNoMoreData() {
                if (this.available() > 0) {
                    throw new RuntimeException("Detected unexpected data");
                }
            }

            public int readByte() {
                int result;
                try {
                    result = this.inputStream.read();
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
                if (result < 0) {
                    throw new RuntimeException(new EOFException("End of file"));
                }
                return result;
            }

            public int readWord() {
                int a = this.readByte();
                int b = this.readByte();
                return b << 8 | a;
            }

            private int readDWord() {
                int a = this.readByte();
                int b = this.readByte();
                int c = this.readByte();
                int d = this.readByte();
                return d << 24 | c << 16 | b << 8 | a;
            }

            @Override
            public void close() throws IOException {
                this.inputStream.close();
            }

            @Override
            public int available() {
                try {
                    return this.inputStream.available();
                }
                catch (IOException ex) {
                    throw new RuntimeException(ex);
                }
            }

            public byte[] readFully(int size) {
                byte[] result = new byte[size];
                try {
                    IOUtils.readFully(this.inputStream, result);
                }
                catch (IOException ex) {
                    throw new RuntimeException(ex);
                }
                return result;
            }
        }

        public static class SzxBlock {
            public static final int ID_ZXSTATASP = SzxContainer.makeDword('Z', 'X', 'A', 'T');
            public static final int ID_ZXSTATASPRAM = SzxContainer.makeDword('A', 'T', 'R', 'P');
            public static final int ID_ZXSTAYBLOCK = SzxContainer.makeDword('A', 'Y', '\u0000', '\u0000');
            public static final int ID_ZXSTCF = SzxContainer.makeDword('Z', 'X', 'C', 'F');
            public static final int ID_ZXSTCFRAM = SzxContainer.makeDword('C', 'F', 'R', 'P');
            public static final int ID_ZXSTCOVOX = SzxContainer.makeDword('C', 'O', 'V', 'X');
            public static final int ID_ZXSTBETA128 = SzxContainer.makeDword('B', '1', '2', '8');
            public static final int ID_ZXSTBETADISK = SzxContainer.makeDword('B', 'D', 'S', 'K');
            public static final int ID_ZXSTCREATOR = SzxContainer.makeDword('C', 'R', 'T', 'R');
            public static final int ID_ZXSTDOCK = SzxContainer.makeDword('D', 'O', 'C', 'K');
            public static final int ID_ZXSTDSKFILE = SzxContainer.makeDword('D', 'S', 'K', '\u0000');
            public static final int ID_ZXSTGS = SzxContainer.makeDword('G', 'S', '\u0000', '\u0000');
            public static final int ID_ZXSTGSRAMPAGE = SzxContainer.makeDword('G', 'S', 'R', 'P');
            public static final int ID_ZXSTKEYBOARD = SzxContainer.makeDword('K', 'E', 'Y', 'B');
            public static final int ID_ZXSTIF1 = SzxContainer.makeDword('I', 'F', '1', '\u0000');
            public static final int ID_ZXSTIF2ROM = SzxContainer.makeDword('I', 'F', '2', 'R');
            public static final int ID_ZXSTJOYSTICK = SzxContainer.makeDword('J', 'O', 'Y', '\u0000');
            public static final int ID_ZXSTMCART = SzxContainer.makeDword('M', 'D', 'R', 'V');
            public static final int ID_ZXSTMOUSE = SzxContainer.makeDword('A', 'M', 'X', 'M');
            public static final int ID_ZXSTMULTIFACE = SzxContainer.makeDword('M', 'F', 'C', 'E');
            public static final int ID_ZXSTOPUS = SzxContainer.makeDword('O', 'P', 'U', 'S');
            public static final int ID_ZXSTOPUSDISK = SzxContainer.makeDword('O', 'D', 'S', 'K');
            public static final int ID_ZXSTPLUS3 = SzxContainer.makeDword('+', '3', '\u0000', '\u0000');
            public static final int ID_ZXSTPLUSD = SzxContainer.makeDword('P', 'L', 'S', 'D');
            public static final int ID_ZXSTPLUSDDISK = SzxContainer.makeDword('P', 'D', 'S', 'K');
            public static final int ID_ZXSTRAMPAGE = SzxContainer.makeDword('R', 'A', 'M', 'P');
            public static final int ID_ZXSTROM = SzxContainer.makeDword('R', 'O', 'M', '\u0000');
            public static final int ID_ZXSTSCLDREGS = SzxContainer.makeDword('S', 'C', 'L', 'D');
            public static final int ID_ZXSTSIDE = SzxContainer.makeDword('S', 'I', 'D', 'E');
            public static final int ID_ZXSTSPECDRUM = SzxContainer.makeDword('D', 'R', 'U', 'M');
            public static final int ID_ZXSTSPECREGS = SzxContainer.makeDword('S', 'P', 'C', 'R');
            public static final int ID_ZXSTTAPE = SzxContainer.makeDword('T', 'A', 'P', 'E');
            public static final int ID_ZXSTUSPEECH = SzxContainer.makeDword('U', 'S', 'P', 'E');
            public static final int ID_ZXSTZXPRINTER = SzxContainer.makeDword('Z', 'X', 'P', 'R');
            public static final int ID_ZXSTZ80REGS = SzxContainer.makeDword('Z', '8', '0', 'R');
            public static final int ID_ZXSTPALETTE = SzxContainer.makeDword('P', 'L', 'T', 'T');
            private final int id;
            private final byte[] data;
            public static final SzxBlock FAKE = new SzxBlock(0, new byte[0]);
            private final BlockWriter bodyWriter;

            SzxBlock(int id, BlockWriter bodyWriter) {
                this.id = id;
                this.data = new byte[0];
                this.bodyWriter = bodyWriter;
            }

            SzxBlock(int id, byte[] data) {
                this.id = id;
                this.data = Objects.requireNonNull(data);
                this.bodyWriter = null;
            }

            SzxBlock(SzxInputStream in) {
                this.id = in.readDWord();
                int size = in.readDWord();
                Snapshot.LOGGER.info("Read " + SzxContainer.asString(this.id) + " size " + size);
                this.data = in.readFully(size);
                this.bodyWriter = null;
            }

            public static byte[] compress(byte[] data) {
                try {
                    ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                    Deflater deflater = new Deflater(9);
                    DeflaterOutputStream deflaterOutputStream = new DeflaterOutputStream((OutputStream)byteArrayOutputStream, deflater);
                    deflaterOutputStream.write(data);
                    deflaterOutputStream.flush();
                    deflaterOutputStream.close();
                    return byteArrayOutputStream.toByteArray();
                }
                catch (IOException ex) {
                    throw new RuntimeException(ex);
                }
            }

            public void write(SzxOutputStream outputStream) throws IOException {
                if (this == FAKE) {
                    return;
                }
                outputStream.writeDWord(this.id);
                if (this.bodyWriter == null) {
                    outputStream.writeDWord(this.data.length);
                    outputStream.writeFully(this.data);
                } else {
                    ByteArrayOutputStream buffer = new ByteArrayOutputStream();
                    SzxOutputStream bufferStream = new SzxOutputStream(buffer);
                    this.bodyWriter.write(this, bufferStream);
                    bufferStream.flush();
                    bufferStream.close();
                    byte[] saved = buffer.toByteArray();
                    outputStream.writeDWord(saved.length);
                    outputStream.writeFully(saved);
                }
            }

            public void consume(BiConsumer<SzxBlock, SzxInputStream> consumer) {
                consumer.accept(this, new SzxInputStream(new ByteArrayInputStream(this.data)));
            }

            public static byte[] decompress(byte[] data) {
                byte[] byArray;
                DeflateCompressorInputStream in = new DeflateCompressorInputStream(new ByteArrayInputStream(data));
                try {
                    int n;
                    ByteArrayOutputStream out = new ByteArrayOutputStream(data.length << 1);
                    byte[] buffer = new byte[1024];
                    while (-1 != (n = in.read(buffer))) {
                        out.write(buffer, 0, n);
                    }
                    byArray = out.toByteArray();
                }
                catch (Throwable throwable) {
                    try {
                        try {
                            in.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        throw throwable;
                    }
                    catch (IOException ex) {
                        throw new RuntimeException(ex);
                    }
                }
                in.close();
                return byArray;
            }

            public int getId() {
                return this.id;
            }

            public String toString() {
                return "SzxBlock(id=" + SzxContainer.asString(this.id) + ",size=" + this.data.length + ")";
            }

            @FunctionalInterface
            public static interface BlockWriter {
                public void write(SzxBlock var1, SzxOutputStream var2) throws IOException;
            }
        }

        public static class SzxOutputStream
        extends OutputStream {
            private final OutputStream outputStream;

            public SzxOutputStream(OutputStream outputStream) {
                this.outputStream = Objects.requireNonNull(outputStream);
            }

            public void writeFully(byte[] data) throws IOException {
                IOUtils.write(data, (OutputStream)this);
            }

            @Override
            public void write(int value) throws IOException {
                this.outputStream.write(value);
            }

            public void writeChar(char chr) throws IOException {
                this.outputStream.write(chr);
            }

            public void writeString(String str) throws IOException {
                for (char c : str.toCharArray()) {
                    this.writeChar(c);
                }
                this.write(0);
            }

            public void writeWord(int value) throws IOException {
                this.write(value);
                this.write(value >>> 8);
            }

            public void writeDWord(int value) throws IOException {
                this.write(value);
                this.write(value >>> 8);
                this.write(value >>> 16);
                this.write(value >>> 24);
            }

            @Override
            public void flush() throws IOException {
                this.outputStream.flush();
            }

            @Override
            public void close() throws IOException {
                this.outputStream.close();
            }
        }
    }
}

