/*
 * Decompiled with CFR 0.152.
 */
package com.igormaznitsa.zxpoly.formats;

import com.igormaznitsa.z80.Z80;
import com.igormaznitsa.zxpoly.MainForm;
import com.igormaznitsa.zxpoly.components.BoardMode;
import com.igormaznitsa.zxpoly.components.Motherboard;
import com.igormaznitsa.zxpoly.components.ZxPolyModule;
import com.igormaznitsa.zxpoly.components.video.VideoController;
import com.igormaznitsa.zxpoly.formats.FormatSNA;
import com.igormaznitsa.zxpoly.formats.SNAParser;
import com.igormaznitsa.zxpoly.formats.Snapshot;
import com.igormaznitsa.zxpoly.formats.Spec256Arch;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.StringReader;
import java.nio.charset.StandardCharsets;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Properties;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.apache.commons.compress.archivers.zip.ZipArchiveEntry;
import org.apache.commons.compress.archivers.zip.ZipArchiveOutputStream;
import org.apache.commons.compress.archivers.zip.ZipFile;
import org.apache.commons.compress.utils.SeekableInMemoryByteChannel;
import org.apache.commons.io.IOUtils;

public class FormatSpec256
extends Snapshot {
    private static final Map<String, BaseItem> APP_BASE = new HashMap<String, BaseItem>();
    private static byte[] lastReadSnapshot = null;
    private static BaseItem lastBaseItem = null;

    private static Spec256Arch.Spec256GfxOrigPage decodeGfx(Spec256Arch.Spec256GfxOrigPage from) {
        int dataLen = from.getGfxData().length;
        byte[] result = new byte[dataLen];
        for (int offset = 0; offset < dataLen; offset += 8) {
            for (int ctx = 0; ctx < 8; ++ctx) {
                int bitMask = 1 << ctx;
                int accumulator = 0;
                for (int i = 0; i < 8; ++i) {
                    if ((from.getGfxData()[offset + i] & bitMask) == 0) continue;
                    accumulator |= 1 << i;
                }
                result[offset + ctx] = (byte)accumulator;
            }
        }
        return new Spec256Arch.Spec256GfxOrigPage(from, result);
    }

    private static Spec256Arch.Spec256GfxOrigPage adaptPageForColor16(Spec256Arch.Spec256GfxOrigPage page) {
        byte[] origData = page.getOrigData();
        byte[] gfxData = page.getGfxData();
        byte[] newGfx = new byte[gfxData.length];
        HashMap<Byte, Byte> cache = new HashMap<Byte, Byte>();
        for (int i = 0; i < origData.length; ++i) {
            int gfxOffset = i * 8;
            for (int b = 0; b < 8; ++b) {
                int gfxAddr = gfxOffset + b;
                byte oldGfx = gfxData[gfxAddr];
                newGfx[gfxAddr] = oldGfx != 0 && oldGfx != -1 ? cache.computeIfAbsent(oldGfx, spindex -> {
                    byte zxpIndex = (byte)VideoController.toZxPolyIndex(spindex);
                    if (zxpIndex == 0) {
                        zxpIndex = 8;
                    }
                    return zxpIndex;
                }) : oldGfx;
            }
        }
        return new Spec256Arch.Spec256GfxOrigPage(page, newGfx);
    }

    private static byte[] makeSna(Motherboard motherboard, VideoController vc) throws IOException {
        return new FormatSNA().saveToArray(motherboard, vc);
    }

    private static Map<Integer, Spec256Arch.Spec256GfxPage> makeGfxPages(Motherboard board) {
        BoardMode mode = board.getBoardMode();
        if (mode == BoardMode.SPEC256) {
            return IntStream.range(0, 8).mapToObj(x -> board.getModules()[0].getGfxRamPage(x)).collect(Collectors.toMap(Spec256Arch.Spec256GfxPage::getPageIndex, Function.identity()));
        }
        throw new Error("Unexpected board mode: " + String.valueOf((Object)mode));
    }

    private static byte[] makeSnapshotSpec256(byte[] baseSpec256Archive, BaseItem baseItem, Motherboard board, VideoController vc) throws IOException {
        return FormatSpec256.replaceInArchive(baseSpec256Archive, baseItem, board.getModules()[0].read7FFD() & 7, FormatSpec256.makeSna(board, vc), FormatSpec256.makeGfxPages(board));
    }

    private static byte[] replaceInArchive(byte[] zipArchive, BaseItem baseItem, int topPageIndex, byte[] snaBody, Map<Integer, Spec256Arch.Spec256GfxPage> gfxPages) throws IOException {
        ByteArrayOutputStream result = new ByteArrayOutputStream(zipArchive.length);
        ZipArchiveOutputStream output = new ZipArchiveOutputStream(result);
        try (ZipFile zipFile = new ZipFile(new SeekableInMemoryByteChannel(zipArchive));){
            Enumeration<ZipArchiveEntry> iterator = zipFile.getEntries();
            boolean configUpdated = false;
            String snaName = null;
            while (iterator.hasMoreElements()) {
                ZipArchiveEntry entry = iterator.nextElement();
                if (entry.isDirectory()) continue;
                String normalizedName = entry.getName().replace('\\', '/').toLowerCase(Locale.ENGLISH);
                if (normalizedName.endsWith(".sna")) {
                    snaName = entry.getName();
                    output.putArchiveEntry(new ZipArchiveEntry(snaName));
                    IOUtils.copy((InputStream)new ByteArrayInputStream(snaBody), (OutputStream)output);
                    output.closeArchiveEntry();
                    continue;
                }
                if (normalizedName.endsWith(".gfx")) {
                    output.putArchiveEntry(new ZipArchiveEntry(entry.getName()));
                    IOUtils.copy((InputStream)new ByteArrayInputStream(gfxPages.get(5).packGfxData()), (OutputStream)output);
                    IOUtils.copy((InputStream)new ByteArrayInputStream(gfxPages.get(2).packGfxData()), (OutputStream)output);
                    IOUtils.copy((InputStream)new ByteArrayInputStream(gfxPages.get(topPageIndex).packGfxData()), (OutputStream)output);
                    output.closeArchiveEntry();
                    continue;
                }
                Matcher gfxMatcher = Spec256Arch.GFn_PATTERN.matcher(normalizedName);
                if (gfxMatcher.find()) {
                    int pageIndex = Integer.parseInt(gfxMatcher.group(1));
                    Spec256Arch.Spec256GfxPage page = gfxPages.get(pageIndex);
                    if (page == null) {
                        throw new IOException("Can't find page " + pageIndex + "in GFX page map");
                    }
                    output.putArchiveEntry(new ZipArchiveEntry(entry.getName()));
                    IOUtils.copy((InputStream)new ByteArrayInputStream(page.packGfxData()), (OutputStream)output);
                    output.closeArchiveEntry();
                    continue;
                }
                if (normalizedName.endsWith(".cfg") && baseItem != null) {
                    output.putArchiveEntry(new ZipArchiveEntry(entry.getName()));
                    IOUtils.copy((InputStream)new ByteArrayInputStream(baseItem.asConfig(Spec256Arch.readData(zipFile, entry))), (OutputStream)output);
                    output.closeArchiveEntry();
                    configUpdated = true;
                    continue;
                }
                output.addRawArchiveEntry(entry, zipFile.getRawInputStream(entry));
            }
            if (baseItem != null && !configUpdated && snaName != null) {
                String configName = snaName.substring(0, snaName.lastIndexOf(".")) + ".CFG";
                output.putArchiveEntry(new ZipArchiveEntry(configName));
                output.write(baseItem.asConfig());
                output.closeArchiveEntry();
            }
        }
        output.finish();
        return result.toByteArray();
    }

    @Override
    public void loadFromArray(File srcFile, Motherboard board, VideoController vc, byte[] array) throws IOException {
        int[] pages;
        int[] nArray;
        Spec256Arch archive = new Spec256Arch(MainForm.BASE_ROM, array);
        BaseItem dbItem = APP_BASE.get(archive.getSha256().toLowerCase(Locale.ENGLISH));
        if (dbItem == null) {
            LOGGER.info("Application not found in Spec256 app base");
        }
        LOGGER.info("Archive: " + String.valueOf(archive));
        SNAParser parser = archive.getParsedSna();
        if (archive.is128()) {
            this.doModeSpec256_128(board);
        } else {
            this.doModeSpec256_48(board);
        }
        ZxPolyModule module = board.getModules()[0];
        Z80 cpu = module.getCpu();
        module.write7FFD(archive.is128() ? (int)parser.getEXTENDEDDATA().port7ffd : 48, true);
        cpu.setRegisterPair(0, parser.getREGAF());
        cpu.setRegisterPair(2, parser.getREGBC());
        cpu.setRegisterPair(4, parser.getREGDE());
        cpu.setRegisterPair(6, parser.getREGHL());
        cpu.setRegisterPair(0, parser.getALTREGAF(), true);
        cpu.setRegisterPair(2, parser.getALTREGBC(), true);
        cpu.setRegisterPair(4, parser.getALTREGDE(), true);
        cpu.setRegisterPair(6, parser.getALTREGHL(), true);
        cpu.setRegister(8, parser.getREGIX());
        cpu.setRegister(9, parser.getREGIY());
        cpu.setRegister(12, parser.getREGI());
        cpu.setRegister(13, parser.getREGR());
        cpu.setIM(parser.getINTMODE());
        boolean iff = (parser.getIFF2() & 4) != 0;
        cpu.setIFF(iff, iff);
        if (archive.is128()) {
            int[] nArray2 = new int[8];
            nArray2[0] = 0;
            nArray2[1] = 1;
            nArray2[2] = 2;
            nArray2[3] = 3;
            nArray2[4] = 4;
            nArray2[5] = 5;
            nArray2[6] = 6;
            nArray = nArray2;
            nArray2[7] = 7;
        } else {
            int[] nArray3 = new int[3];
            nArray3[0] = 5;
            nArray3[1] = 2;
            nArray = nArray3;
            nArray3[2] = 0;
        }
        for (int pageIndex : pages = nArray) {
            archive.getGfxRamPages().stream().filter(x -> x.getPageIndex() == pageIndex).findFirst().ifPresent(p -> {
                LOGGER.info("Detected RAM page: " + p.getPageIndex());
                module.writeHeapPage(p.getPageIndex(), p.getOrigData());
                module.writeGfxRamPage(FormatSpec256.decodeGfx(p));
            });
        }
        module.makeCopyOfRomToGfxRom();
        if (!archive.getGfxRoms().isEmpty()) {
            LOGGER.info("provided adapted ROM");
            archive.getGfxRoms().forEach(x -> module.writeGfxRomPage(FormatSpec256.decodeGfx(x)));
        }
        if (archive.is128()) {
            LOGGER.info("Detected SNA 128");
            LOGGER.info("#" + Integer.toHexString(parser.getEXTENDEDDATA().getREGPC()) + " => PC");
            cpu.setRegister(11, parser.getEXTENDEDDATA().getREGPC());
            LOGGER.info("#" + Integer.toHexString(parser.getREGSP()) + " => SP");
            cpu.setRegister(10, parser.getREGSP());
            LOGGER.info("#" + Integer.toHexString(parser.getEXTENDEDDATA().getPORT7FFD()) + " => #7FFD");
            module.write7FFD(parser.getEXTENDEDDATA().getPORT7FFD(), true);
            module.setTrdosActive(parser.getEXTENDEDDATA().getONTRDOS() != 0);
        } else {
            int highPc;
            int lowPc;
            LOGGER.info("Detected SNA 48");
            int spValue = parser.getREGSP();
            if (spValue < 16384) {
                byte[] romData = MainForm.BASE_ROM.getAsArray();
                lowPc = romData[spValue] & 0xFF;
                spValue = spValue + '\u0001' & 0xFFFF;
                highPc = romData[spValue] & 0xFF;
                spValue = spValue + 1 & 0xFFFF;
            } else {
                lowPc = parser.getRAMDUMP()[spValue - 16384] & 0xFF;
                spValue = spValue + '\u0001' & 0xFFFF;
                highPc = parser.getRAMDUMP()[spValue - 16384] & 0xFF;
                spValue = spValue + 1 & 0xFFFF;
            }
            int pcAddr = highPc << 8 | lowPc;
            LOGGER.info("#" + Integer.toHexString(pcAddr) + " => PC");
            LOGGER.info("#" + Integer.toHexString(spValue) + " => SP");
            cpu.setRegister(10, spValue);
            cpu.setRegister(11, pcAddr);
        }
        LOGGER.info("Interrupt mode: " + parser.getINTMODE());
        board.set3D00(129, true);
        vc.setBorderColor(parser.getBORDERCOLOR() & 7);
        vc.setVideoMode(8);
        Optional<Spec256Arch.Spec256Bkg> bkg = archive.getBackgrounds().stream().min(Comparator.comparingInt(Spec256Arch.Spec256Bkg::getIndex));
        if (bkg.isPresent()) {
            LOGGER.info("Detected GFX background image");
            VideoController.setGfxBack(bkg.get());
        } else {
            LOGGER.info("No any GFX background");
            VideoController.setGfxBack(null);
        }
        board.setGfxAlignParams(this.findProperty(archive, "zxpAlignRegs", dbItem, "1PSsT"));
        VideoController.setGfxBackOverFF(!"0".equals(this.findProperty(archive, "BkOverFF", dbItem, "0")));
        VideoController.setGfxHideSameInkPaper(!"0".equals(this.findProperty(archive, "HideSameInkPaper", dbItem, "1")));
        VideoController.setGfxDownColorsMixed(this.safeParseInt(this.findProperty(archive, "DownColorsMixed", dbItem, "0"), 0));
        VideoController.setGfxUpColorsMixed(this.safeParseInt(this.findProperty(archive, "UpColorsMixed", dbItem, "64"), 64));
        VideoController.setGfxPaper00InkFF(!"0".equals(this.findProperty(archive, "Paper00InkFF", dbItem, bkg.isPresent() ? "0" : "1")));
        boolean leveledXor = !"0".equals(this.findProperty(archive, "GFXLeveledXOR", dbItem, "0"));
        boolean leveledAnd = !"0".equals(this.findProperty(archive, "GFXLeveledAND", dbItem, "0"));
        boolean leveledOr = !"0".equals(this.findProperty(archive, "GFXLeveledOR", dbItem, "0"));
        board.setGfxLeveledLogicalOps(leveledXor, leveledAnd, leveledOr);
        board.syncGfxCpuState(cpu);
        lastBaseItem = dbItem;
        lastReadSnapshot = array;
    }

    @Override
    public boolean canMakeSnapshotForBoardMode(BoardMode mode) {
        return mode == BoardMode.SPEC256;
    }

    private String findProperty(Spec256Arch arch, String name, BaseItem baseItem, String dflt) {
        return arch.getProperties().getProperty(name, baseItem == null ? dflt : baseItem.findProperty(name, dflt));
    }

    private int safeParseInt(String str, int dflt) {
        try {
            return Integer.parseInt(str.trim());
        }
        catch (NumberFormatException ex) {
            return dflt;
        }
    }

    @Override
    public String getExtension() {
        return "zip";
    }

    @Override
    public byte[] saveToArray(Motherboard board, VideoController vc) throws IOException {
        byte[] origSnapshot = Objects.requireNonNull(lastReadSnapshot, "Can't find last read Spec256 snapshot");
        switch (board.getBoardMode()) {
            case SPEC256: {
                return FormatSpec256.makeSnapshotSpec256(Objects.requireNonNull(origSnapshot, "Unexpectedly not found base archive"), lastBaseItem, board, vc);
            }
        }
        throw new IOException("Unsupported board mode: " + String.valueOf((Object)board.getBoardMode()));
    }

    @Override
    public String getName() {
        return "Spec256 snapshot";
    }

    @Override
    public boolean accept(File f) {
        return f != null && (f.isDirectory() || f.getName().toLowerCase(Locale.ENGLISH).endsWith(".zip"));
    }

    @Override
    public String getDescription() {
        return "Spec256 archive (*.zip)";
    }

    static {
        try (InputStream in = FormatSpec256.class.getResourceAsStream("/spec256appbase.txt");){
            for (String str : IOUtils.readLines(in, StandardCharsets.UTF_8)) {
                String trimmed = str.trim();
                if (trimmed.isEmpty() || trimmed.startsWith("//") || trimmed.startsWith("#")) continue;
                Matcher matcher = BaseItem.PATTERN.matcher(str);
                if (matcher.find()) {
                    APP_BASE.put(matcher.group(2).toLowerCase(Locale.ENGLISH), new BaseItem(matcher.group(1).toLowerCase(Locale.ENGLISH), matcher.group(2).toLowerCase(Locale.ENGLISH), matcher.group(3)));
                    continue;
                }
                throw new Error("Can't parse line: " + str);
            }
        }
        catch (IOException ex) {
            throw new Error("Can't load app bData()ase", ex);
        }
    }

    private static class BaseItem {
        private static final Pattern PATTERN = Pattern.compile("^\\s*(\\S+)\\s*,\\s*([0-9a-f]+)\\s*(?:,\\s*([\\S]+)\\s*)?$");
        private final String name;
        private final String sha256;
        private final Properties properties;

        private BaseItem(String name, String sha256, String defaultPropertiesList) {
            this.name = name;
            this.sha256 = sha256;
            this.properties = new Properties();
            if (defaultPropertiesList != null && !defaultPropertiesList.trim().isEmpty()) {
                for (String line : defaultPropertiesList.split(";")) {
                    String trimmed = line.trim();
                    if (trimmed.isEmpty()) continue;
                    String[] pair = trimmed.split("=");
                    if (pair.length != 2) {
                        throw new Error("Can't find name-value: " + trimmed);
                    }
                    this.properties.setProperty(pair[0].trim(), pair[1].trim());
                }
            }
        }

        private String findProperty(String name, String dflt) {
            return this.properties.getProperty(name, dflt);
        }

        public byte[] asConfig(byte[] configData) {
            try {
                Properties parsed = new Properties();
                parsed.load(new StringReader(new String(configData, StandardCharsets.UTF_8)));
                for (String name : this.properties.stringPropertyNames()) {
                    parsed.setProperty(name, this.properties.getProperty(name));
                }
                return parsed.stringPropertyNames().stream().map(x -> x + "=" + parsed.getProperty((String)x)).collect(Collectors.joining("\n")).getBytes(StandardCharsets.UTF_8);
            }
            catch (IOException ex) {
                throw new Error("Unexpected error during config property save", ex);
            }
        }

        public byte[] asConfig() {
            return this.properties.stringPropertyNames().stream().map(x -> x + "=" + this.properties.getProperty((String)x)).collect(Collectors.joining("\n")).getBytes(StandardCharsets.UTF_8);
        }
    }
}

