/*
 * Decompiled with CFR 0.152.
 */
package com.igormaznitsa.zxpoly.formats;

import com.igormaznitsa.jbbp.io.JBBPBitInputStream;
import com.igormaznitsa.jbbp.io.JBBPBitOutputStream;
import com.igormaznitsa.z80.Z80;
import com.igormaznitsa.zxpoly.components.BoardMode;
import com.igormaznitsa.zxpoly.components.Motherboard;
import com.igormaznitsa.zxpoly.components.ZxPolyModule;
import com.igormaznitsa.zxpoly.components.video.VideoController;
import com.igormaznitsa.zxpoly.formats.Snapshot;
import com.igormaznitsa.zxpoly.formats.Z80V1Parser;
import com.igormaznitsa.zxpoly.formats.Z80V2Parser;
import com.igormaznitsa.zxpoly.formats.Z80V3AParser;
import com.igormaznitsa.zxpoly.formats.Z80V3BParser;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Locale;

public class FormatZ80
extends Snapshot {
    private static final int PAGE_SIZE = 16384;
    private static final int VERSION_1 = 0;
    private static final int VERSION_2 = 1;
    private static final int VERSION_3A = 2;
    private static final int VERSION_3B = 3;

    private static boolean is48k(int version, AbstractZ80Snapshot snapshot) {
        switch (version) {
            case 0: {
                return true;
            }
            case 1: {
                return snapshot.getMODE() == '\u0000' || snapshot.getMODE() == '\u0001';
            }
            case 2: 
            case 3: {
                return snapshot.getMODE() == '\u0000' || snapshot.getMODE() == '\u0001' || snapshot.getMODE() == '\u0003';
            }
        }
        return false;
    }

    @Override
    public boolean canMakeSnapshotForBoardMode(BoardMode mode) {
        return mode == BoardMode.ZX128 || mode == BoardMode.SPEC256;
    }

    @Override
    public byte[] saveToArray(Motherboard board, VideoController vc) throws IOException {
        Z80V3AParser parser = new Z80V3AParser();
        Z80 cpu = board.getMasterCpu();
        parser.setREG_A((byte)cpu.getRegister(0));
        parser.setREG_F((byte)cpu.getRegister(1));
        parser.setREG_A_ALT((byte)cpu.getRegister(0, true));
        parser.setREG_F_ALT((byte)cpu.getRegister(1, true));
        parser.setREG_BC((short)cpu.getRegisterPair(2));
        parser.setREG_BC_ALT((short)cpu.getRegisterPair(2, true));
        parser.setREG_DE((short)cpu.getRegisterPair(4));
        parser.setREG_DE_ALT((short)cpu.getRegisterPair(4, true));
        parser.setREG_HL((short)cpu.getRegisterPair(6));
        parser.setREG_HL_ALT((short)cpu.getRegisterPair(6, true));
        parser.setREG_IX((short)cpu.getRegister(8));
        parser.setREG_IY((short)cpu.getRegister(9));
        parser.setREG_R((byte)cpu.getRegister(13));
        parser.setREG_SP((short)cpu.getRegister(10));
        parser.setREG_PC((short)0);
        parser.setREG_PC2((short)cpu.getRegister(11));
        parser.setIFF((byte)(cpu.isIFF1() ? 1 : 0));
        parser.setIFF2((byte)(cpu.isIFF2() ? 1 : 0));
        parser.setREG_IR((byte)cpu.getRegister(12));
        Z80V3AParser.EMULFLAGS emulflags = parser.makeEMULFLAGS();
        emulflags.setINTERRUPTMODE((byte)cpu.getIM());
        emulflags.setISSUE2EMULATION((byte)0);
        emulflags.setDOUBLEINTFREQ((byte)0);
        emulflags.setVIDEOSYNC((byte)0);
        emulflags.setINPUTDEVICE((byte)0);
        ZxPolyModule module = board.getModules()[0];
        boolean mode48 = FormatZ80.isMode48(module);
        Z80V3AParser.FLAGS flags = parser.makeFLAGS();
        flags.setREG_R_BIT7((byte)(cpu.getRegister(13) >>> 7));
        flags.setBORDERCOLOR((byte)vc.getPortFE());
        flags.setBASIC_SAMROM((byte)0);
        flags.setCOMPRESSED((byte)0);
        flags.setNOMEANING((byte)0);
        parser.setPORT7FFD((char)module.read7FFD());
        parser.setPORTFF((char)module.getMotherboard().readBusIo(module, 255));
        parser.setHEADERLEN('6');
        parser.setMODE(mode48 ? (char)'\u0000' : '\u0004');
        parser.setMISCNONZX(new byte[49]);
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        if (mode48) {
            byte[] page4000 = module.makeCopyOfZxMemPage(1);
            byte[] page8000 = module.makeCopyOfZxMemPage(2);
            byte[] pageC000 = module.makeCopyOfZxMemPage(3);
            new Bank(4, page8000).writeNonCompressed(bos);
            new Bank(5, pageC000).writeNonCompressed(bos);
            new Bank(8, page4000).writeNonCompressed(bos);
        } else {
            for (int i = 0; i < 8; ++i) {
                byte[] data = module.makeCopyOfHeapPage(i);
                new Bank(i + 3, data).writeNonCompressed(bos);
            }
        }
        bos.flush();
        bos.close();
        parser.setDATA(bos.toByteArray());
        bos = new ByteArrayOutputStream();
        try (JBBPBitOutputStream bitOut = new JBBPBitOutputStream(bos);){
            parser.write(bitOut);
        }
        return bos.toByteArray();
    }

    @Override
    public String getExtension() {
        return "z80";
    }

    @Override
    public void loadFromArray(File srcFile, Motherboard board, VideoController vc, byte[] array) throws IOException {
        int version;
        AbstractZ80Snapshot snapshot;
        block42: {
            block41: {
                if (array.length < 30) {
                    throw new IOException("File is too short one to be Z80 snapshot");
                }
                if ((array[6] | array[7]) != 0) break block41;
                switch ((array[31] & 0xFF) << 8 | array[30] & 0xFF) {
                    case 23: {
                        snapshot = new Z80V2Parser();
                        version = 1;
                        break block42;
                    }
                    case 54: {
                        snapshot = new Z80V3AParser();
                        version = 2;
                        break block42;
                    }
                    case 55: {
                        snapshot = new Z80V3BParser();
                        version = 3;
                        break block42;
                    }
                    default: {
                        throw new IOException("Detected unknown Z80 snapshot version");
                    }
                }
            }
            snapshot = new Z80V1Parser();
            version = 0;
        }
        snapshot.fillFromArray(array);
        block5 : switch (version) {
            case 0: {
                LOGGER.info("Z80 snapshot v1 " + (snapshot.getFLAGS().getCOMPRESSED() == 0 ? "" : "(compressed)"));
                break;
            }
            case 1: {
                LOGGER.info("Z80 snapshot v2" + (snapshot.getFLAGS().getCOMPRESSED() == 0 ? "" : "(compressed)"));
                switch (snapshot.getMODE()) {
                    case '\u0000': 
                    case '\u0001': 
                    case '\u0003': 
                    case '\u0004': {
                        break block5;
                    }
                }
                throw new IOException("Unsupported Z80 hardware mode [" + snapshot.getMODE() + "]");
            }
            case 2: 
            case 3: {
                LOGGER.info("Z80 snapshot v3" + (version == 2 ? "A" : "B") + (snapshot.getFLAGS().getCOMPRESSED() == 0 ? "" : "(compressed)"));
                switch (snapshot.getMODE()) {
                    case '\u0000': {
                        LOGGER.info("Mode 48k");
                        break block5;
                    }
                    case '\u0001': {
                        LOGGER.info("Mode 48k+If.1");
                        break block5;
                    }
                    case '\u0003': {
                        LOGGER.info("Mode 48k+M.G.T.");
                        break block5;
                    }
                    case '\u0004': {
                        LOGGER.info("Mode 128k");
                        break block5;
                    }
                    case '\u0005': {
                        LOGGER.info("Mode 128k+If.1");
                        break block5;
                    }
                    case '\u0006': {
                        LOGGER.info("Mode 128k+M.G.T.");
                        break block5;
                    }
                }
                throw new IOException("Unsupported Z80 hardware mode [" + snapshot.getMODE() + "]");
            }
            default: {
                throw new IllegalArgumentException("Unexpected Z80 snapshot version: " + version);
            }
        }
        boolean snapshot48k = FormatZ80.is48k(version, snapshot);
        if (snapshot48k) {
            this.doMode48(board);
        } else {
            this.doMode128(board);
        }
        Z80 cpu = board.getMasterCpu();
        cpu.setRegister(0, snapshot.getREG_A());
        cpu.setRegister(1, snapshot.getREG_F());
        cpu.setRegister(0, snapshot.getREG_A_ALT(), true);
        cpu.setRegister(1, snapshot.getREG_F_ALT(), true);
        cpu.setRegisterPair(2, snapshot.getREG_BC());
        cpu.setRegisterPair(2, snapshot.getREG_BC_ALT(), true);
        cpu.setRegisterPair(4, snapshot.getREG_DE());
        cpu.setRegisterPair(4, snapshot.getREG_DE_ALT(), true);
        cpu.setRegisterPair(6, snapshot.getREG_HL());
        cpu.setRegisterPair(6, snapshot.getREG_HL_ALT(), true);
        cpu.setRegister(8, snapshot.getREG_IX());
        cpu.setRegister(9, snapshot.getREG_IY());
        cpu.setRegister(13, snapshot.getREG_R() | snapshot.getFLAGS().getREG_R_BIT7() << 7);
        cpu.setRegister(10, snapshot.getREG_SP());
        if (version == 0) {
            cpu.setRegister(11, snapshot.getREG_PC());
        } else {
            cpu.setRegister(11, snapshot.getREG_PC2());
        }
        cpu.setIFF(snapshot.getIFF() != 0, snapshot.getIFF2() != 0);
        cpu.setRegister(12, snapshot.getREG_IR());
        cpu.setIM(snapshot.getEMULFLAGS().getINTERRUPTMODE());
        ZxPolyModule module = board.getModules()[0];
        if (version == 0) {
            ((Z80V1Parser)snapshot).setDATA(snapshot.getFLAGS().getCOMPRESSED() == 0 ? snapshot.getDATA() : Bank.decodeRLE(snapshot.getDATA(), 0, snapshot.getDATA().length));
            for (int i = 0; i < snapshot.getDATA().length; ++i) {
                module.writeMemory(cpu, 0, i + 16384, snapshot.getDATA()[i]);
            }
        } else {
            Bank[] banks = Bank.toBanks(snapshot.getDATA());
            if (snapshot48k) {
                for (Bank b : banks) {
                    int offset = switch (b.page) {
                        case 4 -> 32768;
                        case 5 -> 49152;
                        case 8 -> 16384;
                        default -> throw new IllegalArgumentException("Detected unexpected bank page index: " + b.page);
                    };
                    for (int i = 0; i < 16384; ++i) {
                        module.writeMemory(cpu, 0, offset + i, b.data[i]);
                    }
                }
            } else {
                module.write7FFD(snapshot.getPORT7FFD(), true);
                for (Bank b : banks) {
                    if (b.page < 3) {
                        module.writeHeapPage(b.page, b.data);
                        continue;
                    }
                    if (b.page <= 10) {
                        module.writeHeapPage(b.page - 3, b.data);
                        continue;
                    }
                    throw new IOException("Unexpected page index (x>10):" + b.page);
                }
            }
        }
        vc.setBorderColor(snapshot.getFLAGS().getBORDERCOLOR());
    }

    @Override
    public String getName() {
        return "Z80 snapshot";
    }

    @Override
    public boolean accept(File f) {
        return f != null && (f.isDirectory() || f.getName().toLowerCase(Locale.ENGLISH).endsWith(".z80"));
    }

    @Override
    public String getDescription() {
        return "Z80 Snapshot (*.z80)";
    }

    public static abstract class AbstractZ80Snapshot {
        public abstract byte getREG_A();

        public abstract byte getREG_F();

        public abstract short getREG_BC();

        public abstract short getREG_HL();

        public abstract short getREG_PC();

        public abstract short getREG_SP();

        public abstract byte getREG_IR();

        public abstract byte getREG_R();

        public abstract Z80Flags getFLAGS();

        public abstract short getREG_DE();

        public abstract short getREG_BC_ALT();

        public abstract short getREG_DE_ALT();

        public abstract short getREG_HL_ALT();

        public abstract byte getREG_A_ALT();

        public abstract byte getREG_F_ALT();

        public abstract short getREG_IY();

        public abstract short getREG_IX();

        public abstract byte getIFF();

        public abstract byte getIFF2();

        public abstract Z80EmulFlags getEMULFLAGS();

        public abstract byte[] getDATA();

        public short getREG_PC2() {
            throw new Error("Must not be called directly");
        }

        public char getMODE() {
            throw new Error("Must not be called directly");
        }

        public char getPORT7FFD() {
            throw new Error("Must not be called directly");
        }

        public char getPORTFF() {
            throw new Error("Must not be called directly");
        }

        public abstract AbstractZ80Snapshot read(JBBPBitInputStream var1) throws IOException;

        public void fillFromArray(byte[] array) throws IOException {
            this.read(new JBBPBitInputStream(new ByteArrayInputStream(array)));
        }
    }

    private static class Bank {
        final int page;
        final byte[] data;

        Bank(int page, byte[] data) {
            this.page = page;
            this.data = data;
        }

        static byte[] decodeRLE(byte[] source, int offset, int length) {
            ByteArrayOutputStream result = new ByteArrayOutputStream(16384);
            while (length > 0) {
                if (length >= 4) {
                    if (source[offset] == 0 && source[offset + 1] == -19 && source[offset + 2] == -19 && source[offset + 3] == 0) {
                        length = 0;
                        continue;
                    }
                    if (source[offset] == -19 && source[offset + 1] == -19) {
                        offset += 2;
                        int repeat = source[offset++] & 0xFF;
                        int value = source[offset++] & 0xFF;
                        length -= 4;
                        while (repeat > 0) {
                            result.write(value);
                            --repeat;
                        }
                        continue;
                    }
                    result.write(source[offset++]);
                    --length;
                    continue;
                }
                result.write(source[offset++]);
                --length;
            }
            return result.toByteArray();
        }

        static byte[] unpackBank(byte[] src, int offset, int length) {
            byte[] result;
            if (length == 65535) {
                result = new byte[16384];
                System.arraycopy(src, offset, result, 0, 16384);
            } else {
                result = Bank.decodeRLE(src, offset, length);
            }
            return result;
        }

        static Bank[] toBanks(byte[] data) {
            int pos = 0;
            int len = data.length;
            ArrayList<Bank> banks = new ArrayList<Bank>();
            while (len > 0) {
                int blocklength = data[pos++] & 0xFF | (data[pos++] & 0xFF) << 8;
                int page = data[pos++] & 0xFF;
                len -= 3 + (blocklength == 65535 ? 16384 : blocklength);
                byte[] uncompressed = Bank.unpackBank(data, pos, blocklength);
                pos += blocklength == 65535 ? 16384 : blocklength;
                banks.add(new Bank(page, uncompressed));
            }
            return banks.toArray(new Bank[0]);
        }

        void writeNonCompressed(OutputStream out) throws IOException {
            out.write(255);
            out.write(255);
            out.write(this.page);
            out.write(this.data);
        }
    }

    public static interface Z80Flags {
        public byte getREG_R_BIT7();

        public byte getBORDERCOLOR();

        public byte getBASIC_SAMROM();

        public byte getCOMPRESSED();

        public byte getNOMEANING();
    }

    public static interface Z80EmulFlags {
        public byte getINTERRUPTMODE();

        public byte getISSUE2EMULATION();

        public byte getDOUBLEINTFREQ();

        public byte getVIDEOSYNC();

        public byte getINPUTDEVICE();
    }
}

