/*
 * Decompiled with CFR 0.152.
 */
package com.igormaznitsa.zxpoly.formats;

import com.igormaznitsa.zxpoly.components.BoardMode;
import com.igormaznitsa.zxpoly.components.Motherboard;
import com.igormaznitsa.zxpoly.components.ZxPolyModule;
import com.igormaznitsa.zxpoly.components.video.VideoController;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.logging.Logger;
import javax.swing.filechooser.FileFilter;

public abstract class Snapshot
extends FileFilter {
    protected static final Logger LOGGER = Logger.getLogger(Snapshot.class.getName());

    static boolean isMode48(ZxPolyModule module) {
        int port7FFD = module.read7FFD();
        return (port7FFD & 0x3F) == 48;
    }

    public boolean canMakeSnapshotForBoardMode(BoardMode mode) {
        return false;
    }

    public boolean isAllowUlaPlus() {
        return false;
    }

    public void doMode128(Motherboard board) {
        LOGGER.info("Turning on the ZX-128 mode");
        board.set3D00(128, true);
        board.setBoardMode(BoardMode.ZX128, false);
        board.getMasterCpu().doReset();
        board.getVideoController().getUlaPlus().reset();
    }

    public void doModeSpec256_128(Motherboard board) {
        LOGGER.info("Turning on the Spec256.128 mode");
        board.set3D00(128, true);
        board.setBoardMode(BoardMode.SPEC256, false);
        board.getMasterCpu().doReset();
        board.getVideoController().getUlaPlus().reset();
    }

    public void doMode48(Motherboard board) {
        LOGGER.info("Turning on the ZX-48 mode");
        board.set3D00(128, true);
        Arrays.stream(board.getModules()).forEach(ZxPolyModule::makeAndLockZx48Mode);
        board.setBoardMode(BoardMode.ZX128, false);
        board.getMasterCpu().doReset();
        board.getVideoController().getUlaPlus().reset();
    }

    public void doZxPoly(Motherboard board) {
        LOGGER.info("Turning on the ZXPoly mode");
        board.set3D00(0, true);
        board.setBoardMode(BoardMode.ZXPOLY, false);
        board.getMasterCpu().doReset();
        board.getVideoController().getUlaPlus().reset();
    }

    public void doModeSpec256_48(Motherboard board) {
        LOGGER.info("Turning on the Spec256.48 mode");
        board.set3D00(128, true);
        Arrays.stream(board.getModules()).forEach(ZxPolyModule::makeAndLockZx48Mode);
        board.setBoardMode(BoardMode.SPEC256, false);
        board.getMasterCpu().doReset();
        board.getVideoController().getUlaPlus().reset();
    }

    public abstract String getExtension();

    public abstract void loadFromArray(File var1, Motherboard var2, VideoController var3, byte[] var4) throws IOException;

    public abstract byte[] saveToArray(Motherboard var1, VideoController var2) throws IOException;

    public abstract String getName();
}

