/*
 * Decompiled with CFR 0.152.
 */
package com.igormaznitsa.zxpoly.formats;

import com.igormaznitsa.jbbp.io.JBBPBitInputStream;
import com.igormaznitsa.jbbp.io.JBBPBitOutputStream;
import com.igormaznitsa.jbbp.io.JBBPByteOrder;
import java.io.IOException;

public class ZXPParser {
    protected static final int _ParserFlags_ = 0;
    protected int magic;
    protected int flags;
    protected char port3d00;
    protected char portfe;
    protected byte[] cpu0ports;
    protected byte[] cpu1ports;
    protected byte[] cpu2ports;
    protected byte[] cpu3ports;
    protected short[] reg_af;
    protected short[] reg_af_alt;
    protected short[] reg_bc;
    protected short[] reg_bc_alt;
    protected short[] reg_de;
    protected short[] reg_de_alt;
    protected short[] reg_hl;
    protected short[] reg_hl_alt;
    protected short[] reg_ix;
    protected short[] reg_iy;
    protected short[] reg_ir;
    protected byte[] reg_im;
    protected boolean[] iff;
    protected boolean[] iff2;
    protected short[] reg_pc;
    protected short[] reg_sp;
    protected PAGES[] pages;

    public ZXPParser read(JBBPBitInputStream In) throws IOException {
        int I;
        this.magic = In.readInt(JBBPByteOrder.BIG_ENDIAN);
        this.flags = In.readInt(JBBPByteOrder.BIG_ENDIAN);
        this.port3d00 = (char)(In.readByte() & 0xFF);
        this.portfe = (char)(In.readByte() & 0xFF);
        this.cpu0ports = In.readByteArray(5, JBBPByteOrder.BIG_ENDIAN);
        this.cpu1ports = In.readByteArray(5, JBBPByteOrder.BIG_ENDIAN);
        this.cpu2ports = In.readByteArray(5, JBBPByteOrder.BIG_ENDIAN);
        this.cpu3ports = In.readByteArray(5, JBBPByteOrder.BIG_ENDIAN);
        this.reg_af = In.readShortArray(4, JBBPByteOrder.BIG_ENDIAN);
        this.reg_af_alt = In.readShortArray(4, JBBPByteOrder.BIG_ENDIAN);
        this.reg_bc = In.readShortArray(4, JBBPByteOrder.BIG_ENDIAN);
        this.reg_bc_alt = In.readShortArray(4, JBBPByteOrder.BIG_ENDIAN);
        this.reg_de = In.readShortArray(4, JBBPByteOrder.BIG_ENDIAN);
        this.reg_de_alt = In.readShortArray(4, JBBPByteOrder.BIG_ENDIAN);
        this.reg_hl = In.readShortArray(4, JBBPByteOrder.BIG_ENDIAN);
        this.reg_hl_alt = In.readShortArray(4, JBBPByteOrder.BIG_ENDIAN);
        this.reg_ix = In.readShortArray(4, JBBPByteOrder.BIG_ENDIAN);
        this.reg_iy = In.readShortArray(4, JBBPByteOrder.BIG_ENDIAN);
        this.reg_ir = In.readShortArray(4, JBBPByteOrder.BIG_ENDIAN);
        this.reg_im = In.readByteArray(4, JBBPByteOrder.BIG_ENDIAN);
        this.iff = In.readBoolArray(4);
        this.iff2 = In.readBoolArray(4);
        this.reg_pc = In.readShortArray(4, JBBPByteOrder.BIG_ENDIAN);
        this.reg_sp = In.readShortArray(4, JBBPByteOrder.BIG_ENDIAN);
        if (this.pages == null || this.pages.length != 4) {
            this.pages = new PAGES[4];
            for (I = 0; I < 4; ++I) {
                this.pages[I] = new PAGES(this);
            }
        }
        for (I = 0; I < 4; ++I) {
            this.pages[I].read(In);
        }
        return this;
    }

    public ZXPParser write(JBBPBitOutputStream Out) throws IOException {
        int I;
        Out.writeInt(this.magic, JBBPByteOrder.BIG_ENDIAN);
        Out.writeInt(this.flags, JBBPByteOrder.BIG_ENDIAN);
        Out.write(this.port3d00);
        Out.write(this.portfe);
        Out.writeBytes(this.cpu0ports, 5, JBBPByteOrder.BIG_ENDIAN);
        Out.writeBytes(this.cpu1ports, 5, JBBPByteOrder.BIG_ENDIAN);
        Out.writeBytes(this.cpu2ports, 5, JBBPByteOrder.BIG_ENDIAN);
        Out.writeBytes(this.cpu3ports, 5, JBBPByteOrder.BIG_ENDIAN);
        for (I = 0; I < 4; ++I) {
            Out.writeShort(this.reg_af[I], JBBPByteOrder.BIG_ENDIAN);
        }
        for (I = 0; I < 4; ++I) {
            Out.writeShort(this.reg_af_alt[I], JBBPByteOrder.BIG_ENDIAN);
        }
        for (I = 0; I < 4; ++I) {
            Out.writeShort(this.reg_bc[I], JBBPByteOrder.BIG_ENDIAN);
        }
        for (I = 0; I < 4; ++I) {
            Out.writeShort(this.reg_bc_alt[I], JBBPByteOrder.BIG_ENDIAN);
        }
        for (I = 0; I < 4; ++I) {
            Out.writeShort(this.reg_de[I], JBBPByteOrder.BIG_ENDIAN);
        }
        for (I = 0; I < 4; ++I) {
            Out.writeShort(this.reg_de_alt[I], JBBPByteOrder.BIG_ENDIAN);
        }
        for (I = 0; I < 4; ++I) {
            Out.writeShort(this.reg_hl[I], JBBPByteOrder.BIG_ENDIAN);
        }
        for (I = 0; I < 4; ++I) {
            Out.writeShort(this.reg_hl_alt[I], JBBPByteOrder.BIG_ENDIAN);
        }
        for (I = 0; I < 4; ++I) {
            Out.writeShort(this.reg_ix[I], JBBPByteOrder.BIG_ENDIAN);
        }
        for (I = 0; I < 4; ++I) {
            Out.writeShort(this.reg_iy[I], JBBPByteOrder.BIG_ENDIAN);
        }
        for (I = 0; I < 4; ++I) {
            Out.writeShort(this.reg_ir[I], JBBPByteOrder.BIG_ENDIAN);
        }
        Out.writeBytes(this.reg_im, 4, JBBPByteOrder.BIG_ENDIAN);
        for (I = 0; I < 4; ++I) {
            Out.write(this.iff[I] ? 1 : 0);
        }
        for (I = 0; I < 4; ++I) {
            Out.write(this.iff2[I] ? 1 : 0);
        }
        for (I = 0; I < 4; ++I) {
            Out.writeShort(this.reg_pc[I], JBBPByteOrder.BIG_ENDIAN);
        }
        for (I = 0; I < 4; ++I) {
            Out.writeShort(this.reg_sp[I], JBBPByteOrder.BIG_ENDIAN);
        }
        for (I = 0; I < 4; ++I) {
            this.pages[I].write(Out);
        }
        return this;
    }

    private static int assrtExprNotNeg(int value) {
        if (value < 0) {
            throw new IllegalArgumentException("Negative value in expression");
        }
        return value;
    }

    public void setMAGIC(int value) {
        this.magic = value;
    }

    public int getMAGIC() {
        return this.magic;
    }

    public void setFLAGS(int value) {
        this.flags = value;
    }

    public int getFLAGS() {
        return this.flags;
    }

    public void setPORT3D00(char value) {
        this.port3d00 = value;
    }

    public char getPORT3D00() {
        return this.port3d00;
    }

    public void setPORTFE(char value) {
        this.portfe = value;
    }

    public char getPORTFE() {
        return this.portfe;
    }

    public void setCPU0PORTS(byte[] value) {
        this.cpu0ports = value;
    }

    public byte[] getCPU0PORTS() {
        return this.cpu0ports;
    }

    public void setCPU1PORTS(byte[] value) {
        this.cpu1ports = value;
    }

    public byte[] getCPU1PORTS() {
        return this.cpu1ports;
    }

    public void setCPU2PORTS(byte[] value) {
        this.cpu2ports = value;
    }

    public byte[] getCPU2PORTS() {
        return this.cpu2ports;
    }

    public void setCPU3PORTS(byte[] value) {
        this.cpu3ports = value;
    }

    public byte[] getCPU3PORTS() {
        return this.cpu3ports;
    }

    public void setREG_AF(short[] value) {
        this.reg_af = value;
    }

    public short[] getREG_AF() {
        return this.reg_af;
    }

    public void setREG_AF_ALT(short[] value) {
        this.reg_af_alt = value;
    }

    public short[] getREG_AF_ALT() {
        return this.reg_af_alt;
    }

    public void setREG_BC(short[] value) {
        this.reg_bc = value;
    }

    public short[] getREG_BC() {
        return this.reg_bc;
    }

    public void setREG_BC_ALT(short[] value) {
        this.reg_bc_alt = value;
    }

    public short[] getREG_BC_ALT() {
        return this.reg_bc_alt;
    }

    public void setREG_DE(short[] value) {
        this.reg_de = value;
    }

    public short[] getREG_DE() {
        return this.reg_de;
    }

    public void setREG_DE_ALT(short[] value) {
        this.reg_de_alt = value;
    }

    public short[] getREG_DE_ALT() {
        return this.reg_de_alt;
    }

    public void setREG_HL(short[] value) {
        this.reg_hl = value;
    }

    public short[] getREG_HL() {
        return this.reg_hl;
    }

    public void setREG_HL_ALT(short[] value) {
        this.reg_hl_alt = value;
    }

    public short[] getREG_HL_ALT() {
        return this.reg_hl_alt;
    }

    public void setREG_IX(short[] value) {
        this.reg_ix = value;
    }

    public short[] getREG_IX() {
        return this.reg_ix;
    }

    public void setREG_IY(short[] value) {
        this.reg_iy = value;
    }

    public short[] getREG_IY() {
        return this.reg_iy;
    }

    public void setREG_IR(short[] value) {
        this.reg_ir = value;
    }

    public short[] getREG_IR() {
        return this.reg_ir;
    }

    public void setREG_IM(byte[] value) {
        this.reg_im = value;
    }

    public byte[] getREG_IM() {
        return this.reg_im;
    }

    public void setIFF(boolean[] value) {
        this.iff = value;
    }

    public boolean[] getIFF() {
        return this.iff;
    }

    public void setIFF2(boolean[] value) {
        this.iff2 = value;
    }

    public boolean[] getIFF2() {
        return this.iff2;
    }

    public void setREG_PC(short[] value) {
        this.reg_pc = value;
    }

    public short[] getREG_PC() {
        return this.reg_pc;
    }

    public void setREG_SP(short[] value) {
        this.reg_sp = value;
    }

    public short[] getREG_SP() {
        return this.reg_sp;
    }

    public PAGES[] getPAGES() {
        return this.pages;
    }

    public PAGES[] makePAGES(int _Len_) {
        this.pages = new PAGES[_Len_];
        for (int i = 0; i < _Len_; ++i) {
            this.pages[i] = new PAGES(this);
        }
        return this.pages;
    }

    public static class PAGES {
        protected char number;
        protected PAGE[] page;
        private final ZXPParser _Root_;

        public PAGES(ZXPParser root) {
            this._Root_ = root;
        }

        public PAGES read(JBBPBitInputStream In) throws IOException {
            int I;
            this.number = (char)(In.readByte() & 0xFF);
            if (this.page == null || this.page.length != ZXPParser.assrtExprNotNeg(this.number)) {
                this.page = new PAGE[ZXPParser.assrtExprNotNeg(this.number)];
                for (I = 0; I < ZXPParser.assrtExprNotNeg(this.number); ++I) {
                    this.page[I] = new PAGE(this._Root_);
                }
            }
            for (I = 0; I < ZXPParser.assrtExprNotNeg(this.number); ++I) {
                this.page[I].read(In);
            }
            return this;
        }

        public PAGES write(JBBPBitOutputStream Out) throws IOException {
            Out.write(this.number);
            for (int I = 0; I < ZXPParser.assrtExprNotNeg(this.number); ++I) {
                this.page[I].write(Out);
            }
            return this;
        }

        public void setNUMBER(char value) {
            this.number = value;
        }

        public char getNUMBER() {
            return this.number;
        }

        public PAGE[] getPAGE() {
            return this.page;
        }

        public PAGE[] makePAGE(int _Len_) {
            this.page = new PAGE[_Len_];
            for (int i = 0; i < _Len_; ++i) {
                this.page[i] = new PAGE(this._Root_);
            }
            return this.page;
        }

        public static class PAGE {
            protected char index;
            protected byte[] data;
            private final ZXPParser _Root_;

            public PAGE(ZXPParser root) {
                this._Root_ = root;
            }

            public PAGE read(JBBPBitInputStream In) throws IOException {
                this.index = (char)(In.readByte() & 0xFF);
                this.data = In.readByteArray(16384, JBBPByteOrder.BIG_ENDIAN);
                return this;
            }

            public PAGE write(JBBPBitOutputStream Out) throws IOException {
                Out.write(this.index);
                Out.writeBytes(this.data, 16384, JBBPByteOrder.BIG_ENDIAN);
                return this;
            }

            public void setINDEX(char value) {
                this.index = value;
            }

            public char getINDEX() {
                return this.index;
            }

            public void setDATA(byte[] value) {
                this.data = value;
            }

            public byte[] getDATA() {
                return this.data;
            }
        }
    }
}

