/*
 * Decompiled with CFR 0.152.
 */
package com.igormaznitsa.zxpoly.formats;

import com.igormaznitsa.jbbp.io.JBBPBitInputStream;
import com.igormaznitsa.jbbp.io.JBBPBitOutputStream;
import com.igormaznitsa.zxpoly.formats.ZXPParser;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;

public class ZxEmlSnapshotFormat
extends ZXPParser {
    public static final int MAGIC = -1061551872;
    public static final int INDEX_CPU0 = 0;
    public static final int INDEX_CPU1 = 1;
    public static final int INDEX_CPU2 = 2;
    public static final int INDEX_CPU3 = 3;

    public ZxEmlSnapshotFormat() {
        this.setMAGIC(-1061551872);
        this.cpu0ports = new byte[5];
        this.cpu1ports = new byte[5];
        this.cpu2ports = new byte[5];
        this.cpu3ports = new byte[5];
        this.reg_af = new short[4];
        this.reg_af_alt = new short[4];
        this.reg_bc = new short[4];
        this.reg_bc_alt = new short[4];
        this.reg_de = new short[4];
        this.reg_de_alt = new short[4];
        this.reg_hl = new short[4];
        this.reg_hl_alt = new short[4];
        this.reg_ix = new short[4];
        this.reg_iy = new short[4];
        this.reg_ir = new short[4];
        this.reg_im = new byte[4];
        this.iff = new boolean[4];
        this.iff2 = new boolean[4];
        this.reg_pc = new short[4];
        this.reg_sp = new short[4];
        this.pages = new ZXPParser.PAGES[4];
        for (int j = 0; j < this.pages.length; ++j) {
            this.pages[j] = new ZXPParser.PAGES(this);
            this.pages[j].number = (char)8;
            this.pages[j].page = new ZXPParser.PAGES.PAGE[8];
            for (int i = 0; i < this.pages[j].page.length; ++i) {
                this.pages[j].page[i] = new ZXPParser.PAGES.PAGE(this);
                this.pages[j].page[i].index = (char)i;
                this.pages[j].page[i].data = new byte[16384];
            }
        }
    }

    public ZxEmlSnapshotFormat(byte[] data) throws IOException {
        this.read(new JBBPBitInputStream(new ByteArrayInputStream(data)));
        if (this.getMAGIC() != -1061551872) {
            throw new IOException("It is not ZXEML snapshot");
        }
    }

    public void setModulePorts(int cpuIndex, int port7FFD, int r0, int r1, int r2, int r3) {
        byte[] data = new byte[]{(byte)port7FFD, (byte)r0, (byte)r1, (byte)r2, (byte)r3};
        switch (cpuIndex) {
            case 0: {
                this.setCPU0PORTS(data);
                break;
            }
            case 1: {
                this.setCPU1PORTS(data);
                break;
            }
            case 2: {
                this.setCPU2PORTS(data);
                break;
            }
            case 3: {
                this.setCPU3PORTS(data);
                break;
            }
            default: {
                throw new IllegalArgumentException("Illegal CPU index");
            }
        }
    }

    public byte[] getModulePorts(int cpuIndex) {
        switch (cpuIndex) {
            case 0: {
                return this.getCPU0PORTS();
            }
            case 1: {
                return this.getCPU1PORTS();
            }
            case 2: {
                return this.getCPU2PORTS();
            }
            case 3: {
                return this.getCPU3PORTS();
            }
        }
        throw new IllegalArgumentException("Illegal CPU index");
    }

    public byte[] save() throws IOException {
        ByteArrayOutputStream buffer = new ByteArrayOutputStream();
        JBBPBitOutputStream bout = new JBBPBitOutputStream(buffer);
        this.write(bout);
        bout.close();
        return buffer.toByteArray();
    }
}

