/*
 * Decompiled with CFR 0.152.
 */
package com.igormaznitsa.zxpoly.streamer;

import com.igormaznitsa.zxpoly.utils.Utils;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.List;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;

public abstract class AbstractTcpSingleThreadServer {
    protected final BlockingQueue<byte[]> buffer;
    private final String id;
    private final InetAddress address;
    private final int port;
    private final AtomicReference<Thread> currentThread = new AtomicReference();
    private final AtomicReference<ServerSocket> serverSocket = new AtomicReference();
    private final AtomicReference<Socket> currentSocket = new AtomicReference();
    private final List<TcpServerListener> listeners = new CopyOnWriteArrayList<TcpServerListener>();
    private volatile boolean stopped;

    public AbstractTcpSingleThreadServer(String id, int bufferSize, InetAddress address, int port) {
        this.id = id;
        this.buffer = new ArrayBlockingQueue<byte[]>(bufferSize);
        this.address = address;
        this.port = port;
    }

    public String getId() {
        return this.id;
    }

    protected boolean isStopped() {
        return this.stopped;
    }

    public void addListener(TcpServerListener listener) {
        this.listeners.add(listener);
    }

    public void removeListener(TcpServerListener listener) {
        this.listeners.remove(listener);
    }

    public void start() {
        Thread thread = Thread.ofVirtual().name(this.id + "-" + this.hashCode()).unstarted(this::doWork);
        if (this.currentThread.compareAndSet(null, thread)) {
            this.stopped = false;
            thread.start();
        }
    }

    public void stop() {
        this.stopped = true;
        Thread thread = this.currentThread.getAndSet(null);
        if (thread != null) {
            thread.interrupt();
            Utils.closeQuietly(this.serverSocket.get());
            Utils.closeQuietly(this.currentSocket.get());
            try {
                thread.join();
            }
            catch (InterruptedException ex) {
                Thread.currentThread().interrupt();
            }
        }
    }

    public String getServerAddress() {
        ServerSocket serverSocket = this.serverSocket.get();
        return serverSocket == null ? "none" : serverSocket.getInetAddress().getHostAddress() + ":" + serverSocket.getLocalPort();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doWork() {
        try {
            ServerSocket serverSocket;
            try {
                serverSocket = new ServerSocket(this.port, 1, this.address);
                this.serverSocket.set(serverSocket);
                this.listeners.forEach(x -> x.onEstablishing(this, serverSocket, null));
            }
            catch (Exception ex) {
                this.listeners.forEach(x -> x.onEstablishing(this, null, ex));
                this.listeners.forEach(x -> x.onDone(this));
                return;
            }
            while (!Thread.currentThread().isInterrupted() && !this.stopped) {
                Socket socket;
                try {
                    socket = serverSocket.accept();
                    socket.setSoLinger(false, 0);
                    socket.setSoTimeout((int)TimeUnit.SECONDS.toMillis(5L));
                    socket.setReuseAddress(true);
                    socket.setTcpNoDelay(true);
                    socket.setKeepAlive(true);
                    socket.setPerformancePreferences(0, 1, 0);
                }
                catch (Exception ex) {
                    this.listeners.forEach(x -> x.onClientError(this, ex));
                    break;
                }
                this.currentSocket.set(socket);
                this.listeners.forEach(x -> x.onConnected(this, socket));
                try {
                    this.doBusiness(socket);
                }
                catch (Exception ex) {
                    if (this.stopped || Thread.currentThread().isInterrupted()) continue;
                    this.listeners.forEach(x -> x.onClientError(this, ex));
                }
                finally {
                    this.listeners.forEach(x -> x.onConnectionDone(this, socket));
                }
            }
        }
        finally {
            this.listeners.forEach(x -> x.onDone(this));
        }
    }

    protected abstract void doBusiness(Socket var1) throws Exception;

    public static interface TcpServerListener {
        default public void onEstablishing(AbstractTcpSingleThreadServer source, ServerSocket socket, Throwable error) {
        }

        default public void onConnected(AbstractTcpSingleThreadServer source, Socket socket) {
        }

        default public void onClientError(AbstractTcpSingleThreadServer source, Throwable error) {
        }

        default public void onDone(AbstractTcpSingleThreadServer source) {
        }

        default public void onConnectionDone(AbstractTcpSingleThreadServer source, Socket socket) {
        }
    }
}

