/*
 * Decompiled with CFR 0.152.
 */
package com.igormaznitsa.zxpoly.tracer;

import java.awt.Color;
import java.awt.Font;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.util.Objects;
import javax.swing.JFormattedTextField;

public abstract class AbstractHexValueField
extends JFormattedTextField {
    protected static final String ALLOWED_CHARS = "0123456789abcdefABCDEF";
    protected int intValue;
    private Color lastForeground;
    private Color changeColor = Color.RED;

    public AbstractHexValueField() {
        this.lastForeground = this.getForeground();
        this.setFont(new Font("Monospaced", 0, this.getFont().getSize()));
        this.addKeyListener(new KeyAdapter(this){

            @Override
            public void keyTyped(KeyEvent e) {
                if (e.getKeyCode() == 127 || e.getKeyCode() == 8 || AbstractHexValueField.ALLOWED_CHARS.indexOf(e.getKeyChar()) < 0) {
                    e.consume();
                }
            }
        });
    }

    public Color getChangeColor() {
        return this.changeColor;
    }

    public void setChangeColor(Color color) {
        this.changeColor = Objects.requireNonNull(color);
    }

    public void setValue(int value) {
        if (this.intValue != (value = this.processValue(value))) {
            this.intValue = value;
            this.lastForeground = this.getForeground();
            this.setForeground(this.changeColor);
            this.refreshTextValue();
        } else {
            this.setForeground(this.lastForeground);
        }
    }

    protected abstract void refreshTextValue();

    protected abstract int processValue(int var1);

    public int getIntValue() {
        String text = this.getText();
        text = text.isEmpty() ? "0" : text.trim();
        return Integer.parseInt(text, 16);
    }
}

