/*
 * Decompiled with CFR 0.152.
 */
package com.igormaznitsa.zxpoly.tracer;

import com.igormaznitsa.zxpoly.components.ZxPolyModule;
import com.igormaznitsa.zxpoly.tracer.HexValue2Field;
import com.igormaznitsa.zxpoly.tracer.HexValue4Field;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.LayoutStyle;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public class MemoryDialog
extends JDialog {
    private final ZxPolyModule module;
    private JButton buttonClose;
    private JButton buttonSet;
    private HexValue4Field fieldAddress;
    private HexValue2Field fieldValue;
    private JLabel jLabel1;
    private JLabel jLabel2;

    public MemoryDialog(Frame parent, boolean modal, ZxPolyModule module) {
        super(parent, modal);
        this.initComponents();
        this.module = module;
        this.fieldAddress.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent e) {
                MemoryDialog.this.updateAddress();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                MemoryDialog.this.updateAddress();
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                MemoryDialog.this.updateAddress();
            }
        });
        this.setLocationRelativeTo(parent);
    }

    private void writeValue() {
        int address = this.fieldAddress.getIntValue();
        int value = this.fieldValue.getIntValue();
        this.module.writeMemory(this.module.getCpu(), 0, address, (byte)value);
    }

    private void updateAddress() {
        this.fieldValue.setValue(this.module.readMemory(this.module.getCpu(), 0, this.fieldAddress.getIntValue(), false, false));
    }

    private void initComponents() {
        this.jLabel1 = new JLabel();
        this.jLabel2 = new JLabel();
        this.fieldAddress = new HexValue4Field();
        this.fieldValue = new HexValue2Field();
        this.buttonClose = new JButton();
        this.buttonSet = new JButton();
        this.setDefaultCloseOperation(2);
        this.setTitle("Address");
        this.setResizable(false);
        this.jLabel1.setText("Address:");
        this.jLabel2.setText("Value:");
        this.fieldAddress.setHorizontalAlignment(0);
        this.fieldValue.setHorizontalAlignment(0);
        this.buttonClose.setText("Close");
        this.buttonClose.addActionListener(this::buttonCloseActionPerformed);
        this.buttonSet.setText("Set");
        this.buttonSet.addActionListener(this::buttonSetActionPerformed);
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.jLabel2).addComponent(this.jLabel1)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.fieldAddress, -1, 57, Short.MAX_VALUE).addComponent(this.fieldValue, -1, -1, Short.MAX_VALUE)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.buttonSet).addGap(0, 0, Short.MAX_VALUE)).addComponent(this.buttonClose, GroupLayout.Alignment.TRAILING, -1, -1, Short.MAX_VALUE)).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel1).addComponent(this.fieldAddress, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel2).addComponent(this.fieldValue, -2, -1, -2).addComponent(this.buttonSet)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addComponent(this.buttonClose).addContainerGap()));
        this.pack();
    }

    private void buttonCloseActionPerformed(ActionEvent evt) {
        this.dispose();
    }

    private void buttonSetActionPerformed(ActionEvent evt) {
        this.writeValue();
    }
}

