/*
 * Decompiled with CFR 0.152.
 */
package com.igormaznitsa.zxpoly.tracer;

import com.igormaznitsa.z80.MemoryAccessProvider;
import com.igormaznitsa.z80.Z80;
import com.igormaznitsa.z80.Z80Instruction;
import com.igormaznitsa.z80.disasm.Z80Disasm;
import com.igormaznitsa.zxpoly.MainForm;
import com.igormaznitsa.zxpoly.components.Motherboard;
import com.igormaznitsa.zxpoly.components.ZxPolyModule;
import com.igormaznitsa.zxpoly.tracer.AbstractHexValueField;
import com.igormaznitsa.zxpoly.tracer.HexValue2Field;
import com.igormaznitsa.zxpoly.tracer.HexValue4Field;
import com.igormaznitsa.zxpoly.tracer.MemoryDialog;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.List;
import java.util.Locale;
import javax.swing.Box;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.border.EmptyBorder;
import javax.swing.border.TitledBorder;
import org.apache.commons.lang3.StringUtils;

public class TraceCpuForm
extends JFrame
implements MemoryAccessProvider {
    private final MainForm mainForm;
    private final Motherboard motherboard;
    private final ZxPolyModule module;
    private final int moduleIndex;
    private final JCheckBox checkBoxC;
    private final JCheckBox checkBoxF3;
    private final JCheckBox checkBoxF5;
    private final JCheckBox checkBoxH;
    private final JCheckBox checkBoxIFF1;
    private final JCheckBox checkBoxIFF2;
    private final JCheckBox checkBoxTrDos;
    private final JCheckBox checkBoxN;
    private final JCheckBox checkBoxPV;
    private final JCheckBox checkBoxS;
    private final JCheckBox checkBoxZ;
    private final JList<String> disasmList;
    private final HexValue2Field fieldAltRegA;
    private final HexValue2Field fieldAltRegB;
    private final HexValue2Field fieldAltRegC;
    private final HexValue2Field fieldAltRegD;
    private final HexValue2Field fieldAltRegE;
    private final HexValue2Field fieldAltRegF;
    private final HexValue2Field fieldAltRegH;
    private final HexValue2Field fieldAltRegL;
    private final HexValue2Field fieldI;
    private final HexValue2Field fieldIM;
    private final HexValue4Field fieldIX;
    private final HexValue4Field fieldIY;
    private final HexValue4Field fieldPC;
    private final HexValue2Field fieldR;
    private final HexValue2Field fieldRegA;
    private final HexValue2Field fieldRegB;
    private final HexValue2Field fieldRegC;
    private final HexValue2Field fieldRegD;
    private final HexValue2Field fieldRegE;
    private final HexValue2Field fieldRegF;
    private final HexValue2Field fieldRegH;
    private final HexValue2Field fieldRegL;
    private final HexValue2Field field7FFD;
    private final HexValue4Field fieldSP;
    private final JPanel panelAltSet;
    private final JPanel panelOthers;
    private final JPanel panelFlags;
    private final JPanel panelMainSet;
    private final StringBuilder buffer = new StringBuilder(32);
    private boolean changeEnabled = true;

    public TraceCpuForm(MainForm mainForm, Motherboard motherboard, int moduleIndex) {
        super(mainForm.getGraphicsConfiguration());
        this.setLocation(mainForm.getLocation());
        this.mainForm = mainForm;
        this.motherboard = motherboard;
        this.moduleIndex = moduleIndex;
        this.module = motherboard.getModules()[this.moduleIndex];
        this.checkBoxC = new JCheckBox();
        this.checkBoxF3 = new JCheckBox();
        this.checkBoxF5 = new JCheckBox();
        this.checkBoxH = new JCheckBox();
        this.checkBoxIFF1 = new JCheckBox("IFF1");
        this.checkBoxIFF2 = new JCheckBox("IFF2");
        this.checkBoxTrDos = new JCheckBox("TrDos");
        this.checkBoxN = new JCheckBox();
        this.checkBoxPV = new JCheckBox();
        this.checkBoxS = new JCheckBox();
        this.checkBoxZ = new JCheckBox();
        this.disasmList = new JList();
        this.disasmList.setPreferredSize(new Dimension(this.disasmList.getFontMetrics(this.disasmList.getFont()).stringWidth(StringUtils.repeat('@', 24)), 128));
        this.fieldAltRegA = new HexValue2Field();
        this.fieldAltRegB = new HexValue2Field();
        this.fieldAltRegC = new HexValue2Field();
        this.fieldAltRegD = new HexValue2Field();
        this.fieldAltRegE = new HexValue2Field();
        this.fieldAltRegF = new HexValue2Field();
        this.fieldAltRegH = new HexValue2Field();
        this.fieldAltRegL = new HexValue2Field();
        this.fieldIM = new HexValue2Field();
        this.fieldI = new HexValue2Field();
        this.fieldIX = new HexValue4Field();
        this.fieldIY = new HexValue4Field();
        this.fieldPC = new HexValue4Field();
        this.fieldR = new HexValue2Field();
        this.fieldRegA = new HexValue2Field();
        this.fieldRegB = new HexValue2Field();
        this.fieldRegC = new HexValue2Field();
        this.fieldRegD = new HexValue2Field();
        this.fieldRegE = new HexValue2Field();
        this.fieldRegF = new HexValue2Field();
        this.fieldRegH = new HexValue2Field();
        this.fieldRegL = new HexValue2Field();
        this.field7FFD = new HexValue2Field();
        this.fieldSP = new HexValue4Field();
        this.panelMainSet = this.makePanelMainSet();
        this.panelAltSet = this.makePanelAltSet();
        this.panelOthers = this.makePanelOthers();
        this.panelFlags = this.makePanelFlags();
        JPanel mainPanel = new JPanel(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.fill = 1;
        gbc.anchor = 10;
        gbc.insets = new Insets(0, 0, 0, 0);
        gbc.ipadx = 0;
        gbc.ipady = 0;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        JPanel disasmPanel = new JPanel(new BorderLayout());
        disasmPanel.add(this.disasmList, "Center");
        disasmPanel.setBorder(new TitledBorder("Disassembler"));
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.gridwidth = 1;
        gbc.gridheight = 4;
        gbc.weightx = 1000.0;
        gbc.weighty = 1000.0;
        gbc.fill = 1;
        mainPanel.add((Component)disasmPanel, gbc);
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        gbc.gridx = 1;
        gbc.gridy = 0;
        gbc.gridwidth = 2;
        gbc.gridheight = 1;
        gbc.fill = 2;
        mainPanel.add((Component)this.panelFlags, gbc);
        gbc.gridx = 1;
        gbc.gridy = 1;
        gbc.gridwidth = 1;
        gbc.gridheight = 1;
        gbc.fill = 1;
        mainPanel.add((Component)this.panelMainSet, gbc);
        gbc.gridx = 2;
        gbc.gridy = 1;
        gbc.gridwidth = 1;
        gbc.gridheight = 1;
        gbc.fill = 1;
        mainPanel.add((Component)this.panelAltSet, gbc);
        gbc.gridx = 1;
        gbc.gridy = 2;
        gbc.gridwidth = 2;
        gbc.gridheight = 1;
        gbc.weighty = 1.0;
        gbc.fill = 2;
        mainPanel.add((Component)this.panelOthers, gbc);
        gbc.gridx = 1;
        gbc.gridy = 3;
        gbc.gridwidth = 2;
        gbc.gridheight = 1;
        gbc.weighty = 1000.0;
        gbc.fill = 1;
        mainPanel.add(Box.createVerticalGlue(), gbc);
        JButton buttonMemory = new JButton("Change memory");
        buttonMemory.addActionListener(e -> new MemoryDialog((Frame)this, true, this.module).setVisible(true));
        JButton buttonSetIFF1 = new JButton("Set IFF1");
        buttonSetIFF1.addActionListener(e -> this.module.getCpu().setIFF(true, true));
        JPanel buttonsPanel = new JPanel(new FlowLayout(2));
        buttonsPanel.add(buttonMemory);
        buttonsPanel.add(buttonSetIFF1);
        gbc.gridx = 0;
        gbc.gridy = 4;
        gbc.gridwidth = 3;
        gbc.gridheight = 1;
        gbc.weighty = 1.0;
        gbc.fill = 2;
        mainPanel.add((Component)buttonsPanel, gbc);
        JPanel contentPanel = new JPanel(new BorderLayout());
        contentPanel.setBorder(new EmptyBorder(8, 8, 8, 8));
        contentPanel.add((Component)mainPanel, "Center");
        this.setTitle("CPU Module#" + this.moduleIndex);
        this.setResizable(true);
        this.setDefaultCloseOperation(2);
        this.setContentPane(contentPanel);
        this.pack();
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowActivated(WindowEvent e) {
                TraceCpuForm.this.mainForm.onTracerActivated(TraceCpuForm.this);
            }

            @Override
            public void windowClosed(WindowEvent e) {
                TraceCpuForm.this.mainForm.onTracerDeactivated(TraceCpuForm.this);
            }
        });
    }

    private static JLabel makeCntrLabel(String text) {
        JLabel result = new JLabel(text);
        result.setHorizontalAlignment(0);
        return result;
    }

    private static void int2hex4(StringBuilder buffer, int value) {
        String str = Integer.toHexString(value).toUpperCase(Locale.ENGLISH);
        if (str.length() < 4) {
            buffer.append("0".repeat(4 - str.length()));
        }
        buffer.append(str);
    }

    private JPanel makePanelFlags() {
        JPanel result = new JPanel(new GridLayout(2, 8, 8, 8));
        result.setBorder(new TitledBorder("Flags"));
        result.add(TraceCpuForm.makeCntrLabel("S"));
        result.add(TraceCpuForm.makeCntrLabel("Z"));
        result.add(TraceCpuForm.makeCntrLabel("F5"));
        result.add(TraceCpuForm.makeCntrLabel("H"));
        result.add(TraceCpuForm.makeCntrLabel("F3"));
        result.add(TraceCpuForm.makeCntrLabel("P/V"));
        result.add(TraceCpuForm.makeCntrLabel("N"));
        result.add(TraceCpuForm.makeCntrLabel("C"));
        this.checkBoxS.setHorizontalAlignment(0);
        this.checkBoxC.setHorizontalAlignment(0);
        this.checkBoxF3.setHorizontalAlignment(0);
        this.checkBoxF5.setHorizontalAlignment(0);
        this.checkBoxH.setHorizontalAlignment(0);
        this.checkBoxN.setHorizontalAlignment(0);
        this.checkBoxZ.setHorizontalAlignment(0);
        this.checkBoxPV.setHorizontalAlignment(0);
        result.add(this.checkBoxS);
        result.add(this.checkBoxZ);
        result.add(this.checkBoxF5);
        result.add(this.checkBoxH);
        result.add(this.checkBoxF3);
        result.add(this.checkBoxPV);
        result.add(this.checkBoxN);
        result.add(this.checkBoxC);
        result.doLayout();
        return result;
    }

    private JPanel makePanelOthers() {
        JPanel result = new JPanel(new GridBagLayout());
        result.setBorder(new TitledBorder("Others"));
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.fill = 0;
        gbc.gridx = 0;
        gbc.gridy = -1;
        gbc.anchor = 13;
        result.add((Component)new JLabel("PC:"), gbc);
        result.add((Component)new JLabel("SP:"), gbc);
        result.add((Component)new JLabel("IX:"), gbc);
        result.add((Component)new JLabel("IY:"), gbc);
        gbc.gridx = 1;
        gbc.gridy = -1;
        gbc.anchor = 17;
        result.add((Component)this.fieldPC, gbc);
        result.add((Component)this.fieldSP, gbc);
        result.add((Component)this.fieldIX, gbc);
        result.add((Component)this.fieldIY, gbc);
        gbc.gridx = 2;
        gbc.gridy = -1;
        gbc.anchor = 13;
        gbc.insets = new Insets(0, 16, 0, 0);
        result.add((Component)new JLabel("R:"), gbc);
        result.add((Component)new JLabel("I:"), gbc);
        result.add((Component)new JLabel("IM:"), gbc);
        result.add((Component)new JLabel("7FFD:"), gbc);
        gbc.gridx = 3;
        gbc.gridy = -1;
        gbc.anchor = 17;
        gbc.insets = new Insets(0, 0, 0, 0);
        result.add((Component)this.fieldR, gbc);
        result.add((Component)this.fieldI, gbc);
        result.add((Component)this.fieldI, gbc);
        result.add((Component)this.fieldIM, gbc);
        result.add((Component)this.field7FFD, gbc);
        gbc.gridx = 0;
        gbc.gridy = 4;
        gbc.gridwidth = 4;
        gbc.fill = 2;
        JPanel flagsPanel = new JPanel(new FlowLayout(0));
        flagsPanel.add(this.checkBoxIFF1);
        flagsPanel.add(this.checkBoxIFF2);
        flagsPanel.add(this.checkBoxTrDos);
        result.add((Component)flagsPanel, gbc);
        return result;
    }

    private JPanel makePanelAltSet() {
        JPanel result = new JPanel(new GridBagLayout());
        result.setBorder(new TitledBorder("Alt set"));
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.fill = 2;
        gbc.gridx = 0;
        gbc.gridy = -1;
        gbc.fill = 1;
        gbc.anchor = 13;
        result.add((Component)new JLabel("A':"), gbc);
        result.add((Component)new JLabel("B':"), gbc);
        result.add((Component)new JLabel("C':"), gbc);
        result.add((Component)new JLabel("D':"), gbc);
        result.add((Component)new JLabel("E':"), gbc);
        result.add((Component)new JLabel("H':"), gbc);
        result.add((Component)new JLabel("L':"), gbc);
        gbc.gridx = 1;
        gbc.gridy = -1;
        gbc.fill = 1;
        gbc.anchor = 17;
        result.add((Component)this.fieldAltRegA, gbc);
        result.add((Component)this.fieldAltRegB, gbc);
        result.add((Component)this.fieldAltRegC, gbc);
        result.add((Component)this.fieldAltRegD, gbc);
        result.add((Component)this.fieldAltRegE, gbc);
        result.add((Component)this.fieldAltRegH, gbc);
        result.add((Component)this.fieldAltRegL, gbc);
        return result;
    }

    private JPanel makePanelMainSet() {
        JPanel result = new JPanel(new GridBagLayout());
        result.setBorder(new TitledBorder("Main set"));
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.fill = 2;
        gbc.gridx = 0;
        gbc.gridy = -1;
        gbc.fill = 1;
        gbc.anchor = 13;
        result.add((Component)new JLabel("A:"), gbc);
        result.add((Component)new JLabel("B:"), gbc);
        result.add((Component)new JLabel("C:"), gbc);
        result.add((Component)new JLabel("D:"), gbc);
        result.add((Component)new JLabel("E:"), gbc);
        result.add((Component)new JLabel("H:"), gbc);
        result.add((Component)new JLabel("L:"), gbc);
        gbc.gridx = 1;
        gbc.gridy = -1;
        gbc.fill = 1;
        gbc.anchor = 17;
        result.add((Component)this.fieldRegA, gbc);
        result.add((Component)this.fieldRegB, gbc);
        result.add((Component)this.fieldRegC, gbc);
        result.add((Component)this.fieldRegD, gbc);
        result.add((Component)this.fieldRegE, gbc);
        result.add((Component)this.fieldRegH, gbc);
        result.add((Component)this.fieldRegL, gbc);
        return result;
    }

    public int getModuleIndex() {
        return this.moduleIndex;
    }

    public void refresh() {
        int pc = this.module.getCpu().getPC();
        if (this.module.isActiveRegistersAsMemorySource()) {
            DefaultListModel<String> model = new DefaultListModel<String>();
            model.addElement("Registers as data source!");
            this.disasmList.setModel(model);
        } else {
            int lines = this.disasmList.getHeight() / this.disasmList.getFont().getSize();
            List<Z80Instruction> instructions = Z80Disasm.decodeList(this, null, pc, lines);
            DefaultListModel<String> model = new DefaultListModel<String>();
            int address = pc;
            model.addElement(this.makeCodeLine(this, pc - 9, 8));
            for (Z80Instruction i : instructions) {
                model.addElement(this.makeInstructionLine(i, address));
                address += i == null ? 1 : i.getLength();
            }
            this.disasmList.setModel(model);
            this.disasmList.setSelectedIndex(1);
        }
        this.refreshRegisterValue();
    }

    private String makeCodeLine(MemoryAccessProvider provider, int addr, int bytes) {
        StringBuilder result = new StringBuilder();
        String addrAsHex = Integer.toHexString(addr).toUpperCase(Locale.ENGLISH);
        switch (addrAsHex.length()) {
            case 3: {
                result.append('0');
                break;
            }
            case 2: {
                result.append("00");
                break;
            }
            case 1: {
                result.append("000");
            }
        }
        result.append(addrAsHex);
        for (int i = 0; i < bytes; ++i) {
            result.append(' ').append(Integer.toHexString(provider.readAddress(addr + i) & 0xFF).toUpperCase(Locale.ENGLISH));
        }
        return result.toString();
    }

    private String makeInstructionLine(Z80Instruction instruction, int address) {
        this.buffer.setLength(0);
        TraceCpuForm.int2hex4(this.buffer, address);
        this.buffer.append("    ");
        if (instruction == null) {
            this.buffer.append("---");
        } else {
            this.buffer.append(instruction.decode(this, address, address));
        }
        return this.buffer.toString();
    }

    private void setEnableForComponentsOfPanel(JPanel panel, boolean flag) {
        for (Component c : panel.getComponents()) {
            if (c instanceof AbstractHexValueField) {
                ((AbstractHexValueField)c).setEditable(flag);
                continue;
            }
            if (c instanceof JCheckBox) {
                c.setEnabled(flag);
                continue;
            }
            if (!(c instanceof JPanel)) continue;
            this.setEnableForComponentsOfPanel((JPanel)c, flag);
        }
    }

    private void refreshRegisterValue() {
        if (this.changeEnabled) {
            this.changeEnabled = false;
            this.setEnableForComponentsOfPanel(this.panelAltSet, this.changeEnabled);
            this.setEnableForComponentsOfPanel(this.panelOthers, this.changeEnabled);
            this.setEnableForComponentsOfPanel(this.panelFlags, this.changeEnabled);
            this.setEnableForComponentsOfPanel(this.panelMainSet, this.changeEnabled);
        }
        Z80 cpu = this.module.getCpu();
        this.fieldPC.setValue(cpu.getPC());
        this.fieldSP.setValue(cpu.getSP());
        this.fieldIX.setValue(cpu.getRegister(8));
        this.fieldIY.setValue(cpu.getRegister(9));
        this.fieldI.setValue(cpu.getRegister(12));
        this.fieldIM.setValue(cpu.getIM());
        this.fieldR.setValue(cpu.getRegister(13));
        int regf = cpu.getRegister(1);
        this.checkBoxC.setSelected((regf & 1) != 0);
        this.checkBoxF3.setSelected((regf & 8) != 0);
        this.checkBoxF5.setSelected((regf & 0x20) != 0);
        this.checkBoxH.setSelected((regf & 0x10) != 0);
        this.checkBoxN.setSelected((regf & 2) != 0);
        this.checkBoxPV.setSelected((regf & 4) != 0);
        this.checkBoxS.setSelected((regf & 0x80) != 0);
        this.checkBoxZ.setSelected((regf & 0x40) != 0);
        this.checkBoxIFF1.setSelected(cpu.isIFF1());
        this.checkBoxIFF2.setSelected(cpu.isIFF2());
        this.checkBoxTrDos.setSelected(this.module.isTrdosActive());
        this.field7FFD.setValue(this.module.read7FFD());
        this.fieldRegA.setValue(cpu.getRegister(0));
        this.fieldRegF.setValue(cpu.getRegister(1));
        this.fieldRegB.setValue(cpu.getRegister(2));
        this.fieldRegC.setValue(cpu.getRegister(3));
        this.fieldRegD.setValue(cpu.getRegister(4));
        this.fieldRegE.setValue(cpu.getRegister(5));
        this.fieldRegH.setValue(cpu.getRegister(6));
        this.fieldRegL.setValue(cpu.getRegister(7));
        this.fieldAltRegA.setValue(cpu.getRegister(0, true));
        this.fieldAltRegF.setValue(cpu.getRegister(1, true));
        this.fieldAltRegB.setValue(cpu.getRegister(2, true));
        this.fieldAltRegC.setValue(cpu.getRegister(3, true));
        this.fieldAltRegD.setValue(cpu.getRegister(4, true));
        this.fieldAltRegE.setValue(cpu.getRegister(5, true));
        this.fieldAltRegH.setValue(cpu.getRegister(6, true));
        this.fieldAltRegL.setValue(cpu.getRegister(7, true));
    }

    @Override
    public byte readAddress(int address) {
        return this.module.readMemory(this.module.getCpu(), 0, address & 0xFFFF, false, false);
    }
}

