/*
 * Decompiled with CFR 0.152.
 */
package com.igormaznitsa.zxpoly.ui;

import com.igormaznitsa.zxpoly.Version;
import java.awt.Cursor;
import java.awt.Desktop;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JEditorPane;
import javax.swing.JScrollPane;
import javax.swing.LayoutStyle;
import javax.swing.event.HyperlinkEvent;
import org.apache.commons.io.IOUtils;

public class AboutDialog
extends JDialog
implements Version {
    private static final long serialVersionUID = 6729883219284422519L;
    private JButton buttonOk;
    private JEditorPane editorPane;
    private JScrollPane jScrollPane1;

    public AboutDialog(Frame parent) {
        super(parent, true);
        this.initComponents();
        this.editorPane.addHyperlinkListener(e -> {
            if (e.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
                try {
                    Desktop.getDesktop().browse(e.getURL().toURI());
                }
                catch (Exception exception) {}
            } else if (e.getEventType() == HyperlinkEvent.EventType.ENTERED) {
                this.editorPane.setCursor(Cursor.getPredefinedCursor(12));
            } else if (e.getEventType() == HyperlinkEvent.EventType.EXITED) {
                this.editorPane.setCursor(Cursor.getDefaultCursor());
            }
        });
        this.editorPane.setContentType("text/html");
        try {
            String htmlText = IOUtils.toString(this.openAboutResource("index.html"), StandardCharsets.UTF_8);
            htmlText = htmlText.replace("${version.major}", Integer.toString(2)).replace("${version.minor}", Integer.toString(3)).replace("${version.build}", Integer.toString(5));
            this.editorPane.setText(htmlText);
            this.editorPane.setCaretPosition(0);
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
        this.getRootPane().setDefaultButton(this.buttonOk);
        this.setLocationRelativeTo(parent);
    }

    private void initComponents() {
        this.buttonOk = new JButton();
        this.jScrollPane1 = new JScrollPane();
        this.editorPane = new JEditorPane();
        this.setDefaultCloseOperation(2);
        this.setTitle("Help");
        this.buttonOk.setIcon(new ImageIcon(this.getClass().getResource("/com/igormaznitsa/zxpoly/icons/ok.png")));
        this.buttonOk.setText("Ok");
        this.buttonOk.addActionListener(this::buttonOkActionPerformed);
        this.buttonOk.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent evt) {
                AboutDialog.this.buttonOkKeyReleased(evt);
            }
        });
        this.editorPane.setEditable(false);
        this.editorPane.setFocusable(false);
        this.jScrollPane1.setViewportView(this.editorPane);
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.jScrollPane1, -1, 588, Short.MAX_VALUE).addComponent(this.buttonOk, -1, -1, Short.MAX_VALUE)).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addContainerGap().addComponent(this.jScrollPane1, -1, 421, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.buttonOk).addContainerGap()));
        this.pack();
    }

    private void buttonOkActionPerformed(ActionEvent evt) {
        this.setVisible(false);
    }

    private void buttonOkKeyReleased(KeyEvent evt) {
        if (evt.getKeyCode() == 27) {
            this.dispose();
        }
    }

    private InputStream openAboutResource(String name) {
        return AboutDialog.class.getClassLoader().getResourceAsStream("com/igormaznitsa/zxpoly/about/" + name);
    }
}

