/*
 * Decompiled with CFR 0.152.
 */
package com.igormaznitsa.zxpoly.ui;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.util.Objects;
import java.util.function.IntFunction;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSlider;

public class CustomIntSlider
extends JPanel {
    private final JSlider slider;
    private final JLabel labelMinIndicator;
    private final JLabel labelMaxIndicator;
    private final JLabel labelIndicator;
    private final IntFunction<Double> convertingFunction;
    private double value;

    public CustomIntSlider(int min, int max, IntFunction<Double> convertingFunction) {
        super(new GridBagLayout());
        this.convertingFunction = Objects.requireNonNull(convertingFunction);
        this.slider = new JSlider(0, min, max, min);
        this.slider.setPaintTrack(true);
        this.slider.setPaintLabels(false);
        this.slider.setPaintTicks(false);
        this.labelIndicator = new JLabel(this.valueAsText(min));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 2;
        this.labelMinIndicator = new JLabel(this.valueAsText(min));
        this.labelMinIndicator.setHorizontalAlignment(2);
        this.add((Component)this.labelMinIndicator, gridBagConstraints);
        gridBagConstraints.anchor = 10;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridx = 1;
        gridBagConstraints.weightx = 1000.0;
        this.labelIndicator.setHorizontalAlignment(0);
        this.add((Component)this.labelIndicator, gridBagConstraints);
        gridBagConstraints.anchor = 13;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridx = 2;
        gridBagConstraints.weightx = 1.0;
        this.labelMaxIndicator = new JLabel(this.valueAsText(max));
        this.labelMinIndicator.setHorizontalAlignment(4);
        this.add((Component)this.labelMaxIndicator, gridBagConstraints);
        gridBagConstraints.anchor = 10;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.weightx = 1000.0;
        this.add((Component)this.slider, gridBagConstraints);
        this.slider.addChangeListener(e -> this.labelIndicator.setText("<html><b>" + this.valueAsText(this.slider.getValue()) + "</b></html>"));
    }

    @Override
    public void setEnabled(boolean value) {
        super.setEnabled(value);
        this.labelMinIndicator.setEnabled(value);
        this.labelMaxIndicator.setEnabled(value);
        this.labelIndicator.setEnabled(value);
        this.slider.setEnabled(value);
    }

    public int getValue() {
        return this.slider.getValue();
    }

    public void setValue(int value) {
        this.slider.setValue(value);
    }

    private String valueAsText(int value) {
        double doubleValue = this.convertingFunction.apply(value);
        return String.format("%.3f", doubleValue);
    }
}

