/*
 * Decompiled with CFR 0.152.
 */
package com.igormaznitsa.zxpoly.ui;

import com.igormaznitsa.zxpoly.components.KeyboardKempstonAndTapeIn;
import com.igormaznitsa.zxpoly.components.gadapter.GameControllerAdapter;
import com.igormaznitsa.zxpoly.components.gadapter.GameControllerAdapterType;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import net.java.games.input.Controller;

public final class GameControllerPanel
extends JPanel {
    private final KeyboardKempstonAndTapeIn module;

    public GameControllerPanel(KeyboardKempstonAndTapeIn module) {
        super(new GridBagLayout());
        this.module = module;
        List controllers = module.getDetectedControllers().stream().sorted(Comparator.comparing(Controller::getName)).collect(Collectors.toList());
        List<GameControllerAdapter> activeGameControllerAdapters = module.getActiveGadapters();
        GridBagConstraints constraints = new GridBagConstraints(0, -1, 1, 1, 1.0, 1.0, 18, 2, new Insets(0, 0, 0, 0), 0, 0);
        for (Controller c : controllers) {
            GadapterRecord newRecord = new GadapterRecord(c, activeGameControllerAdapters);
            this.add((Component)newRecord, constraints);
        }
    }

    public List<GameControllerAdapter> getSelected() {
        ArrayList<GameControllerAdapter> result = new ArrayList<GameControllerAdapter>();
        HashSet<GameControllerAdapterType> alreadySelected = new HashSet<GameControllerAdapterType>();
        for (Component c : this.getComponents()) {
            if (!(c instanceof GadapterRecord)) continue;
            GadapterRecord record = (GadapterRecord)c;
            GameControllerAdapterType gameControllerAdapterType = (GameControllerAdapterType)((Object)record.type.getSelectedItem());
            if (!record.selected.isSelected() || gameControllerAdapterType == GameControllerAdapterType.NONE || alreadySelected.contains((Object)gameControllerAdapterType)) continue;
            result.add(this.module.makeGameControllerAdapter(record.controller, gameControllerAdapterType));
            alreadySelected.add(gameControllerAdapterType);
        }
        return result;
    }

    private static final class GadapterRecord
    extends JPanel {
        private final JCheckBox selected;
        private final JLabel name;
        private final JComboBox<GameControllerAdapterType> type;
        private final Controller controller;

        GadapterRecord(Controller controller, List<GameControllerAdapter> activeGameControllerAdapters) {
            super(new GridBagLayout());
            this.controller = controller;
            this.selected = new JCheckBox();
            this.name = new JLabel(controller.getName());
            this.type = new JComboBox<GameControllerAdapterType>(GameControllerAdapterType.values());
            Optional<GameControllerAdapter> activeForController = activeGameControllerAdapters.stream().filter(x -> x.getController() == controller).findFirst();
            if (activeForController.isPresent()) {
                this.selected.setSelected(true);
                this.type.setSelectedItem((Object)activeForController.get().getType());
            }
            GridBagConstraints constraints = new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(2, 2, 2, 2), 0, 0);
            this.add((Component)this.selected, constraints);
            constraints.gridx = 1;
            constraints.weightx = 1000.0;
            this.add((Component)this.name, constraints);
            constraints.gridx = 2;
            constraints.weightx = 1.0;
            this.add(this.type, constraints);
        }
    }
}

