/*
 * Decompiled with CFR 0.152.
 */
package com.igormaznitsa.zxpoly.ui;

import java.util.concurrent.atomic.AtomicBoolean;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.SwingUtilities;

public class JIndicatorLabel
extends JLabel {
    private final Icon active;
    private final Icon inactive;
    private final AtomicBoolean status = new AtomicBoolean(false);
    private String tooltipActive;
    private String tooltipInactive;

    public JIndicatorLabel(Icon active, Icon inactive, String tooltipActive, String tooltipInactive) {
        this.active = active;
        this.inactive = inactive;
        this.tooltipActive = tooltipActive;
        this.tooltipInactive = tooltipInactive;
        this.updateForState();
    }

    public void setTooltips(String active, String inactive) {
        this.tooltipActive = active;
        this.tooltipInactive = inactive;
        this.updateForState();
    }

    private void updateForState() {
        boolean stateActive = this.status.get();
        this.setIcon(stateActive ? this.active : this.inactive);
        this.setToolTipText(stateActive ? this.tooltipActive : this.tooltipInactive);
    }

    public boolean getStatus() {
        return this.status.get();
    }

    public void setStatus(boolean active) {
        if (this.status.compareAndSet(!active, active)) {
            SwingUtilities.invokeLater(() -> this.updateForState());
        }
    }
}

