/*
 * Decompiled with CFR 0.152.
 */
package com.igormaznitsa.zxpoly.ui;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.OptionalInt;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.JToggleButton;

public class KeyCodeChooser
extends JPanel {
    private static final Map<Integer, String> KEY_NAMES;
    private final JTextField textField;
    private final JToggleButton buttonSelect;
    private OptionalInt key = OptionalInt.empty();

    public KeyCodeChooser() {
        super(new GridBagLayout());
        this.textField = new JTextField(){

            @Override
            public boolean isFocusable() {
                return false;
            }
        };
        this.textField.setEditable(false);
        this.textField.setColumns(10);
        this.buttonSelect = new JToggleButton("SELECT");
        this.buttonSelect.addActionListener(e -> {
            this.buttonSelect.requestFocus();
            this.buttonSelect.setFocusTraversalKeysEnabled(!this.buttonSelect.isSelected());
        });
        this.buttonSelect.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (!e.isConsumed() && KeyCodeChooser.this.buttonSelect.isSelected()) {
                    if (e.getKeyCode() != 27) {
                        KeyCodeChooser.this.setKey(e.getKeyCode());
                    }
                    KeyCodeChooser.this.buttonSelect.doClick();
                    e.consume();
                }
            }
        });
        this.buttonSelect.setToolTipText("Activate and press key");
        this.buttonSelect.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent e) {
                if (KeyCodeChooser.this.buttonSelect.isSelected()) {
                    KeyCodeChooser.this.buttonSelect.setSelected(false);
                }
            }
        });
        this.textField.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (KeyCodeChooser.this.buttonSelect.isSelected()) {
                    KeyCodeChooser.this.buttonSelect.doClick();
                } else {
                    KeyCodeChooser.this.buttonSelect.doClick();
                }
            }
        });
        GridBagConstraints gbc = new GridBagConstraints(0, 0, 1, 1, 1000.0, 1.0, 17, 1, new Insets(0, 0, 0, 0), 0, 0);
        this.add((Component)this.textField, gbc);
        gbc.weightx = 1.0;
        gbc.gridx = 1;
        this.add((Component)this.buttonSelect, gbc);
    }

    public OptionalInt getKey() {
        return this.key;
    }

    public void setKey(int key) {
        this.key = key < 0 ? OptionalInt.empty() : OptionalInt.of(key);
        String name = KEY_NAMES.get(key);
        this.textField.setText(Objects.requireNonNullElse(name, "<UNKNOWN>"));
    }

    static {
        HashMap<Integer, String> names = new HashMap<Integer, String>();
        for (Field field : KeyEvent.class.getFields()) {
            if (field.getType() != Integer.TYPE || !Modifier.isPublic(field.getModifiers()) || !Modifier.isFinal(field.getModifiers()) || !Modifier.isStatic(field.getModifiers()) || !field.getName().startsWith("VK_")) continue;
            String name = field.getName().substring(3);
            try {
                int code = field.getInt(null);
                names.put(code, name);
            }
            catch (Exception ex) {
                throw new Error("Unexpected error during key event code extraction: " + String.valueOf(field), ex);
            }
        }
        KEY_NAMES = Collections.unmodifiableMap(names);
    }
}

