/*
 * Decompiled with CFR 0.152.
 */
package com.igormaznitsa.zxpoly.utils;

import com.igormaznitsa.zxpoly.components.BoardMode;
import com.igormaznitsa.zxpoly.components.sound.VolumeProfile;
import com.igormaznitsa.zxpoly.components.video.BorderWidth;
import com.igormaznitsa.zxpoly.components.video.VirtualKeyboardLook;
import com.igormaznitsa.zxpoly.components.video.timings.TimingProfile;
import com.igormaznitsa.zxpoly.ui.FastButton;
import com.igormaznitsa.zxpoly.utils.FilePlainPreferences;
import java.io.File;
import java.io.IOException;
import java.net.InetAddress;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.prefs.BackingStoreException;
import java.util.prefs.Preferences;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.swing.UIManager;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.SystemUtils;

public final class AppOptions {
    public static final String TEST_ROM = "zxpolytest.prom";
    private static final Logger LOGGER = Logger.getLogger(AppOptions.class.getName());
    private static final AtomicReference<AppOptions> INSTANCE = new AtomicReference();
    private static final String APP_FOLDER_NAME = ".zxpolyemul";
    private static volatile File forceFile;
    private final Preferences preferences;
    private final Lock locker = new ReentrantLock();

    private AppOptions(File forceFile) {
        if (forceFile == null) {
            LOGGER.log(Level.CONFIG, "Creating options for system provided store");
            this.preferences = Preferences.userNodeForPackage(AppOptions.class);
        } else {
            try {
                LOGGER.log(Level.CONFIG, "Creating options for force file: " + String.valueOf(forceFile));
                this.preferences = new FilePlainPreferences("zxpoly-emulator", forceFile, true);
            }
            catch (IOException ex) {
                throw new Error("Can't create file preferences", ex);
            }
        }
    }

    public static void setForceFile(File file) {
        forceFile = file;
    }

    public static AppOptions getInstance() {
        AppOptions newInstance;
        AppOptions result = INSTANCE.get();
        if (result == null && INSTANCE.compareAndSet(null, newInstance = new AppOptions(forceFile))) {
            result = newInstance;
        }
        return result;
    }

    public String getActiveRom() {
        this.locker.lock();
        try {
            String string = this.preferences.get(Option.ROMPATH.name(), TEST_ROM);
            return string;
        }
        finally {
            this.locker.unlock();
        }
    }

    public void setActiveRom(String romPath) {
        this.locker.lock();
        try {
            this.preferences.put(Option.ROMPATH.name(), romPath);
        }
        finally {
            this.locker.unlock();
        }
    }

    public boolean isLpfActive() {
        this.locker.lock();
        try {
            boolean bl = this.preferences.getBoolean(Option.LPF_ACTIVE.name(), false);
            return bl;
        }
        finally {
            this.locker.unlock();
        }
    }

    public void setLpfActive(boolean value) {
        this.locker.lock();
        try {
            this.preferences.putBoolean(Option.LPF_ACTIVE.name(), value);
        }
        finally {
            this.locker.unlock();
        }
    }

    public int getLpfValue() {
        this.locker.lock();
        try {
            int n = Math.min(100, Math.max(0, this.preferences.getInt(Option.LPF_VALUE.name(), 20)));
            return n;
        }
        finally {
            this.locker.unlock();
        }
    }

    public void setLpfValue(int value) {
        this.locker.lock();
        try {
            this.preferences.putInt(Option.LPF_VALUE.name(), value);
        }
        finally {
            this.locker.unlock();
        }
    }

    public boolean isTestRomActive() {
        this.locker.lock();
        try {
            boolean bl = TEST_ROM.equals(this.getActiveRom());
            return bl;
        }
        finally {
            this.locker.unlock();
        }
    }

    public String getLastSelectedAudioDevice() {
        this.locker.lock();
        try {
            String string = this.preferences.get(Option.LAST_SELECTED_AUDIO_DEVICE.name(), null);
            return string;
        }
        finally {
            this.locker.unlock();
        }
    }

    public void setLastSelectedAudioDevice(String device) {
        this.locker.lock();
        try {
            this.preferences.put(Option.LAST_SELECTED_AUDIO_DEVICE.name(), device);
        }
        finally {
            this.locker.unlock();
        }
    }

    public boolean getAutoCsForCursorKeys() {
        this.locker.lock();
        try {
            boolean bl = this.preferences.getBoolean(Option.AUTOCS_FOR_CURSOR_KEYS.name(), true);
            return bl;
        }
        finally {
            this.locker.unlock();
        }
    }

    public void setAutoCsForCursorKeys(boolean flag) {
        this.locker.lock();
        try {
            this.preferences.putBoolean(Option.AUTOCS_FOR_CURSOR_KEYS.name(), flag);
        }
        finally {
            this.locker.unlock();
        }
    }

    public boolean isUlaPlus() {
        this.locker.lock();
        try {
            boolean bl = this.preferences.getBoolean(Option.ULAPLUS.name(), false);
            return bl;
        }
        finally {
            this.locker.unlock();
        }
    }

    public void setUlaPlus(boolean flag) {
        this.locker.lock();
        try {
            this.preferences.putBoolean(Option.ULAPLUS.name(), flag);
        }
        finally {
            this.locker.unlock();
        }
    }

    public boolean isOldColorTvOnStart() {
        this.locker.lock();
        try {
            boolean bl = this.preferences.getBoolean(Option.OLD_COLOR_TV_ON_START.name(), false);
            return bl;
        }
        finally {
            this.locker.unlock();
        }
    }

    public void setOldColorTvOnStart(boolean flag) {
        this.locker.lock();
        try {
            this.preferences.putBoolean(Option.OLD_COLOR_TV_ON_START.name(), flag);
        }
        finally {
            this.locker.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public VirtualKeyboardLook getKeyboardLook() {
        this.locker.lock();
        try {
            VirtualKeyboardLook result = VirtualKeyboardLook.DEFAULT;
            String name = this.preferences.get(Option.KEYBOARD_LOOK.name(), result.name());
            try {
                result = VirtualKeyboardLook.valueOf(name);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
            VirtualKeyboardLook virtualKeyboardLook = result;
            return virtualKeyboardLook;
        }
        finally {
            this.locker.unlock();
        }
    }

    public void setKeyboardLook(VirtualKeyboardLook look) {
        this.locker.lock();
        try {
            this.preferences.put(Option.KEYBOARD_LOOK.name(), look.name());
        }
        finally {
            this.locker.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public VolumeProfile getVolumeProfile() {
        this.locker.lock();
        try {
            VolumeProfile result = VolumeProfile.EXPONENTIAL;
            String name = this.preferences.get(Option.VOLUME_PROFILE.name(), result.name());
            try {
                result = VolumeProfile.valueOf(name);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
            VolumeProfile volumeProfile = result;
            return volumeProfile;
        }
        finally {
            this.locker.unlock();
        }
    }

    public void setVolumeProfile(VolumeProfile volumeProfile) {
        this.locker.lock();
        try {
            this.preferences.put(Option.VOLUME_PROFILE.name(), volumeProfile.name());
        }
        finally {
            this.locker.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BorderWidth getBorderWidth() {
        this.locker.lock();
        try {
            BorderWidth result = BorderWidth.FULL;
            String name = this.preferences.get(Option.BORDER_WIDTH.name(), result.name());
            try {
                result = BorderWidth.valueOf(name);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
            BorderWidth borderWidth = result;
            return borderWidth;
        }
        finally {
            this.locker.unlock();
        }
    }

    public void setBorderWidth(BorderWidth value) {
        this.locker.lock();
        try {
            this.preferences.put(Option.BORDER_WIDTH.name(), value.name());
        }
        finally {
            this.locker.unlock();
        }
    }

    public String getCustomRomPath() {
        this.locker.lock();
        try {
            String string = this.preferences.get(Option.CUSTOM_ROM_PATH.name(), null);
            return string;
        }
        finally {
            this.locker.unlock();
        }
    }

    public void setCustomRomPath(String path) {
        this.locker.lock();
        try {
            if (path == null || path.trim().isEmpty()) {
                this.preferences.remove(Option.CUSTOM_ROM_PATH.name());
            } else {
                this.preferences.put(Option.CUSTOM_ROM_PATH.name(), path);
            }
        }
        finally {
            this.locker.unlock();
        }
    }

    public String getAddress() {
        this.locker.lock();
        try {
            String string = this.preferences.get(Option.STREAM_ADDR.name(), InetAddress.getLoopbackAddress().getHostAddress());
            return string;
        }
        finally {
            this.locker.unlock();
        }
    }

    public void setAddress(String address) {
        this.locker.lock();
        try {
            this.preferences.put(Option.STREAM_ADDR.name(), address == null ? InetAddress.getLoopbackAddress().getHostAddress() : address);
        }
        finally {
            this.locker.unlock();
        }
    }

    public int getPort() {
        this.locker.lock();
        try {
            int n = this.preferences.getInt(Option.STREAM_PORT.name(), 0);
            return n;
        }
        finally {
            this.locker.unlock();
        }
    }

    public void setPort(int port) {
        this.locker.lock();
        try {
            this.preferences.putInt(Option.STREAM_PORT.name(), port & 0xFFFF);
        }
        finally {
            this.locker.unlock();
        }
    }

    public boolean isTurboSound() {
        this.locker.lock();
        try {
            boolean bl = this.preferences.getBoolean(Option.TURBOSOUND.name(), false);
            return bl;
        }
        finally {
            this.locker.unlock();
        }
    }

    public void setTurboSound(boolean value) {
        this.locker.lock();
        try {
            this.preferences.putBoolean(Option.TURBOSOUND.name(), value);
        }
        finally {
            this.locker.unlock();
        }
    }

    public boolean isSoundTurnedOn() {
        this.locker.lock();
        try {
            boolean bl = this.preferences.getBoolean(Option.SOUND_TURNED_ON.name(), false);
            return bl;
        }
        finally {
            this.locker.unlock();
        }
    }

    public void setSoundTurnedOn(boolean value) {
        this.locker.lock();
        try {
            this.preferences.putBoolean(Option.SOUND_TURNED_ON.name(), value);
        }
        finally {
            this.locker.unlock();
        }
    }

    public boolean isInterlacedScan() {
        this.locker.lock();
        try {
            boolean bl = this.preferences.getBoolean(Option.INTERLACED_SCAN.name(), false);
            return bl;
        }
        finally {
            this.locker.unlock();
        }
    }

    public void setInterlacedScan(boolean value) {
        this.locker.lock();
        try {
            this.preferences.putBoolean(Option.INTERLACED_SCAN.name(), value);
        }
        finally {
            this.locker.unlock();
        }
    }

    public boolean isTryLessResources() {
        this.locker.lock();
        try {
            boolean bl = this.preferences.getBoolean(Option.TRY_LESS_RESOURCES.name(), false);
            return bl;
        }
        finally {
            this.locker.unlock();
        }
    }

    public void setTryLessResources(boolean value) {
        this.locker.lock();
        try {
            this.preferences.putBoolean(Option.TRY_LESS_RESOURCES.name(), value);
        }
        finally {
            this.locker.unlock();
        }
    }

    public int getFrameRate() {
        this.locker.lock();
        try {
            int n = this.preferences.getInt(Option.STREAM_FRAMERATE.name(), 25);
            return n;
        }
        finally {
            this.locker.unlock();
        }
    }

    public void setFrameRate(int value) {
        this.locker.lock();
        try {
            this.preferences.putInt(Option.STREAM_FRAMERATE.name(), Math.max(1, Math.min(50, value)));
        }
        finally {
            this.locker.unlock();
        }
    }

    public String getFfmpegPath() {
        this.locker.lock();
        try {
            String string = this.preferences.get(Option.STREAM_FFMPEGPATH.name(), SystemUtils.IS_OS_WINDOWS ? "ffmpeg.exe" : "ffmpeg");
            return string;
        }
        finally {
            this.locker.unlock();
        }
    }

    public void setFfmpegPath(String path) {
        this.locker.lock();
        try {
            this.preferences.put(Option.STREAM_FFMPEGPATH.name(), path == null ? (SystemUtils.IS_OS_WINDOWS ? "ffmpeg.exe" : "ffmpeg") : path);
        }
        finally {
            this.locker.unlock();
        }
    }

    public boolean isGrabSound() {
        this.locker.lock();
        try {
            boolean bl = this.preferences.getBoolean(Option.STREAM_GRABSOUND.name(), false);
            return bl;
        }
        finally {
            this.locker.unlock();
        }
    }

    public void setGrabSound(boolean value) {
        this.locker.lock();
        try {
            this.preferences.putBoolean(Option.STREAM_GRABSOUND.name(), value);
        }
        finally {
            this.locker.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TimingProfile getTimingProfile() {
        this.locker.lock();
        try {
            String timing = this.preferences.get(Option.TIMING_PROFILE.name(), TimingProfile.PENTAGON128.name());
            try {
                TimingProfile timingProfile = TimingProfile.valueOf(timing);
                return timingProfile;
            }
            catch (IllegalArgumentException ex) {
                TimingProfile timingProfile = TimingProfile.PENTAGON128;
                this.locker.unlock();
                return timingProfile;
            }
        }
        finally {
            this.locker.unlock();
        }
    }

    public void setTimingProfile(TimingProfile value) {
        this.locker.lock();
        try {
            this.preferences.put(Option.TIMING_PROFILE.name(), value.name());
        }
        finally {
            this.locker.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BoardMode getDefaultBoardMode() {
        this.locker.lock();
        try {
            String mode = this.preferences.get(Option.DEFAULT_MODE.name(), BoardMode.ZXPOLY.name());
            try {
                BoardMode boardMode = BoardMode.valueOf(mode);
                return boardMode;
            }
            catch (IllegalArgumentException ex) {
                BoardMode boardMode = BoardMode.ZXPOLY;
                this.locker.unlock();
                return boardMode;
            }
        }
        finally {
            this.locker.unlock();
        }
    }

    public void setDefaultBoardMode(BoardMode value) {
        this.locker.lock();
        try {
            this.preferences.put(Option.DEFAULT_MODE.name(), value.name());
        }
        finally {
            this.locker.unlock();
        }
    }

    public boolean isVkbdApart() {
        this.locker.lock();
        try {
            boolean bl = this.preferences.getBoolean(Option.VKBD_APART.name(), false);
            return bl;
        }
        finally {
            this.locker.unlock();
        }
    }

    public void setVkbdApart(boolean value) {
        this.locker.lock();
        try {
            this.preferences.putBoolean(Option.VKBD_APART.name(), value);
        }
        finally {
            this.locker.unlock();
        }
    }

    public boolean isAttributePortFf() {
        this.locker.lock();
        try {
            boolean bl = this.preferences.getBoolean(Option.ATTRIBUTE_PORT_FF.name(), true);
            return bl;
        }
        finally {
            this.locker.unlock();
        }
    }

    public void setAttributePortFf(boolean value) {
        this.locker.lock();
        try {
            this.preferences.putBoolean(Option.ATTRIBUTE_PORT_FF.name(), value);
        }
        finally {
            this.locker.unlock();
        }
    }

    public String getUiLfClass() {
        this.locker.lock();
        try {
            String string = this.preferences.get(Option.UI_LF_CLASS.name(), UIManager.getSystemLookAndFeelClassName());
            return string;
        }
        finally {
            this.locker.unlock();
        }
    }

    public void setUiLfClass(String className) {
        this.locker.lock();
        try {
            if (className == null) {
                this.preferences.remove(Option.UI_LF_CLASS.name());
            } else {
                this.preferences.put(Option.UI_LF_CLASS.name(), className);
            }
        }
        finally {
            this.locker.unlock();
        }
    }

    public String getUiScale() {
        this.locker.lock();
        try {
            String string = this.preferences.get(Option.UI_SCALE.name(), null);
            return string;
        }
        finally {
            this.locker.unlock();
        }
    }

    public void setUiScale(String uiScale) {
        this.locker.lock();
        try {
            if (uiScale == null) {
                this.preferences.remove(Option.UI_SCALE.name());
            } else {
                this.preferences.put(Option.UI_SCALE.name(), uiScale);
            }
        }
        finally {
            this.locker.unlock();
        }
    }

    public List<FastButton> getFastButtons() {
        this.locker.lock();
        try {
            String buttons = this.preferences.get(Option.FAST_BUTTONS.name(), null);
            if (buttons == null) {
                List<FastButton> list = List.of();
                return list;
            }
            List<FastButton> list = Arrays.stream(buttons.split(",")).flatMap(x -> {
                try {
                    return Stream.of(FastButton.valueOf(x.trim().toUpperCase(Locale.ENGLISH)));
                }
                catch (IllegalArgumentException ex) {
                    return Stream.empty();
                }
            }).filter(FastButton::isOptional).distinct().collect(Collectors.toList());
            return list;
        }
        finally {
            this.locker.unlock();
        }
    }

    public void setFastButtons(List<FastButton> fastButtons) {
        this.locker.lock();
        try {
            String packetValue = fastButtons.stream().filter(FastButton::isOptional).distinct().map(Enum::name).collect(Collectors.joining(","));
            this.preferences.put(Option.FAST_BUTTONS.name(), packetValue);
        }
        finally {
            this.locker.unlock();
        }
    }

    public boolean isCovoxFb() {
        this.locker.lock();
        try {
            boolean bl = this.preferences.getBoolean(Option.COVOXFB.name(), false);
            return bl;
        }
        finally {
            this.locker.unlock();
        }
    }

    public void setCovoxFb(boolean value) {
        this.locker.lock();
        try {
            this.preferences.putBoolean(Option.COVOXFB.name(), value);
        }
        finally {
            this.locker.unlock();
        }
    }

    public boolean isSyncPaint() {
        this.locker.lock();
        try {
            boolean bl = this.preferences.getBoolean(Option.SYNC_PAINT.name(), false);
            return bl;
        }
        finally {
            this.locker.unlock();
        }
    }

    public void setSyncPaint(boolean value) {
        this.locker.lock();
        try {
            this.preferences.putBoolean(Option.SYNC_PAINT.name(), value);
        }
        finally {
            this.locker.unlock();
        }
    }

    public boolean isShowIndicatorPanel() {
        this.locker.lock();
        try {
            boolean bl = this.preferences.getBoolean(Option.SHOW_INDICATOR_PANEL.name(), true);
            return bl;
        }
        finally {
            this.locker.unlock();
        }
    }

    public void setShowIndicatorPanel(boolean value) {
        this.locker.lock();
        try {
            this.preferences.putBoolean(Option.SHOW_INDICATOR_PANEL.name(), value);
        }
        finally {
            this.locker.unlock();
        }
    }

    public boolean isSoundChannelsACB() {
        this.locker.lock();
        try {
            boolean bl = this.preferences.getBoolean(Option.SOUND_CHANNELS_ACB.name(), false);
            return bl;
        }
        finally {
            this.locker.unlock();
        }
    }

    public void setSoundChannelsACB(boolean value) {
        this.locker.lock();
        try {
            this.preferences.putBoolean(Option.SOUND_CHANNELS_ACB.name(), value);
        }
        finally {
            this.locker.unlock();
        }
    }

    public boolean isKempstonMouseAllowed() {
        this.locker.lock();
        try {
            boolean bl = this.preferences.getBoolean(Option.KEMPSTON_MOUSE_ALLOWED.name(), true);
            return bl;
        }
        finally {
            this.locker.unlock();
        }
    }

    public void setKempstonMouseAllowed(boolean value) {
        this.locker.lock();
        try {
            this.preferences.putBoolean(Option.KEMPSTON_MOUSE_ALLOWED.name(), value);
        }
        finally {
            this.locker.unlock();
        }
    }

    public int getIntBetweenFrames() {
        this.locker.lock();
        try {
            int n = this.preferences.getInt(Option.INTBETWEENFRAMES.name(), 2);
            return n;
        }
        finally {
            this.locker.unlock();
        }
    }

    public void setIntBetweenFrames(int value) {
        this.locker.lock();
        try {
            this.preferences.putInt(Option.INTBETWEENFRAMES.name(), Math.max(0, value));
        }
        finally {
            this.locker.unlock();
        }
    }

    public int getCursorJoystickDown() {
        this.locker.lock();
        try {
            int n = this.preferences.getInt(Option.PROTEK_JOYSTICK_VK_DOWN.name(), 40);
            return n;
        }
        finally {
            this.locker.unlock();
        }
    }

    public void setProtekJoystickDown(int keyCode) {
        this.locker.lock();
        try {
            this.preferences.putInt(Option.PROTEK_JOYSTICK_VK_DOWN.name(), keyCode);
        }
        finally {
            this.locker.unlock();
        }
    }

    public int getProtekJoystickUp() {
        this.locker.lock();
        try {
            int n = this.preferences.getInt(Option.PROTEK_JOYSTICK_VK_UP.name(), 38);
            return n;
        }
        finally {
            this.locker.unlock();
        }
    }

    public void setProtekJoystickUp(int keyCode) {
        this.locker.lock();
        try {
            this.preferences.putInt(Option.PROTEK_JOYSTICK_VK_UP.name(), keyCode);
        }
        finally {
            this.locker.unlock();
        }
    }

    public int getProtekJoystickLeft() {
        this.locker.lock();
        try {
            int n = this.preferences.getInt(Option.PROTEK_JOYSTICK_VK_LEFT.name(), 37);
            return n;
        }
        finally {
            this.locker.unlock();
        }
    }

    public void setProtekJoystickLeft(int keyCode) {
        this.locker.lock();
        try {
            this.preferences.putInt(Option.PROTEK_JOYSTICK_VK_LEFT.name(), keyCode);
        }
        finally {
            this.locker.unlock();
        }
    }

    public int getProtekJoystickRight() {
        this.locker.lock();
        try {
            int n = this.preferences.getInt(Option.PROTEK_JOYSTICK_VK_RIGHT.name(), 39);
            return n;
        }
        finally {
            this.locker.unlock();
        }
    }

    public void setProtekJoystickRight(int keyCode) {
        this.locker.lock();
        try {
            this.preferences.putInt(Option.PROTEK_JOYSTICK_VK_RIGHT.name(), keyCode);
        }
        finally {
            this.locker.unlock();
        }
    }

    public int getProtekJoystickFire() {
        this.locker.lock();
        try {
            int n = this.preferences.getInt(Option.PROTEK_JOYSTICK_VK_FIRE.name(), 9);
            return n;
        }
        finally {
            this.locker.unlock();
        }
    }

    public void setProtekJoystickFire(int keyCode) {
        this.locker.lock();
        try {
            this.preferences.putInt(Option.PROTEK_JOYSTICK_VK_FIRE.name(), keyCode);
        }
        finally {
            this.locker.unlock();
        }
    }

    public int getKempstonVkLeft() {
        this.locker.lock();
        try {
            int n = this.preferences.getInt(Option.KEMPSTON_VK_LEFT.name(), 100);
            return n;
        }
        finally {
            this.locker.unlock();
        }
    }

    public void setKempstonVkLeft(int keyCode) {
        this.locker.lock();
        try {
            this.preferences.putInt(Option.KEMPSTON_VK_LEFT.name(), keyCode);
        }
        finally {
            this.locker.unlock();
        }
    }

    public int getKempstonVkRight() {
        this.locker.lock();
        try {
            int n = this.preferences.getInt(Option.KEMPSTON_VK_RIGHT.name(), 102);
            return n;
        }
        finally {
            this.locker.unlock();
        }
    }

    public void setKempstonVkRight(int keyCode) {
        this.locker.lock();
        try {
            this.preferences.putInt(Option.KEMPSTON_VK_RIGHT.name(), keyCode);
        }
        finally {
            this.locker.unlock();
        }
    }

    public int getKempstonVkUp() {
        this.locker.lock();
        try {
            int n = this.preferences.getInt(Option.KEMPSTON_VK_UP.name(), 104);
            return n;
        }
        finally {
            this.locker.unlock();
        }
    }

    public void setKempstonVkUp(int keyCode) {
        this.locker.lock();
        try {
            this.preferences.putInt(Option.KEMPSTON_VK_UP.name(), keyCode);
        }
        finally {
            this.locker.unlock();
        }
    }

    public int getKempstonVkDown() {
        this.locker.lock();
        try {
            int n = this.preferences.getInt(Option.KEMPSTON_VK_DOWN.name(), 98);
            return n;
        }
        finally {
            this.locker.unlock();
        }
    }

    public void setKempstonVkDown(int keyCode) {
        this.locker.lock();
        try {
            this.preferences.putInt(Option.KEMPSTON_VK_DOWN.name(), keyCode);
        }
        finally {
            this.locker.unlock();
        }
    }

    public int getKempstonVkFire() {
        this.locker.lock();
        try {
            int n = this.preferences.getInt(Option.KEMPSTON_VK_FIRE.name(), 101);
            return n;
        }
        finally {
            this.locker.unlock();
        }
    }

    public void setKempstonVkFire(int keyCode) {
        this.locker.lock();
        try {
            this.preferences.putInt(Option.KEMPSTON_VK_FIRE.name(), keyCode);
        }
        finally {
            this.locker.unlock();
        }
    }

    public void flush() throws BackingStoreException {
        this.locker.lock();
        try {
            this.preferences.flush();
        }
        finally {
            this.locker.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public File getAppConfigFolder() {
        this.locker.lock();
        try {
            File configFolder;
            String folder = System.getenv("APPDATA");
            if (folder == null) {
                folder = System.getProperty("user.home", FileUtils.getTempDirectoryPath());
            }
            if (!(configFolder = new File(folder, APP_FOLDER_NAME)).exists()) {
                if (configFolder.mkdirs()) {
                    LOGGER.info("Created config folder: " + String.valueOf(configFolder));
                } else {
                    LOGGER.warning("Can't create config folder: " + String.valueOf(configFolder));
                }
            }
            File file = configFolder;
            return file;
        }
        finally {
            this.locker.unlock();
        }
    }

    public File getRomCacheFolder() {
        return new File(this.getAppConfigFolder(), "cache");
    }

    public static enum Option {
        LPF_ACTIVE,
        LPF_VALUE,
        BORDER_WIDTH,
        TIMING_PROFILE,
        SYNC_PAINT,
        SHOW_INDICATOR_PANEL,
        FAST_BUTTONS,
        VOLUME_PROFILE,
        UI_LF_CLASS,
        UI_SCALE,
        OLD_COLOR_TV_ON_START,
        INTERLACED_SCAN,
        AUTOCS_FOR_CURSOR_KEYS,
        CUSTOM_ROM_PATH,
        STREAM_FFMPEGPATH,
        STREAM_GRABSOUND,
        STREAM_ADDR,
        STREAM_PORT,
        STREAM_FRAMERATE,
        DEFAULT_MODE,
        SOUND_CHANNELS_ACB,
        ROMPATH,
        COVOXFB,
        TURBOSOUND,
        INTBETWEENFRAMES,
        LAST_SELECTED_AUDIO_DEVICE,
        SOUND_TURNED_ON,
        VKBD_APART,
        KEYBOARD_LOOK,
        KEMPSTON_MOUSE_ALLOWED,
        KEMPSTON_VK_LEFT,
        KEMPSTON_VK_RIGHT,
        KEMPSTON_VK_UP,
        KEMPSTON_VK_DOWN,
        KEMPSTON_VK_FIRE,
        PROTEK_JOYSTICK_VK_LEFT,
        PROTEK_JOYSTICK_VK_RIGHT,
        PROTEK_JOYSTICK_VK_UP,
        PROTEK_JOYSTICK_VK_DOWN,
        PROTEK_JOYSTICK_VK_FIRE,
        ATTRIBUTE_PORT_FF,
        ULAPLUS,
        TRY_LESS_RESOURCES;

    }
}

