/*
 * Decompiled with CFR 0.152.
 */
package com.igormaznitsa.zxpoly.utils;

import com.igormaznitsa.zxpoly.components.RomData;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.Locale;
import java.util.Set;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import org.apache.commons.compress.archivers.ArchiveEntry;
import org.apache.commons.compress.archivers.ArchiveInputStream;
import org.apache.commons.compress.archivers.ar.ArArchiveInputStream;
import org.apache.commons.compress.archivers.tar.TarArchiveInputStream;
import org.apache.commons.compress.archivers.zip.ZipArchiveInputStream;
import org.apache.commons.compress.compressors.gzip.GzipCompressorInputStream;
import org.apache.commons.compress.compressors.xz.XZCompressorInputStream;
import org.apache.commons.io.IOUtils;
import org.apache.commons.net.ftp.FTPClient;
import org.apache.commons.net.ftp.FTPReply;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.protocol.HttpClientContext;
import org.apache.http.config.Registry;
import org.apache.http.config.RegistryBuilder;
import org.apache.http.conn.socket.ConnectionSocketFactory;
import org.apache.http.conn.socket.PlainConnectionSocketFactory;
import org.apache.http.conn.ssl.NoopHostnameVerifier;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.conn.BasicHttpClientConnectionManager;

public class RomLoader {
    static byte[] loadHTTPArchive(String url) throws IOException {
        SSLContext sslcontext;
        try {
            sslcontext = SSLContext.getInstance("TLS");
        }
        catch (NoSuchAlgorithmException ex) {
            throw new IOException("Can't find TLS: " + ex.getMessage());
        }
        X509TrustManager tm = new X509TrustManager(){

            @Override
            public X509Certificate[] getAcceptedIssuers() {
                return null;
            }

            @Override
            public void checkClientTrusted(X509Certificate[] arg0, String arg1) throws CertificateException {
            }

            @Override
            public void checkServerTrusted(X509Certificate[] arg0, String arg1) throws CertificateException {
            }
        };
        try {
            sslcontext.init(null, new TrustManager[]{tm}, null);
        }
        catch (KeyManagementException ex) {
            throw new IOException("Can't init ssl context: " + ex.getMessage());
        }
        SSLConnectionSocketFactory sslfactory = new SSLConnectionSocketFactory(sslcontext, (HostnameVerifier)NoopHostnameVerifier.INSTANCE);
        Registry<ConnectionSocketFactory> registry = RegistryBuilder.create().register("https", sslfactory).register("http", (SSLConnectionSocketFactory)((Object)new PlainConnectionSocketFactory())).build();
        CloseableHttpClient client = HttpClientBuilder.create().setUserAgent("zx-poly-emulator/2.0").disableCookieManagement().setConnectionManager(new BasicHttpClientConnectionManager(registry)).setSSLSocketFactory(sslfactory).setSSLContext(sslcontext).build();
        HttpClientContext context = HttpClientContext.create();
        HttpGet get = new HttpGet(url);
        get.setConfig(RequestConfig.copy(RequestConfig.DEFAULT).setAuthenticationEnabled(false).setRedirectsEnabled(true).setRelativeRedirectsAllowed(true).setConnectTimeout(2000).setSocketTimeout(2000).build());
        HttpResponse response = client.execute((HttpUriRequest)get, context);
        if (response.getStatusLine().getStatusCode() == 200) {
            HttpEntity entity = response.getEntity();
            try (InputStream in = entity.getContent();){
                byte[] byArray = entity.getContentLength() < 0L ? IOUtils.toByteArray(in) : IOUtils.toByteArray(in, entity.getContentLength());
                return byArray;
            }
        }
        throw new IOException("Can't download from http '" + url + "' code [" + url + "]");
    }

    static byte[] loadFTPArchive(String host, String path, String name, String password) throws IOException {
        FTPClient client = new FTPClient();
        client.connect(host);
        int replyCode = client.getReplyCode();
        if (FTPReply.isPositiveCompletion(replyCode)) {
            try {
                client.login(name == null ? "" : name, password == null ? "" : password);
                client.setFileType(2);
                client.enterLocalPassiveMode();
                ByteArrayOutputStream out = new ByteArrayOutputStream(300000);
                if (client.retrieveFile(path, out)) {
                    byte[] byArray = out.toByteArray();
                    return byArray;
                }
                throw new IOException("Can't load file 'ftp://" + host + path + "' status=" + client.getReplyCode());
            }
            finally {
                client.disconnect();
            }
        }
        client.disconnect();
        throw new IOException("Can't connect to ftp '" + host + "'");
    }

    private static RomData extractFromTarGz(String url, Set<String> rom48names, Set<String> rom128names, Set<String> trdosNames, byte[] archive) throws IOException {
        try (TarArchiveInputStream archiveStream = new TarArchiveInputStream(new GzipCompressorInputStream(new ByteArrayInputStream(archive)));){
            RomData romData = RomLoader.extractFromArchive(url, rom48names, rom128names, trdosNames, archiveStream);
            return romData;
        }
    }

    private static RomData extractFromTarXz(String url, Set<String> rom48names, Set<String> rom128names, Set<String> trdosNames, byte[] archive) throws IOException {
        try (TarArchiveInputStream archiveStream = new TarArchiveInputStream(new XZCompressorInputStream(new ByteArrayInputStream(archive)));){
            RomData romData = RomLoader.extractFromArchive(url, rom48names, rom128names, trdosNames, archiveStream);
            return romData;
        }
    }

    private static RomData extractFromDeb(String url, Set<String> rom48names, Set<String> rom128names, Set<String> trdosNames, byte[] archive) throws IOException {
        byte[] data = null;
        try (ArArchiveInputStream archiveStream = new ArArchiveInputStream(new ByteArrayInputStream(archive));){
            while (!Thread.currentThread().isInterrupted()) {
                Object entry = archiveStream.getNextEntry();
                if (entry == null) {
                } else {
                    if (!archiveStream.canReadEntryData((ArchiveEntry)entry) || entry.isDirectory() || !entry.getName().equalsIgnoreCase("data.tar.xz")) continue;
                    data = IOUtils.readFully((InputStream)archiveStream, (int)entry.getSize());
                }
                break;
            }
        }
        if (data == null) {
            throw new IOException("Can't find data.tar.xz in deb archive: " + url);
        }
        return RomLoader.extractFromTarXz(url, rom48names, rom128names, trdosNames, data);
    }

    private static RomData extractFromZip(String url, Set<String> rom48names, Set<String> rom128names, Set<String> trdosNames, byte[] archive) throws IOException {
        try (ZipArchiveInputStream archiveStream = new ZipArchiveInputStream(new ByteArrayInputStream(archive));){
            RomData romData = RomLoader.extractFromArchive(url, rom48names, rom128names, trdosNames, archiveStream);
            return romData;
        }
    }

    private static RomData extractFromArchive(String url, Set<String> rom48names, Set<String> rom128names, Set<String> trdosNames, ArchiveInputStream archiveStream) throws IOException {
        Object entry;
        byte[] rom48 = null;
        byte[] rom128 = null;
        byte[] romTrDos = null;
        while (!Thread.currentThread().isInterrupted() && (entry = archiveStream.getNextEntry()) != null) {
            int size;
            if (!archiveStream.canReadEntryData((ArchiveEntry)entry) || entry.isDirectory()) continue;
            String normalizedEntryName = entry.getName().trim().toLowerCase(Locale.ENGLISH).replace('\\', '/');
            int lastFolderChar = normalizedEntryName.lastIndexOf(47);
            if (lastFolderChar >= 0) {
                normalizedEntryName = normalizedEntryName.substring(lastFolderChar + 1);
            }
            if (rom48names.contains(normalizedEntryName)) {
                size = (int)entry.getSize();
                if (size > 16384) {
                    throw new IOException("ROM 48 has too big size");
                }
                rom48 = new byte[16384];
                IOUtils.readFully(archiveStream, rom48, 0, size);
                continue;
            }
            if (rom128names.contains(normalizedEntryName)) {
                size = (int)entry.getSize();
                if (size > 16384) {
                    throw new IOException("ROM 128 has too big size");
                }
                rom128 = new byte[16384];
                IOUtils.readFully(archiveStream, rom128, 0, size);
                continue;
            }
            if (!trdosNames.contains(normalizedEntryName)) continue;
            size = (int)entry.getSize();
            if (size > 16384) {
                throw new IOException("ROM TR-DOS has too big size");
            }
            romTrDos = new byte[16384];
            IOUtils.readFully(archiveStream, romTrDos, 0, size);
        }
        if (rom48 == null) {
            throw new IOException("Rom 48 not found");
        }
        if (rom128 == null) {
            throw new IOException("Rom 128 not found");
        }
        if (romTrDos == null) {
            return new RomData(url, rom128, rom48);
        }
        return new RomData(url, rom128, rom48, romTrDos);
    }

    public static RomData getROMFrom(String url, Set<String> rom48names, Set<String> rom128names, Set<String> trdosNames) throws IOException {
        byte[] loaded;
        String password;
        String name;
        URI uri;
        try {
            uri = new URI(url);
        }
        catch (URISyntaxException ex) {
            throw new IOException("Error in URL '" + url + "'", ex);
        }
        String scheme = uri.getScheme();
        String userInfo = uri.getUserInfo();
        if (userInfo != null) {
            String[] splitted = userInfo.split("\\:", -1);
            name = splitted[0];
            password = splitted[1];
        } else {
            name = null;
            password = null;
        }
        if (scheme.startsWith("http")) {
            loaded = RomLoader.loadHTTPArchive(url);
        } else if (scheme.startsWith("ftp")) {
            loaded = RomLoader.loadFTPArchive(uri.getHost(), uri.getPath(), name, password);
        } else {
            throw new IllegalArgumentException("Unsupported scheme [" + scheme + "]");
        }
        String resourceInLowerCase = url.trim().toLowerCase(Locale.ENGLISH);
        if (resourceInLowerCase.endsWith(".zip")) {
            return RomLoader.extractFromZip(url, rom48names, rom128names, trdosNames, loaded);
        }
        if (resourceInLowerCase.endsWith(".tar.gz")) {
            return RomLoader.extractFromTarGz(url, rom48names, rom128names, trdosNames, loaded);
        }
        if (resourceInLowerCase.endsWith(".deb")) {
            return RomLoader.extractFromDeb(url, rom48names, rom128names, trdosNames, loaded);
        }
        throw new IOException("Can't process resource extension: " + url);
    }
}

