/*
 * Decompiled with CFR 0.152.
 */
package com.igormaznitsa.zxpoly.utils;

import java.awt.Component;
import java.awt.Desktop;
import java.awt.Dialog;
import java.awt.Window;
import java.awt.event.HierarchyEvent;
import java.awt.event.HierarchyListener;
import java.awt.image.BufferedImage;
import java.io.Closeable;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.logging.Logger;
import javax.imageio.ImageIO;
import javax.swing.SwingUtilities;
import org.apache.commons.lang3.SystemUtils;

public final class Utils {
    public static final Logger LOGGER = Logger.getLogger(Utils.class.getName());

    private Utils() {
    }

    public static String extractMessage(Throwable throwable) {
        if (throwable == null) {
            return "NONE";
        }
        if (throwable.getCause() != null) {
            return Utils.extractMessage(throwable.getCause());
        }
        String message = throwable.getMessage();
        if (message == null) {
            message = throwable.getClass().getCanonicalName();
        }
        return message;
    }

    public static void makeOwningDialogResizable(final Component component, final Runnable ... extraActions) {
        HierarchyListener listener = new HierarchyListener(){

            @Override
            public void hierarchyChanged(HierarchyEvent e) {
                Dialog dialog;
                Window window = SwingUtilities.getWindowAncestor(component);
                if (window instanceof Dialog && !(dialog = (Dialog)window).isResizable()) {
                    dialog.setResizable(true);
                    component.removeHierarchyListener(this);
                    for (Runnable r : extraActions) {
                        r.run();
                    }
                }
            }
        };
        component.addHierarchyListener(listener);
    }

    public static void browseLink(URL url) {
        if (Desktop.isDesktopSupported()) {
            Desktop desktop = Desktop.getDesktop();
            if (desktop.isSupported(Desktop.Action.BROWSE)) {
                try {
                    desktop.browse(url.toURI());
                }
                catch (Exception x) {
                    LOGGER.warning("Can't browse URL in Desktop: " + x.getMessage());
                }
            } else if (SystemUtils.IS_OS_LINUX) {
                Runtime runtime = Runtime.getRuntime();
                try {
                    runtime.exec("xdg-open " + String.valueOf(url));
                }
                catch (IOException e) {
                    LOGGER.warning("Can't browse URL under Linux: " + e.getMessage());
                }
            } else if (SystemUtils.IS_OS_MAC) {
                Runtime runtime = Runtime.getRuntime();
                try {
                    runtime.exec("open " + String.valueOf(url));
                }
                catch (IOException e) {
                    LOGGER.warning("Can't browse URL on MAC: " + e.getMessage());
                }
            }
        }
    }

    public static void closeQuietly(Closeable closeable) {
        if (closeable != null) {
            try {
                closeable.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public static int[] alignPaletteColors(int[] dstPalette, int[] etalPalette) {
        int[] result = (int[])dstPalette.clone();
        for (int i = 0; i < result.length; ++i) {
            int r = result[i] >>> 16 & 0xFF;
            int g = result[i] >>> 8 & 0xFF;
            int b = result[i] & 0xFF;
            double dist = Double.MAX_VALUE;
            for (int value : etalPalette) {
                int rr = value >>> 16 & 0xFF;
                int gg = value >>> 8 & 0xFF;
                int bb = value & 0xFF;
                double cdist = Math.sqrt(Math.pow((double)rr - (double)r, 2.0) + Math.pow((double)gg - (double)g, 2.0) + Math.pow((double)bb - (double)b, 2.0));
                if (!(cdist < dist)) continue;
                dist = cdist;
                result[i] = value;
            }
        }
        return result;
    }

    public static int[] readRawPalette(InputStream in, boolean close) {
        int[] result = new int[256];
        try {
            for (int i = 0; i < 256; ++i) {
                int red = in.read();
                int green = in.read();
                int blue = in.read();
                if (red < 0 || green < 0 || blue < 0) {
                    throw new EOFException();
                }
                result[i] = 0xFF000000 | red << 16 | green << 8 | blue;
            }
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
        finally {
            if (close) {
                try {
                    in.close();
                }
                catch (Exception exception) {}
            }
        }
        return result;
    }

    public static void assertUiThread() {
        if (!SwingUtilities.isEventDispatchThread()) {
            throw new Error("Detected call from outside of event dispatch thread!");
        }
    }

    public static void safeSwingCall(Runnable runnable) {
        if (runnable != null) {
            if (SwingUtilities.isEventDispatchThread()) {
                runnable.run();
            } else {
                SwingUtilities.invokeLater(runnable);
            }
        }
    }

    public static BufferedImage loadIcon(String name) {
        BufferedImage bufferedImage;
        block8: {
            InputStream resource = Utils.findResourceOrError("com/igormaznitsa/zxpoly/icons/" + name);
            try {
                bufferedImage = ImageIO.read(resource);
                if (resource == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (resource != null) {
                        try {
                            resource.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException ex) {
                    throw new Error("Can't read resource icon [" + name + "]");
                }
            }
            resource.close();
        }
        return bufferedImage;
    }

    public static int minimalRequiredBitsFor(int number) {
        int r = 0;
        while ((number >>>= 1) != 0) {
            ++r;
        }
        return r + 1;
    }

    public static InputStream findResourceOrError(String resource) {
        InputStream result = Utils.class.getClassLoader().getResourceAsStream(resource);
        if (result == null) {
            throw new IllegalArgumentException("Can't find resource for path [" + resource + "]");
        }
        return result;
    }
}

