/*
 * Decompiled with CFR 0.152.
 */
package com.igormaznitsa.zxpspritecorrector;

import com.igormaznitsa.zxpspritecorrector.AboutDialog;
import com.igormaznitsa.zxpspritecorrector.ContextProvider;
import com.igormaznitsa.zxpspritecorrector.NewDataDialog;
import com.igormaznitsa.zxpspritecorrector.components.CpuRegProperties;
import com.igormaznitsa.zxpspritecorrector.components.CpuSnapshotParamsEditor;
import com.igormaznitsa.zxpspritecorrector.components.EditorComponent;
import com.igormaznitsa.zxpspritecorrector.components.InsideFileView;
import com.igormaznitsa.zxpspritecorrector.components.PenWidth;
import com.igormaznitsa.zxpspritecorrector.components.SelectInsideDataDialog;
import com.igormaznitsa.zxpspritecorrector.components.ZXColorSelector;
import com.igormaznitsa.zxpspritecorrector.components.ZXPolyData;
import com.igormaznitsa.zxpspritecorrector.files.SessionData;
import com.igormaznitsa.zxpspritecorrector.files.Spec256ConfigEditorPanel;
import com.igormaznitsa.zxpspritecorrector.files.plugins.AbstractFilePlugin;
import com.igormaznitsa.zxpspritecorrector.files.plugins.HOBETAPlugin;
import com.igormaznitsa.zxpspritecorrector.files.plugins.LegacySZEPlugin;
import com.igormaznitsa.zxpspritecorrector.files.plugins.SCLPlugin;
import com.igormaznitsa.zxpspritecorrector.files.plugins.SCRPlugin;
import com.igormaznitsa.zxpspritecorrector.files.plugins.SNAPlugin;
import com.igormaznitsa.zxpspritecorrector.files.plugins.SZEPlugin;
import com.igormaznitsa.zxpspritecorrector.files.plugins.Spec256ZipPlugin;
import com.igormaznitsa.zxpspritecorrector.files.plugins.TAPPlugin;
import com.igormaznitsa.zxpspritecorrector.files.plugins.TRDPlugin;
import com.igormaznitsa.zxpspritecorrector.files.plugins.Z80InZXPOutPlugin;
import com.igormaznitsa.zxpspritecorrector.tools.AbstractTool;
import com.igormaznitsa.zxpspritecorrector.tools.ToolButtonModel;
import com.igormaznitsa.zxpspritecorrector.tools.ToolColorizer;
import com.igormaznitsa.zxpspritecorrector.tools.ToolEraser;
import com.igormaznitsa.zxpspritecorrector.tools.ToolPencil;
import com.igormaznitsa.zxpspritecorrector.utils.GfxUtils;
import com.igormaznitsa.zxpspritecorrector.utils.TransferableImage;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GraphicsConfiguration;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.AdjustmentEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.awt.event.MouseWheelEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.io.StringReader;
import java.io.StringWriter;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Base64;
import java.util.Dictionary;
import java.util.Hashtable;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.Optional;
import java.util.Properties;
import java.util.concurrent.atomic.AtomicReference;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.prefs.Preferences;
import java.util.stream.Collectors;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.BoundedRangeModel;
import javax.swing.Box;
import javax.swing.ButtonGroup;
import javax.swing.DefaultBoundedRangeModel;
import javax.swing.GroupLayout;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JSlider;
import javax.swing.JSpinner;
import javax.swing.JToggleButton;
import javax.swing.KeyStroke;
import javax.swing.LayoutStyle;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.MenuEvent;
import javax.swing.event.MenuListener;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.picocontainer.MutablePicoContainer;
import org.picocontainer.PicoBuilder;
import org.picocontainer.PicoContainer;
import org.picocontainer.injectors.ProviderAdapter;

public final class SpriteCorrectorMainFrame
extends JFrame {
    private static final Logger LOGGER = Logger.getLogger("Sprite-Corrector");
    public static final String EXTRA_PROPERTY_DATA_ID = "spec256.config.properties";
    public static final String EXTRA_PROPERTY_OVERRIDE_CPU_DATA = "z80.override.cpu.properties";
    private static final long serialVersionUID = -5031012548284731523L;
    private static Properties lastSpec256Properties = new Properties();
    public final MutablePicoContainer container = new PicoBuilder().withAutomatic().withAnnotatedMethodInjection().withAnnotatedFieldInjection().withConstructorInjection().withCaching().build();
    final BoundedRangeModel SLIDER_ALL_MODEL = new DefaultBoundedRangeModel(32, 0, 1, 32);
    final BoundedRangeModel SLIDER_ODD_OR_EVEN_MODEL = new DefaultBoundedRangeModel(16, 0, 1, 16);
    final Dictionary<Integer, JLabel> SLIDER_ALL_LABELS;
    final Dictionary<Integer, JLabel> SLIDER_ODD_LABELS;
    final Dictionary<Integer, JLabel> SLIDER_EVEN_LABELS;
    private final Cursor CURSOR_BLANK = Toolkit.getDefaultToolkit().createCustomCursor(new BufferedImage(16, 16, 2), new Point(0, 0), "blank cursor");
    private final AtomicReference<AbstractTool> currentAbstractTool = new AtomicReference();
    private File lastOpenedFile;
    private File lastExportedFile;
    private File szeFile;
    private boolean selectAreaMode = false;
    private ButtonGroup attributesButtonGroup;
    private JToggleButton buttonLock;
    private ZXColorSelector colorSelector;
    private ButtonGroup columnModeGroup;
    private Box.Filler filler1;
    private JPanel jPanel2;
    private JScrollPane jScrollPane1;
    private JSeparator jSeparator1;
    private JPopupMenu.Separator jSeparator2;
    private JPopupMenu.Separator jSeparator3;
    private JPopupMenu.Separator jSeparator4;
    private JPopupMenu.Separator jSeparator5;
    private JPopupMenu.Separator jSeparator6;
    private JPopupMenu.Separator jSeparator7;
    private JPopupMenu.Separator jSeparator8;
    private JLabel labelAddress;
    private JLabel labelZoom;
    private EditorComponent mainEditor;
    private JPanel mainEditorPanel;
    private JMenuBar menuBar;
    private JMenu menuEdit;
    private JMenu menuView;
    private JMenu menuViewZoom;
    private JMenuItem menuViewZoomIn;
    private JMenuItem menuViewZoomOut;
    private JMenuItem menuEditClear;
    private JMenuItem menuEditCopyBaseToPlans;
    private JMenuItem menuEditCopySelectedBaseAsImage;
    private JMenuItem menuEditCopySelectedZxPolyAsImage;
    private JMenuItem menuEditPasteImage;
    private JMenuItem menuEditRedo;
    private JMenuItem menuEditSelectArea;
    private JMenuItem menuEditUndo;
    private JMenuItem menuEditEditStartParameters;
    private JMenu menuFile;
    private JMenuItem menuFileExit;
    private JMenu menuFileExportAs;
    private JMenu menuFileRecentFiles;
    private JMenuItem menuFileNew;
    private JMenuItem menuFileOpen;
    private JMenuItem menuFileSaveAs;
    private JMenu menuHelp;
    private JMenuItem menuHelpAbout;
    private JRadioButtonMenuItem menuOptionDontShowAttributes;
    private JMenu menuOptions;
    private JCheckBoxMenuItem menuOptionsColumns;
    private JRadioButtonMenuItem menuOptionsColumnsAll;
    private JRadioButtonMenuItem menuOptionsColumnsEven;
    private JRadioButtonMenuItem menuOptionsColumnsOdd;
    private JCheckBoxMenuItem menuOptionsGrid;
    private JCheckBoxMenuItem menuOptionsInvertBase;
    private JCheckBoxMenuItem menuOptionsMode512;
    private JRadioButtonMenuItem menuOptionsShow512x384Attributes;
    private JRadioButtonMenuItem menuOptionsShowBaseAttributes;
    private JCheckBoxMenuItem menuOptionsZXScreen;
    private JMenuItem menuSave;
    private JPanel panelTools;
    private JScrollBar scrollBarAddress;
    private JSlider sliderColumns;
    private PenWidth sliderPenWidth;
    private JSpinner spinnerCurrentAddress;
    private ButtonGroup toolsButtonGroup;
    private CpuRegProperties snapshotCpuOverrideValues = new CpuRegProperties();

    public SpriteCorrectorMainFrame(GraphicsConfiguration graphicsConfig, boolean standaloneApplication) {
        super(graphicsConfig);
        this.SLIDER_ALL_LABELS = new Hashtable<Integer, JLabel>();
        this.SLIDER_ODD_LABELS = new Hashtable<Integer, JLabel>();
        this.SLIDER_EVEN_LABELS = new Hashtable<Integer, JLabel>();
        int even = 1;
        int odd = 1;
        for (int i = 1; i <= 32; ++i) {
            JLabel label = new JLabel(Integer.toString(i));
            label.setFont(label.getFont().deriveFont(1));
            this.SLIDER_ALL_LABELS.put(i, label);
            if ((i & 1) == 0) {
                this.SLIDER_EVEN_LABELS.put(even++, label);
                continue;
            }
            this.SLIDER_ODD_LABELS.put(odd++, label);
        }
        this.initComponents();
        this.sliderColumns.setSnapToTicks(true);
        this.sliderColumns.setModel(this.SLIDER_ALL_MODEL);
        this.sliderColumns.setLabelTable(this.SLIDER_ALL_LABELS);
        this.sliderColumns.setValue(this.mainEditor.getColumns());
        this.container.addAdapter(new ProviderAdapter(new ContextProvider(this.container)));
        this.container.addComponent(this);
        this.container.addComponent(this.colorSelector);
        this.container.addComponent(SZEPlugin.class);
        this.container.addComponent(HOBETAPlugin.class);
        this.container.addComponent(TAPPlugin.class);
        this.container.addComponent(TRDPlugin.class);
        this.container.addComponent(SCLPlugin.class);
        this.container.addComponent(SCRPlugin.class);
        this.container.addComponent(Z80InZXPOutPlugin.class);
        this.container.addComponent(SNAPlugin.class);
        this.container.addComponent(Spec256ZipPlugin.class);
        this.container.addComponent(LegacySZEPlugin.class);
        this.container.addComponent(ToolPencil.class);
        this.container.addComponent(ToolEraser.class);
        this.container.addComponent(ToolColorizer.class);
        this.container.start();
        this.container.getComponents(AbstractTool.class).forEach(tool -> {
            this.panelTools.add((Component)tool);
            this.toolsButtonGroup.add((AbstractButton)tool);
            tool.addItemListener(e -> {
                if (e.getStateChange() == 1) {
                    this.selectAreaMode = false;
                    this.sliderPenWidth.setModel(((AbstractTool)e.getItem()).getScaleModel());
                    this.currentAbstractTool.set((AbstractTool)tool);
                } else if (e.getStateChange() == 2 && this.currentAbstractTool.compareAndSet((AbstractTool)tool, (AbstractTool)null)) {
                    this.sliderPenWidth.setModel(null);
                }
            });
        });
        this.container.getComponents(AbstractFilePlugin.class).stream().filter(AbstractFilePlugin::isExportable).forEachOrdered(p -> {
            JMenuItem menuItem = new JMenuItem(p.getPluginDescription(true));
            this.menuFileExportAs.add(menuItem);
            menuItem.setToolTipText(p.getToolTip(true));
            menuItem.addActionListener(e -> this.exportDataWithPlugin((AbstractFilePlugin)p));
        });
        this.setLocationRelativeTo(null);
        this.updateAddressScrollBar();
        this.loadStateFromSession(new SessionData(this.mainEditor));
        this.setCurrentSZEFile(null);
        this.updateBottomBar();
        this.spinnerCurrentAddress.setModel(this.mainEditor);
        this.setIconImage(GfxUtils.loadImage("ico.png"));
        for (Component j : this.menuBar.getComponents()) {
            if (!(j instanceof JMenu)) continue;
            ((JMenu)j).addMenuListener(new MenuListener(){

                @Override
                public void menuSelected(MenuEvent e) {
                    SpriteCorrectorMainFrame.this.selectAreaMode = false;
                    SpriteCorrectorMainFrame.this.toolsButtonGroup.clearSelection();
                }

                @Override
                public void menuDeselected(MenuEvent e) {
                }

                @Override
                public void menuCanceled(MenuEvent e) {
                }
            });
        }
        this.menuOptionsMode512.addActionListener(x -> {
            boolean mode512 = this.menuOptionsMode512.isSelected();
            this.container.getComponents(AbstractTool.class).forEach(t -> t.setEnabled(!mode512 || t.doesSupport512x384()));
        });
        this.resetOptions();
    }

    public static String toHex(int value) {
        String h = Integer.toHexString(value).toUpperCase(Locale.ENGLISH);
        return "#" + (String)(h.length() < 4 ? "0000".substring(0, 4 - h.length()) + h : h);
    }

    public static Properties deserializeProperties(String data) {
        if (data == null) {
            return null;
        }
        byte[] array = Base64.getDecoder().decode(data);
        Properties result = new Properties();
        try {
            result.load(new StringReader(new String(array, StandardCharsets.UTF_8)));
        }
        catch (IOException ex) {
            throw new Error("Can't load properties", ex);
        }
        return result;
    }

    private static String serializeProperties(Properties properties) {
        if (properties == null) {
            return null;
        }
        StringWriter writer = new StringWriter();
        try {
            properties.store(writer, null);
        }
        catch (IOException ex) {
            throw new Error("Can't write properties", ex);
        }
        return Base64.getEncoder().encodeToString(writer.toString().getBytes(StandardCharsets.UTF_8));
    }

    public PicoContainer getPico() {
        return this.container;
    }

    private void deactivateCheckbox(JCheckBoxMenuItem item) {
        if (item.isSelected()) {
            item.doClick();
        }
    }

    private void resetOptions() {
        this.deactivateCheckbox(this.menuOptionsMode512);
        this.deactivateCheckbox(this.menuOptionsZXScreen);
        this.spinnerCurrentAddress.setValue(0);
        this.deactivateCheckbox(this.menuOptionsGrid);
        this.deactivateCheckbox(this.menuOptionsColumns);
        this.deactivateCheckbox(this.menuOptionsInvertBase);
        this.menuOptionDontShowAttributes.doClick();
        this.menuOptionsColumnsAll.doClick();
        this.sliderColumns.setValue(32);
        this.refreshMenuAndToolState();
    }

    private void refreshMenuAndToolState() {
        this.menuEditSelectArea.setEnabled(this.mainEditor.hasData());
        this.menuEditPasteImage.setEnabled(this.mainEditor.hasData());
        this.menuEditCopySelectedBaseAsImage.setEnabled(this.mainEditor.hasSelectedArea());
        this.menuEditCopySelectedZxPolyAsImage.setEnabled(this.mainEditor.hasSelectedArea());
        boolean m512 = this.mainEditor.isMode512();
        this.container.getComponents(AbstractTool.class).forEach(t -> {
            if (m512 && !t.doesSupport512x384()) {
                t.setEnabled(false);
            }
        });
    }

    private File ensureExtension(File file, AbstractFilePlugin plugin) {
        String extension = plugin.getExtension(true);
        if (extension != null && FilenameUtils.getExtension(file.getName()).isEmpty()) {
            return new File(file.getParent(), file.getName() + "." + extension);
        }
        return file;
    }

    private void exportDataWithPlugin(AbstractFilePlugin plugin) {
        if (!this.mainEditor.hasData()) {
            JOptionPane.showMessageDialog(this, "There is no data to export!", "There is no data", 2);
            return;
        }
        JFileChooser fileChooser = new JFileChooser(this.lastExportedFile == null ? null : this.lastExportedFile.getParentFile());
        fileChooser.setAcceptAllFileFilterUsed(false);
        fileChooser.addChoosableFileFilter(plugin.getExportFileFilter());
        if (fileChooser.showSaveDialog(this) == 0) {
            this.lastExportedFile = this.ensureExtension(fileChooser.getSelectedFile(), plugin);
            try {
                if (plugin instanceof Spec256ZipPlugin) {
                    Properties properties = lastSpec256Properties;
                    Spec256ConfigEditorPanel configEditorPanel = new Spec256ConfigEditorPanel(properties);
                    if (JOptionPane.showConfirmDialog(this, configEditorPanel, "Spec256 properties", 2, -1) == 0) {
                        lastSpec256Properties = properties = configEditorPanel.make();
                        SessionData sessionDataToSave = this.makeCurrentSessionData();
                        plugin.writeTo(this.lastExportedFile, this.mainEditor.getProcessingData(), sessionDataToSave, properties);
                    }
                } else {
                    SessionData sessionDataToSave = this.makeCurrentSessionData();
                    plugin.writeTo(this.lastExportedFile, this.mainEditor.getProcessingData(), sessionDataToSave, new Object[0]);
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
                JOptionPane.showMessageDialog(this, "Can't export data for exception [" + ex.getMessage() + "]", "Error", 0);
            }
        }
    }

    private void updateBottomBar() {
        this.labelZoom.setText("x" + this.mainEditor.getZoom());
    }

    private void loadStateFromSession(SessionData sessionData) {
        int address = sessionData.getBaseAddress();
        sessionData.fill(this.mainEditor);
        this.snapshotCpuOverrideValues = new CpuRegProperties(SpriteCorrectorMainFrame.deserializeProperties(sessionData.getExtraProperty(EXTRA_PROPERTY_OVERRIDE_CPU_DATA)));
        Properties sessionSpec256Properties = Objects.requireNonNullElseGet(SpriteCorrectorMainFrame.deserializeProperties(sessionData.getExtraProperty(EXTRA_PROPERTY_DATA_ID)), Spec256ConfigEditorPanel::makeDefault);
        lastSpec256Properties.clear();
        sessionSpec256Properties.stringPropertyNames().forEach(name -> lastSpec256Properties.setProperty((String)name, sessionSpec256Properties.getProperty((String)name)));
        this.menuOptionsColumnsAll.setSelected(true);
        this.menuOptionsZXScreen.setSelected(sessionData.isZXAddressing());
        this.menuOptionsColumns.setSelected(sessionData.isShowColumns());
        this.menuOptionsGrid.setSelected(sessionData.isShowGrid());
        this.menuOptionsInvertBase.setSelected(sessionData.isInvertBaseShow());
        this.menuOptionsMode512.setSelected(sessionData.is512Mode());
        switch (sessionData.getAttributeMode()) {
            case DONT_SHOW: {
                this.menuOptionDontShowAttributes.setSelected(true);
                break;
            }
            case SHOW_BASE: {
                this.menuOptionsShowBaseAttributes.setSelected(true);
                break;
            }
            case SHOW_512x384_ZXPOLY_PLANES: {
                this.menuOptionsShow512x384Attributes.setSelected(true);
            }
        }
        this.updateAddressScrollBar();
        this.scrollBarAddress.setValue(address);
        this.menuOptionsColumnsAll.setSelected(true);
        this.mainEditor.setColumnMode(EditorComponent.ColumnMode.ALL);
        this.sliderColumns.setModel(this.SLIDER_ALL_MODEL);
        this.sliderColumns.setLabelTable(this.SLIDER_ALL_LABELS);
        this.sliderColumns.setValue(this.mainEditor.getColumns());
        this.updateBottomBar();
        this.refreshMenuAndToolState();
    }

    private void initComponents() {
        this.toolsButtonGroup = new ButtonGroup();
        this.attributesButtonGroup = new ButtonGroup();
        this.columnModeGroup = new ButtonGroup();
        this.scrollBarAddress = new JScrollBar();
        this.sliderColumns = new JSlider();
        this.buttonLock = new JToggleButton();
        this.panelTools = new JPanel();
        this.colorSelector = new ZXColorSelector();
        this.sliderPenWidth = new PenWidth();
        this.jScrollPane1 = new JScrollPane();
        this.mainEditorPanel = new JPanel();
        this.mainEditor = new EditorComponent();
        this.jPanel2 = new JPanel();
        this.labelZoom = new JLabel();
        this.filler1 = new Box.Filler(new Dimension(0, 0), new Dimension(0, 0), new Dimension(Short.MAX_VALUE, 0));
        this.labelAddress = new JLabel();
        this.spinnerCurrentAddress = new JSpinner();
        this.menuBar = new JMenuBar();
        this.menuFile = new JMenu();
        this.menuFileNew = new JMenuItem();
        this.menuFileOpen = new JMenuItem();
        this.menuSave = new JMenuItem();
        this.menuFileSaveAs = new JMenuItem();
        this.jSeparator4 = new JPopupMenu.Separator();
        this.menuFileExportAs = new JMenu();
        this.menuFileRecentFiles = new JMenu();
        this.jSeparator1 = new JSeparator();
        this.menuFileExit = new JMenuItem();
        this.menuEdit = new JMenu();
        this.menuView = new JMenu();
        this.menuViewZoom = new JMenu();
        this.menuViewZoomIn = new JMenuItem();
        this.menuViewZoomOut = new JMenuItem();
        this.menuEditUndo = new JMenuItem();
        this.menuEditRedo = new JMenuItem();
        this.menuEditEditStartParameters = new JMenuItem();
        this.jSeparator2 = new JPopupMenu.Separator();
        this.jSeparator8 = new JPopupMenu.Separator();
        this.menuEditSelectArea = new JMenuItem();
        this.menuEditCopySelectedZxPolyAsImage = new JMenuItem();
        this.menuEditCopySelectedBaseAsImage = new JMenuItem();
        this.menuEditPasteImage = new JMenuItem();
        this.jSeparator7 = new JPopupMenu.Separator();
        this.menuEditCopyBaseToPlans = new JMenuItem();
        this.menuEditClear = new JMenuItem();
        this.menuOptions = new JMenu();
        this.menuOptionsGrid = new JCheckBoxMenuItem();
        this.menuOptionsColumns = new JCheckBoxMenuItem();
        this.menuOptionsInvertBase = new JCheckBoxMenuItem();
        this.jSeparator5 = new JPopupMenu.Separator();
        this.menuOptionsZXScreen = new JCheckBoxMenuItem();
        this.menuOptionsMode512 = new JCheckBoxMenuItem();
        this.jSeparator6 = new JPopupMenu.Separator();
        this.menuOptionDontShowAttributes = new JRadioButtonMenuItem();
        this.menuOptionsShowBaseAttributes = new JRadioButtonMenuItem();
        this.menuOptionsShow512x384Attributes = new JRadioButtonMenuItem();
        this.jSeparator3 = new JPopupMenu.Separator();
        this.menuOptionsColumnsAll = new JRadioButtonMenuItem();
        this.menuOptionsColumnsOdd = new JRadioButtonMenuItem();
        this.menuOptionsColumnsEven = new JRadioButtonMenuItem();
        this.menuHelp = new JMenu();
        this.menuHelpAbout = new JMenuItem();
        this.setDefaultCloseOperation(0);
        this.setTitle("ZX-Poly Sprite Corrector");
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent evt) {
                SpriteCorrectorMainFrame.this.applicationClosing(evt);
            }
        });
        this.scrollBarAddress.setToolTipText("Memory window position");
        this.scrollBarAddress.setFocusable(false);
        this.scrollBarAddress.addAdjustmentListener(this::scrollBarAddressAdjustmentValueChanged);
        this.sliderColumns.setMajorTickSpacing(1);
        this.sliderColumns.setMinorTickSpacing(1);
        this.sliderColumns.setPaintLabels(true);
        this.sliderColumns.setPaintTicks(true);
        this.sliderColumns.setSnapToTicks(true);
        this.sliderColumns.setToolTipText("Columns number");
        this.sliderColumns.setExtent(1);
        this.sliderColumns.setFocusable(false);
        this.sliderColumns.setValueIsAdjusting(true);
        this.sliderColumns.addChangeListener(this::sliderColumnsStateChanged);
        this.buttonLock.setText("LOCK");
        this.buttonLock.setToolTipText("To lock current memory position and cols number");
        this.buttonLock.setFocusable(false);
        this.buttonLock.addActionListener(this::buttonLockActionPerformed);
        this.panelTools.setBorder(BorderFactory.createTitledBorder("Tools"));
        this.panelTools.setFocusable(false);
        this.colorSelector.setToolTipText("Colors for paint (Lft btn - INK, Rght btn - PAPER)");
        GroupLayout colorSelectorLayout = new GroupLayout(this.colorSelector);
        this.colorSelector.setLayout(colorSelectorLayout);
        colorSelectorLayout.setHorizontalGroup(colorSelectorLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 0, Short.MAX_VALUE));
        colorSelectorLayout.setVerticalGroup(colorSelectorLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 110, Short.MAX_VALUE));
        this.sliderPenWidth.setToolTipText("Width of an operation tool");
        this.sliderPenWidth.setDoubleBuffered(false);
        this.sliderPenWidth.setMaximumSize(new Dimension(96, 84));
        this.sliderPenWidth.setMinimumSize(new Dimension(96, 84));
        this.sliderPenWidth.setPreferredSize(new Dimension(96, 84));
        this.mainEditorPanel.setCursor(new Cursor(1));
        this.mainEditorPanel.addMouseMotionListener(new MouseMotionAdapter(){

            @Override
            public void mouseMoved(MouseEvent evt) {
                SpriteCorrectorMainFrame.this.mainEditorPanelMouseMoved(evt);
            }

            @Override
            public void mouseDragged(MouseEvent evt) {
                SpriteCorrectorMainFrame.this.mainEditorPanelMouseDragged(evt);
            }
        });
        this.mainEditorPanel.addMouseWheelListener(this::mainEditorPanelMouseWheelMoved);
        this.mainEditorPanel.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent evt) {
                SpriteCorrectorMainFrame.this.mainEditorPanelMousePressed(evt);
            }

            @Override
            public void mouseReleased(MouseEvent evt) {
                SpriteCorrectorMainFrame.this.mainEditorPanelMouseReleased(evt);
            }

            @Override
            public void mouseClicked(MouseEvent evt) {
                SpriteCorrectorMainFrame.this.mainEditorPanelMouseClicked(evt);
            }

            @Override
            public void mouseExited(MouseEvent evt) {
                SpriteCorrectorMainFrame.this.mainEditorPanelMouseExited(evt);
            }

            @Override
            public void mouseEntered(MouseEvent evt) {
                SpriteCorrectorMainFrame.this.mainEditorPanelMouseEntered(evt);
            }
        });
        GroupLayout mainEditorPanelLayout = new GroupLayout(this.mainEditorPanel);
        this.mainEditorPanel.setLayout(mainEditorPanelLayout);
        mainEditorPanelLayout.setHorizontalGroup(mainEditorPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 598, Short.MAX_VALUE).addGroup(mainEditorPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(mainEditorPanelLayout.createSequentialGroup().addGap(0, 0, Short.MAX_VALUE).addComponent(this.mainEditor, -2, -1, -2).addGap(0, 0, Short.MAX_VALUE))));
        mainEditorPanelLayout.setVerticalGroup(mainEditorPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 394, Short.MAX_VALUE).addGroup(mainEditorPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(mainEditorPanelLayout.createSequentialGroup().addGap(0, 0, Short.MAX_VALUE).addComponent(this.mainEditor, -2, -1, -2).addGap(0, 0, Short.MAX_VALUE))));
        this.jScrollPane1.setViewportView(this.mainEditorPanel);
        this.jPanel2.setBorder(BorderFactory.createEtchedBorder());
        this.jPanel2.setLayout(new GridBagLayout());
        this.labelZoom.setText("Zoom");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        this.jPanel2.add((Component)this.labelZoom, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 1000.0;
        this.jPanel2.add((Component)this.filler1, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        this.jPanel2.add((Component)this.labelAddress, gridBagConstraints);
        this.spinnerCurrentAddress.setFocusable(false);
        this.menuFile.setText("File");
        this.menuFileNew.setText("New");
        this.menuFileNew.addActionListener(this::menuFileNewActionPerformed);
        this.menuFile.add(this.menuFileNew);
        this.menuFileOpen.setText("Open");
        this.menuFileOpen.addActionListener(this::menuFileOpenActionPerformed);
        this.menuFile.add(this.menuFileOpen);
        this.menuSave.setAccelerator(KeyStroke.getKeyStroke(83, 2));
        this.menuSave.setText("Save");
        this.menuSave.addActionListener(this::menuSaveActionPerformed);
        this.menuFile.add(this.menuSave);
        this.menuFileSaveAs.setText("Save As");
        this.menuFileSaveAs.addActionListener(this::menuFileSaveAsActionPerformed);
        this.menuFile.add(this.menuFileSaveAs);
        this.menuFile.add(this.jSeparator4);
        this.menuFileRecentFiles.setText("Recent projects");
        this.menuFile.add(this.menuFileRecentFiles);
        this.menuFileRecentFiles.addMenuListener(new MenuListener(){

            @Override
            public void menuSelected(MenuEvent e) {
                List<String> recentProjects = SpriteCorrectorMainFrame.this.getRecentProjects();
                SpriteCorrectorMainFrame.this.menuFileRecentFiles.removeAll();
                for (String path : recentProjects) {
                    JMenuItem projectItem = new JMenuItem(path);
                    projectItem.addActionListener(x -> SpriteCorrectorMainFrame.this.openSzeFileForPath(path));
                    SpriteCorrectorMainFrame.this.menuFileRecentFiles.add(projectItem);
                }
            }

            @Override
            public void menuDeselected(MenuEvent e) {
            }

            @Override
            public void menuCanceled(MenuEvent e) {
            }
        });
        this.menuFile.add(new JSeparator());
        this.menuFileExportAs.setText("Export as..");
        this.menuFile.add(this.menuFileExportAs);
        this.menuFile.add(this.jSeparator1);
        this.menuFileExit.setText("Exit");
        this.menuFileExit.setToolTipText("Close application");
        this.menuFileExit.addActionListener(this::menuFileExitActionPerformed);
        this.menuFile.add(this.menuFileExit);
        this.menuBar.add(this.menuFile);
        this.menuView.setText("View");
        this.menuViewZoom.setText("Zoom");
        this.menuViewZoomIn.setText("Zoom In");
        this.menuViewZoomIn.addActionListener(e -> this.mainEditor.zoomIn());
        this.menuViewZoomIn.setAccelerator(KeyStroke.getKeyStroke(61, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()));
        this.menuViewZoomOut.setText("Zoom Out");
        this.menuViewZoomOut.addActionListener(e -> this.mainEditor.zoomOut());
        this.menuViewZoomOut.setAccelerator(KeyStroke.getKeyStroke(45, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()));
        this.menuEdit.setText("Edit");
        this.menuEdit.addMenuListener(new MenuListener(){

            @Override
            public void menuSelected(MenuEvent evt) {
                SpriteCorrectorMainFrame.this.menuEditMenuSelected(evt);
            }

            @Override
            public void menuDeselected(MenuEvent evt) {
                SpriteCorrectorMainFrame.this.menuEditMenuDeselected(evt);
            }

            @Override
            public void menuCanceled(MenuEvent evt) {
            }
        });
        this.menuEditUndo.setAccelerator(KeyStroke.getKeyStroke(90, 2));
        this.menuEditUndo.setText("Undo");
        this.menuEditUndo.addActionListener(this::menuEditUndoActionPerformed);
        this.menuEdit.add(this.menuEditUndo);
        this.menuEditRedo.setAccelerator(KeyStroke.getKeyStroke(90, 3));
        this.menuEditRedo.setText("Redo");
        this.menuEditRedo.addActionListener(this::menuEditRedoActionPerformed);
        this.menuEdit.add(this.menuEditRedo);
        this.menuEdit.add(this.jSeparator2);
        this.menuEditEditStartParameters.setText("Change snapshot CPU values");
        this.menuEditEditStartParameters.addActionListener(this::onActionMenuEditEditStartParameters);
        this.menuEdit.add(this.menuEditEditStartParameters);
        this.menuEdit.add(this.jSeparator8);
        this.menuEditSelectArea.setAccelerator(KeyStroke.getKeyStroke(82, 2));
        this.menuEditSelectArea.setText("Select area");
        this.menuEditSelectArea.addActionListener(this::menuEditSelectAreaActionPerformed);
        this.menuEdit.add(this.menuEditSelectArea);
        this.menuEditCopySelectedZxPolyAsImage.setAccelerator(KeyStroke.getKeyStroke(67, 10));
        this.menuEditCopySelectedZxPolyAsImage.setText("Copy selection (zxpoly)");
        this.menuEditCopySelectedZxPolyAsImage.addActionListener(this::menuEditCopySelectedZxPolyAsImageActionPerformed);
        this.menuEdit.add(this.menuEditCopySelectedZxPolyAsImage);
        this.menuEditCopySelectedBaseAsImage.setText("Copy selection (base)");
        this.menuEditCopySelectedBaseAsImage.addActionListener(this::menuEditCopySelectedBaseAsImageActionPerformed);
        this.menuEdit.add(this.menuEditCopySelectedBaseAsImage);
        this.menuEditPasteImage.setAccelerator(KeyStroke.getKeyStroke(86, 10));
        this.menuEditPasteImage.setText("Paste image");
        this.menuEditPasteImage.addActionListener(this::menuEditPasteImageActionPerformed);
        this.menuEdit.add(this.menuEditPasteImage);
        this.menuEdit.add(this.jSeparator7);
        this.menuEditCopyBaseToPlans.setText("Copy base to all plans");
        this.menuEditCopyBaseToPlans.addActionListener(this::menuEditCopyBaseToPlansActionPerformed);
        this.menuEdit.add(this.menuEditCopyBaseToPlans);
        this.menuEditClear.setText("Clear");
        this.menuEditClear.addActionListener(this::menuEditClearActionPerformed);
        this.menuEdit.add(this.menuEditClear);
        this.menuBar.add(this.menuEdit);
        this.menuViewZoom.add(this.menuViewZoomIn);
        this.menuViewZoom.add(this.menuViewZoomOut);
        this.menuView.add(this.menuViewZoom);
        this.menuBar.add(this.menuView);
        this.menuOptions.setText("Options");
        this.menuOptionsGrid.setSelected(true);
        this.menuOptionsGrid.setText("Grid");
        this.menuOptionsGrid.addActionListener(this::menuOptionsGridActionPerformed);
        this.menuOptions.add(this.menuOptionsGrid);
        this.menuOptionsColumns.setSelected(true);
        this.menuOptionsColumns.setText("Columns");
        this.menuOptionsColumns.addActionListener(this::menuOptionsColumnsActionPerformed);
        this.menuOptions.add(this.menuOptionsColumns);
        this.menuOptionsInvertBase.setSelected(true);
        this.menuOptionsInvertBase.setText("Invert base");
        this.menuOptionsInvertBase.addActionListener(this::menuOptionsInvertBaseActionPerformed);
        this.menuOptions.add(this.menuOptionsInvertBase);
        this.menuOptions.add(this.jSeparator5);
        this.menuOptionsZXScreen.setAccelerator(KeyStroke.getKeyStroke(90, 0));
        this.menuOptionsZXScreen.setSelected(true);
        this.menuOptionsZXScreen.setText("ZX-Screen addressing");
        this.menuOptionsZXScreen.addChangeListener(this::menuOptionsZXScreenStateChanged);
        this.menuOptions.add(this.menuOptionsZXScreen);
        this.menuOptionsMode512.setSelected(true);
        this.menuOptionsMode512.setText("512 video mode");
        this.menuOptionsMode512.addChangeListener(this::menuOptionsMode512StateChanged);
        this.menuOptions.add(this.menuOptionsMode512);
        this.menuOptions.add(this.jSeparator6);
        this.menuOptionDontShowAttributes.setAccelerator(KeyStroke.getKeyStroke(65, 3));
        this.attributesButtonGroup.add(this.menuOptionDontShowAttributes);
        this.menuOptionDontShowAttributes.setSelected(true);
        this.menuOptionDontShowAttributes.setText("Don't show attribute colors");
        this.menuOptionDontShowAttributes.addActionListener(this::menuOptionDontShowAttributesActionPerformed);
        this.menuOptions.add(this.menuOptionDontShowAttributes);
        this.menuOptionsShowBaseAttributes.setAccelerator(KeyStroke.getKeyStroke(65, 2));
        this.attributesButtonGroup.add(this.menuOptionsShowBaseAttributes);
        this.menuOptionsShowBaseAttributes.setText("Show attribute colors");
        this.menuOptionsShowBaseAttributes.addActionListener(this::menuOptionsShowBaseAttributesActionPerformed);
        this.menuOptions.add(this.menuOptionsShowBaseAttributes);
        this.menuOptionsShow512x384Attributes.setAccelerator(KeyStroke.getKeyStroke(65, 10));
        this.attributesButtonGroup.add(this.menuOptionsShow512x384Attributes);
        this.menuOptionsShow512x384Attributes.setText("Show 512x384 plane attributes");
        this.menuOptionsShow512x384Attributes.addActionListener(this::menuOptionsShow512x384AttributesActionPerformed);
        this.menuOptions.add(this.menuOptionsShow512x384Attributes);
        this.menuOptions.add(this.jSeparator3);
        this.columnModeGroup.add(this.menuOptionsColumnsAll);
        this.menuOptionsColumnsAll.setSelected(true);
        this.menuOptionsColumnsAll.setText("All columns");
        this.menuOptionsColumnsAll.addActionListener(this::menuOptionsColumnsAllActionPerformed);
        this.menuOptions.add(this.menuOptionsColumnsAll);
        this.columnModeGroup.add(this.menuOptionsColumnsOdd);
        this.menuOptionsColumnsOdd.setText("Odd columns");
        this.menuOptionsColumnsOdd.addActionListener(this::menuOptionsColumnsOddActionPerformed);
        this.menuOptions.add(this.menuOptionsColumnsOdd);
        this.columnModeGroup.add(this.menuOptionsColumnsEven);
        this.menuOptionsColumnsEven.setText("Even columns");
        this.menuOptionsColumnsEven.addActionListener(this::menuOptionsColumnsEvenActionPerformed);
        this.menuOptions.add(this.menuOptionsColumnsEven);
        this.menuBar.add(this.menuOptions);
        this.menuHelp.setText("Help");
        this.menuHelpAbout.setText("About");
        this.menuHelpAbout.addActionListener(this::menuHelpAboutActionPerformed);
        this.menuHelp.add(this.menuHelpAbout);
        this.menuBar.add(this.menuHelp);
        this.setJMenuBar(this.menuBar);
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jPanel2, GroupLayout.Alignment.TRAILING, -1, -1, Short.MAX_VALUE).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.jScrollPane1).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.scrollBarAddress, -2, -1, -2)).addComponent(this.colorSelector, -1, -1, Short.MAX_VALUE)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.panelTools, GroupLayout.Alignment.TRAILING, -2, 107, -2).addComponent(this.sliderPenWidth, -1, -1, Short.MAX_VALUE))).addGroup(layout.createSequentialGroup().addComponent(this.sliderColumns, -1, -1, Short.MAX_VALUE).addGap(29, 29, 29).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.buttonLock, -1, 107, Short.MAX_VALUE).addComponent(this.spinnerCurrentAddress)))).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.scrollBarAddress, -1, -1, Short.MAX_VALUE).addComponent(this.jScrollPane1, GroupLayout.Alignment.TRAILING, -1, 399, Short.MAX_VALUE).addComponent(this.panelTools, GroupLayout.Alignment.TRAILING, -1, -1, Short.MAX_VALUE)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.sliderColumns, -2, -1, -2).addComponent(this.spinnerCurrentAddress, -2, -1, -2)).addGroup(layout.createSequentialGroup().addComponent(this.buttonLock).addGap(27, 27, 27))).addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.colorSelector, -2, -1, -2).addComponent(this.sliderPenWidth, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jPanel2, -2, -1, -2)));
        layout.linkSize(1, this.colorSelector, this.sliderPenWidth);
        this.getAccessibleContext().setAccessibleName("ZX-Poly Sprite corrector");
        this.pack();
    }

    private void openSzeFileForPath(String path) {
        File file = new File(path);
        if (file.isFile()) {
            if (this.mainEditor.isChanged() && JOptionPane.showConfirmDialog(this, "Open file '" + file.getName() + "'?", "Confirmation", 2) == 2) {
                return;
            }
            SZEPlugin szePlugin = this.container.getComponent(SZEPlugin.class);
            try {
                String name = file.getName();
                this.loadFileWithPlugin(szePlugin, file, name, FileUtils.readFileToByteArray(file), -1);
            }
            catch (IOException ex) {
                JOptionPane.showMessageDialog(this, ex.getMessage(), "Error", 0);
            }
        } else {
            JOptionPane.showMessageDialog(this, "Can't find file '" + path + "'", "Error", 0);
        }
    }

    private List<String> getRecentProjects() {
        Preferences preferences = Preferences.userNodeForPackage(SpriteCorrectorMainFrame.class);
        String list = preferences.get("recent-projects", "");
        return Arrays.stream(list.split("\\n")).map(String::trim).filter(x -> !x.isEmpty()).collect(Collectors.toList());
    }

    private synchronized void addSzeProjectToRecentProjects(File file) {
        try {
            ArrayList<String> recentProjects = new ArrayList<String>(this.getRecentProjects());
            recentProjects.remove(file.getAbsolutePath());
            recentProjects.add(0, file.getAbsolutePath());
            String newValue = recentProjects.stream().limit(10L).collect(Collectors.joining("\n"));
            Preferences preferences = Preferences.userNodeForPackage(SpriteCorrectorMainFrame.class);
            preferences.put("recent-projects", newValue);
            preferences.flush();
        }
        catch (Exception ex) {
            LOGGER.log(Level.SEVERE, "Can't save recent project info: " + ex.getMessage(), ex);
        }
    }

    private void menuFileExitActionPerformed(ActionEvent evt) {
        this.dispose();
    }

    private void applicationClosing(WindowEvent evt) {
        if (this.mainEditor.hasData() && JOptionPane.showConfirmDialog(this, "Close application?", "Confirmation", 0) == 1) {
            return;
        }
        this.dispose();
    }

    private void buttonLockActionPerformed(ActionEvent evt) {
        if (this.buttonLock.isSelected()) {
            this.scrollBarAddress.setEnabled(false);
            this.sliderColumns.setEnabled(false);
        } else {
            if (this.mainEditor.getProcessingData() != null) {
                this.scrollBarAddress.setEnabled(true);
            }
            this.sliderColumns.setEnabled(true);
        }
    }

    private void menuHelpAboutActionPerformed(ActionEvent evt) {
        new AboutDialog(this).setVisible(true);
    }

    private void mainEditorPanelMouseWheelMoved(MouseWheelEvent evt) {
        if (this.selectAreaMode) {
            this.selectAreaMode = false;
            this.mainEditor.resetSelectArea();
        } else if (evt.getModifiersEx() == 128) {
            if (evt.getWheelRotation() < 0) {
                this.mainEditor.zoomIn();
            } else {
                this.mainEditor.zoomOut();
            }
        }
        this.updateBottomBar();
    }

    private void sliderColumnsStateChanged(ChangeEvent evt) {
        int columns;
        int columnIndex = this.sliderColumns.getValue();
        switch (this.mainEditor.getColumnMode()) {
            case EVEN: 
            case ODD: {
                columns = columnIndex * 2;
                break;
            }
            default: {
                columns = columnIndex;
            }
        }
        this.mainEditor.setColumns(columns);
        this.updateAddressScrollBar();
    }

    private void setCurrentSZEFile(File file) {
        this.szeFile = file;
        this.menuSave.setEnabled(file != null);
    }

    public void loadFileWithPlugin(AbstractFilePlugin plugin, File sourceFile, String name, byte[] data, int selected) throws IOException {
        AbstractFilePlugin.ReadResult result = plugin.readFrom(name, data, selected);
        this.setTitle(name);
        this.mainEditor.setProcessingData(result.getData());
        if (result.getSessionData() != null) {
            this.loadStateFromSession(result.getSessionData());
        } else {
            this.resetOptions();
        }
        this.mainEditor.setChanged(false);
        this.setCurrentSZEFile(plugin instanceof SZEPlugin ? sourceFile : null);
        if (plugin instanceof SCRPlugin && !this.menuOptionsZXScreen.isSelected()) {
            this.menuOptionsZXScreen.setSelected(true);
        }
    }

    public Optional<AbstractFilePlugin> findImportFilePlugin(String extension) {
        return this.container.getComponents(AbstractFilePlugin.class).stream().filter(x -> !(x instanceof LegacySZEPlugin)).filter(AbstractFilePlugin::isImportable).filter(x -> extension.equalsIgnoreCase(x.getExtension(false))).findFirst();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private void menuFileOpenActionPerformed(ActionEvent evt) {
        block17: {
            try {
                File selectedFile;
                this.toolsButtonGroup.clearSelection();
                JFileChooser chooser = new JFileChooser(this.lastOpenedFile);
                chooser.setAcceptAllFileFilterUsed(false);
                this.container.getComponents(AbstractFilePlugin.class).stream().filter(AbstractFilePlugin::isImportable).forEach(plugin -> chooser.addChoosableFileFilter(plugin.getImportFileFilter()));
                InsideFileView insideFileView = new InsideFileView(chooser);
                chooser.setAccessory(insideFileView);
                if (chooser.showOpenDialog(this) != 0) break block17;
                AbstractFilePlugin plugin2 = (AbstractFilePlugin)chooser.getFileFilter();
                this.lastOpenedFile = selectedFile = chooser.getSelectedFile();
                try {
                    int selected = -1;
                    if (plugin2.doesContainInternalFileItems()) {
                        SelectInsideDataDialog itemSelector = new SelectInsideDataDialog((Frame)this, selectedFile, plugin2);
                        itemSelector.setVisible(true);
                        selected = itemSelector.getSelectedIndex();
                        if (selected < 0) {
                            return;
                        }
                    }
                    String name = selectedFile.getName();
                    byte[] data = FileUtils.readFileToByteArray(selectedFile);
                    this.loadFileWithPlugin(plugin2, selectedFile, name, data, selected);
                    if (plugin2 instanceof SZEPlugin) {
                        this.addSzeProjectToRecentProjects(selectedFile);
                    }
                }
                catch (IllegalArgumentException ex) {
                    ex.printStackTrace();
                    JOptionPane.showMessageDialog(this, ex.getMessage(), "Can't read", 2);
                }
                catch (IOException ex) {
                    ex.printStackTrace();
                    JOptionPane.showMessageDialog(this, "Can't read file or its part [" + ex.getMessage() + "]", "Error", 0);
                }
                catch (Exception ex2) {
                    ex2.printStackTrace();
                    JOptionPane.showMessageDialog(this, "Unexpected exception! See log!", "Unexpected error", 0);
                    break block17;
                    {
                        catch (Throwable throwable) {
                            throw throwable;
                        }
                    }
                }
                finally {
                    this.updateAddressScrollBar();
                    this.updateRedoUndo();
                }
            }
            finally {
                this.menuEditMenuSelected(null);
            }
        }
    }

    public void updateAndResetEditMenu() {
        this.updateAddressScrollBar();
        this.updateRedoUndo();
        this.menuEditMenuSelected(null);
    }

    private void scrollBarAddressAdjustmentValueChanged(AdjustmentEvent evt) {
        int address = evt.getValue();
        this.mainEditor.setAddress(address);
    }

    private void processCurrentToolForPoint(int buttons) {
        ToolButtonModel tool;
        Rectangle toolRect = this.mainEditor.getToolArea();
        if (toolRect != null && (tool = (ToolButtonModel)this.toolsButtonGroup.getSelection()) != null) {
            tool.getTool().process(this.mainEditor, toolRect, buttons);
        }
    }

    private Point mouseCoord2EditorCoord(MouseEvent evt) {
        return this.mainEditor.mousePoint2ScreenPoint(SwingUtilities.convertPoint(this.mainEditorPanel, evt.getPoint(), this.mainEditor));
    }

    private Rectangle updateToolRectangle(Point editorPoint) {
        int width = this.sliderPenWidth.getValue();
        Rectangle rect = width <= 1 ? new Rectangle(editorPoint.x, editorPoint.y, 1, 1) : new Rectangle(editorPoint.x - (width >> 1), editorPoint.y - (width >> 1), width, width);
        if (this.currentAbstractTool.get() == null) {
            this.mainEditor.setCursor(Cursor.getPredefinedCursor(1));
            this.mainEditor.setCursorPoint(rect.getLocation());
            this.mainEditor.setToolArea(null);
        } else {
            this.mainEditor.setCursor(this.CURSOR_BLANK);
            this.mainEditor.setCursorPoint(rect.getLocation());
            this.mainEditor.setToolArea(rect);
        }
        this.setLabelAddress(this.mainEditor.getZXGraphics().coordToAddress(rect.x, rect.y));
        return rect;
    }

    private void setLabelAddress(int address) {
        if (address < 0) {
            this.labelAddress.setText("Addr: ----");
        } else {
            this.labelAddress.setText("Addr: " + address + " (" + SpriteCorrectorMainFrame.toHex(address) + ")");
        }
    }

    private void updateRedoUndo() {
        this.menuEditRedo.setEnabled(this.mainEditor.hasRedo());
        this.menuEditUndo.setEnabled(this.mainEditor.hasUndo());
    }

    private int extractButtons(MouseEvent event) {
        int result = 0;
        if ((event.getModifiersEx() & 0x80) != 0) {
            result |= 0x10;
        }
        if ((event.getModifiersEx() & 0x200) != 0) {
            result |= 0x20;
        }
        if ((event.getModifiersEx() & 0x40) != 0) {
            result |= 8;
        }
        if ((event.getModifiersEx() & 0x400) != 0) {
            result |= 1;
        }
        if ((event.getModifiersEx() & 0x800) != 0) {
            result |= 2;
        }
        if ((event.getModifiersEx() & 0x1000) != 0) {
            result |= 4;
        }
        return result;
    }

    private void mainEditorPanelMousePressed(MouseEvent evt) {
        this.mainEditor.addUndo();
        this.updateRedoUndo();
        if (this.selectAreaMode) {
            this.mainEditor.startSelectArea(this.mouseCoord2EditorCoord(evt));
        } else {
            this.updateToolRectangle(this.mouseCoord2EditorCoord(evt));
            this.processCurrentToolForPoint(this.extractButtons(evt));
        }
    }

    private void mainEditorPanelMouseMoved(MouseEvent evt) {
        this.updateToolRectangle(this.mouseCoord2EditorCoord(evt));
    }

    private void mainEditorPanelMouseExited(MouseEvent evt) {
        this.mainEditor.setToolArea(null);
    }

    private void mainEditorPanelMouseEntered(MouseEvent evt) {
        this.updateToolRectangle(this.mouseCoord2EditorCoord(evt));
    }

    private void mainEditorPanelMouseDragged(MouseEvent evt) {
        if (this.selectAreaMode) {
            this.mainEditor.updateSelectArea(this.mouseCoord2EditorCoord(evt));
        } else {
            this.updateToolRectangle(this.mouseCoord2EditorCoord(evt));
            this.processCurrentToolForPoint(this.extractButtons(evt));
        }
    }

    private void menuOptionsMode512StateChanged(ChangeEvent evt) {
        this.mainEditor.resetSelectArea();
        this.mainEditor.setMode512(this.menuOptionsMode512.isSelected());
    }

    private void menuOptionsZXScreenStateChanged(ChangeEvent evt) {
        this.mainEditor.setZXScreenMode(this.menuOptionsZXScreen.isSelected());
    }

    private void menuOptionsInvertBaseActionPerformed(ActionEvent evt) {
        this.mainEditor.setInvertShowBaseData(this.menuOptionsInvertBase.isSelected());
    }

    private void menuOptionsColumnsActionPerformed(ActionEvent evt) {
        this.mainEditor.setShowColumnBorders(this.menuOptionsColumns.isSelected());
    }

    private void menuOptionsGridActionPerformed(ActionEvent evt) {
        this.mainEditor.setShowGrid(this.menuOptionsGrid.isSelected());
    }

    private void menuEditUndoActionPerformed(ActionEvent evt) {
        this.mainEditor.undo();
        this.updateRedoUndo();
    }

    private void menuEditRedoActionPerformed(ActionEvent evt) {
        this.mainEditor.redo();
        this.updateRedoUndo();
    }

    private void menuEditClearActionPerformed(ActionEvent evt) {
        if (JOptionPane.showConfirmDialog(this, "Clear ZX-Poly data?", "Confirmation", 2) == 0) {
            this.mainEditor.clear();
        }
    }

    private void menuOptionDontShowAttributesActionPerformed(ActionEvent evt) {
        this.mainEditor.setShowAttributes(EditorComponent.AttributeMode.DONT_SHOW);
    }

    private void menuOptionsShowBaseAttributesActionPerformed(ActionEvent evt) {
        this.mainEditor.setShowAttributes(EditorComponent.AttributeMode.SHOW_BASE);
    }

    private void menuFileSaveAsActionPerformed(ActionEvent evt) {
        if (this.mainEditor.hasData()) {
            ZXPolyData zxpolydata = this.mainEditor.getProcessingData();
            JFileChooser fileChoolser = new JFileChooser(this.lastOpenedFile);
            fileChoolser.setAcceptAllFileFilterUsed(false);
            fileChoolser.addChoosableFileFilter(this.container.getComponent(SZEPlugin.class));
            if (fileChoolser.showSaveDialog(this) == 0) {
                try {
                    File thefile = this.ensureExtension(fileChoolser.getSelectedFile(), this.container.getComponent(SZEPlugin.class));
                    this.container.getComponent(SZEPlugin.class).writeTo(thefile, zxpolydata, this.makeCurrentSessionData(), new Object[0]);
                    this.mainEditor.setChanged(false);
                    this.setTitle(thefile.getAbsolutePath());
                    this.setCurrentSZEFile(thefile);
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                    JOptionPane.showMessageDialog(this, "Error during operation [" + ex.getMessage() + "]", "Error", 0);
                }
            }
        }
    }

    private void menuOptionsShow512x384AttributesActionPerformed(ActionEvent evt) {
        this.mainEditor.setShowAttributes(EditorComponent.AttributeMode.SHOW_512x384_ZXPOLY_PLANES);
    }

    private void menuEditCopyBaseToPlansActionPerformed(ActionEvent evt) {
        if (JOptionPane.showConfirmDialog(this, "Do you really want to copy base data to all ZX-Poly planes?", "Confirmation", 0) == 0) {
            this.mainEditor.copyPlansFromBase();
        }
    }

    private SessionData makeCurrentSessionData() {
        SessionData result = new SessionData(this.mainEditor);
        result.setExtraProperty(EXTRA_PROPERTY_DATA_ID, SpriteCorrectorMainFrame.serializeProperties(lastSpec256Properties));
        result.setExtraProperty(EXTRA_PROPERTY_OVERRIDE_CPU_DATA, SpriteCorrectorMainFrame.serializeProperties(this.snapshotCpuOverrideValues));
        return result;
    }

    private void menuSaveActionPerformed(ActionEvent evt) {
        try {
            this.container.getComponent(SZEPlugin.class).writeTo(this.szeFile, this.mainEditor.getProcessingData(), this.makeCurrentSessionData(), new Object[0]);
            this.mainEditor.setChanged(false);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            JOptionPane.showMessageDialog(this, "Can't save file for exception [" + ex.getMessage() + "]", "Error", 0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void menuFileNewActionPerformed(ActionEvent evt) {
        try {
            if (this.mainEditor.hasData() && JOptionPane.showConfirmDialog(this, "Do you really want to create new data?", "Confirmation", 0) != 0) {
                return;
            }
            NewDataDialog dialog = new NewDataDialog(this);
            dialog.setVisible(true);
            AbstractFilePlugin.ReadResult result = dialog.getResult();
            if (result != null) {
                this.mainEditor.setProcessingData(result.getData());
                this.setCurrentSZEFile(null);
            }
            this.repaint();
        }
        finally {
            this.menuEditMenuSelected(null);
        }
    }

    private void menuOptionsColumnsAllActionPerformed(ActionEvent evt) {
        this.mainEditor.setColumnMode(EditorComponent.ColumnMode.ALL);
        this.sliderColumns.setModel(this.SLIDER_ALL_MODEL);
        this.sliderColumns.setLabelTable(this.SLIDER_ALL_LABELS);
        this.sliderColumns.setValue(this.mainEditor.getColumns());
    }

    private void menuOptionsColumnsOddActionPerformed(ActionEvent evt) {
        this.mainEditor.setColumnMode(EditorComponent.ColumnMode.ODD);
        this.sliderColumns.setModel(this.SLIDER_ODD_OR_EVEN_MODEL);
        this.sliderColumns.setLabelTable(this.SLIDER_ODD_LABELS);
        this.sliderColumns.setValue(this.mainEditor.getColumns() / 2);
    }

    private void menuOptionsColumnsEvenActionPerformed(ActionEvent evt) {
        this.mainEditor.setColumnMode(EditorComponent.ColumnMode.EVEN);
        this.sliderColumns.setModel(this.SLIDER_ODD_OR_EVEN_MODEL);
        this.sliderColumns.setLabelTable(this.SLIDER_EVEN_LABELS);
        this.sliderColumns.setValue(this.mainEditor.getColumns() / 2);
    }

    private void mainEditorPanelMouseReleased(MouseEvent evt) {
        if (this.selectAreaMode) {
            this.selectAreaMode = false;
            this.mainEditor.endSelectArea(this.mouseCoord2EditorCoord(evt));
            this.menuEditMenuSelected(null);
        }
    }

    private void deactivateCurrentTool() {
        this.toolsButtonGroup.clearSelection();
    }

    private void menuEditSelectAreaActionPerformed(ActionEvent evt) {
        this.deactivateCurrentTool();
        this.mainEditor.setDraggedImage(null);
        this.selectAreaMode = true;
        this.mainEditor.setCursor(Cursor.getPredefinedCursor(1));
        this.mainEditor.addUndo();
        this.mainEditor.resetSelectArea();
    }

    private void menuEditCopySelectedBaseAsImageActionPerformed(ActionEvent evt) {
        Image selectedAreaImage = this.mainEditor.getSelectedAreaAsImage(true);
        if (selectedAreaImage != null) {
            new TransferableImage(selectedAreaImage).toClipboard();
        }
    }

    private void menuEditCopySelectedZxPolyAsImageActionPerformed(ActionEvent evt) {
        Image selectedAreaImage = this.mainEditor.getSelectedAreaAsImage(false);
        if (selectedAreaImage != null) {
            new TransferableImage(selectedAreaImage).toClipboard();
        }
    }

    private void onActionMenuEditEditStartParameters(ActionEvent actionEvent) {
        try {
            CpuSnapshotParamsEditor panel = new CpuSnapshotParamsEditor(this.mainEditor.getProcessingData(), this.snapshotCpuOverrideValues);
            if (JOptionPane.showConfirmDialog(this, panel, "Edit start parameters", 2, -1) == 0) {
                this.snapshotCpuOverrideValues = panel.asProperties();
            }
        }
        catch (IOException ex) {
            JOptionPane.showMessageDialog(this, "Error: " + ex.getMessage(), "Error", 0);
        }
    }

    private void menuEditMenuSelected(MenuEvent evt) {
        this.toolsButtonGroup.clearSelection();
        this.menuEditSelectArea.setEnabled(this.mainEditor.hasData());
        this.menuEditPasteImage.setEnabled(GfxUtils.doesClipboardHasImage());
        this.menuEditCopySelectedBaseAsImage.setEnabled(this.mainEditor.hasSelectedArea());
        this.menuEditCopySelectedZxPolyAsImage.setEnabled(this.mainEditor.hasSelectedArea());
        this.menuEditEditStartParameters.setEnabled(this.mainEditor.getProcessingData() != null && this.mainEditor.getProcessingData().getPlugin() instanceof Z80InZXPOutPlugin);
    }

    private void mainEditorPanelMouseClicked(MouseEvent evt) {
        if (this.mainEditor.hasDraggedImage()) {
            if (evt.getClickCount() > 1 && evt.getButton() == 1) {
                this.mainEditor.doStampDraggedImage();
                evt.consume();
            } else if (evt.getButton() == 3) {
                this.mainEditor.setDraggedImage(null);
                evt.consume();
            }
        }
    }

    private void menuEditPasteImageActionPerformed(ActionEvent evt) {
        Image image = GfxUtils.getImageFromClipboard();
        if (image != null) {
            this.toolsButtonGroup.clearSelection();
            this.mainEditor.setCursor(Cursor.getPredefinedCursor(1));
            this.mainEditor.setToolArea(null);
            this.mainEditor.setDraggedImage(image);
        }
    }

    private void menuEditMenuDeselected(MenuEvent evt) {
        this.menuEditSelectArea.setEnabled(this.mainEditor.hasData());
        this.menuEditPasteImage.setEnabled(this.mainEditor.hasData());
        this.menuEditCopySelectedBaseAsImage.setEnabled(this.mainEditor.hasData());
        this.menuEditCopySelectedZxPolyAsImage.setEnabled(this.mainEditor.hasData());
    }

    private void updateAddressScrollBar() {
        this.sliderColumns.setEnabled(true);
        this.scrollBarAddress.setMinimum(0);
        if (this.mainEditor.getProcessingData() == null) {
            this.scrollBarAddress.setEnabled(false);
        } else {
            this.scrollBarAddress.setMaximum(Math.max(0, this.mainEditor.getProcessingData().length() - 32));
            this.scrollBarAddress.setEnabled(true);
            this.scrollBarAddress.setValue(this.mainEditor.getAddress());
            this.scrollBarAddress.setUnitIncrement(this.mainEditor.getColumns());
            this.scrollBarAddress.setBlockIncrement(this.mainEditor.getColumns() * 96);
            this.scrollBarAddress.setVisibleAmount(this.mainEditor.getColumns() * 192);
        }
        this.scrollBarAddress.repaint();
    }
}

