/*
 * Decompiled with CFR 0.152.
 */
package com.igormaznitsa.zxpspritecorrector.components;

import java.awt.Font;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import javax.swing.JFormattedTextField;

public abstract class AbstractHexValueField
extends JFormattedTextField {
    protected static final String ALLOWED_CHARS = "0123456789abcdefABCDEF";
    protected int intValue;

    public AbstractHexValueField() {
        this.setFont(new Font("Monospaced", 0, this.getFont().getSize()));
        this.addKeyListener(new KeyAdapter(){

            @Override
            public void keyTyped(KeyEvent e) {
                if (e.getKeyCode() == 127 || e.getKeyCode() == 8 || AbstractHexValueField.ALLOWED_CHARS.indexOf(e.getKeyChar()) < 0) {
                    e.consume();
                }
            }
        });
    }

    public void setValue(int value) {
        this.intValue = value = this.processValue(value);
        this.refreshTextValue();
    }

    protected abstract void refreshTextValue();

    protected abstract int processValue(int var1);

    public int getIntValue() {
        String text = this.getText();
        text = text.isEmpty() ? "0" : text.trim();
        return Integer.parseInt(text, 16);
    }
}

