/*
 * Decompiled with CFR 0.152.
 */
package com.igormaznitsa.zxpspritecorrector.components;

import com.igormaznitsa.zxpspritecorrector.components.CpuRegProperties;
import com.igormaznitsa.zxpspritecorrector.components.HexValue2Field;
import com.igormaznitsa.zxpspritecorrector.components.HexValue4Field;
import com.igormaznitsa.zxpspritecorrector.components.ZXPolyData;
import com.igormaznitsa.zxpspritecorrector.files.plugins.Z80InZXPOutPlugin;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.io.IOException;
import java.util.Properties;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.border.TitledBorder;

public class CpuSnapshotParamsEditor
extends JPanel {
    private final JCheckBox checkBoxIFF1;
    private final JCheckBox checkBoxIFF2;
    private final HexValue2Field fieldAltRegA;
    private final HexValue4Field fieldAltRegBC;
    private final HexValue4Field fieldAltRegDE;
    private final HexValue4Field fieldAltRegHL;
    private final HexValue4Field fieldIR;
    private final HexValue2Field fieldIM;
    private final HexValue4Field fieldIX;
    private final HexValue4Field fieldIY;
    private final HexValue4Field fieldPC;
    private final HexValue2Field fieldRegA;
    private final HexValue4Field fieldRegBC;
    private final HexValue4Field fieldRegDE;
    private final HexValue4Field fieldRegHL;
    private final HexValue2Field field7FFD;
    private final HexValue4Field fieldSP;
    private final JPanel panelAltSet;
    private final JPanel panelOthers;
    private final FlagPanel panelFlags;
    private final FlagPanel panelFlagsAlt;
    private final JPanel panelMainSet;
    private final int snapshotVersion;
    private final byte[] snapshotHeader;
    private final Z80InZXPOutPlugin.Z80MainHeader mainSnapshotHeader;

    public CpuSnapshotParamsEditor(ZXPolyData zxPolyData, CpuRegProperties properties) throws IOException {
        super(new GridBagLayout());
        byte[] extra = zxPolyData.getInfo().getExtra();
        this.snapshotHeader = Z80InZXPOutPlugin.extractHeader(extra);
        this.snapshotVersion = Z80InZXPOutPlugin.getVersion(this.snapshotHeader);
        this.mainSnapshotHeader = Z80InZXPOutPlugin.extractZ80SnapshotHeader(this.snapshotHeader);
        int regPc = Z80InZXPOutPlugin.getPcReg(this.mainSnapshotHeader, this.snapshotHeader);
        this.checkBoxIFF1 = new JCheckBox("IFF1", properties.extractBoolean("IFF1", this.mainSnapshotHeader.iff != 0));
        this.checkBoxIFF2 = new JCheckBox("IFF2", properties.extractBoolean("IFF2", this.mainSnapshotHeader.iff2 != 0));
        this.fieldAltRegA = new HexValue2Field(properties.extractInt("ALT_A", this.mainSnapshotHeader.reg_a_alt));
        this.fieldAltRegBC = new HexValue4Field(properties.extractInt("ALT_BC", this.mainSnapshotHeader.reg_bc_alt));
        this.fieldAltRegDE = new HexValue4Field(properties.extractInt("ALT_DE", this.mainSnapshotHeader.reg_de_alt));
        this.fieldAltRegHL = new HexValue4Field(properties.extractInt("ALT_HL", this.mainSnapshotHeader.reg_hl_alt));
        this.fieldIM = new HexValue2Field(properties.extractInt("IM", this.mainSnapshotHeader.emulFlags.interruptmode));
        this.fieldIR = new HexValue4Field(properties.extractInt("IR", CpuSnapshotParamsEditor.makePair(this.mainSnapshotHeader.reg_ir, this.mainSnapshotHeader.reg_r)));
        this.fieldIX = new HexValue4Field(properties.extractInt("IX", this.mainSnapshotHeader.reg_ix));
        this.fieldIY = new HexValue4Field(properties.extractInt("IY", this.mainSnapshotHeader.reg_iy));
        this.fieldPC = new HexValue4Field(properties.extractInt("PC", regPc));
        this.fieldSP = new HexValue4Field(properties.extractInt("SP", this.mainSnapshotHeader.reg_sp));
        this.fieldRegA = new HexValue2Field(properties.extractInt("A", this.mainSnapshotHeader.reg_a));
        this.fieldRegBC = new HexValue4Field(properties.extractInt("BC", this.mainSnapshotHeader.reg_bc));
        this.fieldRegDE = new HexValue4Field(properties.extractInt("DE", this.mainSnapshotHeader.reg_de));
        this.fieldRegHL = new HexValue4Field(properties.extractInt("HL", this.mainSnapshotHeader.reg_hl));
        this.field7FFD = new HexValue2Field(properties.extractInt("7FFD", Z80InZXPOutPlugin.getPort7ffd(this.snapshotVersion, this.snapshotHeader)));
        this.panelMainSet = this.makePanelMainSet();
        this.panelAltSet = this.makePanelAltSet();
        this.panelOthers = this.makePanelOthers();
        this.panelFlags = new FlagPanel("Flags", false, properties.extractInt("F", this.mainSnapshotHeader.reg_f));
        this.panelFlagsAlt = new FlagPanel("Flags'", true, properties.extractInt("ALT_F", this.mainSnapshotHeader.reg_f_alt));
        GridBagConstraints constraints = new GridBagConstraints();
        constraints.fill = 1;
        constraints.anchor = 10;
        constraints.insets = new Insets(0, 0, 0, 0);
        constraints.ipadx = 0;
        constraints.ipady = 0;
        constraints.weightx = 1.0;
        constraints.weighty = 1.0;
        constraints.gridx = 0;
        constraints.gridy = 0;
        constraints.gridwidth = 2;
        constraints.gridheight = 1;
        constraints.fill = 2;
        this.add((Component)this.panelFlags, constraints);
        constraints.gridx = 0;
        constraints.gridy = 1;
        constraints.gridwidth = 2;
        constraints.gridheight = 1;
        constraints.fill = 2;
        this.add((Component)this.panelFlagsAlt, constraints);
        constraints.gridx = 0;
        constraints.gridy = 2;
        constraints.gridwidth = 1;
        constraints.gridheight = 1;
        constraints.fill = 1;
        this.add((Component)this.panelMainSet, constraints);
        constraints.gridx = 1;
        constraints.gridy = 2;
        constraints.gridwidth = 1;
        constraints.gridheight = 1;
        constraints.fill = 1;
        this.add((Component)this.panelAltSet, constraints);
        constraints.gridx = 0;
        constraints.gridy = 3;
        constraints.gridwidth = 2;
        constraints.gridheight = 1;
        constraints.weighty = 1.0;
        constraints.fill = 2;
        this.add((Component)this.panelOthers, constraints);
        JPanel buttonsPanel = new JPanel(new FlowLayout(2));
        JButton buttonReset = new JButton("Reset");
        buttonReset.addActionListener(a -> {
            if (JOptionPane.showConfirmDialog(this, "Do you really want reset data?", "Confirmation", 2) == 0) {
                this.reset();
            }
        });
        buttonsPanel.add(buttonReset);
        constraints.gridx = 1;
        constraints.gridy = 4;
        constraints.gridwidth = 2;
        constraints.fill = 2;
        this.add((Component)buttonsPanel, constraints);
        constraints.gridx = 1;
        constraints.gridy = 5;
        constraints.gridwidth = 2;
        constraints.gridheight = 1;
        constraints.weighty = 1000.0;
        constraints.fill = 1;
        this.add(Box.createVerticalGlue(), constraints);
    }

    private static void addPropertyIfChanged(Properties properties, String name, boolean value, boolean orig) {
        if (value != orig) {
            properties.put(name, Boolean.toString(value));
        }
    }

    private static void addPropertyIfChanged(Properties properties, String name, int value, byte orig) {
        if (value != (orig & 0xFF)) {
            properties.put(name, Integer.toString(value));
        }
    }

    private static void addPropertyIfChanged(Properties properties, String name, int value, int orig) {
        if (value != (orig & 0xFFFF)) {
            properties.put(name, Integer.toString(value));
        }
    }

    public static int makePair(byte a, byte b) {
        return (a & 0xFF) << 8 | b & 0xFF;
    }

    private static JLabel makeCenteredLabel(String text) {
        JLabel result = new JLabel(text);
        result.setHorizontalAlignment(0);
        return result;
    }

    public void reset() {
        this.checkBoxIFF1.setSelected(this.mainSnapshotHeader.iff != 0);
        this.checkBoxIFF2.setSelected(this.mainSnapshotHeader.iff2 != 0);
        this.fieldAltRegA.setValue(this.mainSnapshotHeader.reg_a_alt);
        this.fieldAltRegBC.setValue(this.mainSnapshotHeader.reg_bc_alt);
        this.fieldAltRegDE.setValue(this.mainSnapshotHeader.reg_de_alt);
        this.fieldAltRegHL.setValue(this.mainSnapshotHeader.reg_hl_alt);
        this.panelFlagsAlt.setData(this.mainSnapshotHeader.reg_f_alt);
        this.fieldRegA.setValue(this.mainSnapshotHeader.reg_a);
        this.fieldRegBC.setValue(this.mainSnapshotHeader.reg_bc);
        this.fieldRegDE.setValue(this.mainSnapshotHeader.reg_de);
        this.fieldRegHL.setValue(this.mainSnapshotHeader.reg_hl);
        this.panelFlags.setData(this.mainSnapshotHeader.reg_f);
        this.field7FFD.setValue(Z80InZXPOutPlugin.getPort7ffd(this.snapshotVersion, this.snapshotHeader));
        this.fieldIM.setValue(this.mainSnapshotHeader.emulFlags.interruptmode);
        this.fieldIR.setValue(CpuSnapshotParamsEditor.makePair(this.mainSnapshotHeader.reg_ir, this.mainSnapshotHeader.reg_r));
        this.fieldSP.setValue(this.mainSnapshotHeader.reg_sp);
        this.fieldPC.setValue(Z80InZXPOutPlugin.getPcReg(this.mainSnapshotHeader, this.snapshotHeader));
        this.fieldIX.setValue(this.mainSnapshotHeader.reg_ix);
        this.fieldIY.setValue(this.mainSnapshotHeader.reg_iy);
    }

    public CpuRegProperties asProperties() {
        CpuRegProperties result = new CpuRegProperties();
        CpuSnapshotParamsEditor.addPropertyIfChanged((Properties)result, "IFF1", this.checkBoxIFF1.isSelected(), this.mainSnapshotHeader.iff != 0);
        CpuSnapshotParamsEditor.addPropertyIfChanged((Properties)result, "IFF2", this.checkBoxIFF2.isSelected(), this.mainSnapshotHeader.iff2 != 0);
        CpuSnapshotParamsEditor.addPropertyIfChanged((Properties)result, "ALT_A", this.fieldAltRegA.getIntValue(), this.mainSnapshotHeader.reg_a_alt);
        CpuSnapshotParamsEditor.addPropertyIfChanged((Properties)result, "ALT_BC", this.fieldAltRegBC.getIntValue(), this.mainSnapshotHeader.reg_bc_alt);
        CpuSnapshotParamsEditor.addPropertyIfChanged((Properties)result, "ALT_DE", this.fieldAltRegDE.getIntValue(), this.mainSnapshotHeader.reg_de_alt);
        CpuSnapshotParamsEditor.addPropertyIfChanged((Properties)result, "ALT_HL", this.fieldAltRegHL.getIntValue(), this.mainSnapshotHeader.reg_hl_alt);
        CpuSnapshotParamsEditor.addPropertyIfChanged((Properties)result, "ALT_F", this.panelFlagsAlt.getData(), this.mainSnapshotHeader.reg_f_alt);
        CpuSnapshotParamsEditor.addPropertyIfChanged((Properties)result, "A", this.fieldRegA.getIntValue(), this.mainSnapshotHeader.reg_a);
        CpuSnapshotParamsEditor.addPropertyIfChanged((Properties)result, "BC", this.fieldRegBC.getIntValue(), this.mainSnapshotHeader.reg_bc);
        CpuSnapshotParamsEditor.addPropertyIfChanged((Properties)result, "DE", this.fieldRegDE.getIntValue(), this.mainSnapshotHeader.reg_de);
        CpuSnapshotParamsEditor.addPropertyIfChanged((Properties)result, "HL", this.fieldRegHL.getIntValue(), this.mainSnapshotHeader.reg_hl);
        CpuSnapshotParamsEditor.addPropertyIfChanged((Properties)result, "F", this.panelFlags.getData(), this.mainSnapshotHeader.reg_f);
        CpuSnapshotParamsEditor.addPropertyIfChanged((Properties)result, "7FFD", this.field7FFD.getIntValue(), Z80InZXPOutPlugin.getPort7ffd(this.snapshotVersion, this.snapshotHeader));
        CpuSnapshotParamsEditor.addPropertyIfChanged((Properties)result, "IM", this.fieldIM.getIntValue(), this.mainSnapshotHeader.emulFlags.interruptmode);
        CpuSnapshotParamsEditor.addPropertyIfChanged((Properties)result, "IR", this.fieldIR.getIntValue(), CpuSnapshotParamsEditor.makePair(this.mainSnapshotHeader.reg_ir, this.mainSnapshotHeader.reg_r));
        CpuSnapshotParamsEditor.addPropertyIfChanged((Properties)result, "SP", this.fieldSP.getIntValue(), this.mainSnapshotHeader.reg_sp);
        CpuSnapshotParamsEditor.addPropertyIfChanged((Properties)result, "PC", this.fieldPC.getIntValue(), Z80InZXPOutPlugin.getPcReg(this.mainSnapshotHeader, this.snapshotHeader));
        CpuSnapshotParamsEditor.addPropertyIfChanged((Properties)result, "IX", this.fieldIX.getIntValue(), this.mainSnapshotHeader.reg_ix);
        CpuSnapshotParamsEditor.addPropertyIfChanged((Properties)result, "IY", this.fieldIY.getIntValue(), this.mainSnapshotHeader.reg_iy);
        return result;
    }

    private JPanel makePanelOthers() {
        JPanel result = new JPanel(new GridBagLayout());
        result.setBorder(new TitledBorder("Others"));
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.fill = 0;
        gbc.gridx = 0;
        gbc.gridy = -1;
        gbc.anchor = 13;
        result.add((Component)new JLabel("PC:"), gbc);
        result.add((Component)new JLabel("SP:"), gbc);
        result.add((Component)new JLabel("IX:"), gbc);
        result.add((Component)new JLabel("IY:"), gbc);
        gbc.gridx = 1;
        gbc.gridy = -1;
        gbc.anchor = 17;
        result.add((Component)this.fieldPC, gbc);
        result.add((Component)this.fieldSP, gbc);
        result.add((Component)this.fieldIX, gbc);
        result.add((Component)this.fieldIY, gbc);
        gbc.gridx = 2;
        gbc.gridy = -1;
        gbc.anchor = 13;
        gbc.insets = new Insets(0, 16, 0, 0);
        result.add((Component)new JLabel("IR:"), gbc);
        result.add((Component)new JLabel("IM:"), gbc);
        result.add((Component)new JLabel("7FFD:"), gbc);
        gbc.gridx = 3;
        gbc.gridy = -1;
        gbc.anchor = 17;
        gbc.insets = new Insets(0, 0, 0, 0);
        result.add((Component)this.fieldIR, gbc);
        result.add((Component)this.fieldIM, gbc);
        result.add((Component)this.field7FFD, gbc);
        gbc.gridx = 0;
        gbc.gridy = 4;
        gbc.gridwidth = 4;
        gbc.fill = 2;
        JPanel flagsPanel = new JPanel(new FlowLayout(0));
        flagsPanel.add(this.checkBoxIFF1);
        flagsPanel.add(this.checkBoxIFF2);
        result.add((Component)flagsPanel, gbc);
        return result;
    }

    private JPanel makePanelAltSet() {
        JPanel result = new JPanel(new GridBagLayout());
        result.setBorder(new TitledBorder("Alt set"));
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.fill = 2;
        gbc.gridx = 0;
        gbc.gridy = -1;
        gbc.fill = 1;
        gbc.anchor = 13;
        result.add((Component)new JLabel("A':"), gbc);
        result.add((Component)new JLabel("BC':"), gbc);
        result.add((Component)new JLabel("DE':"), gbc);
        result.add((Component)new JLabel("HL':"), gbc);
        gbc.gridx = 1;
        gbc.gridy = -1;
        gbc.fill = 1;
        gbc.anchor = 17;
        result.add((Component)this.fieldAltRegA, gbc);
        result.add((Component)this.fieldAltRegBC, gbc);
        result.add((Component)this.fieldAltRegDE, gbc);
        result.add((Component)this.fieldAltRegHL, gbc);
        return result;
    }

    private JPanel makePanelMainSet() {
        JPanel result = new JPanel(new GridBagLayout());
        result.setBorder(new TitledBorder("Main set"));
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.fill = 2;
        gbc.gridx = 0;
        gbc.gridy = -1;
        gbc.fill = 1;
        gbc.anchor = 13;
        result.add((Component)new JLabel("A:"), gbc);
        result.add((Component)new JLabel("BC:"), gbc);
        result.add((Component)new JLabel("DE:"), gbc);
        result.add((Component)new JLabel("HL:"), gbc);
        gbc.gridx = 1;
        gbc.gridy = -1;
        gbc.fill = 1;
        gbc.anchor = 17;
        result.add((Component)this.fieldRegA, gbc);
        result.add((Component)this.fieldRegBC, gbc);
        result.add((Component)this.fieldRegDE, gbc);
        result.add((Component)this.fieldRegHL, gbc);
        return result;
    }

    private static class FlagPanel
    extends JPanel {
        private final JCheckBox checkBoxC = new JCheckBox();
        private final JCheckBox checkBoxF3 = new JCheckBox();
        private final JCheckBox checkBoxF5 = new JCheckBox();
        private final JCheckBox checkBoxH = new JCheckBox();
        private final JCheckBox checkBoxN = new JCheckBox();
        private final JCheckBox checkBoxPV = new JCheckBox();
        private final JCheckBox checkBoxS = new JCheckBox();
        private final JCheckBox checkBoxZ = new JCheckBox();

        FlagPanel(String title, boolean alt, int value) {
            super(new GridLayout(2, 8, 8, 8));
            this.setBorder(new TitledBorder(title));
            if (alt) {
                this.add(CpuSnapshotParamsEditor.makeCenteredLabel("S'"));
                this.add(CpuSnapshotParamsEditor.makeCenteredLabel("Z'"));
                this.add(CpuSnapshotParamsEditor.makeCenteredLabel("F5'"));
                this.add(CpuSnapshotParamsEditor.makeCenteredLabel("H'"));
                this.add(CpuSnapshotParamsEditor.makeCenteredLabel("F3'"));
                this.add(CpuSnapshotParamsEditor.makeCenteredLabel("P/V'"));
                this.add(CpuSnapshotParamsEditor.makeCenteredLabel("N'"));
                this.add(CpuSnapshotParamsEditor.makeCenteredLabel("C'"));
            } else {
                this.add(CpuSnapshotParamsEditor.makeCenteredLabel("S"));
                this.add(CpuSnapshotParamsEditor.makeCenteredLabel("Z"));
                this.add(CpuSnapshotParamsEditor.makeCenteredLabel("F5"));
                this.add(CpuSnapshotParamsEditor.makeCenteredLabel("H"));
                this.add(CpuSnapshotParamsEditor.makeCenteredLabel("F3"));
                this.add(CpuSnapshotParamsEditor.makeCenteredLabel("P/V"));
                this.add(CpuSnapshotParamsEditor.makeCenteredLabel("N"));
                this.add(CpuSnapshotParamsEditor.makeCenteredLabel("C"));
            }
            this.checkBoxS.setHorizontalAlignment(0);
            this.checkBoxC.setHorizontalAlignment(0);
            this.checkBoxF3.setHorizontalAlignment(0);
            this.checkBoxF5.setHorizontalAlignment(0);
            this.checkBoxH.setHorizontalAlignment(0);
            this.checkBoxN.setHorizontalAlignment(0);
            this.checkBoxZ.setHorizontalAlignment(0);
            this.checkBoxPV.setHorizontalAlignment(0);
            this.add(this.checkBoxS);
            this.add(this.checkBoxZ);
            this.add(this.checkBoxF5);
            this.add(this.checkBoxH);
            this.add(this.checkBoxF3);
            this.add(this.checkBoxPV);
            this.add(this.checkBoxN);
            this.add(this.checkBoxC);
            this.setData(value);
            this.doLayout();
        }

        int getData() {
            int result = 0;
            result |= this.checkBoxS.isSelected() ? 128 : 0;
            result |= this.checkBoxZ.isSelected() ? 64 : 0;
            result |= this.checkBoxF5.isSelected() ? 32 : 0;
            result |= this.checkBoxH.isSelected() ? 16 : 0;
            result |= this.checkBoxF3.isSelected() ? 8 : 0;
            result |= this.checkBoxPV.isSelected() ? 4 : 0;
            result |= this.checkBoxN.isSelected() ? 2 : 0;
            return result |= this.checkBoxC.isSelected() ? 1 : 0;
        }

        void setData(int data) {
            this.checkBoxS.setSelected((data & 0x80) != 0);
            this.checkBoxZ.setSelected((data & 0x40) != 0);
            this.checkBoxF5.setSelected((data & 0x20) != 0);
            this.checkBoxH.setSelected((data & 0x10) != 0);
            this.checkBoxF3.setSelected((data & 8) != 0);
            this.checkBoxPV.setSelected((data & 4) != 0);
            this.checkBoxN.setSelected((data & 2) != 0);
            this.checkBoxC.setSelected((data & 1) != 0);
        }
    }
}

