/*
 * Decompiled with CFR 0.152.
 */
package com.igormaznitsa.zxpspritecorrector.components;

import com.igormaznitsa.zxpspritecorrector.components.VideoMode;
import com.igormaznitsa.zxpspritecorrector.components.ZXPolyData;
import com.igormaznitsa.zxpspritecorrector.utils.ZXPalette;
import java.awt.AlphaComposite;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Composite;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Stroke;
import java.awt.image.BufferedImage;
import java.awt.image.PixelGrabber;
import java.util.ArrayList;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.SpinnerModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public final class EditorComponent
extends JComponent
implements SpinnerModel {
    private static final long serialVersionUID = -6948149982924499351L;
    private static final Stroke GRID_STROKE = new BasicStroke(0.3f);
    private static final Stroke COLUMN_BORDER_STROKE = new BasicStroke(0.7f);
    private static final Stroke TOOL_AREA_STROKE = new BasicStroke(2.3f);
    private static final Stroke SELECTED_AREA_STROKE = new BasicStroke(3.0f, 0, 2, 0.0f, new float[]{3.0f, 3.0f}, 0.0f);
    private static final RenderingHints RENDERING_IMAGE_HINTS = new RenderingHints(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
    private static final RenderingHints RENDERING_LINE_HINTS = new RenderingHints(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_DEFAULT);
    private final ZXGraphics zxGraphics = new ZXGraphics(this);
    private final List<ChangeListener> changeListeners = new ArrayList<ChangeListener>();
    private final List<ZXPolyData.UndoBlock> listUndo = new ArrayList<ZXPolyData.UndoBlock>();
    private final List<ZXPolyData.UndoBlock> listRedo = new ArrayList<ZXPolyData.UndoBlock>();
    private volatile boolean changed;
    private Color colorSelectedAreaBorder = Color.MAGENTA.brighter().brighter();
    private Color colorToolArea = Color.WHITE;
    private Color colorPixelOn = Color.GRAY.darker();
    private Color colorPixelOff = Color.DARK_GRAY.darker();
    private Color colorZX512On = Color.YELLOW;
    private Color colorZX512Off = Color.BLUE;
    private Color colorGrid = Color.ORANGE.darker();
    private Color colorColumnBorder = Color.CYAN;
    private BufferedImage image;
    private boolean mode512;
    private boolean invertShowBaseData;
    private boolean showColumnBorders;
    private boolean showGrid;
    private AttributeMode attributeMode = AttributeMode.DONT_SHOW;
    private ColumnMode columnMode = ColumnMode.ALL;
    private boolean addressingModeZXScreen;
    private Dimension preferredSize;
    private int zoom = 1;
    private int columns = 32;
    private ZXPolyData processingData;
    private int startAddress;
    private Point startSelectedAreaPoint;
    private Rectangle selectedArea;
    private Rectangle toolArea;
    private Point cursorPoint = new Point(0, 0);
    private Image draggedImage;
    private int gridStep = 1;

    public EditorComponent() {
        this.setBorder(BorderFactory.createEmptyBorder());
        this.setMode512(false);
    }

    public static double intensity(int rgb) {
        int r = rgb >>> 16 & 0xFF;
        int g = rgb >>> 8 & 0xFF;
        int b = rgb & 0xFF;
        return 0.299 * (double)r + 0.587 * (double)g + 0.114 * (double)b;
    }

    public boolean isChanged() {
        return this.processingData != null && this.changed;
    }

    public void setChanged(boolean flag) {
        this.changed = flag;
    }

    public Point mousePoint2ScreenPoint(Point pointAtComponent) {
        if (pointAtComponent == null) {
            return null;
        }
        return new Point(pointAtComponent.x / this.zoom, pointAtComponent.y / this.zoom);
    }

    public void setCursorPoint(Point point) {
        this.cursorPoint = point;
        this.repaint();
    }

    public Image getSelectedAreaAsImage(boolean baseData) {
        BufferedImage result = null;
        if (this.processingData != null && this.selectedArea != null) {
            int w = this.selectedArea.width;
            int h = this.selectedArea.height;
            int sx = this.selectedArea.x;
            int sy = this.selectedArea.y;
            result = baseData || this.mode512 ? new BufferedImage(w, h, 12) : new BufferedImage(w, h, 12, ZXPalette.makeIndexPalette());
            Graphics2D gfx = result.createGraphics();
            for (int y = 0; y < h; ++y) {
                for (int x = 0; x < w; ++x) {
                    if (baseData) {
                        if (this.zxGraphics.isBaseBitSet(sx + x, sy + y)) {
                            gfx.setColor(Color.WHITE);
                        } else {
                            gfx.setColor(Color.BLACK);
                        }
                        gfx.drawLine(x, y, x, y);
                        continue;
                    }
                    if (this.mode512) {
                        if (this.zxGraphics.isPointSetIn512(sx + x, sy + y)) {
                            gfx.setColor(Color.WHITE);
                        } else {
                            gfx.setColor(Color.BLACK);
                        }
                        gfx.drawLine(x, y, x, y);
                        continue;
                    }
                    gfx.setColor(ZXPalette.COLORS[this.zxGraphics.getPoint3012(sx + x, sy + y)]);
                    gfx.drawLine(x, y, x, y);
                }
            }
            gfx.dispose();
        }
        return result;
    }

    public boolean hasSelectedArea() {
        return this.selectedArea != null;
    }

    public Rectangle getSelectedArea() {
        return this.selectedArea == null ? null : new Rectangle(this.selectedArea);
    }

    public ZXGraphics getZXGraphics() {
        return this.zxGraphics;
    }

    public Rectangle getToolArea() {
        return this.toolArea;
    }

    public void setToolArea(Rectangle rect) {
        this.toolArea = rect;
        this.repaint();
    }

    public ZXPolyData getProcessingData() {
        return this.processingData;
    }

    public void setProcessingData(ZXPolyData data) {
        this.listRedo.clear();
        this.listUndo.clear();
        this.processingData = data;
        this._updatePictureInBuffer();
        this.repaint();
    }

    public int getColumns() {
        return this.columns;
    }

    public void setColumns(int value) {
        this.changed = true;
        this.columns = Math.max(1, Math.min(32, value));
        this._updatePictureInBuffer();
        this.repaint();
    }

    public boolean isInvertShowBaseData() {
        return this.invertShowBaseData;
    }

    public void setInvertShowBaseData(boolean flag) {
        this.changed = true;
        this.invertShowBaseData = flag;
        this._updatePictureInBuffer();
        this.repaint();
    }

    public boolean hasUndo() {
        return !this.listUndo.isEmpty();
    }

    public boolean hasRedo() {
        return !this.listRedo.isEmpty();
    }

    public void addUndo() {
        if (this.processingData != null) {
            this.listRedo.clear();
            this.listUndo.add(this.processingData.makeUndo(this.selectedArea));
            while (this.listUndo.size() > 15) {
                this.listUndo.remove(0);
            }
        }
    }

    public void undo() {
        if (this.processingData != null && !this.listUndo.isEmpty()) {
            this.selectedArea = null;
            this.draggedImage = null;
            ZXPolyData.UndoBlock blockPrevious = this.listUndo.remove(this.listUndo.size() - 1);
            if (this.listRedo.isEmpty()) {
                this.listRedo.add(this.processingData.makeUndo(this.selectedArea));
            }
            this.listRedo.add(blockPrevious);
            this.processingData.restoreFromUndo(blockPrevious);
            this.selectedArea = blockPrevious.getSelectedArea();
            this._updatePictureInBuffer();
            this.repaint();
        }
    }

    public void redo() {
        if (this.processingData != null && !this.listRedo.isEmpty()) {
            this.selectedArea = null;
            this.draggedImage = null;
            ZXPolyData.UndoBlock block = this.listRedo.remove(this.listRedo.size() - 1);
            this.listUndo.add(block);
            this.processingData.restoreFromUndo(block);
            this.selectedArea = block.getSelectedArea();
            this._updatePictureInBuffer();
            this.repaint();
        }
    }

    public void clear() {
        if (this.processingData != null) {
            this.selectedArea = null;
            this.draggedImage = null;
            this.listRedo.clear();
            this.listUndo.clear();
            this.processingData.clear();
            this._updatePictureInBuffer();
            this.repaint();
        }
    }

    public boolean isShowColumnBorders() {
        return this.showColumnBorders;
    }

    public void setShowColumnBorders(boolean flag) {
        this.showColumnBorders = flag;
        this.repaint();
    }

    public boolean isShowGrid() {
        return this.showGrid;
    }

    public void setShowGrid(boolean flag) {
        this.changed = true;
        this.showGrid = flag;
        this.repaint();
    }

    public int getGridStep() {
        return this.gridStep;
    }

    public void setGridStep(int step) {
        this.gridStep = Math.max(1, Math.min(128, step));
        this.repaint();
    }

    public int getAddress() {
        return this.startAddress;
    }

    public void setAddress(int address) {
        if (this.processingData == null) {
            this.startAddress = 0;
        } else {
            this.changed = true;
            this.startAddress = Math.max(0, Math.min(this.processingData.length() - 1, address));
        }
        this.changeListeners.forEach(l -> l.stateChanged(new ChangeEvent(this)));
        this._updatePictureInBuffer();
        this.repaint();
    }

    @Override
    public boolean isFocusable() {
        return false;
    }

    public boolean isZXScreenMode() {
        return this.addressingModeZXScreen;
    }

    public void setZXScreenMode(boolean flag) {
        this.addressingModeZXScreen = flag;
        this._updatePictureInBuffer();
        this.repaint();
    }

    public Color getToolAreaColor() {
        return this.colorToolArea;
    }

    public void setToolAreaColor(Color color) {
        this.changed = true;
        this.colorToolArea = color;
        this.repaint();
    }

    public Color getColorPixelOn() {
        return this.colorPixelOn;
    }

    public void setColorPixelOn(Color colorPixelOn) {
        this.changed = true;
        this.colorPixelOn = colorPixelOn;
        this.repaint();
    }

    public Color getColorPixelOff() {
        return this.colorPixelOff;
    }

    public void setColorPixelOff(Color colorPixelOff) {
        this.changed = true;
        this.colorPixelOff = colorPixelOff;
        this.repaint();
    }

    public Color getColorSelectedAreaBorder() {
        return this.colorSelectedAreaBorder;
    }

    public void setColorSelectedAreaBorder(Color color) {
        this.changed = true;
        this.colorSelectedAreaBorder = color;
    }

    public Color getColorZX512On() {
        return this.colorZX512On;
    }

    public void setColorZX512On(Color colorZX512On) {
        this.changed = true;
        this.colorZX512On = colorZX512On;
        this._updatePictureInBuffer();
        this.repaint();
    }

    public Color getColorZX512Off() {
        return this.colorZX512Off;
    }

    public void setColorZX512Off(Color colorZX512Off) {
        this.changed = true;
        this.colorZX512Off = colorZX512Off;
        this._updatePictureInBuffer();
        this.repaint();
    }

    public AttributeMode getShowAttributes() {
        return this.attributeMode;
    }

    public void setShowAttributes(AttributeMode selected) {
        this.changed = true;
        this.attributeMode = selected;
        this._updatePictureInBuffer();
        this.repaint();
    }

    public ColumnMode getColumnMode() {
        return this.columnMode;
    }

    public void setColumnMode(ColumnMode selected) {
        this.changed = true;
        this.columnMode = selected;
        this._updatePictureInBuffer();
        this.repaint();
    }

    public Color getColorGrid() {
        return this.colorGrid;
    }

    public void setColorGrid(Color colorGrid) {
        this.changed = true;
        this.colorGrid = colorGrid;
        this.repaint();
    }

    public Color getColorColumnBorder() {
        return this.colorColumnBorder;
    }

    public void setColorColumnBorder(Color colorColumnBorder) {
        this.changed = true;
        this.colorColumnBorder = colorColumnBorder;
        this.repaint();
    }

    public boolean isMode512() {
        return this.mode512;
    }

    public void setMode512(boolean flag) {
        this.changed = true;
        this.mode512 = flag;
        int width = flag ? 512 : 256;
        int height = flag ? 384 : 192;
        this.image = new BufferedImage(width, height, 1);
        this._updatePictureInBuffer();
        this._updatePreferredSize();
        this.revalidate();
        this.repaint();
    }

    public void resetSelectArea() {
        this.selectedArea = null;
        this.repaint();
    }

    private Point ensureInsideScreenAndEven(Point point) {
        if (this.mode512) {
            return new Point(Math.min(511, Math.max(0, point.x)), Math.min(383, Math.max(0, point.y)));
        }
        return new Point(Math.min(255, Math.max(0, point.x)), Math.min(191, Math.max(0, point.y)));
    }

    public void startSelectArea(Point editorPoint) {
        this.startSelectedAreaPoint = this.ensureInsideScreenAndEven(editorPoint);
        this.selectedArea = new Rectangle(this.ensureInsideScreenAndEven(this.startSelectedAreaPoint), new Dimension(this.mode512 ? 2 : 1, this.mode512 ? 2 : 1));
        this.repaint();
    }

    public void updateSelectArea(Point editorPoint) {
        int newH;
        int newY;
        int newW;
        int newX;
        this.changed = true;
        Point point = this.ensureInsideScreenAndEven(editorPoint);
        int dx = this.startSelectedAreaPoint.x - point.x;
        int dy = this.startSelectedAreaPoint.y - point.y;
        boolean m512 = this.mode512;
        if (dx < 0) {
            newX = this.startSelectedAreaPoint.x;
            newW = -dx;
        } else {
            newX = point.x;
            newW = dx;
        }
        if (dy < 0) {
            newY = this.startSelectedAreaPoint.y;
            newH = -dy;
        } else {
            newY = point.y;
            newH = dy;
        }
        this.selectedArea.setBounds(newX, newY, newW + 1, newH + 1);
        this.repaint();
    }

    public void endSelectArea(Point editorPoint) {
        this.updateSelectArea(editorPoint);
        this.repaint();
    }

    public int getZoom() {
        return this.zoom;
    }

    public void setZoom(int zoom) {
        this.zoom = Math.max(1, Math.min(10, zoom));
        this._updatePreferredSize();
        this.revalidate();
        this.repaint();
    }

    public void zoomIn() {
        this.zoom = Math.min(this.zoom + 1, 10);
        this._updatePreferredSize();
        this.revalidate();
        this.repaint();
    }

    public void zoomOut() {
        this.zoom = Math.max(this.zoom - 1, 1);
        this._updatePreferredSize();
        this.revalidate();
        this.repaint();
    }

    private void _updatePictureInBuffer() {
        Graphics2D gfx = this.image.createGraphics();
        gfx.setColor(Color.black);
        gfx.fillRect(0, 0, this.image.getWidth(), this.image.getHeight());
        if (this.processingData != null) {
            int columnMax;
            int addrStep;
            int column = 0;
            int x = 0;
            int y = 0;
            int step = this.mode512 ? 2 : 1;
            switch (this.columnMode.ordinal()) {
                case 2: {
                    int startAddr = this.startAddress + (this.startAddress & 1 ^ 1);
                    addrStep = 2;
                    columnMax = this.columns >> 1;
                    break;
                }
                case 1: {
                    int startAddr = this.startAddress + (this.startAddress & 1);
                    addrStep = 2;
                    columnMax = this.columns >> 1;
                    break;
                }
                default: {
                    addrStep = 1;
                    int startAddr = this.startAddress;
                    columnMax = this.columns;
                }
            }
            if (columnMax > 0) {
                int procLen = this.processingData.length();
                for (int addr = startAddr; addr < procLen; addr += addrStep) {
                    int basedata = this.processingData.getBaseData(addr);
                    int mask = this.processingData.getMask(addr);
                    int cury = this.addressingModeZXScreen ? VideoMode.y2zxy(this.mode512 ? y >> 1 : y) << (this.mode512 ? 1 : 0) : y;
                    int packedData3012 = this.processingData.getPackedZxPolyData3012(addr);
                    int data0 = packedData3012 >>> 16;
                    int data1 = packedData3012 >>> 8;
                    int data2 = packedData3012;
                    int data3 = packedData3012 >>> 24;
                    int attributeAddress = ZXPalette.calcAttributeAddressZXMode(this.startAddress, addr - this.startAddress);
                    int baseAttribute = attributeAddress >= this.processingData.length() ? 0 : this.processingData.getBaseData(attributeAddress);
                    for (int i = 0; i < 8; ++i) {
                        if ((mask & 0x80) == 0) {
                            if (this.attributeMode == AttributeMode.SHOW_BASE) {
                                Color inkColor = ZXPalette.extractInk(baseAttribute);
                                Color paperColor = ZXPalette.extractPaper(baseAttribute);
                                gfx.setColor((basedata & 0x80) == 0 ? paperColor : inkColor);
                            } else if (this.invertShowBaseData) {
                                gfx.setColor((basedata & 0x80) == 0 ? this.colorPixelOn : this.colorPixelOff);
                            } else {
                                gfx.setColor((basedata & 0x80) == 0 ? this.colorPixelOff : this.colorPixelOn);
                            }
                            gfx.fillRect(x, cury, step, step);
                        } else if (this.mode512) {
                            if (this.attributeMode == AttributeMode.SHOW_512x384_ZXPOLY_PLANES) {
                                int packedAttributes3012 = attributeAddress >= this.processingData.length() ? 0 : this.processingData.getPackedZxPolyData3012(attributeAddress);
                                int attr0 = packedAttributes3012 >>> 16 & 0xFF;
                                gfx.setColor((data0 & 0x80) == 0 ? ZXPalette.extractPaper(attr0) : ZXPalette.extractInk(attr0));
                                gfx.drawLine(x, cury, x, cury);
                                int attr1 = packedAttributes3012 >>> 8 & 0xFF;
                                gfx.setColor((data1 & 0x80) == 0 ? ZXPalette.extractPaper(attr1) : ZXPalette.extractInk(attr1));
                                gfx.drawLine(x + 1, cury, x + 1, cury);
                                int attr2 = packedAttributes3012 & 0xFF;
                                gfx.setColor((data2 & 0x80) == 0 ? ZXPalette.extractPaper(attr2) : ZXPalette.extractInk(attr2));
                                gfx.drawLine(x, cury + 1, x, cury + 1);
                                int attr3 = packedAttributes3012 >>> 24 & 0xFF;
                                gfx.setColor((data3 & 0x80) == 0 ? ZXPalette.extractPaper(attr3) : ZXPalette.extractInk(attr3));
                                gfx.drawLine(x + 1, cury + 1, x + 1, cury + 1);
                            } else {
                                gfx.setColor((data0 & 0x80) == 0 ? this.colorZX512Off : this.colorZX512On);
                                gfx.drawLine(x, cury, x, cury);
                                gfx.setColor((data1 & 0x80) == 0 ? this.colorZX512Off : this.colorZX512On);
                                gfx.drawLine(x + 1, cury, x + 1, cury);
                                gfx.setColor((data2 & 0x80) == 0 ? this.colorZX512Off : this.colorZX512On);
                                gfx.drawLine(x, cury + 1, x, cury + 1);
                                gfx.setColor((data3 & 0x80) == 0 ? this.colorZX512Off : this.colorZX512On);
                                gfx.drawLine(x + 1, cury + 1, x + 1, cury + 1);
                            }
                        } else {
                            int colorIndex = (data3 & 0x80) >>> 4 | (data0 & 0x80) >>> 5 | (data1 & 0x80) >>> 6 | (data2 & 0x80) >>> 7;
                            gfx.setColor(ZXPalette.COLORS[colorIndex]);
                            gfx.fillRect(x, cury, step, step);
                        }
                        basedata <<= 1;
                        data0 <<= 1;
                        data1 <<= 1;
                        data2 <<= 1;
                        data3 <<= 1;
                        mask <<= 1;
                        x += step;
                    }
                    if (++column < columnMax) continue;
                    x = 0;
                    column = 0;
                    if ((y += step) >= this.image.getHeight()) break;
                }
            }
        }
        gfx.dispose();
    }

    private void _updatePreferredSize() {
        this.preferredSize = new Dimension(this.getWidth(), this.getHeight());
    }

    @Override
    public Dimension getPreferredSize() {
        return this.preferredSize;
    }

    @Override
    public Dimension getMinimumSize() {
        return this.preferredSize;
    }

    @Override
    public Dimension getMaximumSize() {
        return this.preferredSize;
    }

    @Override
    public int getWidth() {
        return this.image.getWidth() * this.zoom;
    }

    @Override
    public int getHeight() {
        return this.image.getHeight() * this.zoom;
    }

    public Image getDraggedImage() {
        return this.draggedImage;
    }

    public void setDraggedImage(Image draggedImage) {
        this.draggedImage = draggedImage;
        this.repaint();
    }

    public void doStampDraggedImage() {
        if (this.draggedImage != null) {
            this.changed = true;
            int w = this.draggedImage.getWidth(null);
            int h = this.draggedImage.getHeight(null);
            int[] pixels = new int[w * h];
            PixelGrabber pixelGrabber = new PixelGrabber(this.draggedImage, 0, 0, w, h, pixels, 0, w);
            try {
                pixelGrabber.grabPixels();
            }
            catch (InterruptedException ex) {
                Thread.interrupted();
                return;
            }
            int x = this.cursorPoint.x;
            int y = this.cursorPoint.y;
            if (this.mode512) {
                for (int dy = 0; dy < h; ++dy) {
                    for (int dx = 0; dx < w; ++dx) {
                        int pixel = pixels[dy * w + dx];
                        if ((pixel >>> 24 & 0xFF) <= 0) continue;
                        if (EditorComponent.intensity(pixel) > 128.0) {
                            this.zxGraphics.setPoint(x + dx, y + dy, 15);
                            continue;
                        }
                        this.zxGraphics.setPoint(x + dx, y + dy, 0);
                    }
                }
            } else {
                for (int dy = 0; dy < h; ++dy) {
                    for (int dx = 0; dx < w; ++dx) {
                        int argb = pixels[dy * w + dx];
                        if ((argb >>> 24 & 0xFF) <= 0) continue;
                        this.zxGraphics.setPoint(x + dx, y + dy, ZXPalette.findNearestColorIndex(argb));
                    }
                }
            }
            this._updatePictureInBuffer();
            this.repaint();
        }
    }

    public boolean hasDraggedImage() {
        return this.draggedImage != null;
    }

    @Override
    public void paintComponent(Graphics g) {
        Graphics2D gfx = (Graphics2D)g;
        gfx.setRenderingHints(RENDERING_IMAGE_HINTS);
        Dimension size = this.getPreferredSize();
        gfx.drawImage(this.image, 0, 0, size.width, size.height, null);
        if (this.zoom > 1) {
            int i;
            int step;
            gfx.setRenderingHints(RENDERING_LINE_HINTS);
            int columnBorder = (this.columnMode == ColumnMode.ALL ? this.columns : this.columns >> 1) * (this.zoom << (this.mode512 ? 4 : 3));
            if (this.showGrid) {
                gfx.setStroke(GRID_STROKE);
                gfx.setColor(this.colorGrid);
                step = this.gridStep * this.zoom * (this.mode512 ? 2 : 1);
                for (i = 0; i <= columnBorder; i += step) {
                    gfx.drawLine(i, 0, i, size.height);
                }
                for (i = 0; i < size.height; i += step) {
                    gfx.drawLine(0, i, columnBorder, i);
                }
            }
            if (this.showColumnBorders) {
                step = this.zoom << (this.mode512 ? 4 : 3);
                gfx.setStroke(COLUMN_BORDER_STROKE);
                gfx.setColor(this.colorColumnBorder);
                for (i = 0; i <= columnBorder; i += step) {
                    gfx.drawLine(i, 0, i, size.height);
                }
            }
        }
        if (this.selectedArea != null) {
            gfx.setRenderingHints(RENDERING_LINE_HINTS);
            gfx.setStroke(SELECTED_AREA_STROKE);
            gfx.setColor(this.colorSelectedAreaBorder);
            Rectangle rect = new Rectangle(this.selectedArea.x * this.zoom, this.selectedArea.y * this.zoom, this.selectedArea.width * this.zoom, this.selectedArea.height * this.zoom);
            gfx.draw(rect);
        }
        if (this.draggedImage != null && this.cursorPoint != null) {
            Composite prev = gfx.getComposite();
            gfx.setComposite(AlphaComposite.getInstance(3, 0.5f));
            gfx.drawImage(this.draggedImage, this.cursorPoint.x * this.zoom, this.cursorPoint.y * this.zoom, this.draggedImage.getWidth(null) * this.zoom, this.draggedImage.getHeight(null) * this.zoom, null);
            gfx.setComposite(prev);
        }
        if (this.toolArea != null) {
            gfx.setRenderingHints(RENDERING_LINE_HINTS);
            gfx.setStroke(TOOL_AREA_STROKE);
            Rectangle zoomed = new Rectangle(this.toolArea.x * this.zoom, this.toolArea.y * this.zoom, this.toolArea.width * this.zoom, this.toolArea.height * this.zoom);
            gfx.setColor(this.colorToolArea);
            gfx.draw(zoomed);
            --zoomed.x;
            --zoomed.y;
            zoomed.width += 2;
            zoomed.height += 2;
            gfx.setColor(this.colorToolArea.darker().darker().darker());
            gfx.draw(zoomed);
        }
    }

    public boolean hasData() {
        return this.processingData != null;
    }

    public void copyPlansFromBase() {
        if (this.processingData != null) {
            this.processingData.copyPlansFromBase();
            this._updatePictureInBuffer();
            this.repaint();
        }
    }

    @Override
    public Object getValue() {
        return this.getAddress();
    }

    @Override
    public void setValue(Object addr) {
        int address = (Integer)addr;
        this.setAddress(address);
    }

    @Override
    public Object getNextValue() {
        if (this.hasData()) {
            return Math.min(this.getProcessingData().length() - 1, this.startAddress + 1);
        }
        return 0;
    }

    @Override
    public Object getPreviousValue() {
        if (this.hasData()) {
            return Math.max(0, this.startAddress - 1);
        }
        return 0;
    }

    @Override
    public void addChangeListener(ChangeListener l) {
        this.changeListeners.add(l);
    }

    @Override
    public void removeChangeListener(ChangeListener l) {
        this.changeListeners.remove(l);
    }

    static {
        RENDERING_IMAGE_HINTS.put(RenderingHints.KEY_COLOR_RENDERING, RenderingHints.VALUE_COLOR_RENDER_SPEED);
        RENDERING_IMAGE_HINTS.put(RenderingHints.KEY_DITHERING, RenderingHints.VALUE_DITHER_DISABLE);
        RENDERING_LINE_HINTS.put(RenderingHints.KEY_COLOR_RENDERING, RenderingHints.VALUE_COLOR_RENDER_SPEED);
    }

    public static final class ZXGraphics {
        private final EditorComponent editor;

        private ZXGraphics(EditorComponent editor) {
            this.editor = editor;
        }

        private static int makeXMask(int x) {
            return 1 << 7 - (x & 7);
        }

        public int coordToAddress(int x, int y) {
            int result;
            ZXPolyData data = this.editor.processingData;
            if (data == null || x < 0 || y < 0) {
                result = -1;
            } else {
                int dy;
                int vcolumn;
                boolean m512 = this.editor.mode512;
                int columns = this.editor.columns;
                int n = vcolumn = m512 ? x >> 4 : x >> 3;
                if (vcolumn > 31) {
                    return -1;
                }
                int startAddr = this.editor.startAddress;
                switch (this.editor.columnMode.ordinal()) {
                    case 2: {
                        startAddr += startAddr & 1 ^ 1;
                        x += vcolumn << (m512 ? 4 : 3);
                        break;
                    }
                    case 1: {
                        startAddr += startAddr & 1;
                        x += vcolumn << (m512 ? 4 : 3);
                    }
                }
                int dx = m512 ? x >> 1 : x;
                int n2 = dy = m512 ? y >> 1 : y;
                if (dy > 191) {
                    return -1;
                }
                int theY = this.editor.addressingModeZXScreen ? VideoMode.zxy2y(dy) : dy;
                int rowAddress = theY * columns + startAddr;
                result = dx >= columns << 3 || rowAddress >= data.length() ? -1 : (dx >>> 3) + rowAddress;
            }
            return result;
        }

        public ZXGraphics setPoint(int x, int y, int cpu3012) {
            int address = this.coordToAddress(x, y);
            if (address >= 0) {
                int mask = this.editor.processingData.getMask(address);
                int packed3012 = this.editor.processingData.getPackedZxPolyData3012(address);
                if (this.editor.mode512) {
                    int bitmask = ZXGraphics.makeXMask(x >> 1);
                    int invertedbitmask = ~bitmask;
                    int value = (cpu3012 == 0 ? 0 : 255) & bitmask;
                    if ((x & 1) == 0) {
                        if ((y & 1) == 0) {
                            this.editor.processingData.setZXPolyData(address, mask | bitmask, packed3012 >>> 16 & invertedbitmask | value, packed3012 >>> 8, packed3012, packed3012 >>> 24);
                        } else {
                            this.editor.processingData.setZXPolyData(address, mask | bitmask, packed3012 >>> 16, packed3012 >>> 8, packed3012 & invertedbitmask | value, packed3012 >>> 24);
                        }
                    } else if ((y & 1) == 0) {
                        this.editor.processingData.setZXPolyData(address, mask | bitmask, packed3012 >>> 16, packed3012 >>> 8 & invertedbitmask | value, packed3012, packed3012 >>> 24);
                    } else {
                        this.editor.processingData.setZXPolyData(address, mask | bitmask, packed3012 >>> 16, packed3012 >>> 8, packed3012, packed3012 >>> 24 & invertedbitmask | value);
                    }
                } else {
                    int bitmask = ZXGraphics.makeXMask(x);
                    int invertedbitmask = ~bitmask;
                    this.editor.processingData.setZXPolyData(address, mask | bitmask, packed3012 >>> 16 & invertedbitmask | ((cpu3012 & 4) == 0 ? 0 : 255) & bitmask, packed3012 >>> 8 & invertedbitmask | ((cpu3012 & 2) == 0 ? 0 : 255) & bitmask, packed3012 & invertedbitmask | ((cpu3012 & 1) == 0 ? 0 : 255) & bitmask, packed3012 >>> 24 & invertedbitmask | ((cpu3012 & 8) == 0 ? 0 : 255) & bitmask);
                }
            }
            return this;
        }

        public ZXGraphics resetPoint(int x, int y, boolean copyBasePointToPlanes) {
            int address = this.coordToAddress(x, y);
            if (address >= 0) {
                int mask = this.editor.processingData.getMask(address);
                if (copyBasePointToPlanes) {
                    boolean reset;
                    int packed3012 = this.editor.processingData.getPackedZxPolyData3012(address);
                    int bitmask = ZXGraphics.makeXMask(x >> (this.editor.mode512 ? 1 : 0));
                    boolean bl = reset = (this.editor.processingData.getBaseData(address) & bitmask) == 0;
                    if (reset) {
                        int invertedmask = ~bitmask;
                        this.editor.processingData.setZXPolyData(address, bitmask | this.editor.processingData.getMask(address), packed3012 >>> 16 & invertedmask, packed3012 >>> 8 & invertedmask, packed3012 & invertedmask, packed3012 >>> 24 & invertedmask);
                    } else {
                        this.editor.processingData.setZXPolyData(address, bitmask | this.editor.processingData.getMask(address), packed3012 >>> 16 | bitmask, packed3012 >>> 8 | bitmask, packed3012 | bitmask, packed3012 >>> 24 | bitmask);
                    }
                } else {
                    int packed3012 = this.editor.processingData.getPackedZxPolyData3012(address);
                    int bitmask = ZXGraphics.makeXMask(x >> (this.editor.mode512 ? 1 : 0));
                    int invertedbitmask = ~bitmask;
                    this.editor.processingData.setZXPolyData(address, mask & invertedbitmask, packed3012 >>> 16 & invertedbitmask, packed3012 >>> 8 & invertedbitmask, packed3012 & invertedbitmask, packed3012 >>> 24 & invertedbitmask);
                }
            }
            return this;
        }

        public boolean isPointSetIn512(int x, int y) {
            int address = this.coordToAddress(x, y);
            boolean result = false;
            int bitmask = ZXGraphics.makeXMask(x >> 1);
            if ((this.editor.processingData.getMask(address) & bitmask) != 0) {
                int packedData3012 = this.editor.processingData.getPackedZxPolyData3012(address);
                int xshift = x >> 1 & 7;
                int data0 = packedData3012 >>> 16 << xshift;
                int data1 = packedData3012 >>> 8 << xshift;
                int data2 = packedData3012 << xshift;
                int data3 = packedData3012 >>> 24 << xshift;
                result = (y & 1) == 0 ? ((x & 1) == 0 ? (data0 & 0x80) != 0 : (data1 & 0x80) != 0) : ((x & 1) == 0 ? (data2 & 0x80) != 0 : (data3 & 0x80) != 0);
            }
            return result;
        }

        public int getPoint3012(int x, int y) {
            int address = this.coordToAddress(x, y);
            int result = 0;
            if (address >= 0) {
                int packed3012;
                int bitmask = ZXGraphics.makeXMask(x >> (this.editor.mode512 ? 1 : 0));
                result = (this.editor.processingData.getMask(address) & bitmask) == 0 ? 0 : (((packed3012 = this.editor.processingData.getPackedZxPolyData3012(address)) & bitmask) == 0 ? 0 : 1) | ((packed3012 & bitmask << 8) == 0 ? 0 : 2) | ((packed3012 & bitmask << 16) == 0 ? 0 : 4) | ((packed3012 & bitmask << 24) == 0 ? 0 : 8);
            }
            return result;
        }

        public boolean isBaseBitSet(int x, int y) {
            int address = this.coordToAddress(x, y);
            if (address >= 0) {
                return (this.editor.processingData.getBaseData(address) & ZXGraphics.makeXMask(x >> (this.editor.mode512 ? 1 : 0))) != 0;
            }
            return false;
        }

        public void flush() {
            this.editor._updatePictureInBuffer();
            this.editor.repaint();
        }
    }

    public static enum AttributeMode {
        DONT_SHOW,
        SHOW_BASE,
        SHOW_512x384_ZXPOLY_PLANES;

    }

    public static enum ColumnMode {
        ALL,
        ODD,
        EVEN;

    }
}

