/*
 * Decompiled with CFR 0.152.
 */
package com.igormaznitsa.zxpspritecorrector.components;

import com.igormaznitsa.zxpspritecorrector.files.Info;
import com.igormaznitsa.zxpspritecorrector.files.plugins.AbstractFilePlugin;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Font;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.util.List;
import javax.swing.DefaultListModel;
import javax.swing.JFileChooser;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.ListCellRenderer;

public class InsideFileView
extends JPanel
implements PropertyChangeListener {
    private static final long serialVersionUID = -3736184888649683739L;
    private final JFileChooser chooser;
    private final DefaultListModel<String> listModel = new DefaultListModel();
    private JScrollPane jScrollPane1;
    private JList listFiles;

    public InsideFileView(JFileChooser chooser) {
        this.initComponents();
        this.chooser = chooser;
        this.chooser.addPropertyChangeListener(this);
        this.listFiles.setModel(this.listModel);
        final InsideFileView thePanel = this;
        this.listFiles.setCellRenderer(new ListCellRenderer(){
            private final JTextArea renderer = new JTextArea();
            final /* synthetic */ InsideFileView this$0;
            {
                this.this$0 = this$0;
            }

            public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                this.renderer.setFont(list.getFont());
                this.renderer.setBackground(list.getBackground());
                this.renderer.setForeground(list.getForeground());
                this.renderer.setOpaque(false);
                this.renderer.setWrapStyleWord(false);
                this.renderer.setLineWrap(false);
                this.renderer.setEditable(false);
                this.renderer.setText(value.toString());
                this.renderer.setBorder(null);
                thePanel.revalidate();
                thePanel.repaint();
                return this.renderer;
            }
        });
    }

    private void initComponents() {
        this.jScrollPane1 = new JScrollPane();
        this.listFiles = new JList();
        this.setLayout(new BorderLayout());
        this.listFiles.setFont(new Font("Courier New", 0, 10));
        this.listFiles.setSelectionMode(0);
        this.listFiles.setEnabled(false);
        this.jScrollPane1.setViewportView(this.listFiles);
        this.add((Component)this.jScrollPane1, "Center");
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        String changeName = evt.getPropertyName();
        if (changeName.equals("SelectedFileChangedProperty")) {
            File file = (File)evt.getNewValue();
            this.listModel.clear();
            if (file != null) {
                AbstractFilePlugin plugin = (AbstractFilePlugin)this.chooser.getFileFilter();
                if (plugin.doesContainInternalFileItems()) {
                    List<Info> info = plugin.getImportingContainerFileList(file);
                    if (info == null) {
                        this.listModel.addElement("   Wrong format   ");
                    } else {
                        for (Info s : info) {
                            this.listModel.addElement(s.toString());
                        }
                    }
                } else {
                    String fileReference = plugin.getImportingFileInfo(file);
                    if (fileReference == null) {
                        this.listModel.addElement("   Wrong format   ");
                    } else {
                        this.listModel.addElement(fileReference);
                    }
                }
            }
        }
    }
}

