/*
 * Decompiled with CFR 0.152.
 */
package com.igormaznitsa.zxpspritecorrector.components;

import com.igormaznitsa.zxpspritecorrector.files.Info;
import com.igormaznitsa.zxpspritecorrector.files.plugins.AbstractFilePlugin;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.io.File;
import java.io.IOException;
import java.util.List;
import java.util.Objects;
import javax.swing.DefaultListModel;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.LayoutStyle;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableModel;

public class SelectInsideDataDialog
extends JDialog
implements TableModel {
    private static final long serialVersionUID = -1593974231619108719L;
    private final List<Info> infoList;
    private int result = -1;
    private JButton buttonCancel;
    private JButton buttonOk;
    private JTable itemTable;

    public SelectInsideDataDialog(Frame parent, File file, AbstractFilePlugin plugin) throws IOException {
        super(parent, true);
        this.initComponents();
        this.setLocationRelativeTo(parent);
        this.setTitle(file.getName());
        this.infoList = plugin.getImportingContainerFileList(file);
        if (this.infoList == null) {
            throw new IOException("Can't get list of container items");
        }
        DefaultListModel<Info> model = new DefaultListModel<Info>();
        for (Info s : this.infoList) {
            model.addElement(s);
        }
        this.buttonOk.setEnabled(false);
        this.itemTable.setModel(this);
        this.itemTable.getSelectionModel().addListSelectionListener(this::onItemSelection);
    }

    private void onItemSelection(ListSelectionEvent event) {
        int selectedIndex = this.itemTable.getSelectedRow();
        if (selectedIndex < 0) {
            this.buttonOk.setEnabled(false);
        } else {
            Info info = this.infoList.get(selectedIndex);
            this.buttonOk.setEnabled(info.isSelectable());
        }
    }

    private void initComponents() {
        this.buttonCancel = new JButton();
        this.buttonOk = new JButton();
        JScrollPane jScrollPane2 = new JScrollPane();
        this.itemTable = new JTable();
        this.setDefaultCloseOperation(2);
        this.buttonCancel.setIcon(new ImageIcon(Objects.requireNonNull(this.getClass().getResource("/com/igormaznitsa/zxpspritecorrector/icons/cross.png"))));
        this.buttonCancel.setText("Cancel");
        this.buttonCancel.addActionListener(this::buttonCancelActionPerformed);
        this.buttonOk.setIcon(new ImageIcon(Objects.requireNonNull(this.getClass().getResource("/com/igormaznitsa/zxpspritecorrector/icons/tick.png"))));
        this.buttonOk.setText("Ok");
        this.buttonOk.addActionListener(this::buttonOkActionPerformed);
        this.itemTable.setModel(new DefaultTableModel(new Object[0][], new String[0]));
        this.itemTable.setSelectionMode(0);
        jScrollPane2.setViewportView(this.itemTable);
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGap(0, 127, Short.MAX_VALUE).addComponent(this.buttonOk).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.buttonCancel)).addComponent(jScrollPane2, GroupLayout.Alignment.TRAILING, -2, 0, Short.MAX_VALUE)).addContainerGap()));
        layout.linkSize(0, this.buttonCancel, this.buttonOk);
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addGap(13, 13, 13).addComponent(jScrollPane2, -1, 240, Short.MAX_VALUE).addGap(9, 9, 9).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.buttonCancel).addComponent(this.buttonOk)).addContainerGap()));
        this.pack();
    }

    private void buttonOkActionPerformed(ActionEvent evt) {
        this.result = this.itemTable.getSelectedRow();
        this.setVisible(false);
    }

    private void buttonCancelActionPerformed(ActionEvent evt) {
        this.result = -1;
        this.setVisible(false);
    }

    public int getSelectedIndex() {
        return this.result;
    }

    @Override
    public int getRowCount() {
        return this.infoList.size();
    }

    @Override
    public int getColumnCount() {
        return 3;
    }

    @Override
    public String getColumnName(int columnIndex) {
        switch (columnIndex) {
            case 0: {
                return "Name";
            }
            case 1: {
                return "Type";
            }
            case 2: {
                return "Size";
            }
        }
        return null;
    }

    @Override
    public Class<?> getColumnClass(int columnIndex) {
        return String.class;
    }

    @Override
    public boolean isCellEditable(int rowIndex, int columnIndex) {
        return false;
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        Info row = this.infoList.get(rowIndex);
        switch (columnIndex) {
            case 0: {
                return row.getName();
            }
            case 1: {
                return Character.toString(row.getType());
            }
            case 2: {
                return Integer.toString(row.getLength());
            }
        }
        return null;
    }

    @Override
    public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
    }

    @Override
    public void addTableModelListener(TableModelListener l) {
    }

    @Override
    public void removeTableModelListener(TableModelListener l) {
    }
}

