/*
 * Decompiled with CFR 0.152.
 */
package com.igormaznitsa.zxpspritecorrector.components;

import java.awt.Dimension;

public enum VideoMode {
    ZXPOLY(256, 192),
    ZX_512x384(512, 384);

    private static final byte[] LINEAR_TO_ZX_Y;
    private static final byte[] ZX_Y_TO_LINEAR;
    private final Dimension size;

    private VideoMode(int width, int height) {
        this.size = new Dimension(width, height);
    }

    public static int zxy2y(int y) {
        return ZX_Y_TO_LINEAR[y] & 0xFF;
    }

    public static int y2zxy(int y) {
        return LINEAR_TO_ZX_Y[y] & 0xFF;
    }

    public static int extractYFromAddress(int address) {
        return (address & 0x1800) >> 5 | (address & 0x700) >> 8 | (address & 0xE0) >> 2;
    }

    public static int extractXFromAddress(int address) {
        return address & 0x1F;
    }

    public Dimension getSize() {
        return this.size;
    }

    static {
        LINEAR_TO_ZX_Y = new byte[192];
        ZX_Y_TO_LINEAR = new byte[192];
        int a = 16384;
        for (int y = 0; y < 192; ++y) {
            int zxy = VideoMode.extractYFromAddress(a);
            VideoMode.LINEAR_TO_ZX_Y[y] = (byte)zxy;
            VideoMode.ZX_Y_TO_LINEAR[zxy] = (byte)y;
            a += 32;
        }
    }
}

