/*
 * Decompiled with CFR 0.152.
 */
package com.igormaznitsa.zxpspritecorrector.files;

import com.igormaznitsa.jbbp.io.JBBPBitInputStream;
import com.igormaznitsa.jbbp.io.JBBPByteOrder;
import com.igormaznitsa.jbbp.io.JBBPOut;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;

public class Info {
    private final String name;
    private final char type;
    private final int startAddress;
    private final int length;
    private final int offset;
    private final byte[] extra;
    private final boolean selectable;

    public Info(String name, char type, int startAddress, int length, int offset, boolean selectable, byte ... extra) {
        this.name = name;
        this.type = type;
        this.startAddress = startAddress;
        this.length = length;
        this.offset = offset;
        this.extra = extra;
        this.selectable = selectable;
    }

    public Info(InputStream in, boolean selectable) throws IOException {
        JBBPBitInputStream bitin = new JBBPBitInputStream(in);
        this.name = new String(bitin.readByteArray(bitin.readByte()), StandardCharsets.US_ASCII);
        this.type = (char)bitin.readUnsignedShort(JBBPByteOrder.BIG_ENDIAN);
        this.startAddress = bitin.readInt(JBBPByteOrder.BIG_ENDIAN);
        this.length = bitin.readInt(JBBPByteOrder.BIG_ENDIAN);
        this.offset = bitin.readInt(JBBPByteOrder.BIG_ENDIAN);
        this.extra = bitin.readByteArray(bitin.readInt(JBBPByteOrder.BIG_ENDIAN));
        this.selectable = selectable;
    }

    public boolean isSelectable() {
        return this.selectable;
    }

    public JBBPOut save(JBBPOut context) throws IOException {
        context.Byte(this.name.length()).Byte(this.name).Short((int)this.type).Int(this.startAddress, this.length, this.offset).Int(this.extra.length).Byte(this.extra);
        return context;
    }

    public byte[] getExtra() {
        return this.extra;
    }

    public int getOffset() {
        return this.offset;
    }

    public String getName() {
        return this.name;
    }

    public char getType() {
        return this.type;
    }

    public int getStartAddress() {
        return this.startAddress;
    }

    public int getLength() {
        return this.length;
    }

    public String toString() {
        StringBuilder result = new StringBuilder(32);
        result.append("  ");
        result.append(this.name);
        while (result.length() < 10) {
            result.append(' ');
        }
        while (result.length() < 18) {
            result.append('.');
        }
        result.append('<').append(this.type).append('>').append(' ').append(this.length).append(" bytes").append("  ");
        return result.toString();
    }
}

