/*
 * Decompiled with CFR 0.152.
 */
package com.igormaznitsa.zxpspritecorrector.files;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Properties;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;
import javax.swing.SwingUtilities;

public class Spec256ConfigEditorPanel
extends JPanel {
    private JButton buttonResetToDefault;
    private JCheckBox checkBkMixBkAttr;
    private JCheckBox checkBkMixed;
    private JCheckBox checkBkOverFF;
    private JCheckBox checkCpuMCPUPtrs;
    private JCheckBox checkCpuRegA;
    private JCheckBox checkCpuRegAltA;
    private JCheckBox checkCpuRegAltB;
    private JCheckBox checkCpuRegAltC;
    private JCheckBox checkCpuRegAltD;
    private JCheckBox checkCpuRegAltE;
    private JCheckBox checkCpuRegAltF;
    private JCheckBox checkCpuRegAltH;
    private JCheckBox checkCpuRegAltL;
    private JCheckBox checkCpuRegB;
    private JCheckBox checkCpuRegC;
    private JCheckBox checkCpuRegD;
    private JCheckBox checkCpuRegE;
    private JCheckBox checkCpuRegF;
    private JCheckBox checkCpuRegFaltExclC;
    private JCheckBox checkCpuRegFexclC;
    private JCheckBox checkCpuRegH;
    private JCheckBox checkCpuRegIXh;
    private JCheckBox checkCpuRegIXl;
    private JCheckBox checkCpuRegIYh;
    private JCheckBox checkCpuRegIYl;
    private JCheckBox checkCpuRegL;
    private JCheckBox checkCpuRegPc;
    private JCheckBox checkCpuRegSPh;
    private JCheckBox checkCpuRegSPl;
    private JCheckBox checkDownMixPaper;
    private JCheckBox checkGFXLeveledAND;
    private JCheckBox checkGFXLeveledOR;
    private JCheckBox checkGFXLeveledXOR;
    private JCheckBox checkGFXScreenXORBuffered;
    private JCheckBox checkPaper00InkFF;
    private JCheckBox checkUpMixPaper;
    private JCheckBox checkUseBrightInMix;
    private JCheckBox checkHideSameInkPaper;
    private Box.Filler filler1;
    private Box.Filler filler2;
    private Box.Filler filler3;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JPanel jPanel3;
    private JSpinner spinnerDownColorsMixed;
    private JSpinner spinnerDownMixChgBright;
    private JSpinner spinnerUpColorsMixed;
    private JSpinner spinnerUpMixChgBright;
    private JPanel syncRegsPanel;

    public Spec256ConfigEditorPanel(Properties config) {
        this.initComponents();
        this.fill(config == null ? Spec256ConfigEditorPanel.makeDefault() : config);
    }

    public static Properties makeDefault() {
        Properties result = new Properties();
        result.put("GFXLeveledXOR", "0");
        result.put("GFXLeveledOR", "0");
        result.put("GFXLeveledAND", "0");
        result.put("GFXScreenXORBuffered", "0");
        result.put("UpColorsMixed", "0");
        result.put("DownColorsMixed", "0");
        result.put("UpMixChgBright", "0");
        result.put("DownMixChgBright", "0");
        result.put("UseBrightInMix", "0");
        result.put("UpMixPaper", "0");
        result.put("DownMixPaper", "0");
        result.put("BkMixed", "0");
        result.put("BkMixBkAttr", "0");
        result.put("BkOverFF", "0");
        result.put("HideSameInkPaper", "1");
        result.put("zxpAlignRegs", "PSs");
        result.put("GFXColors16", "1");
        return result;
    }

    private static boolean isPropertySet(String name, Properties properties, boolean defaultValue) {
        String value = properties.getProperty(name, defaultValue ? "1" : "0");
        return !"0".equals(value.trim());
    }

    private static int getValue(String name, Properties properties, int min, int max) {
        String value = properties.getProperty(name);
        if (value == null) {
            return min;
        }
        try {
            return Math.max(min, Math.min(Integer.parseInt(value.trim()), max));
        }
        catch (NumberFormatException ex) {
            return min;
        }
    }

    private void fill(Properties properties) {
        this.checkGFXLeveledXOR.setSelected(Spec256ConfigEditorPanel.isPropertySet("GFXLeveledXOR", properties, false));
        this.checkGFXLeveledOR.setSelected(Spec256ConfigEditorPanel.isPropertySet("GFXLeveledOR", properties, false));
        this.checkGFXLeveledAND.setSelected(Spec256ConfigEditorPanel.isPropertySet("GFXLeveledAND", properties, false));
        this.checkGFXScreenXORBuffered.setSelected(Spec256ConfigEditorPanel.isPropertySet("GFXScreenXORBuffered", properties, false));
        this.checkPaper00InkFF.setSelected(Spec256ConfigEditorPanel.isPropertySet("Paper00InkFF", properties, false));
        this.checkUseBrightInMix.setSelected(Spec256ConfigEditorPanel.isPropertySet("UseBrightInMix", properties, false));
        this.checkHideSameInkPaper.setSelected(Spec256ConfigEditorPanel.isPropertySet("HideSameInkPaper", properties, true));
        this.checkUpMixPaper.setSelected(Spec256ConfigEditorPanel.isPropertySet("UpMixPaper", properties, false));
        this.checkDownMixPaper.setSelected(Spec256ConfigEditorPanel.isPropertySet("DownMixPaper", properties, false));
        this.checkBkMixed.setSelected(Spec256ConfigEditorPanel.isPropertySet("BkMixed", properties, false));
        this.checkBkMixBkAttr.setSelected(Spec256ConfigEditorPanel.isPropertySet("BkMixBkAttr", properties, false));
        this.checkBkOverFF.setSelected(Spec256ConfigEditorPanel.isPropertySet("BkOverFF", properties, false));
        String gfxRegisters = properties.getProperty("zxpAlignRegs", "");
        this.checkCpuRegA.setSelected(gfxRegisters.contains("A"));
        this.checkCpuRegAltA.setSelected(gfxRegisters.contains("a"));
        this.checkCpuRegF.setSelected(gfxRegisters.contains("F"));
        this.checkCpuRegAltF.setSelected(gfxRegisters.contains("f"));
        this.checkCpuRegFexclC.setSelected(gfxRegisters.contains("1"));
        this.checkCpuRegFaltExclC.setSelected(gfxRegisters.contains("0"));
        this.checkCpuRegB.setSelected(gfxRegisters.contains("B"));
        this.checkCpuRegAltB.setSelected(gfxRegisters.contains("b"));
        this.checkCpuRegC.setSelected(gfxRegisters.contains("C"));
        this.checkCpuRegAltC.setSelected(gfxRegisters.contains("c"));
        this.checkCpuRegD.setSelected(gfxRegisters.contains("D"));
        this.checkCpuRegAltD.setSelected(gfxRegisters.contains("d"));
        this.checkCpuRegE.setSelected(gfxRegisters.contains("E"));
        this.checkCpuRegAltE.setSelected(gfxRegisters.contains("e"));
        this.checkCpuRegH.setSelected(gfxRegisters.contains("H"));
        this.checkCpuRegAltH.setSelected(gfxRegisters.contains("h"));
        this.checkCpuRegL.setSelected(gfxRegisters.contains("L"));
        this.checkCpuRegAltL.setSelected(gfxRegisters.contains("l"));
        this.checkCpuRegPc.setSelected(gfxRegisters.contains("P"));
        this.checkCpuRegSPh.setSelected(gfxRegisters.contains("S"));
        this.checkCpuRegSPl.setSelected(gfxRegisters.contains("s"));
        this.checkCpuRegIXh.setSelected(gfxRegisters.contains("X"));
        this.checkCpuRegIXl.setSelected(gfxRegisters.contains("x"));
        this.checkCpuRegIYh.setSelected(gfxRegisters.contains("Y"));
        this.checkCpuRegIYl.setSelected(gfxRegisters.contains("y"));
        this.checkCpuMCPUPtrs.setSelected(gfxRegisters.contains("T"));
        this.spinnerUpColorsMixed.setValue(Spec256ConfigEditorPanel.getValue("UpColorsMixed", properties, 0, 64));
        this.spinnerDownColorsMixed.setValue(Spec256ConfigEditorPanel.getValue("DownColorsMixed", properties, 0, 64));
        this.spinnerDownMixChgBright.setValue(Spec256ConfigEditorPanel.getValue("DownMixChgBright", properties, 0, 100));
        this.spinnerUpMixChgBright.setValue(Spec256ConfigEditorPanel.getValue("UpMixChgBright", properties, 0, 100));
    }

    public void reset() {
        SwingUtilities.invokeLater(() -> {
            this.fill(Spec256ConfigEditorPanel.makeDefault());
            this.repaint();
        });
    }

    private String makeGfxRegistersSync() {
        StringBuilder result = new StringBuilder();
        result.append(this.checkCpuRegA.isSelected() ? "A" : "");
        result.append(this.checkCpuRegAltA.isSelected() ? "a" : "");
        result.append(this.checkCpuRegF.isSelected() ? "F" : "");
        result.append(this.checkCpuRegAltF.isSelected() ? "f" : "");
        result.append(this.checkCpuRegFexclC.isSelected() ? "1" : "");
        result.append(this.checkCpuRegFaltExclC.isSelected() ? "0" : "");
        result.append(this.checkCpuRegB.isSelected() ? "B" : "");
        result.append(this.checkCpuRegAltB.isSelected() ? "b" : "");
        result.append(this.checkCpuRegC.isSelected() ? "C" : "");
        result.append(this.checkCpuRegAltC.isSelected() ? "c" : "");
        result.append(this.checkCpuRegD.isSelected() ? "D" : "");
        result.append(this.checkCpuRegAltD.isSelected() ? "d" : "");
        result.append(this.checkCpuRegE.isSelected() ? "E" : "");
        result.append(this.checkCpuRegAltE.isSelected() ? "e" : "");
        result.append(this.checkCpuRegH.isSelected() ? "H" : "");
        result.append(this.checkCpuRegAltH.isSelected() ? "h" : "");
        result.append(this.checkCpuRegL.isSelected() ? "L" : "");
        result.append(this.checkCpuRegAltL.isSelected() ? "l" : "");
        result.append(this.checkCpuRegPc.isSelected() ? "P" : "");
        result.append(this.checkCpuRegSPh.isSelected() ? "S" : "");
        result.append(this.checkCpuRegSPl.isSelected() ? "s" : "");
        result.append(this.checkCpuRegIXh.isSelected() ? "X" : "");
        result.append(this.checkCpuRegIXl.isSelected() ? "x" : "");
        result.append(this.checkCpuRegIYh.isSelected() ? "Y" : "");
        result.append(this.checkCpuRegIYl.isSelected() ? "y" : "");
        result.append(this.checkCpuMCPUPtrs.isSelected() ? "T" : "");
        return result.toString();
    }

    public Properties make() {
        Properties properties = new Properties();
        properties.setProperty("zxpAlignRegs", this.makeGfxRegistersSync());
        properties.setProperty("GFXLeveledXOR", this.checkGFXLeveledXOR.isSelected() ? "1" : "0");
        properties.setProperty("GFXLeveledOR", this.checkGFXLeveledOR.isSelected() ? "1" : "0");
        properties.setProperty("GFXLeveledAND", this.checkGFXLeveledAND.isSelected() ? "1" : "0");
        properties.setProperty("GFXScreenXORBuffered", this.checkGFXScreenXORBuffered.isSelected() ? "1" : "0");
        properties.setProperty("Paper00InkFF", this.checkPaper00InkFF.isSelected() ? "1" : "0");
        properties.setProperty("UseBrightInMix", this.checkUseBrightInMix.isSelected() ? "1" : "0");
        properties.setProperty("HideSameInkPaper", this.checkHideSameInkPaper.isSelected() ? "1" : "0");
        properties.setProperty("UpMixPaper", this.checkUpMixPaper.isSelected() ? "1" : "0");
        properties.setProperty("DownMixPaper", this.checkDownMixPaper.isSelected() ? "1" : "0");
        properties.setProperty("BkMixed", this.checkBkMixed.isSelected() ? "1" : "0");
        properties.setProperty("BkMixBkAttr", this.checkBkMixBkAttr.isSelected() ? "1" : "0");
        properties.setProperty("BkOverFF", this.checkBkOverFF.isSelected() ? "1" : "0");
        properties.setProperty("UpColorsMixed", this.spinnerUpColorsMixed.getValue().toString());
        properties.setProperty("DownColorsMixed", this.spinnerDownColorsMixed.getValue().toString());
        properties.setProperty("DownMixChgBright", this.spinnerDownMixChgBright.getValue().toString());
        properties.setProperty("UpMixChgBright", this.spinnerUpMixChgBright.getValue().toString());
        return properties;
    }

    private void initComponents() {
        this.syncRegsPanel = new JPanel();
        this.checkCpuRegA = new JCheckBox();
        this.checkCpuRegAltA = new JCheckBox();
        this.checkCpuRegF = new JCheckBox();
        this.checkCpuRegAltF = new JCheckBox();
        this.checkCpuRegB = new JCheckBox();
        this.checkCpuRegAltB = new JCheckBox();
        this.checkCpuRegC = new JCheckBox();
        this.checkCpuRegAltC = new JCheckBox();
        this.checkCpuRegD = new JCheckBox();
        this.checkCpuRegAltD = new JCheckBox();
        this.checkCpuRegE = new JCheckBox();
        this.checkCpuRegAltE = new JCheckBox();
        this.checkCpuRegH = new JCheckBox();
        this.checkCpuRegAltH = new JCheckBox();
        this.checkCpuRegL = new JCheckBox();
        this.checkCpuRegAltL = new JCheckBox();
        this.checkCpuRegPc = new JCheckBox();
        this.checkCpuRegSPh = new JCheckBox();
        this.checkCpuRegSPl = new JCheckBox();
        this.checkCpuRegFexclC = new JCheckBox();
        this.checkCpuRegFaltExclC = new JCheckBox();
        this.checkCpuRegIXh = new JCheckBox();
        this.checkCpuRegIXl = new JCheckBox();
        this.checkCpuRegIYh = new JCheckBox();
        this.checkCpuRegIYl = new JCheckBox();
        this.checkCpuMCPUPtrs = new JCheckBox();
        this.jPanel1 = new JPanel();
        this.checkGFXLeveledXOR = new JCheckBox();
        this.checkGFXLeveledOR = new JCheckBox();
        this.checkGFXLeveledAND = new JCheckBox();
        this.checkGFXScreenXORBuffered = new JCheckBox();
        this.checkPaper00InkFF = new JCheckBox();
        this.checkBkMixed = new JCheckBox();
        this.checkBkMixBkAttr = new JCheckBox();
        this.checkBkOverFF = new JCheckBox();
        this.checkUseBrightInMix = new JCheckBox();
        this.checkHideSameInkPaper = new JCheckBox();
        this.checkUpMixPaper = new JCheckBox();
        this.checkDownMixPaper = new JCheckBox();
        this.filler1 = new Box.Filler(new Dimension(0, 0), new Dimension(0, 0), new Dimension(0, Short.MAX_VALUE));
        this.jPanel2 = new JPanel();
        this.jLabel1 = new JLabel();
        this.jLabel2 = new JLabel();
        this.jLabel3 = new JLabel();
        this.jLabel4 = new JLabel();
        this.spinnerUpColorsMixed = new JSpinner();
        this.spinnerDownColorsMixed = new JSpinner();
        this.spinnerUpMixChgBright = new JSpinner();
        this.spinnerDownMixChgBright = new JSpinner();
        this.filler2 = new Box.Filler(new Dimension(0, 0), new Dimension(0, 0), new Dimension(Short.MAX_VALUE, 0));
        this.filler3 = new Box.Filler(new Dimension(0, 0), new Dimension(0, 0), new Dimension(0, Short.MAX_VALUE));
        this.jPanel3 = new JPanel();
        this.buttonResetToDefault = new JButton();
        this.setLayout(new GridBagLayout());
        this.syncRegsPanel.setBorder(BorderFactory.createTitledBorder("Sync GFX CPU registers"));
        this.syncRegsPanel.setLayout(new GridBagLayout());
        this.checkCpuRegA.setText("A");
        this.checkCpuRegA.setToolTipText("Register A");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 8, 0, 0);
        this.syncRegsPanel.add((Component)this.checkCpuRegA, gridBagConstraints);
        this.checkCpuRegAltA.setText("A'");
        this.checkCpuRegAltA.setToolTipText("Register alt A");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 8, 0, 0);
        this.syncRegsPanel.add((Component)this.checkCpuRegAltA, gridBagConstraints);
        this.checkCpuRegF.setText("F");
        this.checkCpuRegF.setToolTipText("Register F");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 8, 0, 0);
        this.syncRegsPanel.add((Component)this.checkCpuRegF, gridBagConstraints);
        this.checkCpuRegAltF.setText("F'");
        this.checkCpuRegAltF.setToolTipText("Register alt F");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 8, 0, 0);
        this.syncRegsPanel.add((Component)this.checkCpuRegAltF, gridBagConstraints);
        this.checkCpuRegB.setText("B");
        this.checkCpuRegB.setToolTipText("Register B");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 8, 0, 0);
        this.syncRegsPanel.add((Component)this.checkCpuRegB, gridBagConstraints);
        this.checkCpuRegAltB.setText("B'");
        this.checkCpuRegAltB.setToolTipText("Register alt B");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 8, 0, 0);
        this.syncRegsPanel.add((Component)this.checkCpuRegAltB, gridBagConstraints);
        this.checkCpuRegC.setText("C");
        this.checkCpuRegC.setToolTipText("Register C");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 8, 0, 0);
        this.syncRegsPanel.add((Component)this.checkCpuRegC, gridBagConstraints);
        this.checkCpuRegAltC.setText("C'");
        this.checkCpuRegAltC.setToolTipText("Register alt C");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 8, 0, 0);
        this.syncRegsPanel.add((Component)this.checkCpuRegAltC, gridBagConstraints);
        this.checkCpuRegD.setText("D");
        this.checkCpuRegD.setToolTipText("Register D");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 8, 0, 0);
        this.syncRegsPanel.add((Component)this.checkCpuRegD, gridBagConstraints);
        this.checkCpuRegAltD.setText("D'");
        this.checkCpuRegAltD.setToolTipText("Register alt D");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 8, 0, 0);
        this.syncRegsPanel.add((Component)this.checkCpuRegAltD, gridBagConstraints);
        this.checkCpuRegE.setText("E");
        this.checkCpuRegE.setToolTipText("Register E");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 8, 0, 0);
        this.syncRegsPanel.add((Component)this.checkCpuRegE, gridBagConstraints);
        this.checkCpuRegAltE.setText("E'");
        this.checkCpuRegAltE.setToolTipText("Register alt E");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 8, 0, 0);
        this.syncRegsPanel.add((Component)this.checkCpuRegAltE, gridBagConstraints);
        this.checkCpuRegH.setText("H");
        this.checkCpuRegH.setToolTipText("Register H");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 8, 0, 0);
        this.syncRegsPanel.add((Component)this.checkCpuRegH, gridBagConstraints);
        this.checkCpuRegAltH.setText("H'");
        this.checkCpuRegAltH.setToolTipText("Register alt H");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 8, 0, 0);
        this.syncRegsPanel.add((Component)this.checkCpuRegAltH, gridBagConstraints);
        this.checkCpuRegL.setText("L");
        this.checkCpuRegL.setToolTipText("Register L");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 8, 0, 0);
        this.syncRegsPanel.add((Component)this.checkCpuRegL, gridBagConstraints);
        this.checkCpuRegAltL.setText("L'");
        this.checkCpuRegAltL.setToolTipText("Register alt L");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 8, 0, 0);
        this.syncRegsPanel.add((Component)this.checkCpuRegAltL, gridBagConstraints);
        this.checkCpuRegPc.setText("PC");
        this.checkCpuRegPc.setToolTipText("Register PC");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 8, 0, 0);
        this.syncRegsPanel.add((Component)this.checkCpuRegPc, gridBagConstraints);
        this.checkCpuRegSPh.setText("SPh");
        this.checkCpuRegSPh.setToolTipText("High byte of SP register");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 8, 0, 0);
        this.syncRegsPanel.add((Component)this.checkCpuRegSPh, gridBagConstraints);
        this.checkCpuRegSPl.setText("SPl");
        this.checkCpuRegSPl.setToolTipText("Low byte of SP register");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 8, 0, 0);
        this.syncRegsPanel.add((Component)this.checkCpuRegSPl, gridBagConstraints);
        this.checkCpuRegFexclC.setText("F (excl. C)");
        this.checkCpuRegFexclC.setToolTipText("Register F excluding C flag");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 8, 0, 0);
        this.syncRegsPanel.add((Component)this.checkCpuRegFexclC, gridBagConstraints);
        this.checkCpuRegFaltExclC.setText("F' (excl. C)");
        this.checkCpuRegFaltExclC.setToolTipText("Register alt F excluding C flag");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 8, 0, 0);
        this.syncRegsPanel.add((Component)this.checkCpuRegFaltExclC, gridBagConstraints);
        this.checkCpuRegIXh.setText("IXh");
        this.checkCpuRegIXh.setToolTipText("High byte of IX register");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 8, 0, 0);
        this.syncRegsPanel.add((Component)this.checkCpuRegIXh, gridBagConstraints);
        this.checkCpuRegIXl.setText("IXl");
        this.checkCpuRegIXl.setToolTipText("Low byte of IX register");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 8, 0, 0);
        this.syncRegsPanel.add((Component)this.checkCpuRegIXl, gridBagConstraints);
        this.checkCpuRegIYh.setText("IYh");
        this.checkCpuRegIYh.setToolTipText("High byte of IY register");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 8, 0, 0);
        this.syncRegsPanel.add((Component)this.checkCpuRegIYh, gridBagConstraints);
        this.checkCpuRegIYl.setText("IYl");
        this.checkCpuRegIYl.setToolTipText("Low byte of IY register");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 8, 0, 0);
        this.syncRegsPanel.add((Component)this.checkCpuRegIYl, gridBagConstraints);
        this.checkCpuMCPUPtrs.setText("mCPU PTRs");
        this.checkCpuMCPUPtrs.setToolTipText("GFX processors must read PTR values for memory operations from registers in main CPU (SP,HL,IX,IY,BC,DE)");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 8, 0, 0);
        this.syncRegsPanel.add((Component)this.checkCpuMCPUPtrs, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        this.add((Component)this.syncRegsPanel, gridBagConstraints);
        this.jPanel1.setBorder(BorderFactory.createTitledBorder("Extra flags"));
        this.jPanel1.setLayout(new GridBagLayout());
        this.checkGFXLeveledXOR.setText("GFXLeveledXOR");
        this.checkGFXLeveledXOR.setToolTipText("while XORing two GFX bytes, MAX function used to get result.");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        this.jPanel1.add((Component)this.checkGFXLeveledXOR, gridBagConstraints);
        this.checkGFXLeveledOR.setText("GFXLeveledOR");
        this.checkGFXLeveledOR.setToolTipText("while ORing two GFX bytes, MAX function used to get result");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        this.jPanel1.add((Component)this.checkGFXLeveledOR, gridBagConstraints);
        this.checkGFXLeveledAND.setText("GFXLeveledAND");
        this.checkGFXLeveledAND.setToolTipText("while ANDing two GFX bytes, MIN function used to get result");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        this.jPanel1.add((Component)this.checkGFXLeveledAND, gridBagConstraints);
        this.checkGFXScreenXORBuffered.setText("GFXScreenXORBuffered");
        this.checkGFXScreenXORBuffered.setToolTipText("special sequence [XOR A,(HL);LD (HL),A] when HL is between 4000H and 57FFH is recognized as xor with screen");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        this.jPanel1.add((Component)this.checkGFXScreenXORBuffered, gridBagConstraints);
        this.checkPaper00InkFF.setText("Paper00InkFF");
        this.checkPaper00InkFF.setToolTipText("force drawing paper color over #00 and ink color over #FF palette indexes");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        this.jPanel1.add((Component)this.checkPaper00InkFF, gridBagConstraints);
        this.checkBkMixed.setText("BkMixed");
        this.checkBkMixed.setToolTipText("colors in the background with indeces under DownColorsMixed and above UpColorsMixed are are mixed with the attribute");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 8, 0, 0);
        this.jPanel1.add((Component)this.checkBkMixed, gridBagConstraints);
        this.checkBkMixBkAttr.setText("BkMixBkAttr");
        this.checkBkMixBkAttr.setToolTipText("background pixels with indeces under DownColorsMixed and above UpColorsMixed are mixed with back attribute rather then with fore attribute");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 8, 0, 0);
        this.jPanel1.add((Component)this.checkBkMixBkAttr, gridBagConstraints);
        this.checkBkOverFF.setText("BkOverFF");
        this.checkBkOverFF.setToolTipText("background pixels are overriding also FF value from GFX");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 8, 0, 0);
        this.jPanel1.add((Component)this.checkBkOverFF, gridBagConstraints);
        this.checkUseBrightInMix.setText("UseBrightInMix");
        this.checkUseBrightInMix.setToolTipText("then brightness bit also used to mix with");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 8, 0, 0);
        this.jPanel1.add((Component)this.checkUseBrightInMix, gridBagConstraints);
        this.checkUpMixPaper.setText("UpMixPaper");
        this.checkUpMixPaper.setToolTipText("mixing with a paper color only - for upper mixed colors bank");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 8, 0, 0);
        this.jPanel1.add((Component)this.checkUpMixPaper, gridBagConstraints);
        this.checkDownMixPaper.setText("DownMixPaper");
        this.checkDownMixPaper.setToolTipText("the same as UpMixPaper, but for down mixed colors bank");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 8, 0, 0);
        this.jPanel1.add((Component)this.checkDownMixPaper, gridBagConstraints);
        this.checkHideSameInkPaper.setText("HideSameInkPaper");
        this.checkHideSameInkPaper.setToolTipText("force show ink color if attribute ink and paper has same value");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 8, 0, 0);
        this.jPanel1.add((Component)this.checkHideSameInkPaper, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weighty = 1000.0;
        this.jPanel1.add((Component)this.filler1, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        this.add((Component)this.jPanel1, gridBagConstraints);
        this.jPanel2.setBorder(BorderFactory.createTitledBorder("Spinners"));
        this.jPanel2.setLayout(new GridBagLayout());
        this.jLabel1.setText("UpColorsMixed:");
        this.jLabel1.setToolTipText("mixing for up colors in the palette");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 13;
        this.jPanel2.add((Component)this.jLabel1, gridBagConstraints);
        this.jLabel2.setText("DownColorsMixed:");
        this.jLabel2.setToolTipText("mixing for down colors in the palette");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 13;
        this.jPanel2.add((Component)this.jLabel2, gridBagConstraints);
        this.jLabel3.setText("UpMixChgBright:");
        this.jLabel3.setToolTipText("defines which part of mixed result is affected by the bright of an attribute rather then by its color");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(0, 8, 0, 0);
        this.jPanel2.add((Component)this.jLabel3, gridBagConstraints);
        this.jLabel4.setText("DownMixChgBright:");
        this.jLabel4.setToolTipText("defines which part of mixed result is affected by the bright of an attribute rather then by its color");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(0, 8, 0, 0);
        this.jPanel2.add((Component)this.jLabel4, gridBagConstraints);
        this.spinnerUpColorsMixed.setModel(new SpinnerNumberModel(64, 0, 64, 1));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        this.jPanel2.add((Component)this.spinnerUpColorsMixed, gridBagConstraints);
        this.spinnerDownColorsMixed.setModel(new SpinnerNumberModel(0, 0, 64, 1));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        this.jPanel2.add((Component)this.spinnerDownColorsMixed, gridBagConstraints);
        this.spinnerUpMixChgBright.setModel(new SpinnerNumberModel(0, 0, 100, 1));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        this.jPanel2.add((Component)this.spinnerUpMixChgBright, gridBagConstraints);
        this.spinnerDownMixChgBright.setModel(new SpinnerNumberModel(0, 0, 100, 1));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        this.jPanel2.add((Component)this.spinnerDownMixChgBright, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1000.0;
        this.jPanel2.add((Component)this.filler2, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 5;
        gridBagConstraints.fill = 3;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weighty = 1000.0;
        this.jPanel2.add((Component)this.filler3, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        this.add((Component)this.jPanel2, gridBagConstraints);
        this.jPanel3.setLayout(new FlowLayout(2));
        this.buttonResetToDefault.setText("Reset to default");
        this.buttonResetToDefault.setToolTipText("Reset all values to default ones");
        this.buttonResetToDefault.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Spec256ConfigEditorPanel.this.buttonResetToDefaultActionPerformed(evt);
            }
        });
        this.jPanel3.add(this.buttonResetToDefault);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        this.add((Component)this.jPanel3, gridBagConstraints);
    }

    private void buttonResetToDefaultActionPerformed(ActionEvent evt) {
        this.reset();
    }
}

