/*
 * Decompiled with CFR 0.152.
 */
package com.igormaznitsa.zxpspritecorrector.files;

import com.igormaznitsa.jbbp.JBBPParser;
import com.igormaznitsa.jbbp.io.JBBPOut;
import com.igormaznitsa.jbbp.mapper.Bin;
import com.igormaznitsa.jbbp.mapper.BinType;
import com.igormaznitsa.jbbp.utils.Function;
import java.io.IOException;

public class ZXEMLSnapshotFormat {
    public static final int MAGIC = -1061551872;
    public static final int INDEX_CPU0 = 0;
    public static final int INDEX_CPU1 = 1;
    public static final int INDEX_CPU2 = 2;
    public static final int INDEX_CPU3 = 3;
    private static final JBBPParser ZXEML_SNAPSHOT = JBBPParser.prepare("int magic; int flags; ubyte port3D00; ubyte portFE;byte [5] cpu0ports; byte [5] cpu1ports; byte [5] cpu2ports; byte [5] cpu3ports;short [4] reg_af; short [4] reg_af_alt; short [4] reg_bc; short [4] reg_bc_alt; short [4] reg_de; short [4] reg_de_alt; short [4] reg_hl; short [4] reg_hl_alt; short [4] reg_ix; short [4] reg_iy; short [4] reg_ir;byte [4] reg_im; bool [4] iff; bool [4] iff2;short [4] reg_pc; short [4] reg_sp;pages [4]{ubyte number; page[number]{ubyte index; byte [16384] data;}}");
    @Bin(order=1, type=BinType.INT)
    public int magic = -1061551872;
    @Bin(order=2, type=BinType.INT)
    public int flags;
    @Bin(order=3, type=BinType.UBYTE)
    public int port3D00;
    @Bin(order=4, type=BinType.UBYTE)
    public int portFE;
    @Bin(order=5, type=BinType.BYTE_ARRAY)
    public byte[] cpu0ports = new byte[5];
    @Bin(order=6, type=BinType.BYTE_ARRAY)
    public byte[] cpu1ports = new byte[5];
    @Bin(order=7, type=BinType.BYTE_ARRAY)
    public byte[] cpu2ports = new byte[5];
    @Bin(order=8, type=BinType.BYTE_ARRAY)
    public byte[] cpu3ports = new byte[5];
    @Bin(order=9, type=BinType.SHORT_ARRAY)
    public short[] reg_af = new short[4];
    @Bin(order=10, type=BinType.SHORT_ARRAY)
    public short[] reg_af_alt = new short[4];
    @Bin(order=11, type=BinType.SHORT_ARRAY)
    public short[] reg_bc = new short[4];
    @Bin(order=12, type=BinType.SHORT_ARRAY)
    public short[] reg_bc_alt = new short[4];
    @Bin(order=13, type=BinType.SHORT_ARRAY)
    public short[] reg_de = new short[4];
    @Bin(order=14, type=BinType.SHORT_ARRAY)
    public short[] reg_de_alt = new short[4];
    @Bin(order=15, type=BinType.SHORT_ARRAY)
    public short[] reg_hl = new short[4];
    @Bin(order=16, type=BinType.SHORT_ARRAY)
    public short[] reg_hl_alt = new short[4];
    @Bin(order=17, type=BinType.SHORT_ARRAY)
    public short[] reg_ix = new short[4];
    @Bin(order=18, type=BinType.SHORT_ARRAY)
    public short[] reg_iy = new short[4];
    @Bin(order=19, type=BinType.SHORT_ARRAY)
    public short[] reg_ir = new short[4];
    @Bin(order=20, type=BinType.BYTE_ARRAY)
    public byte[] reg_im = new byte[4];
    @Bin(order=21, type=BinType.BOOL_ARRAY)
    public boolean[] iff = new boolean[4];
    @Bin(order=22, type=BinType.BOOL_ARRAY)
    public boolean[] iff2 = new boolean[4];
    @Bin(order=23, type=BinType.SHORT_ARRAY)
    public short[] reg_pc = new short[4];
    @Bin(order=24, type=BinType.SHORT_ARRAY)
    public short[] reg_sp = new short[4];
    @Bin(order=25, type=BinType.STRUCT_ARRAY)
    public Pages[] pages = new Pages[]{new Pages(new Page[]{new Page(0, new byte[16384])}), new Pages(new Page[]{new Page(0, new byte[16384])}), new Pages(new Page[]{new Page(0, new byte[16384])}), new Pages(new Page[]{new Page(0, new byte[16384])})};

    public ZXEMLSnapshotFormat() {
    }

    public ZXEMLSnapshotFormat(byte[] data) throws IOException {
        this.pages = null;
        ZXEML_SNAPSHOT.parse(data).mapTo(this, new Function[0]);
        if (this.magic != -1061551872) {
            throw new IOException("It is not ZXEML snapshot");
        }
    }

    public void setPages(int cpuIndex, Pages pages) {
        if (pages == null) {
            throw new NullPointerException("Value must not be null");
        }
        this.pages[cpuIndex] = pages;
    }

    public Pages getPages(int cpuIndex) {
        return this.pages[cpuIndex];
    }

    public int getFlags() {
        return this.flags;
    }

    public void setFlags(int value) {
        this.flags = value;
    }

    public void setHL(int cpuIndex, int value, boolean alt) {
        if (alt) {
            this.reg_hl_alt[cpuIndex] = (short)value;
        } else {
            this.reg_hl[cpuIndex] = (short)value;
        }
    }

    public int getHL(int cpuIndex, boolean alt) {
        return (alt ? this.reg_de_alt[cpuIndex] : this.reg_de[cpuIndex]) & 0xFFFF;
    }

    public void setDE(int cpuIndex, int value, boolean alt) {
        if (alt) {
            this.reg_de_alt[cpuIndex] = (short)value;
        } else {
            this.reg_de[cpuIndex] = (short)value;
        }
    }

    public int getDE(int cpuIndex, boolean alt) {
        return (alt ? this.reg_de_alt[cpuIndex] : this.reg_de[cpuIndex]) & 0xFFFF;
    }

    public void setBC(int cpuIndex, int value, boolean alt) {
        if (alt) {
            this.reg_bc_alt[cpuIndex] = (short)value;
        } else {
            this.reg_bc[cpuIndex] = (short)value;
        }
    }

    public int getBC(int cpuIndex, boolean alt) {
        return (alt ? this.reg_bc_alt[cpuIndex] : this.reg_bc[cpuIndex]) & 0xFFFF;
    }

    public void setAF(int cpuIndex, int value, boolean alt) {
        if (alt) {
            this.reg_af_alt[cpuIndex] = (short)value;
        } else {
            this.reg_af[cpuIndex] = (short)value;
        }
    }

    public int getAF(int cpuIndex, boolean alt) {
        return (alt ? this.reg_af_alt[cpuIndex] : this.reg_af[cpuIndex]) & 0xFFFF;
    }

    public void setIFF2(int cpuIndex, boolean value) {
        this.iff2[cpuIndex] = value;
    }

    public boolean isIFF2(int cpuIndex) {
        return this.iff2[cpuIndex];
    }

    public void setIFF(int cpuIndex, boolean value) {
        this.iff[cpuIndex] = value;
    }

    public boolean isIFF(int cpuIndex) {
        return this.iff[cpuIndex];
    }

    public void setRegIX(int cpuIndex, int value) {
        this.reg_ix[cpuIndex] = (short)value;
    }

    public int getRegIX(int cpuIndex) {
        return this.reg_ix[cpuIndex] & 0xFFFF;
    }

    public void setRegIY(int cpuIndex, int value) {
        this.reg_iy[cpuIndex] = (short)value;
    }

    public int getRegIY(int cpuIndex) {
        return this.reg_iy[cpuIndex] & 0xFFFF;
    }

    public void setRegIR(int cpuIndex, int value) {
        this.reg_ir[cpuIndex] = (short)value;
    }

    public int getRegIR(int cpuIndex) {
        return this.reg_ir[cpuIndex] & 0xFFFF;
    }

    public void setRegPC(int cpuIndex, int value) {
        this.reg_pc[cpuIndex] = (short)value;
    }

    public int getRegPC(int cpuIndex) {
        return this.reg_pc[cpuIndex] & 0xFFFF;
    }

    public void setRegSP(int cpuIndex, int value) {
        this.reg_sp[cpuIndex] = (short)value;
    }

    public int getRegSP(int cpuIndex) {
        return this.reg_sp[cpuIndex] & 0xFFFF;
    }

    public void setRegIM(int cpuIndex, int value) {
        this.reg_im[cpuIndex] = (byte)value;
    }

    public int getRegIM(int cpuIndex) {
        return this.reg_im[cpuIndex] & 0xFF;
    }

    public int getPort3D00() {
        return this.port3D00;
    }

    public void setPort3D00(int value) {
        this.port3D00 = value;
    }

    public int getPortFE() {
        return this.portFE;
    }

    public void setPortFE(int value) {
        this.portFE = value;
    }

    public void setModulePorts(int cpuIndex, int port7FFD, int r0, int r1, int r2, int r3) {
        byte[] data = new byte[]{(byte)port7FFD, (byte)r0, (byte)r1, (byte)r2, (byte)r3};
        switch (cpuIndex) {
            case 0: {
                this.cpu0ports = data;
                break;
            }
            case 1: {
                this.cpu1ports = data;
                break;
            }
            case 2: {
                this.cpu2ports = data;
                break;
            }
            case 3: {
                this.cpu3ports = data;
                break;
            }
            default: {
                throw new IllegalArgumentException("Illegal CPU index");
            }
        }
    }

    public byte[] getModulePorts(int cpuIndex) {
        switch (cpuIndex) {
            case 0: {
                return this.cpu0ports;
            }
            case 1: {
                return this.cpu1ports;
            }
            case 2: {
                return this.cpu2ports;
            }
            case 3: {
                return this.cpu3ports;
            }
        }
        throw new IllegalArgumentException("Illegal CPU index");
    }

    public byte[] save() throws IOException {
        if (this.pages == null) {
            throw new NullPointerException("Pages must not be null");
        }
        for (Pages p : this.pages) {
            if (p == null) {
                throw new NullPointerException("Item in Pages contains null");
            }
            for (Page pp : p.page) {
                if (pp != null) continue;
                throw new NullPointerException("Detected defined null page");
            }
        }
        return JBBPOut.BeginBin().Bin(this).End().toByteArray();
    }

    public static class Pages {
        @Bin(order=1, type=BinType.UBYTE)
        public int number;
        @Bin(order=2, type=BinType.STRUCT_ARRAY)
        public Page[] page;

        public Pages(Page[] page) {
            this.number = page.length;
            this.page = page;
        }

        public Page[] getPages() {
            return this.page;
        }
    }

    public static class Page {
        @Bin(order=1, type=BinType.UBYTE)
        public int index;
        @Bin(order=2, type=BinType.BYTE_ARRAY)
        public byte[] data;

        public Page(int index, byte[] data) {
            if (index < 0 || index > 7) {
                throw new IllegalArgumentException("Page muste be 0..7");
            }
            if (data == null || data.length != 16384) {
                throw new IllegalArgumentException("Data must not be null and must have length 0x4000");
            }
            this.index = index;
            this.data = (byte[])data.clone();
        }

        public int getIndex() {
            return this.index;
        }

        public byte[] getData() {
            return this.data;
        }
    }
}

