/*
 * Decompiled with CFR 0.152.
 */
package com.igormaznitsa.zxpspritecorrector.files.plugins;

import com.igormaznitsa.jbbp.JBBPParser;
import com.igormaznitsa.jbbp.io.JBBPBitInputStream;
import com.igormaznitsa.jbbp.io.JBBPByteOrder;
import com.igormaznitsa.jbbp.io.JBBPOut;
import com.igormaznitsa.jbbp.mapper.Bin;
import com.igormaznitsa.jbbp.mapper.BinType;
import com.igormaznitsa.jbbp.utils.Function;
import com.igormaznitsa.jbbp.utils.JBBPUtils;
import com.igormaznitsa.zxpspritecorrector.components.ZXPolyData;
import com.igormaznitsa.zxpspritecorrector.files.FileNameDialog;
import com.igormaznitsa.zxpspritecorrector.files.Info;
import com.igormaznitsa.zxpspritecorrector.files.SessionData;
import com.igormaznitsa.zxpspritecorrector.files.plugins.AbstractFilePlugin;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import javax.swing.filechooser.FileFilter;

public class SCLPlugin
extends AbstractFilePlugin {
    private static final String DESCRIPTION = "TR-Dos SCL disk image";
    public static final JBBPParser CATALOG_PARSER = JBBPParser.prepare("byte [8] name; ubyte type; <ushort start; <ushort length; ubyte sectors;");

    @Override
    public String getPluginUID() {
        return "SCLP";
    }

    @Override
    public String getToolTip(boolean forExport) {
        return DESCRIPTION;
    }

    @Override
    public boolean doesContainInternalFileItems() {
        return true;
    }

    @Override
    public String getPluginDescription(boolean forExport) {
        return DESCRIPTION;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public List<Info> getImportingContainerFileList(File file) {
        try {
            JBBPBitInputStream in;
            ArrayList<Info> result;
            block6: {
                List<Info> list;
                result = new ArrayList<Info>();
                in = null;
                try {
                    in = new JBBPBitInputStream(new FileInputStream(file));
                    long id = in.readLong(JBBPByteOrder.BIG_ENDIAN);
                    if (id == 6001414029397018962L) {
                        int fileNumber = in.readByte();
                        for (int i = 0; i < fileNumber; ++i) {
                            SCLCatalogItem item = CATALOG_PARSER.parse(in).mapTo(new SCLCatalogItem(), new Function[0]);
                            result.add(new Info(item.name, item.type, item.start, item.length, -1, true, new byte[0]));
                        }
                        break block6;
                    }
                    list = null;
                }
                catch (Throwable throwable) {
                    JBBPUtils.closeQuietly(in);
                    throw throwable;
                }
                JBBPUtils.closeQuietly(in);
                return list;
            }
            JBBPUtils.closeQuietly(in);
            return result;
        }
        catch (Exception ex) {
            return null;
        }
    }

    @Override
    public AbstractFilePlugin.ReadResult readFrom(String name, byte[] dataArray, int index) throws IOException {
        ArrayList<SCLCatalogItem> list = new ArrayList<SCLCatalogItem>();
        JBBPBitInputStream in = new JBBPBitInputStream(new ByteArrayInputStream(dataArray));
        try {
            long id = in.readLong(JBBPByteOrder.BIG_ENDIAN);
            if (id == 6001414029397018962L) {
                int fileNumber = in.readByte();
                for (int i = 0; i < fileNumber; ++i) {
                    SCLCatalogItem item = CATALOG_PARSER.parse(in).mapTo(new SCLCatalogItem(), new Function[0]);
                    list.add(item);
                }
                SCLCatalogItem itemToRead = (SCLCatalogItem)list.get(index);
                for (int i = 0; i < index; ++i) {
                    int len = ((SCLCatalogItem)list.get((int)i)).sectors * 256;
                    if ((long)len == in.skip(len)) continue;
                    throw new IllegalStateException("Can't skip bytes:" + ((SCLCatalogItem)list.get((int)i)).length);
                }
                long offset = in.getCounter();
                AbstractFilePlugin.ReadResult readResult = new AbstractFilePlugin.ReadResult(new ZXPolyData(new Info(itemToRead.name, itemToRead.type, itemToRead.start, itemToRead.length, (int)offset, true, new byte[0]), this, in.readByteArray(itemToRead.sectors * 256)), null);
                return readResult;
            }
            throw new IllegalArgumentException("It's not a SCl file");
        }
        finally {
            JBBPUtils.closeQuietly(in);
        }
    }

    @Override
    public void writeTo(File file, ZXPolyData data, SessionData sessionData, Object ... extraData) throws IOException {
        String zxname = data.getInfo().getName();
        String[] zxFileName = new String[]{SCLPlugin.prepareNameForTRD(zxname, 0), SCLPlugin.prepareNameForTRD(zxname, 1), SCLPlugin.prepareNameForTRD(zxname, 2), SCLPlugin.prepareNameForTRD(zxname, 3)};
        char type = data.getInfo().getType();
        FileNameDialog fileNameDialog = new FileNameDialog(this.spriteCorrectorMainFrame, "SCL file " + file.getName(), null, zxFileName, new char[]{type, type, type, type});
        fileNameDialog.setVisible(true);
        if (fileNameDialog.approved()) {
            int i;
            JBBPOut out = JBBPOut.BeginBin();
            out.Long(6001414029397018962L).ByteOrder(JBBPByteOrder.LITTLE_ENDIAN).Byte(4);
            String[] fnames = fileNameDialog.getZxName();
            Character[] fchars = fileNameDialog.getZxType();
            int sectors = (data.length() >>> 8) + ((data.length() & 0xFF) == 0 ? 0 : 1);
            for (i = 0; i < 4; ++i) {
                out.Byte(fnames[i]).Byte((int)fchars[i].charValue()).Short(data.getInfo().getStartAddress(), data.getInfo().getLength()).Byte(sectors);
            }
            out.ResetCounter();
            for (i = 0; i < 4; ++i) {
                byte[] arr = data.getDataForCPU(i);
                out.Byte(arr).Align(256);
            }
            this.saveDataToFile(file, out.End().toByteArray());
        }
    }

    @Override
    public boolean accept(File pathname) {
        return pathname != null && (pathname.isDirectory() || pathname.getName().toLowerCase(Locale.ENGLISH).endsWith(".scl"));
    }

    @Override
    public FileFilter getImportFileFilter() {
        return this;
    }

    @Override
    public FileFilter getExportFileFilter() {
        return this;
    }

    @Override
    public String getExtension(boolean forExport) {
        return "scl";
    }

    @Override
    public String getDescription() {
        return this.getToolTip(false) + " (*.SCL)";
    }

    public static final class SCLCatalogItem {
        @Bin(type=BinType.BYTE_ARRAY)
        public String name;
        @Bin(type=BinType.UBYTE)
        public char type;
        @Bin(type=BinType.USHORT)
        public int start;
        @Bin(type=BinType.USHORT)
        public int length;
        @Bin(type=BinType.UBYTE)
        public int sectors;
    }
}

