/*
 * Decompiled with CFR 0.152.
 */
package com.igormaznitsa.zxpspritecorrector.files.plugins;

import com.igormaznitsa.jbbp.JBBPParser;
import com.igormaznitsa.jbbp.io.JBBPBitNumber;
import com.igormaznitsa.jbbp.io.JBBPByteOrder;
import com.igormaznitsa.jbbp.io.JBBPOut;
import com.igormaznitsa.jbbp.mapper.Bin;
import com.igormaznitsa.jbbp.mapper.BinType;
import com.igormaznitsa.jbbp.utils.Function;
import com.igormaznitsa.zxpspritecorrector.components.ZXPolyData;
import com.igormaznitsa.zxpspritecorrector.files.Info;
import com.igormaznitsa.zxpspritecorrector.files.SessionData;
import com.igormaznitsa.zxpspritecorrector.files.plugins.AbstractFilePlugin;
import com.igormaznitsa.zxpspritecorrector.files.plugins.Z80InZXPOutPlugin;
import java.io.File;
import java.io.IOException;
import java.util.List;
import java.util.Locale;
import java.util.logging.Logger;
import java.util.stream.IntStream;
import javax.swing.filechooser.FileFilter;

public final class SNAPlugin
extends AbstractFilePlugin {
    private static final Logger LOGGER = Logger.getLogger("SNA-Plugin");
    private static final String DESCRIPTION = "SNA snapshot";
    private final JBBPParser SNA_PARSER = JBBPParser.prepare("ubyte regI;<ushort altRegHL;<ushort altRegDE;<ushort altRegBC;<ushort altRegAF;<ushort regHL;<ushort regDE;<ushort regBC;<ushort regIY;<ushort regIX;ubyte iff2;ubyte regR;<ushort regAF;<ushort regSP;ubyte intMode;ubyte borderColor;byte [49152] ramDump;extendedData {  <ushort regPC;  ubyte port7FFD;  byte onTrDos;  extrabank [_] {    byte [16384] data;  }}", 1);

    @Override
    public boolean isExportable() {
        return false;
    }

    @Override
    public String getToolTip(boolean forExport) {
        return DESCRIPTION;
    }

    @Override
    public boolean doesContainInternalFileItems() {
        return false;
    }

    @Override
    public FileFilter getImportFileFilter() {
        return this;
    }

    @Override
    public FileFilter getExportFileFilter() {
        return new FileFilter(){

            @Override
            public boolean accept(File f) {
                return f != null && (f.isDirectory() || f.getName().toLowerCase(Locale.ENGLISH).endsWith(".sna"));
            }

            @Override
            public String getDescription() {
                return SNAPlugin.this.getToolTip(true) + " (*.SNA)";
            }
        };
    }

    @Override
    public String getPluginDescription(boolean forExport) {
        return DESCRIPTION;
    }

    @Override
    public String getPluginUID() {
        return "SNAS";
    }

    @Override
    public List<Info> getImportingContainerFileList(File file) {
        return null;
    }

    @Override
    public String getExtension(boolean forExport) {
        return "sna";
    }

    @Override
    public AbstractFilePlugin.ReadResult readFrom(String name, byte[] array, int index) throws IOException {
        boolean sna128;
        switch (array.length) {
            case 49179: {
                sna128 = false;
                break;
            }
            case 131103: 
            case 147487: {
                sna128 = true;
                break;
            }
            default: {
                throw new IOException("SNA file has inappropriate length: " + array.length);
            }
        }
        SnaFileSnapshot snaFile = this.SNA_PARSER.parse(array).mapTo(new SnaFileSnapshot(), 1, new Function[0]);
        if (sna128) {
            LOGGER.info("SNA128 DETECTED");
            byte[] data = new byte[16384 * (3 + snaFile.extendedData.extrabank.length)];
            LOGGER.info("SNA128 data length: " + data.length + " bytes");
            int topPage = snaFile.extendedData.port7FFD & 7;
            System.arraycopy(snaFile.ramDump, 0, data, 81920, 16384);
            System.arraycopy(snaFile.ramDump, 16384, data, 32768, 16384);
            System.arraycopy(snaFile.ramDump, 32768, data, topPage * 16384, 16384);
            int extraBankIndex = 0;
            for (int i = 0; i < 8; ++i) {
                if (extraBankIndex >= snaFile.extendedData.extrabank.length || i == 2 || i == 5 || i == topPage) continue;
                byte[] pageData = snaFile.extendedData.extrabank[extraBankIndex].data;
                System.arraycopy(pageData, 0, data, i * 16384, 16384);
                ++extraBankIndex;
            }
            byte[] extra = JBBPOut.BeginBin(JBBPByteOrder.LITTLE_ENDIAN).Byte(data.length / 16384).Byte(IntStream.range(0, data.length / 16384).map(x -> x + 3).toArray()).Byte(snaFile.regAF >>> 8).Byte((int)snaFile.regAF).Short((int)snaFile.regBC).Short((int)snaFile.regHL).Short(0).Short((int)snaFile.regSP).Byte((int)snaFile.regI).Byte((int)snaFile.regR).Bit((snaFile.regR & 0x80) != 0).Bits(JBBPBitNumber.BITS_3, (int)snaFile.borderColor).Bit(0, 0).Bits(JBBPBitNumber.BITS_2, 0).Short((int)snaFile.regDE).Short((int)snaFile.altRegBC).Short((int)snaFile.altRegDE).Short((int)snaFile.altRegHL).Byte(snaFile.altRegAF >>> 8).Byte((int)snaFile.altRegAF).Short((int)snaFile.regIY).Short((int)snaFile.regIX).Byte((snaFile.iff2 & 4) == 0 ? 0 : 255).Byte((snaFile.iff2 & 4) == 0 ? 0 : 255).Bits(JBBPBitNumber.BITS_2, (int)snaFile.intMode).Bit(0).Bit(0).Bits(JBBPBitNumber.BITS_2, 0).Bits(JBBPBitNumber.BITS_2, 0).Short(23).Short((int)snaFile.extendedData.regPC).Byte(3).Byte((int)snaFile.extendedData.port7FFD).Byte(0).Byte(0).Byte(0).Byte(0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0).End().toByteArray();
            return new AbstractFilePlugin.ReadResult(new ZXPolyData(new Info(name, 'C', snaFile.extendedData.regPC, data.length, 0, true, extra), new Z80InZXPOutPlugin(), data), null);
        }
        LOGGER.info("SNA48 DETECTED");
        int regsp = snaFile.regSP;
        if (regsp < 16384) {
            throw new IOException("Can't import SNA because its stack in ROM area!");
        }
        int lowaddr = snaFile.ramDump[regsp - 16384] & 0xFF;
        regsp = regsp + '\u0001' & 0xFFFF;
        int highaddr = snaFile.ramDump[regsp - 16384] & 0xFF;
        regsp = regsp + 1 & 0xFFFF;
        snaFile.regSP = (char)regsp;
        int startAddress = highaddr << 8 | lowaddr;
        int dataLength = snaFile.ramDump.length;
        byte[] data = snaFile.ramDump;
        byte[] extra = JBBPOut.BeginBin(JBBPByteOrder.LITTLE_ENDIAN).Byte(0).Byte(snaFile.regAF >>> 8).Byte((int)snaFile.regAF).Short((int)snaFile.regBC).Short((int)snaFile.regHL).Short(startAddress).Short((int)snaFile.regSP).Byte((int)snaFile.regI).Byte((int)snaFile.regR).Bit((snaFile.regR & 0x80) != 0).Bits(JBBPBitNumber.BITS_3, (int)snaFile.borderColor).Bit(0, 0).Bits(JBBPBitNumber.BITS_2, 0).Short((int)snaFile.regDE).Short((int)snaFile.altRegBC).Short((int)snaFile.altRegDE).Short((int)snaFile.altRegHL).Byte(snaFile.altRegAF >>> 8).Byte((int)snaFile.altRegAF).Short((int)snaFile.regIY).Short((int)snaFile.regIX).Byte((snaFile.iff2 & 4) == 0 ? 0 : 255).Byte((snaFile.iff2 & 4) == 0 ? 0 : 255).Bits(JBBPBitNumber.BITS_2, (int)snaFile.intMode).Bit(0).Bit(0).Bits(JBBPBitNumber.BITS_2, 0).Bits(JBBPBitNumber.BITS_2, 0).End().toByteArray();
        return new AbstractFilePlugin.ReadResult(new ZXPolyData(new Info(name, 'C', startAddress, dataLength, 0, true, extra), new Z80InZXPOutPlugin(), data), null);
    }

    @Override
    public void writeTo(File file, ZXPolyData data, SessionData sessionData, Object ... extraData) throws IOException {
        throw new IOException("SNA export is unsupported");
    }

    @Override
    public boolean accept(File f) {
        return f != null && (f.isDirectory() || f.getName().toLowerCase(Locale.ENGLISH).endsWith(".sna"));
    }

    @Override
    public String getDescription() {
        return "SNA snapshot (*.SNA)";
    }

    public static class SnaFileSnapshot {
        @Bin(type=BinType.UBYTE)
        public byte regI;
        @Bin(type=BinType.USHORT)
        public char altRegHL;
        @Bin(type=BinType.USHORT)
        public char altRegDE;
        @Bin(type=BinType.USHORT)
        public char altRegBC;
        @Bin(type=BinType.USHORT)
        public char altRegAF;
        @Bin(type=BinType.USHORT)
        public char regHL;
        @Bin(type=BinType.USHORT)
        public char regDE;
        @Bin(type=BinType.USHORT)
        public char regBC;
        @Bin(type=BinType.USHORT)
        public char regIY;
        @Bin(type=BinType.USHORT)
        public char regIX;
        @Bin(type=BinType.UBYTE)
        public byte iff2;
        @Bin(type=BinType.UBYTE)
        public byte regR;
        @Bin(type=BinType.USHORT)
        public char regAF;
        @Bin(type=BinType.USHORT)
        public char regSP;
        @Bin(type=BinType.UBYTE)
        public byte intMode;
        @Bin(type=BinType.UBYTE)
        public byte borderColor;
        @Bin(type=BinType.BYTE_ARRAY)
        public byte[] ramDump;
        @Bin
        public ExtendedData extendedData;

        public Object newInstance(Class<?> klazz) {
            if (klazz == ExtendedData.class) {
                return new ExtendedData();
            }
            return null;
        }

        @Bin
        public class ExtendedData {
            public char regPC;
            @Bin(type=BinType.UBYTE)
            public byte port7FFD;
            public byte onTrDos;
            public Extrabank[] extrabank;

            public Object newInstance(Class<?> klazz) {
                if (klazz == Extrabank.class) {
                    return new Extrabank();
                }
                return null;
            }

            @Bin
            public class Extrabank {
                public byte[] data;
            }
        }
    }
}

