/*
 * Decompiled with CFR 0.152.
 */
package com.igormaznitsa.zxpspritecorrector.files.plugins;

import com.igormaznitsa.jbbp.io.JBBPBitInputStream;
import com.igormaznitsa.jbbp.io.JBBPByteOrder;
import com.igormaznitsa.jbbp.io.JBBPOut;
import com.igormaznitsa.jbbp.utils.JBBPUtils;
import com.igormaznitsa.zxpspritecorrector.components.ZXPolyData;
import com.igormaznitsa.zxpspritecorrector.files.Info;
import com.igormaznitsa.zxpspritecorrector.files.SessionData;
import com.igormaznitsa.zxpspritecorrector.files.plugins.AbstractFilePlugin;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.List;
import java.util.Locale;
import javax.swing.filechooser.FileFilter;
import org.picocontainer.PicoContainer;
import org.picocontainer.annotations.Inject;

public class SZEPlugin
extends AbstractFilePlugin {
    private static final String DESCRIPTION = "ZX-Poly editor session";
    @Inject
    private PicoContainer context;

    @Override
    public String getPluginUID() {
        return "SZEP";
    }

    @Override
    public boolean isExportable() {
        return false;
    }

    @Override
    public String getToolTip(boolean forExport) {
        return DESCRIPTION;
    }

    @Override
    public boolean doesContainInternalFileItems() {
        return false;
    }

    @Override
    public List<Info> getImportingContainerFileList(File file) {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getImportingFileInfo(File file) {
        String string;
        FileInputStream in = null;
        try {
            String result;
            in = new FileInputStream(file);
            ZXPolyData zxpoly = new ZXPolyData(in, this.context.getComponents(AbstractFilePlugin.class));
            string = result = "  Name : " + zxpoly.getInfo().getName() + "\n  Type : " + zxpoly.getInfo().getType() + "\nLength : " + zxpoly.getInfo().getLength() + "\nPlugin : " + zxpoly.getPlugin().getPluginDescription(false);
        }
        catch (Throwable throwable) {
            try {
                JBBPUtils.closeQuietly(in);
                throw throwable;
            }
            catch (Exception ex) {
                return null;
            }
        }
        JBBPUtils.closeQuietly(in);
        return string;
    }

    @Override
    public String getPluginDescription(boolean forExport) {
        return DESCRIPTION;
    }

    @Override
    public AbstractFilePlugin.ReadResult readFrom(String name, byte[] data, int index) throws IOException {
        try (ByteArrayInputStream inStream = new ByteArrayInputStream(data);){
            ZXPolyData zxpolyData = new ZXPolyData(inStream, this.context.getComponents(AbstractFilePlugin.class));
            JBBPBitInputStream in = new JBBPBitInputStream(inStream);
            int length = in.readInt(JBBPByteOrder.BIG_ENDIAN);
            AbstractFilePlugin.ReadResult readResult = new AbstractFilePlugin.ReadResult(zxpolyData, new SessionData(in));
            return readResult;
        }
    }

    @Override
    public void writeTo(File file, ZXPolyData data, SessionData sessionData, Object ... extraData) throws IOException {
        byte[] dataarray = data.getAsArray();
        byte[] sessionarray = sessionData.makeArray();
        byte[] result = JBBPOut.BeginBin().Byte(dataarray).Int(sessionarray.length).Byte(sessionarray).End().toByteArray();
        this.saveDataToFile(file, result);
    }

    @Override
    public boolean accept(File pathname) {
        return pathname != null && (pathname.isDirectory() || pathname.getName().toLowerCase(Locale.ENGLISH).endsWith(".sze"));
    }

    @Override
    public FileFilter getImportFileFilter() {
        return this;
    }

    @Override
    public FileFilter getExportFileFilter() {
        return this;
    }

    @Override
    public String getExtension(boolean forExport) {
        return "sze";
    }

    @Override
    public String getDescription() {
        return "ZX-Poly editor session (*.SZE)";
    }
}

