/*
 * Decompiled with CFR 0.152.
 */
package com.igormaznitsa.zxpspritecorrector.files.plugins;

import com.igormaznitsa.jbbp.JBBPParser;
import com.igormaznitsa.jbbp.io.JBBPBitInputStream;
import com.igormaznitsa.jbbp.io.JBBPByteOrder;
import com.igormaznitsa.jbbp.io.JBBPOut;
import com.igormaznitsa.jbbp.utils.JBBPUtils;
import com.igormaznitsa.zxpspritecorrector.components.ZXPolyData;
import com.igormaznitsa.zxpspritecorrector.files.FileNameDialog;
import com.igormaznitsa.zxpspritecorrector.files.Info;
import com.igormaznitsa.zxpspritecorrector.files.SessionData;
import com.igormaznitsa.zxpspritecorrector.files.plugins.AbstractFilePlugin;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import javax.swing.JOptionPane;
import javax.swing.filechooser.FileFilter;
import org.apache.commons.io.FilenameUtils;

public class TAPPlugin
extends AbstractFilePlugin {
    private static final String DESCRIPTION = "ZX Tape image";
    public static final JBBPParser TAP_FILE_PARSER = JBBPParser.prepare("tapblocks [_]{ <ushort len; byte flag; byte [len-2] data; byte checksum;}");
    public static final JBBPParser HEADER_PARSER = JBBPParser.prepare("byte type; byte [10] name; <ushort length; <ushort param1; <ushort param2;");

    private static String extractHeaderName(byte[] headerData) {
        StringBuilder result = new StringBuilder(10);
        for (int i = 0; i < 10; ++i) {
            int value = headerData[i] & 0xFF;
            if (value < 32 || value > 126) {
                result.append(' ');
                continue;
            }
            result.append((char)value);
        }
        return result.toString();
    }

    private static int extractStartAddressField(byte[] headerData) {
        return headerData[12] & 0xFF | (headerData[13] & 0xFF) << 8;
    }

    private static int extractDataLengthField(byte[] headerData) {
        return headerData[10] & 0xFF | (headerData[11] & 0xFF) << 8;
    }

    @Override
    public String getPluginDescription(boolean forExport) {
        return DESCRIPTION;
    }

    @Override
    public String getToolTip(boolean forExport) {
        return DESCRIPTION;
    }

    @Override
    public boolean doesContainInternalFileItems() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<Info> getImportingContainerFileList(File file) {
        try {
            ArrayList<Info> result = new ArrayList<Info>();
            JBBPBitInputStream in = null;
            try {
                in = new JBBPBitInputStream(new FileInputStream(file));
                while (in.hasAvailableData()) {
                    int length = in.readUnsignedShort(JBBPByteOrder.LITTLE_ENDIAN);
                    int flag = in.readByte();
                    if (flag == 0) {
                        int standardflag = in.readByte();
                        byte[] data = in.readByteArray(length - 2);
                        int datalen = TAPPlugin.extractDataLengthField(data);
                        int address = TAPPlugin.extractStartAddressField(data);
                        switch (standardflag) {
                            case 0: {
                                result.add(new Info(TAPPlugin.extractHeaderName(data), 'B', address, datalen, -1, false, new byte[0]));
                                break;
                            }
                            case 1: {
                                result.add(new Info(TAPPlugin.extractHeaderName(data), 'N', address, datalen, -1, true, new byte[0]));
                                break;
                            }
                            case 2: {
                                result.add(new Info(TAPPlugin.extractHeaderName(data), 'S', address, datalen, -1, true, new byte[0]));
                                break;
                            }
                            case 3: {
                                result.add(new Info(TAPPlugin.extractHeaderName(data), 'C', address, datalen, -1, true, new byte[0]));
                                break;
                            }
                            default: {
                                result.add(new Info("<Unknown>", 'U', address, length, -1, true, new byte[0]));
                                break;
                            }
                        }
                        continue;
                    }
                    if (flag == 255) {
                        result.add(new Info("<Code>", 'D', -1, length - 2, -1, true, new byte[0]));
                    } else {
                        result.add(new Info("<Unknown>", 'U', -1, length, -1, true, new byte[0]));
                    }
                    in.skip(length - 1);
                }
            }
            catch (Throwable throwable) {
                JBBPUtils.closeQuietly(in);
                throw throwable;
            }
            JBBPUtils.closeQuietly(in);
            return result;
        }
        catch (Exception ex) {
            return null;
        }
    }

    @Override
    public AbstractFilePlugin.ReadResult readFrom(String name, byte[] dataArray, int index) throws IOException {
        JBBPBitInputStream in = new JBBPBitInputStream(new ByteArrayInputStream(dataArray));
        try {
            int currentIndex = 0;
            while (in.hasAvailableData()) {
                Info info;
                int length = in.readUnsignedShort(JBBPByteOrder.LITTLE_ENDIAN);
                int flag = in.readByte();
                int offset = (int)in.getCounter();
                if (flag == 0) {
                    int standardFlag = in.readByte();
                    byte[] data = in.readByteArray(length - 2);
                    int dataLength = TAPPlugin.extractDataLengthField(data);
                    int address = TAPPlugin.extractStartAddressField(data);
                    switch (standardFlag) {
                        case 0: {
                            info = new Info(TAPPlugin.extractHeaderName(data), 'B', address, dataLength, offset, false, new byte[0]);
                            break;
                        }
                        case 1: {
                            info = new Info(TAPPlugin.extractHeaderName(data), 'N', address, dataLength, offset, true, new byte[0]);
                            break;
                        }
                        case 2: {
                            info = new Info(TAPPlugin.extractHeaderName(data), 'S', address, dataLength, offset, true, new byte[0]);
                            break;
                        }
                        case 3: {
                            info = new Info(TAPPlugin.extractHeaderName(data), 'C', address, dataLength, offset, true, new byte[0]);
                            break;
                        }
                        default: {
                            info = new Info("<Unknown>", 'U', address, length, offset, true, new byte[0]);
                        }
                    }
                    if (currentIndex < index) {
                        ++currentIndex;
                        continue;
                    }
                    throw new IllegalArgumentException("Selected item is not a data block but a header");
                }
                info = flag == 255 ? new Info("<Code>", 'D', -1, length - 2, offset, true, new byte[0]) : new Info("<Unknown>", 'U', -1, length, offset, true, new byte[0]);
                if (currentIndex < index) {
                    ++currentIndex;
                    in.skip(length - 1);
                    continue;
                }
                AbstractFilePlugin.ReadResult readResult = new AbstractFilePlugin.ReadResult(new ZXPolyData(info, this, in.readByteArray(length - 1)), null);
                return readResult;
            }
            throw new IllegalArgumentException("Can't find file for index " + index);
        }
        finally {
            JBBPUtils.closeQuietly(in);
        }
    }

    @Override
    public void writeTo(File file, ZXPolyData data, SessionData session, Object ... extraData) throws IOException {
        int saveAsSeparateFiles = JOptionPane.showConfirmDialog(this.spriteCorrectorMainFrame, "Save each block as separated file?", "Separate files", 1);
        if (saveAsSeparateFiles == 2) {
            return;
        }
        String baseName = file.getName();
        String baseZXName = FilenameUtils.getBaseName(baseName);
        if (saveAsSeparateFiles == 0) {
            FileNameDialog fileNameDialog = new FileNameDialog(this.spriteCorrectorMainFrame, "Saving as separated files", new String[]{TAPPlugin.addNumberToFileName(baseName, 0), TAPPlugin.addNumberToFileName(baseName, 1), TAPPlugin.addNumberToFileName(baseName, 2), TAPPlugin.addNumberToFileName(baseName, 3)}, new String[]{TAPPlugin.prepareNameForTAP(baseZXName, 0), TAPPlugin.prepareNameForTAP(baseZXName, 1), TAPPlugin.prepareNameForTAP(baseZXName, 2), TAPPlugin.prepareNameForTAP(baseZXName, 3)}, null);
            fileNameDialog.setVisible(true);
            if (fileNameDialog.approved()) {
                String[] fileNames = fileNameDialog.getFileName();
                String[] zxNames = fileNameDialog.getZxName();
                for (int i = 0; i < 4; ++i) {
                    byte[] headerblock = this.makeHeaderBlock(zxNames[i], data.getInfo().getStartAddress(), data.length());
                    byte[] datablock = this.makeDataBlock(data.getDataForCPU(i));
                    byte[] dataToSave = JBBPOut.BeginBin().Byte(this.wellTapBlock(headerblock)).Byte(this.wellTapBlock(datablock)).End().toByteArray();
                    File fileToSave = new File(file.getParent(), fileNames[i]);
                    if (this.saveDataToFile(fileToSave, dataToSave)) continue;
                    return;
                }
            }
        } else {
            FileNameDialog fileNameDialog = new FileNameDialog(this.spriteCorrectorMainFrame, "Save as " + baseName, null, new String[]{TAPPlugin.prepareNameForTAP(baseZXName, 0), TAPPlugin.prepareNameForTAP(baseZXName, 1), TAPPlugin.prepareNameForTAP(baseZXName, 2), TAPPlugin.prepareNameForTAP(baseZXName, 3)}, null);
            fileNameDialog.setVisible(true);
            if (fileNameDialog.approved()) {
                String[] zxNames = fileNameDialog.getZxName();
                JBBPOut out = JBBPOut.BeginBin();
                for (int i = 0; i < 4; ++i) {
                    byte[] headerblock = this.makeHeaderBlock(zxNames[i], data.getInfo().getStartAddress(), data.length());
                    byte[] datablock = this.makeDataBlock(data.getDataForCPU(i));
                    out.Byte(this.wellTapBlock(headerblock)).Byte(this.wellTapBlock(datablock));
                }
                this.saveDataToFile(file, out.End().toByteArray());
            }
        }
    }

    private byte[] wellTapBlock(byte[] data) throws IOException {
        return JBBPOut.BeginBin(JBBPByteOrder.LITTLE_ENDIAN).Short(data.length + 1).Byte(data).Byte((int)this.doTapCRC(data)).End().toByteArray();
    }

    private byte doTapCRC(byte[] array) {
        byte result = 0;
        for (byte b : array) {
            result = (byte)(result ^ b);
        }
        return result;
    }

    private byte[] makeHeaderBlock(String name, int startAddress, int dataLength) throws IOException {
        JBBPOut out = JBBPOut.BeginBin(JBBPByteOrder.LITTLE_ENDIAN);
        if (name.length() != 10) {
            throw new IllegalArgumentException("Name must have 10 length");
        }
        return out.Byte(0, 3).Byte(name).Short(dataLength, startAddress, 32768).End().toByteArray();
    }

    private byte[] makeDataBlock(byte[] data) throws IOException {
        JBBPOut out = JBBPOut.BeginBin(JBBPByteOrder.LITTLE_ENDIAN);
        return out.Byte(255).Byte(data).End().toByteArray();
    }

    @Override
    public boolean accept(File pathname) {
        return pathname != null && (pathname.isDirectory() || pathname.getName().toLowerCase(Locale.ENGLISH).endsWith(".tap"));
    }

    @Override
    public String getDescription() {
        return "ZX Tape image (*.TAP)";
    }

    @Override
    public FileFilter getImportFileFilter() {
        return this;
    }

    @Override
    public FileFilter getExportFileFilter() {
        return this;
    }

    @Override
    public String getExtension(boolean forExport) {
        return "tap";
    }

    @Override
    public String getPluginUID() {
        return "TAPP";
    }
}

